<?php 
    $msg = '';
    global $wpdb;
    if(isset($_POST['add_new_group'])){
        extract($_POST);
        // echo '<pre>';
        //     print_r($_POST);
        // echo '</pre>';
        // die();
        $table_name = $wpdb->prefix . 'wbp_group_users';
        $visible_cats = implode(",",$visible_categories);
        $visible_prod = implode(",",$visible_products);
        $group_users = explode(",",$selected_search_users);
        $data = array(
            'group_name' => $groupname,
            'logo' => $themelogo,
            'grpdomain' => $grpdomain,
            'grpcode' => $grpcode,
            'primary_menu' => $primary_menu_position,
            'secondary_menu' => $secondary_menu_position,
            'handheld_menu' => $handheld_menu_position,
            'visible_categories' => $visible_cats,
            'visible_products' => $visible_prod,
            'group_users' => $selected_search_users
        );
        $group_inserted = $wpdb->insert($table_name, $data);
        $group_id = $wpdb->insert_id;
        if($group_inserted){
            foreach($group_users as $group_user){
                update_user_meta($group_user, 'nbd_company_user', $group_id);
            }
        }
        
        if($group_inserted){
            $msg = 'New group added.';
        }else{
            $msg = 'New group not added.';
        }
    }

    if(isset($_POST['edit_new_group']) && isset($_REQUEST['group'])){
        extract($_POST);
        // echo '<pre>';
        //     print_r($_POST);
        // echo '</pre>';
        $table_name = $wpdb->prefix . 'wbp_group_users';
        $visible_cats = implode(",",$visible_categories);
        $group_user = implode(",",$group_users);
        $visible_prod = implode(",",$visible_products);
        $data = array(
            'group_name' => $groupname,
            'logo' => $themelogo,
            'grpdomain' => $grpdomain,
            'grpcode' => $grpcode,
            'primary_menu' => $primary_menu_position,
            'secondary_menu' => $secondary_menu_position,
            'handheld_menu' => $handheld_menu_position,
            'visible_categories' => $visible_cats,
            'visible_products' => $visible_prod,
            'group_users' => $group_user
        );
        $group_updated = $wpdb->update($table_name, $data, array('id'=>$_REQUEST['group']));
        $users = get_users(array(
            'meta_key'     => 'nbd_company_user',
            'meta_value'   => $_REQUEST['group'],
            'meta_compare' => '=',
        ));
        $userlistIDS = array();
        foreach ($users as $key => $value) {
            $userlistIDS[] = $value->ID;
        } 
        $dataUnique = array_diff($userlistIDS, $group_users);
        if($group_updated){
            foreach($group_users as $grp_user){
                update_user_meta($grp_user, 'nbd_company_user', $_REQUEST['group']);
            }
            foreach ($dataUnique as $userUnique) {
                update_user_meta($userUnique, 'nbd_company_user', '');
            }
        }
        if($group_updated){
            $msg = 'Group updated.';
        }else{
            $msg = 'Group not updated.';
        }
    }

    if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete-group' && isset($_REQUEST['gid']) && $_REQUEST['gid']){
        $delete_group = get_sgl_group($_REQUEST['gid']);
        $table_name = $wpdb->prefix . 'wbp_group_users';
        if($delete_group){
            $group_deleted = $wpdb->delete($table_name, array('id'=>$_REQUEST['gid']));
            if($group_deleted){
                $msg = 'Group deleted.';
            }else{
                $msg = 'Group not deleted.';
            }
        }else{
            $msg = 'Group not found.';
        }
    }

?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<div class="wrap">
    <?php if(isset($_REQUEST['page']) && $_REQUEST['page'] == 'wbp_user_groups' && isset($_REQUEST['action']) && $_REQUEST['action'] == 'add_new_group'){ ?>
        <h1 class="wp-heading-inline">Add New User Group <a href="admin.php?page=wbp_user_groups" class="page-title-action">User Groups</a></h1>
        <?php if($msg){ ?>
            <div id="message" class="updated notice notice-success is-dismissible">
                <p><?=$msg?></p>
                <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
            </div>
        <?php } ?>
        <form name="addnewusergroup" method="post" enctype="multipart/form-data" autocomplete="off">
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row"><label for="groupname">Group Name</label></th>
                        <td><input name="groupname" type="text" id="groupname" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="themelogo">Theme Logo</label></th>
                        <td>
                            <input id="upload_image" class="regular-text" type="hidden" name="themelogo" value="http://" /> 
                            <input id="themelogo" class="button" type="button" value="Upload Logo" />
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="grpdomain">Group Domain</label></th>
                        <td><input name="grpdomain" type="text" id="grpdomain" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="grpcode">Group Code</label></th>
                        <td><input name="grpcode" type="text" id="grpcode" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="primary_menu_position">Primary Menu Position</label></th>
                        <td>
                            <select name="primary_menu_position" id="primary_menu_position" class="regular-text">
                            <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                                <?php
                                    $all_menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
                                    if($all_menus){
                                        foreach($all_menus as $all_menu){
                                            ?>
                                                <option value="<?=$all_menu->term_id?>"><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="secondary_menu_position">Secondary Menu Position</label></th>
                        <td>
                            <select name="secondary_menu_position" id="secondary_menu_position" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                                <?php
                                    if($all_menus){
                                        foreach($all_menus as $all_menu){
                                            ?>
                                                <option value="<?=$all_menu->term_id?>"><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="handheld_menu_position">Handheld Menu Position</label></th>
                        <td>
                            <select name="handheld_menu_position" id="handheld_menu_position" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                                <?php
                                    if($all_menus){
                                        foreach($all_menus as $all_menu){
                                            ?>
                                                <option value="<?=$all_menu->term_id?>"><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="visible_categories">Visible Categories</label></th>
                        <td>
                            <select multiple="multiple" name="visible_categories[]" id="visible_categories" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option>
                                <?php 
                                    $args = array(
                                        'parent'        => 0,
                                        'taxonomy'     => 'product_cat',
                                        'hide_empty'   => false
                                    );
                                    $all_categories = get_categories( $args );
                                    if($all_categories){
                                        foreach($all_categories as $all_category){
                                            ?>
                                                <option value="<?=$all_category->term_id?>"><?php echo esc_attr( __( $all_category->name ) ); ?></option>
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="visible_products">Products</label></th>
                        <td>
                            <select multiple="multiple" name="visible_products[]" id="visible_products" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option>
                                <?php 
                                    $args = array(
                                        'post_type'    => 'product',
                                        'post_status'     => 'publish',
                                        'posts_per_page'   => -1
                                    );
                                    $all_products = new WP_Query( $args );
                                    if($all_products->have_posts()){
                                        while($all_products->have_posts()){
                                            $all_products->the_post();
                                            $product_cat_name = array();
                                            $terms = get_the_terms( get_the_ID(), 'product_cat' );
                                            foreach ($terms as $term) {
                                                if($term->parent){
                                                    $product_cat_name[] = $term->name;
                                                }
                                            }
                                            $sub_cats = '';
                                            if($product_cat_name){
                                                $sub_cats = ' ('.implode(' > ',$product_cat_name).')';
                                            }
                                            ?>
                                                <option value="<?=get_the_ID()?>"><?php echo get_the_title().$sub_cats; ?></option>
                                            <?php
                                        }
                                        wp_reset_postdata();
                                        wp_reset_query();
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <!--tr>
                        <th scope="row"><label for="group_users">Group Users</label></th>
                        <td>
                            <select multiple="multiple" name="group_users[]" id="group_users" class="regular-text">
                            <option value="all"><?php echo esc_attr( __( 'Select All' ) ); ?></option>
                                <?php 
                                    $g_user_lists = get_users();
                                    if($g_user_lists){
                                        foreach($g_user_lists as $g_user_list){
                                            if(is_user_group_exists($g_user_list->ID) === false){
                                            ?>
                                                <option <?=(get_user_groups($g_user_list->ID)) ? 'disabled' : '' ;?> value="<?=$g_user_list->ID?>"><?php echo esc_attr( __( $g_user_list->user_email ) ); ?></option>
                                            <?php
                                            }
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr-->
                    <tr>
                        <th scope="row"><label for="search_users">Group Users</label></th>
                        <td>
                            <input name="search_users" type="text" placeholder="Search...@compass.com" id="search_users" class="regular-text">
                            <input name="selected_search_users" type="hidden" id="selected_search_users">
                            <div class="searched_content regular-text" style="display: none;"></div>
                        </td>
                    </tr>
                </tbody>
            </table>
            <p class="submit"><input type="submit" name="add_new_group" id="submit" class="button button-primary" value="Save Changes"></p>
        </form>
    <?php } elseif(isset($_REQUEST['page']) && $_REQUEST['page'] == 'wbp_user_groups' && isset($_REQUEST['action']) && $_REQUEST['action'] == 'edit_group' && $_REQUEST['group']){
        $edit_group = get_sgl_group($_REQUEST['group']);
    ?>
        <h1 class="wp-heading-inline">Edit Group <a href="admin.php?page=wbp_user_groups" class="page-title-action">User Groups</a> <a href="admin.php?page=wbp_user_groups&action=add_new_group" class="page-title-action">Add Group</a></h1>
        <?php if($msg){ ?>
            <div id="message" class="updated notice notice-success is-dismissible">
                <p><?=$msg?></p>
                <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
            </div>
        <?php } ?>
        <form name="addnewusergroup" method="post" enctype="multipart/form-data" autocomplete="off">
            <table class="form-table" role="presentation">
                <tbody>
                    <tr>
                        <th scope="row"><label for="groupname">Group Name</label></th>
                        <td><input name="groupname" type="text" id="groupname" value="<?=$edit_group->group_name?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="themelogo">Theme Logo</label></th>
                        <td>
                            <input id="upload_image" class="regular-text" type="hidden" name="themelogo" value="<?=$edit_group->logo?>" />
                            <input id="themelogo" class="button" type="button" value="Upload Logo" />
                            <?php if($edit_group->logo){ ?>
                            <input onclick="return false;" id="upload_image_preview" type="image" src="<?=wp_get_attachment_url($edit_group->logo)?>" style="width: 100px;object-fit: contain;object-position: top;" />
                            <?php } ?>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="grpdomain">Group Domain</label></th>
                        <td><input name="grpdomain" type="text" id="grpdomain" value="<?=$edit_group->grpdomain?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="grpcode">Group Code</label></th>
                        <td><input name="grpcode" type="text" id="grpcode" value="<?=$edit_group->grpcode?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="primary_menu_position">Primary Menu Position</label></th>
                        <td>
                            <select name="primary_menu_position" id="primary_menu_position" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                                <?php
                                    $all_menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
                                    if($all_menus){
                                        foreach($all_menus as $all_menu){
                                            ?>
                                                <option <?=($all_menu->term_id == $edit_group->primary_menu) ? 'selected' : '' ; ?> value="<?=$all_menu->term_id?>"><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="secondary_menu_position">Secondary Menu Position</label></th>
                        <td>
                            <select name="secondary_menu_position" id="secondary_menu_position" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                                <?php
                                    if($all_menus){
                                        foreach($all_menus as $all_menu){
                                            ?>
                                                <option <?=($all_menu->term_id == $edit_group->secondary_menu) ? 'selected' : '' ; ?> value="<?=$all_menu->term_id?>"><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="handheld_menu_position">Handheld Menu Position</label></th>
                        <td>
                            <select name="handheld_menu_position" id="handheld_menu_position" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                                <?php
                                    if($all_menus){
                                        foreach($all_menus as $all_menu){
                                            ?>
                                                <option <?=($all_menu->term_id == $edit_group->handheld_menu) ? 'selected' : '' ; ?> value="<?=$all_menu->term_id?>"><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="visible_categories">Visible Categories</label></th>
                        <td>
                            <select multiple="multiple" name="visible_categories[]" id="visible_categories" class="regular-text">
                                <option disabled="disabled" value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option>
                                <?php 
                                    $args = array(
                                        'parent'        => 0,
                                        'taxonomy'     => 'product_cat',
                                        'hide_empty'   => false
                                    );
                                    $all_categories = get_categories( $args );
                                    $s_visible_cat = explode(",",$edit_group->visible_categories);
                                    if($all_categories){
                                        foreach($all_categories as $all_category){
                                            ?>
                                                <option value="<?=$all_category->term_id?>" <?=(in_array($all_category->term_id,$s_visible_cat)) ? 'selected' : '' ; ?>><?php echo esc_attr( __( $all_category->name ) ); ?></option>
                                            <?php
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="visible_products">Products</label></th>
                        <td>
                            <select multiple="multiple" name="visible_products[]" id="visible_products" class="regular-text">
                                <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option>
                                <?php 
                                    $args = array(
                                        'post_type'    => 'product',
                                        'post_status'     => 'publish',
                                        'posts_per_page'   => -1,
                                    );
                                    $args['tax_query'][] = array(
                                        'taxonomy'      => 'product_cat',
                                        'terms'         => $s_visible_cat,
                                        'field'         => 'term_id',
                                        'operator'      => 'IN'
                                    );
                                    $all_products = new WP_Query( $args );
                                    $s_visible_prod = explode(",",$edit_group->visible_products);
                                    if($all_products->have_posts()){
                                        while($all_products->have_posts()){
                                            $all_products->the_post();
                                            $product_cat_name = array();
                                            $terms = get_the_terms( get_the_ID(), 'product_cat' );
                                            foreach ($terms as $term) {
                                                // if($term->parent){
                                                    $product_cat_name[] = $term->name;
                                                // }
                                            }
                                            $sub_cats = '';
                                            if($product_cat_name){
                                                $sub_cats = ' ('.implode(' > ',$product_cat_name).')';
                                            }
                                            ?>
                                                <option value="<?=get_the_ID()?>" <?=(in_array(get_the_ID(),$s_visible_prod)) ? 'selected' : '' ; ?>><?php echo get_the_title().$sub_cats; ?></option>
                                            <?php
                                        }
                                        wp_reset_postdata();
                                        wp_reset_query();
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="group_users">Group Users</label></th>
                        <td>
                            <select multiple="multiple" name="group_users[]" id="group_users" class="regular-text">
                                <option value="all"><?php echo esc_attr( __( 'Select All' ) ); ?></option>
                                <?php 
                                    $g_user_lists = get_users();
                                    $s_user_lists = explode(",",$edit_group->group_users);
                                    if($g_user_lists){
                                        foreach($g_user_lists as $g_user_list){
                                            if(is_user_group_exists($g_user_list->ID) === false || (is_user_group_exists($g_user_list->ID) && get_user_groups($g_user_list->ID) == $edit_group->id)){
                                            ?>
                                                <option value="<?=$g_user_list->ID?>" <?=(in_array($g_user_list->ID,$s_user_lists)) ? 'selected' : '' ; ?>><?php echo esc_attr( __( $g_user_list->user_email ) ); ?></option>
                                            <?php
                                            }
                                        }
                                    }
                                ?>
                            </select>
                        </td>
                    </tr>
                </tbody>
            </table>
            <p class="submit"><input type="submit" name="edit_new_group" id="submit" class="button button-primary" value="Save Changes"></p>
        </form>
    <?php }else{ ?>
        <h1 class="wp-heading-inline">User Groups <a href="admin.php?page=wbp_user_groups&action=add_new_group" class="page-title-action">Add Group</a></h1>
        <?php if($msg){ ?>
            <div id="message" class="updated notice notice-success is-dismissible">
                <p><?=$msg?></p>
                <button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
            </div>
        <?php } ?>
        <table class="wp-list-table widefat fixed striped table-view-list" role="presentation">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Group Name</th>
                    <th>Group Domain</th>
                    <th>Group Code</th>
                    <th>Users</th>
                    <th>Created</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $groups_data = get_all_groups();
                    $i = 1;
                    if($groups_data){
                        foreach($groups_data as $group){
                            ?>
                                <tr>
                                    <td><?=$i?></td>
                                    <td><a href="admin.php?page=wbp_user_groups&action=edit_group&group=<?=$group->id?>"><?=$group->group_name?></a></td>
                                    <td><?=($group->grpdomain) ? $group->grpdomain : 'N/A' ;?></td>
                                    <td><?=($group->grpcode) ? $group->grpcode : 'N/A' ;?></td>
                                    <td><?=get_group_users($group->id)?></td>
                                    <td><?=$group->created?></td>
                                    <td><a href="admin.php?page=wbp_user_groups&action=delete-group&gid=<?=$group->id?>"><i class="fa fa-trash"></i></a></td>
                                </tr>
                            <?php $i++;
                        }
                    }else{
                        ?>
                            <tr>
                                <td colspan="4" align="center">No user group found.</td>
                            </tr>
                        <?php
                    }
                ?>
            </tbody>
        </table>
    <?php } ?>
</div>

<script>
    jQuery(document).ready(function($) {
        $(".notice-dismiss").click(function(){
            $('#message').remove();
        });
        $('#group_users').select2({
            placeholder: '-- Select Users --',
            closeOnSelect: false
        });
        $('#visible_categories').select2({
            placeholder: '-- Select Categories --',
            closeOnSelect: false
        });
        $('#visible_products').select2({
            placeholder: '-- Select Products --',
            closeOnSelect: false
        });
        $('#primary_menu_position, #secondary_menu_position, #handheld_menu_position').select2({
            placeholder: '-- Select Menu --',
            allowClear : true
        });

        $('#visible_categories').change(function(){
            var selected_categories = $(this).val();
            var selected_products = $('#visible_products').val();
            $.ajax({
                url: '<?=admin_url('admin-ajax.php')?>',
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'get_selected_products',
                    selected_categories: selected_categories,
                    selected_products: selected_products
                },
                success: function (response) {
                    if(response.status == 'success'){
                        $("#visible_products").html(response.options);
                    }
                }
            });
        });

        var custom_uploader;
        $('#themelogo').click(function(e) {
            e.preventDefault();
            //If the uploader object has already been created, reopen the dialog
            if (custom_uploader) {
                custom_uploader.open();
                return;
            }
            //Extend the wp.media object
            custom_uploader = wp.media.frames.file_frame = wp.media({
                title: 'Choose Logo',
                button: {
                    text: 'Choose Logo'
                },
                multiple: true
            });
            //When a file is selected, grab the URL and set it as the text field's value
            custom_uploader.on('select', function() {
                $("#upload_image_preview").remove();
                attachment = custom_uploader.state().get('selection').first().toJSON();
                $('#upload_image').val(attachment.id);
                $('#themelogo').after('<input onclick="return false;" id="upload_image_preview" width="40" height="40" type="image" src="'+attachment.url+'"  />');
                
            });
            //Open the uploader dialog
            custom_uploader.open();

        });

        $("#search_users").keyup(function(){
            var str = $(this).val();
            $(".searched_content").hide();
            if(str.length > 3){
                $.ajax({
                    url: '<?=admin_url('admin-ajax.php')?>',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'search_users',
                        str: str
                    },
                    success: function (response) {
                        console.log(response);
                        $(".searched_content").html(response.htm);
                    },
                    complete: function(){
                        $(".searched_content").show();
                    }
                });
            }
        });

        $(document).on("click",".all_select",function(){
            var result = $('.ser_li').map(function(i, opt) {
                $(opt).addClass('selected');
                return $(opt).val();
            }).toArray().join(',');
            $("#selected_search_users").val(result);
            // $('.ser_li').toggleClass('selected');
        });
        $(document).on("click",".ser_li",function(){
            //$('.ser_li').removeClass('selected');
            $(this).toggleClass('selected');
            var result = $('.ser_li.selected').map(function(i, opt) {
                return $(opt).val();
            }).toArray().join(',');            
            $("#selected_search_users").val(result);
        });
        $(document).on("click",".clear-search",function(){
            $("#selected_search_users").val('');
            $(".searched_content").html('').hide();
        });
        $(document).mouseup(function(e){
            var container = $(".searched_content");

            // if the target of the click isn't the container nor a descendant of the container
            if (!container.is(e.target) && container.has(e.target).length === 0) 
            {
                container.hide();
            }
        });
    });
    jQuery('#group_users').on("select2:select", function (e) { 
        var data = e.params.data.id;
        if(data=='all'){
            jQuery("#group_users > option").prop("selected","selected");
            jQuery("#group_users").trigger("change");
        }
    });
</script>
<style>
.select2-container { 
  width:100%!important;
}
.form-table tr:nth-child(8) td > span:first-of-type {
width:100%!important; 
overflow-y:auto;
}

.form-table tr:nth-child(7) td > span ul li {
width:100%!important; 
}

.form-table tr:nth-child(6) td > span ul li,
.form-table tr:nth-child(8) td > span ul li,
.form-table tr:nth-child(9) td > span ul li {
width:48%!important; 
}

.form-table tr:nth-child(10) td > span ul li {
width:22%!important; 
}

.form-table tr:nth-child(7) td > span:first-of-type {
width:100%!important; 
overflow-y:auto;
}

    .searched_content {
        max-height: 290px;
        overflow-y: auto;
        position: absolute;
        z-index: 9999;
        background-color: #fff;
    }
    .searched_content ul {
        margin: 0;
    }
    .searched_content li {
        border-bottom: 1px solid #ccc;
        cursor: pointer;
        padding: 5px;
        margin: 0;
    }
    li.ser_li.selected::before {
        content: "\f00c";
        font-family: "Font Awesome 6 Free";
        font-weight: 900;
        margin-right: 5px;
        border-radius: 50px;
        background-color: #000;
        padding: 2px;
        font-size: 10px;
        color: #fff;
    }
    /* width */
    .searched_content::-webkit-scrollbar {
        width: 4px;
    }

    /* Track */
    .searched_content::-webkit-scrollbar-track {
        background: #ddd;
    }

    /* Handle */
    .searched_content::-webkit-scrollbar-thumb {
        background: #000;
        border-radius: 5px;
    }

    /* Handle on hover */
    .searched_content::-webkit-scrollbar-thumb:hover {
        background: #555;
    }
    .clear-search {
        position: absolute;
        top: 7px;
        right: 7px;
        cursor: pointer;
    }
    span.select2-search.select2-search--inline {
        position: relative;
        top: -18px;
    }
    li.select2-selection__choice {
        padding-left: 20px !important;
    }
    li.select2-selection__choice button span {
        position: relative;
        top: -2px;
    }
</style>