<?php /**Portal User Registration*/ ?>
<?php get_header(); 

if(!is_user_logged_in()){
    wp_redirect(site_url());
    exit;
}
$user = wp_get_current_user();
$valid_roles = [ 'administrator', 'vendor' ];
$the_roles = array_intersect( $valid_roles, $user->roles );
if ( empty( $the_roles ) ) {
    wp_redirect(site_url());
        exit;
}
// if ( !empty( $user->roles ) && is_array( $user->roles ) ) {
//     if(!in_array('administrator', $user->roles) || !in_array('vendor', $user->roles)){
//         wp_redirect(site_url());
//         exit;
//     }
// }

?>

<style>
    .PortalUserRegistration {
        margin: 50px 0;
    }
    .PortalUserRegistration input, .PortalUserRegistration button {
	outline:none;
    }
    .pur_frm_group{
        display: flex;
        flex-direction: row;
        align-items: center;
        margin-bottom: 20px;
    }
    .form-outline {
        position: relative;
        flex: 1 1 auto !important;
    }
    .form-control {
        min-height: auto;
        padding: 0.33em 0.75em;
        border: 0;
        background: transparent;
        transition: all .2s linear;
        width: 100%;
    }
    .form-control:focus {
        box-shadow: none;
        transition: all .1s linear;
        border-color: #1266f1;
        box-shadow: inset 0 0 0 1px #1266f1;
    }
    .form-outline .form-control:focus {
        box-shadow: none!important;
    }
    .fw-bold {
        font-weight: 700!important;
    }
    .form-group-data {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
    }
    .personalDetails{
        flex: 50%;
        max-width: 50%;
        padding: 15px;
    }
    .personalDetails fieldset {
        background-color: #ffffff;
        border: 1px solid silver;
    }
    .PortalUserRegistration fieldset legend {
        background-color: #ffffff;
	font-size:18px;
    }

    .PortalUserRegistration fieldset input, .PortalUserRegistration fieldset select {
        background-color: #ffffff;
	box-shadow:none;
	border: 2px solid #d2d2d2 !important;
	width:100%;
    }
   
    .PortalUserRegistration fieldset select {
	padding:12px 10px;
    }

    .PortalUserRegistration fieldset input:focus {
        background-color: #ffffff;
	box-shadow:none;
	border: 2px solid #d2d2d2 !important;
	outline:none;
	color:#333333;
    }

    .addlinedetails {
        display: flex;
        flex-wrap: wrap;
        flex: 50%;
        max-width: 50%;
        padding: 15px;
    }
    .addlinedetails fieldset {
        flex: 100%;
        max-width: 100%;
        background-color: #ffffff;
        border: 1px solid silver;
    }
    .personalDetails button {
        background-color: #29aae0;
        border-color: #eeeeee;
        color: #fff;
        transition: 0.5s all ease;
    }
    .succees_msg {
        background: #458936;
        margin-left: 0;
        border-radius: 2px;
        color: #fff;
        clear: both;
        border-left: 0.6180469716em solid rgba(0,0,0,.15);
        padding: 1em 2em 1em 3.5em;
        position: relative;
        list-style: none outside;
    }
    .error_msg {
        background: #e04029;
        margin-left: 0;
        border-radius: 2px;
        color: #fff;
        clear: both;
        border-left: 0.6180469716em solid rgba(0,0,0,.15);
        padding: 1em 2em 1em 3.5em;
        position: relative;
        list-style: none outside;
    }
</style>
<script>
    jQuery(document).ready(function(){
        jQuery("#diffship").click(function(){
            jQuery(".diffShipAdd").slideToggle();
        });
        jQuery( ".pur_reg_frm" ).on( "submit", function( event ) {
            jQuery(".succees_msg").hide();
            jQuery(".error_msg").hide();
            jQuery(".personalDetails button").html('Please wait ...<i class="fa fa-spin fa-spinner"></i>');
            event.preventDefault();
            var form_data = jQuery(this).serialize();
            var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
            jQuery.ajax({
                url: ajaxurl, 
                dataType : "json",
                type: "POST",
                data: form_data,  
                success: function(response) 
                {
                    jQuery(".personalDetails button").html('Register');
                    if(response.status == 'success'){
                        jQuery(".succees_msg").show();
                        jQuery('.pur_reg_frm')[0].reset();
                    }
                    else{
                        jQuery(".error_msg").html(response.message).show();
                    }
                }   
            });
        });
    });
</script>

<section class="PortalUserRegistration">
    <div class="pur_container">
        <h1 class="product_title">Portal New User Registration</h1>
        <p class="succees_msg" style="display:none">User Registered Successfully</p>
        <p class="error_msg" style="display:none">User Registration Failed</p>
        <form class="pur_reg_frm" autocomplete="Off" method="post">
            <input type="hidden" name = "action" value="add_user_register">
            <div class="form-group-data">
                <div class="personalDetails">
                    <fieldset>
                        <legend>Agent's Personal Details:</legend>

			<div class="pur_frm_group" style="display:block;">
			<label style="display:block; margin-bottom:15px;">This email will also be their <strong>username to login</strong> into the site.</label>
                            <input type="email" name="yemail" id="yemail" class="form-control" autocomplete="Off" placeholder="Agent's Email"/><br/>
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="fname" id="fname" class="form-control" placeholder="First Name" />
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="lname" id="lname" class="form-control" placeholder="Last Name" />
                        </div>

			<?php /*

                        <div class="pur_frm_group">
                            <input type="tel" name="yphone" id="yphone" class="form-control" autocomplete="Off" placeholder="Phone Number"/>
                        </div>
                        <div class="pur_frm_group">
                            <input type="tel" name="ycompany" id="ycompany" class="form-control" autocomplete="Off" placeholder="Your Company"/>
                        </div>
			*/ ?>

                    </fieldset>

                    <div class="pur_frm_group">
                        <button type="submit" class="btn btn-primary btn-lg">Register</button>
                    </div>
                </div>
                <div class="addlinedetails">
                    <fieldset>
                        <legend>Agent's Billing Details:</legend>
                        <div class="pur_frm_group">
                            <input type="text" name="billing_address_1" id="billing_address_1" class="form-control" autocomplete="Off" placeholder="Address Line 1"/>
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="billing_address_2" id="billing_address_2" class="form-control" autocomplete="Off" placeholder="Address Line 2"/>
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="billing_city" id="billing_city" class="form-control" autocomplete="Off" placeholder="City"/>
                        </div>

			<div class="pur_frm_group">
			<select id="billing_state" name="billing_state"><option value="0">Choose State ...</option><option value="AL">Alabama</option><option value="AK">Alaska</option><option value="AZ">Arizona</option><option value="AR">Arkansas</option><option value="CA">California</option><option value="CO">Colorado</option><option value="CT">Connecticut</option><option value="DE">Delaware</option><option value="DC">District Of Columbia</option><option value="FL">Florida</option><option value="GA">Georgia</option><option value="HI">Hawaii</option><option value="ID">Idaho</option><option value="IL">Illinois</option><option value="IN">Indiana</option><option value="IA">Iowa</option><option value="KS">Kansas</option><option value="KY">Kentucky</option><option value="LA">Louisiana</option><option value="ME">Maine</option><option value="MD">Maryland</option><option value="MA">Massachusetts</option><option value="MI">Michigan</option><option value="MN">Minnesota</option><option value="MS">Mississippi</option><option value="MO">Missouri</option><option value="MT">Montana</option><option value="NE">Nebraska</option><option value="NV">Nevada</option><option value="NH">New Hampshire</option><option value="NJ">New Jersey</option><option value="NM">New Mexico</option><option value="NY">New York</option><option value="NC">North Carolina</option><option value="ND">North Dakota</option><option value="OH">Ohio</option><option value="OK">Oklahoma</option><option value="OR">Oregon</option><option value="PA">Pennsylvania</option><option value="RI">Rhode Island</option><option value="SC">South Carolina</option><option value="SD">South Dakota</option><option value="TN">Tennessee</option><option value="TX">Texas</option><option value="UT">Utah</option><option value="VT">Vermont</option><option value="VA">Virginia</option><option value="WA">Washington</option><option value="WV">West Virginia</option><option value="WI">Wisconsin</option><option value="WY">Wyoming</option><option value="AA">Armed Forces (AA)</option><option value="AE">Armed Forces (AE)</option><option value="AP">Armed Forces (AP)</option></select>
			</div>

                        <div class="pur_frm_group">
                            <input type="text" name="billing_postcode" id="billing_postcode" class="form-control" autocomplete="Off" placeholder="Postcode"/>
                        </div>

			<div class="pur_frm_group">
                            <input type="text" name="billing_phone" id="billing_phone" class="form-control" autocomplete="Off" placeholder="Billing Phone Number"/>
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="addcountry" id="addcountry" value="United States (US)" class="form-control" autocomplete="Off" placeholder="Country" disabled="disabled"/>
                        </div>
                    </fieldset>
                    
                    <div class="pur_frm_group">
                        <input class="form-check-input me-2" name="diffship" type="checkbox" value="" id="diffship"/>
                        <label class="form-check-label" for="diffship">
                            Ship to a different address?
                        </label>
                    </div>

                    <fieldset style="display: none;" class="diffShipAdd">
                        <legend>Agent's Shipping Details:</legend>
                        <div class="pur_frm_group">
                            <input type="text" name="shipping_address_1" id="shipping_address_1" class="form-control" autocomplete="Off" placeholder="Address Line 1"/>
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="shipping_address_2" id="shipping_address_2" class="form-control" autocomplete="Off" placeholder="Address Line 2"/>
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="shipping_city" id="shipping_city" class="form-control" autocomplete="Off" placeholder="City"/>
                        </div>

			<div class="pur_frm_group">
			<select id="shipping_state" name="shipping_state"><option value="0">Choose State ...</option><option value="AL">Alabama</option><option value="AK">Alaska</option><option value="AZ">Arizona</option><option value="AR">Arkansas</option><option value="CA">California</option><option value="CO">Colorado</option><option value="CT">Connecticut</option><option value="DE">Delaware</option><option value="DC">District Of Columbia</option><option value="FL">Florida</option><option value="GA">Georgia</option><option value="HI">Hawaii</option><option value="ID">Idaho</option><option value="IL">Illinois</option><option value="IN">Indiana</option><option value="IA">Iowa</option><option value="KS">Kansas</option><option value="KY">Kentucky</option><option value="LA">Louisiana</option><option value="ME">Maine</option><option value="MD">Maryland</option><option value="MA">Massachusetts</option><option value="MI">Michigan</option><option value="MN">Minnesota</option><option value="MS">Mississippi</option><option value="MO">Missouri</option><option value="MT">Montana</option><option value="NE">Nebraska</option><option value="NV">Nevada</option><option value="NH">New Hampshire</option><option value="NJ">New Jersey</option><option value="NM">New Mexico</option><option value="NY">New York</option><option value="NC">North Carolina</option><option value="ND">North Dakota</option><option value="OH">Ohio</option><option value="OK">Oklahoma</option><option value="OR">Oregon</option><option value="PA">Pennsylvania</option><option value="RI">Rhode Island</option><option value="SC">South Carolina</option><option value="SD">South Dakota</option><option value="TN">Tennessee</option><option value="TX">Texas</option><option value="UT">Utah</option><option value="VT">Vermont</option><option value="VA">Virginia</option><option value="WA">Washington</option><option value="WV">West Virginia</option><option value="WI">Wisconsin</option><option value="WY">Wyoming</option><option value="AA">Armed Forces (AA)</option><option value="AE">Armed Forces (AE)</option><option value="AP">Armed Forces (AP)</option></select>
			</div>


                        <div class="pur_frm_group">
                            <input type="text" name="shipping_postcode" id="shipping_postcode" class="form-control" autocomplete="Off" placeholder="Postcode"/>
                        </div>

			<div class="pur_frm_group">
                            <input type="text" name="shipping_phone" id="shipping_phone" class="form-control" autocomplete="Off" placeholder="Shipping Phone Number"/>
                        </div>

                        <div class="pur_frm_group">
                            <input type="text" name="shipping_country" id="shipping_country" value="United States (US)" class="form-control" autocomplete="Off" placeholder="Country" disabled="disabled"/>
                        </div>
                    </fieldset>
                </div>
            </div>

        </form>
    </div>
</section>

<?php get_footer(); ?>