<?php
/*
    Plugin Name: WBP Portal Manager
    Plugin URI: https://www.helpfulinsightsolution.com/custom-plugin-development/
    Description: Addon for user switching plugin to perform switching functionality in frontend.Admin/Shop manager can switch user from Woo My Account section.
    Version: 1.0
    Author: Helpful Insight Pvt. Ltd.
    Author URI: https://www.helpfulinsightsolution.com/
    License: GPLv2 or later
    Text Domain: pcl
*/

add_filter( 'wp_nav_menu_items', 'add_extra_item_to_nav_menu', 10, 2 );
function add_extra_item_to_nav_menu( $items, $args ) {
    $user = new WP_User( get_current_user_id() );
    if ( !empty( $user->roles ) && is_array( $user->roles ) ) {
        if(in_array('administrator', $user->roles) || in_array('vendor', $user->roles)){
            if($args->menu->name == 'Header Menu' || (isset($args->menu) && $args->menu->name == 'Portals Menu')){
                $items .= '<li class="mega-menu-item mega-menu-item-type-custom mega-menu-item-object-custom"><a class="mega-menu-link" href="'. get_permalink( get_option('woocommerce_myaccount_page_id') ) .'wbp-board-members/">Portal Manager</a></li>';
            }
        }
    }
    return $items;
}

function bbloomer_add_wbp_board_members_endpoint() {
    add_rewrite_endpoint( 'wbp-board-members', EP_ROOT | EP_PAGES );
    add_rewrite_endpoint( 'wbp-profile-picture', EP_ROOT | EP_PAGES );
}
add_action( 'init', 'bbloomer_add_wbp_board_members_endpoint' );
  
// ------------------
// 2. Add new query var
  
function bbloomer_wbp_board_members_query_vars( $vars ) {
    $vars[] = 'wbp-board-members';
    $vars[] = 'wbp-profile-picture';
    return $vars;
}
add_filter( 'query_vars', 'bbloomer_wbp_board_members_query_vars', 0 );
  
// ------------------
// 3. Insert the new endpoint into the My Account menu
function eden_account_add_profile_link( $items ) {
    $newItems = array( 
        'wbp-profile-picture' => 'Profile Picture'        
    );

    $user = new WP_User( get_current_user_id() );
    if ( !empty( $user->roles ) && is_array( $user->roles ) ) {
        if(in_array('administrator', $user->roles) || in_array('vendor', $user->roles) || in_array('customer', $user->roles)){
            $items = array_slice( $items, 0, 1, true ) 
            + $newItems 
            + array_slice( $items, 1, NULL, true );
        }
    }

    return $items;
} 
add_filter( 'woocommerce_account_menu_items', 'eden_account_add_profile_link' );

function bbloomer_add_wbp_board_members_link_my_account( $items ) {
    $newItems = array( 
        'wbp-board-members' => 'Portal Manager',
    );

    $user = new WP_User( get_current_user_id() );
    if ( !empty( $user->roles ) && is_array( $user->roles ) ) {
        if(in_array('administrator', $user->roles) || in_array('vendor', $user->roles)){
            $items = array_slice( $items, 0, 1, true ) 
            + $newItems 
            + array_slice( $items, 1, NULL, true );
        }
    }

    return $items;
} 
add_filter( 'woocommerce_account_menu_items', 'bbloomer_add_wbp_board_members_link_my_account' );

  
// ------------------
// 4. Add content to the new tab
  
function bbloomer_wbp_board_members_content() {
    // header("Cache-Control: no-cache, must-revalidate");
    // header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    // header("Content-Type: application/xml; charset=utf-8");
    // clearstatcache();
    $user = new WP_User( get_current_user_id() );
    $html = 'You are not authorized.';
    if ( !empty( $user->roles ) && is_array( $user->roles ) ) {
        if(in_array('administrator', $user->roles) || in_array('vendor', $user->roles)){
            $html = '<h3>Users</h3>';
            $html .= '<table id="customer-mailing-list" class="customer-mailing-list woocommerce-orders-table shop_table shop_table_responsive my_account_orders ">';
                $html .= '<thead>';
                    $html .= '<tr>';
                        $html .= '<th>';
                            $html .= 'Username';
                        $html .= '</th>';
                        $html .= '<th>';
                            $html .= 'Name';
                        $html .= '</th>';
                        $html .= '<th>';
                            $html .= 'Email';
                        $html .= '</th>';
                        $html .= '<th>';
                            $html .= 'Action';
                        $html .= '</th>';
                    $html .= '</tr>';
                $html .= '</thead>';
                $html .= '<tbody>';
                    global $wpdb;
                    $alluser = get_users();
                    $logged_in_group_is = get_user_meta(get_current_user_id(), '_user_group', true);
                    $logged_in_group_is = get_user_groups(get_current_user_id());
		    $alluser = get_group_users_data($logged_in_group_is);
            
                    $i = 0;
                    if($alluser){
                        foreach ($alluser as $customer) {
                            //$user_group_is = get_user_meta($customer->ID, '_user_group', true);
                            $usrDetails = get_user_by('ID',$customer);
                            $wpnonce = wp_create_nonce('switch_to_user_'.$customer);
                            if($customer != get_current_user_id()){ $i++;
                                $html .= '<tr>';
                                    $html .= '<td>';
                                        $html .= $usrDetails->user_login;
                                    $html .= '</td>';
                                    $html .= '<td>';
                                        $html .= ($usrDetails->first_name) ? $usrDetails->first_name.' '.$usrDetails->last_name : $usrDetails->display_name;
                                    $html .= '</td>';
                                    $html .= '<td>';
                                        $html .= $usrDetails->user_email;
                                    $html .= '</td>';
                                    $html .= '<td>';
                                        $html .= '<a href="'.site_url().'/wbp-super-login?action=switch_to_user&user_id='.$usrDetails->ID.'&nr=1&_wpnonce='.$wpnonce.'">Switch</a>';
                                    $html .= '</td>';
                                $html .= '</tr>';
                            }
                        }
                        if($i == 0){
                            $html .= '<tr>';
                                $html .= '<td colspan="3" style="text-align: center;">';
                                    $html .= 'Currently there are no users, please contact us <a href="/contact-us">(click here)</a> for further info.';
                                $html .= '</td>';
                            $html .= '</tr>';
                        }
                    }else{
                        $html .= '<tr>';
                            $html .= '<td colspan="3" style="text-align: center;">';
                                $html .= 'Currently there are no users, please contact us <a href="/contact-us">(click here)</a> for further info.';
                            $html .= '</td>';
                        $html .= '</tr>';
                    }
                $html .= '</tbody>';
            $html .= '</table>';

	    $html .= "<div class='account-add-realtor-link'><p><strong>Can't find the realtor?</strong> If you can't find the realtor please submit a request here:</p><br/><a href='/portal-new-user-registration/'>Request New User Addition</a></div>";
        }
    }
    echo $html;
}
add_action( 'woocommerce_account_wbp-board-members_endpoint', 'bbloomer_wbp_board_members_content' );

function add_css_for_switch_back(){
    $css = '
        <style>
            p#user_switching_switch_on a {
                color: #fff;
            }
            p#user_switching_switch_on {
                position: fixed;
		bottom:15px;
		left:0;
		width:fit-content;
                padding: 16px 15px;
                z-index: 9999;
                background: #cc3e06;
		font-weight:bold;
            }
        </style>
		<script>
			jQuery(document).ready(function() {
				jQuery("#customer-mailing-list").DataTable();
			} );
		</script>
    ';
    echo $css;
}
add_action( 'wp_head', 'add_css_for_switch_back' );

function portal_profile_picture_content(){
    $uploaded_file = '';
    if(isset($_POST['upload-profile-picture']) && $_POST['upload-profile-picture']){
        if(!$_FILES['wbp-profile-picture']['error']){
            $uploaded_file = wp_upload_bits( $_FILES['wbp-profile-picture']['name'], null, @file_get_contents( $_FILES['wbp-profile-picture']['tmp_name'] ) );
            update_user_meta(get_current_user_id(), 'wbp-profile-picture', $uploaded_file['url']);
        }
    }

    $wbp_profile_picture_url = get_user_meta(get_current_user_id(), 'wbp-profile-picture', true);
    $wbp_profile_picture_id = attachment_url_to_postid($wbp_profile_picture_url);

    $html = '<div class="portal_profile_picture">
        <p>Please Upload a Profile Picture for templates, this image should ideally be <strong style="text-decoration:underline;">150px wide and 180px tall (height).</strong></p><br/>
        <div class="portal_profile_picture_wrap">
            <form method="post" enctype="multipart/form-data">
                <input type="file" accept="image/*" onchange="openFile(event)" name="wbp-profile-picture" id="wbp-profile-picture" />
                <input type="submit" name="upload-profile-picture" class="upload-profile-picture" value="Upload Profile Picture" />
            </form>
            <div class="portal_profile_picture_val">
                <img media-id="'.$wbp_profile_picture_id.'" src="'.$wbp_profile_picture_url.'" id="portal_profile_picture_val" />
            </div>
        </div>
    </div>

    <style>
	.portal_profile_picture input[type="submit"] { 
	background:#29aae0;
	color:#fff;
	}
	.portal_profile_picture input[type="submit"]:hover {
	background:#277b9f;
	}
        .portal_profile_picture_val {
            width: 150px;
            height: 180px;
        }
	.portal_profile_picture_val img {
            min-width: 100%;
        }
        .upload-profile-picture{
            background-color: #29aae0;
            border-color: #29aae0;
            color: #ffffff;
            transition: all 0.5s ease;
        }
    </style>

    <script>
        var openFile = function(file) {
            var input = file.target;
        
            var reader = new FileReader();
            reader.onload = function(){
            var dataURL = reader.result;
            var output = document.getElementById("portal_profile_picture_val");
            output.src = dataURL;
            };
            reader.readAsDataURL(input.files[0]);
        };
    </script>';

    echo $html;
}
add_action( 'woocommerce_account_wbp-profile-picture_endpoint', 'portal_profile_picture_content' );

// add_action( 'edit_user_profile', 'wk_custom_user_profile_fields' );
add_action( 'show_user_profile', 'wk_custom_user_profile_fields' );
function wk_custom_user_profile_fields( $user ){
    $wbp_profile_picture_url = get_user_meta(get_current_user_id(), 'wbp-profile-picture', true);
    ?>    
        <table class="form-table">
            <tr>
                <th><label for="profilePicture">Profile Picture</label></th>
                <td><img src="<?=$wbp_profile_picture_url?>" style="width: 150px;height: 150px;object-fit: contain;" /></td>
            </tr>
        </table>    
    <?php
}