<?php 
/*
Plugin Name: Template NBDesigner for user
Plugin URI: https://cmsmart.net/wordpress-plugins/woocommerce-online-product-designer-plugin
Description: A NBDesigner printing ecosystem. Included advanced function hooks.
Version: 1.0.0
Author: The
Author URI: https://cmsmart.net/
License: GPLv2 or later
Text Domain: web-to-print-online-designer
Domain Path: /langs
*/

add_action( 'nbd_menu', 'tfu_add_sub_menu', 100 );
function tfu_add_sub_menu(){
	if( current_user_can( 'manage_nbd_tool' ) ){
        add_submenu_page(
            'nbdesigner', esc_html__('User Companies', 'web-to-print-online-designer'), esc_html__('User Companies', 'web-to-print-online-designer'), 'manage_nbd_tool', 'edit-tags.php?taxonomy=company_tag&post_type=product', null
        );
    }
}

add_action( 'woocommerce_register_taxonomy', 'tfu_init_taxonomy' );
function tfu_init_taxonomy(){
	register_taxonomy('company_tag', array('product'),
        array(
            'hierarchical'  => false,
            'public'        => false,
            'rewrite'       => false,
            'show_ui'       => true,
            'show_in_menu'  => false,
            'show_tagcloud' => false,
            'meta_box_cb'   => false,
            'label'         => esc_html__('User companies', 'web-to-print-online-designer'),
            'labels'        => array(
                'name'              => esc_html__('User companies', 'web-to-print-online-designer'),
                'singular_name'     => esc_html__('User company', 'web-to-print-online-designer'),
                'search_items'      => esc_html__('Search Template company', 'web-to-print-online-designer'),
                'all_items'         => esc_html__('All User company', 'web-to-print-online-designer'),
                'edit_item'         => esc_html__('Edit User company', 'web-to-print-online-designer'),
                'update_item'       => esc_html__('Update User company', 'web-to-print-online-designer'),
                'add_new_item'      => esc_html__('Add New User company', 'web-to-print-online-designer'),
                'new_item_name'     => esc_html__('New User company', 'web-to-print-online-designer')
            ),
            
        )
    );
}
add_action('nbod_before_artist_info','tfu_before_artist_info');
function tfu_before_artist_info($user_info){
	$terms = get_terms( array(
	    'taxonomy' => 'company_tag',
	    'hide_empty' => false
	) );
	// print_r($user_info);
	?>
	<div class="nbd-section">
        <label><?php esc_html_e( 'Company', 'web-to-print-online-designer' ); ?></label>
        <?php $banner = $user_info['nbd_artist_banner']; ?>
        <select style="width: 15em;" name="nbd_company_user">
			<option value="">Select Company</option>
        	<?php /*foreach ($terms as $key => $term) :?>
        	<option <?php selected( $user_info['company_user'], $term->term_id ); ?> value="<?php echo $term->term_id ?>"><?php echo $term->name ?></option>
        	<?php endforeach; */
			foreach(get_all_groups() as $groups){
				echo '<option value="'.$groups->id.'" '.(get_user_groups($user_info['user_id']) == $groups->id ? 'selected' : '').'>'.$groups->group_name.'</option>';
			}?>
        </select>
    </div>
	<?php
}

add_filter('nbod_get_infor_designer','tfu_get_infor_designer',10,2);
function tfu_get_infor_designer($infos,$user_id){
	$company_user = get_user_meta( $user_id, 'nbd_company_user',true );
	$infos['company_user'] = $company_user;
	$infos['user_id'] = $user_id;
	return $infos;
}
add_filter('nbod_extra_field_setting_update','tfu_extra_field_setting_update');
function tfu_extra_field_setting_update($infos){
	$infos[] = 'company_user';
	return $infos;
}

add_filter('nbod_extra_settings_user','tfu_extra_settings_user');
function tfu_extra_settings_user($infos){
	$infos['company_user'] = $_POST['nbd_company_user'];
	return $infos;
}

add_action('nbod_create_template_fields','tfu_create_template_fields');
function tfu_create_template_fields(){
	$path = NBDESIGNER_CUSTOMER_DIR . '/' . $_GET['nbd_item_key'];
	$config = nbd_get_data_from_json( $path . '/config.json' );
	?>
	<div class="template-tags template-field-wrap">

        <label style="margin-right: 10px"><?php esc_html_e('Company','web-to-print-online-designer'); ?></label>
        <select style="width: 150px;" name="company">
        	<!-- <option ng-repeat="com in settings.term_company_tag" value="{{com.term_id}}">{{com.name}}</option> -->
			<?php
			

				echo '<option value="">No Company</option>';
				foreach(get_all_groups() as $groups){
					echo '<option value="'.$groups->id.'" '.($config->company && $config->company == $groups->id ? 'selected' : '' ).'>'.$groups->group_name.'</option>';
				}
			?>
        </select>
    </div>
    <?php
}
add_action('nbd_js_config','tfu_nbd_js_config');
function tfu_nbd_js_config(){
	$terms = get_terms( array(
	    'taxonomy' => 'company_tag',
	    'hide_empty' => false
	) );
	?>
	var tfu_nbd_js_config = true;
	NBDESIGNCONFIG['term_company_tag'] = <?php echo json_encode($terms); ?>;
	<?php
}

add_action('nbod_update_extra_settings_templates','tfu_update_extra_settings_templates');
function tfu_update_extra_settings_templates($temp){
	$folder = $temp['folder'];
	$path = NBDESIGNER_CUSTOMER_DIR . '/' . $folder;
	$config = nbd_get_data_from_json( $path . '/config.json' );
	$config->company = $_POST['company'];
	file_put_contents($path . '/config.json', json_encode($config));
}

add_filter('nbod_variable_data_template','tfu_variable_data_template',10,2);
function tfu_variable_data_template($data,$template){
	$folder = $template['folder'];
	$path = NBDESIGNER_CUSTOMER_DIR . '/' . $folder;
	$config = nbd_get_data_from_json( $path . '/config.json' );
	$data['company'] = $config->company ? $config->company : '';
	return $data;
}

add_filter('nbd_product_templates','nbd_tpl',10,2);
function nbd_tpl($data, $templates){
	$user_id = get_current_user_id();
	$company_user = get_user_meta( $user_id, 'nbd_company_user',true );
	// echo $company_user;
	// print_r($data);
	//print_r($templates);
	// die();
	$newData = array();

	if ( current_user_can( 'manage_options' ) ) {
		return $data;
	}

	// if ( !is_user_logged_in() ) {
	// 	return $data;
	// }
	
	if($templates){
		foreach ( $templates as $tem ){
			$path_preview   = NBDESIGNER_CUSTOMER_DIR . '/' . $tem['folder'] . '/preview';
			$listThumb      = Nbdesigner_IO::get_list_images( $path_preview );
			$listThumb      = nbd_sort_file_by_side( $listThumb );
			if( count( $listThumb ) ){
				$_temp          = array();
				$_temp['id']    = $tem['folder'];
				/*nbdesigner advanced */
				$_temp = apply_filters('add_color',$_temp,$tem);
				foreach( $listThumb as $img ){
					$_temp['src'][] = Nbdesigner_IO::wp_convert_path_to_url( $img );
				}
				if( isset( $tem['thumbnail'] ) && $tem['thumbnail'] ){
					$_temp['thumbnail'] = wp_get_attachment_url( $tem['thumbnail'] );
				}else{
					$_temp['thumbnail'] = $_temp['src'][0];
				}
				/*nbdesigner advanced */
				$_temp = apply_filters('nbod_add_temp_name',$_temp,$tem);

				$folder = $tem['folder'];
				$path = NBDESIGNER_CUSTOMER_DIR . '/' . $folder;
				$config = nbd_get_data_from_json( $path . '/config.json' );
				$datacompany = $config->company ? $config->company : '';
				// echo $datacompany;

				if(!is_user_logged_in() || $datacompany == ''){
					$newData[] = $_temp;
				}elseif($datacompany && ($company_user == $datacompany)){
					$newData[] = $_temp;
				}
			}
		}
	}

	return $newData;
}
function tfu_get_list_templates($data, $templates){
	$user_id = get_current_user_id();
	$company_user = 0;
	$templs = array();
	if($user_id){	
		$templs = array();	
		foreach ($templates as $key => $temp) {
			$company_user = get_user_meta( $user_id, 'nbd_company_user',true );
			$folder = $temp['folder'];
			$path = NBDESIGNER_CUSTOMER_DIR . '/' . $folder;
			$config = nbd_get_data_from_json( $path . '/config.json' );
			if($config->company && $company_user == $config->company){
				$templs[] = $temp;
			}
		}
	}
	else{
		$templs = array();
		return $templs;	
		foreach ($templates as $key => $temp) {
			$company_user = get_user_meta( $user_id, 'nbd_company_user',true );
			$folder = $temp['folder'];
			$path = NBDESIGNER_CUSTOMER_DIR . '/' . $folder;
			$config = nbd_get_data_from_json( $path . '/config.json' );
			if(!isset($config->company)){
				$templs[] = $temp;
			}
		}
	}
	return $templs;
}
add_action('edited_company_tag','tfu_edited_company_tag',10,2);
function tfu_edited_company_tag($term_id, $tt_id){
	update_term_meta($term_id,'_slug_address',$_POST['slug_address']);
	update_term_meta($term_id,'_slug_code',$_POST['slug_code']);
	update_term_meta($term_id,'_slug_city',$_POST['slug_city']);
	update_term_meta($term_id,'_slug_phone',$_POST['slug_phone']);
	update_term_meta($term_id,'_slug_email',$_POST['slug_email']);
	update_term_meta($term_id,'_slug_website',$_POST['slug_website']);
}
add_action('company_tag_edit_form','tfu_edit_form_fields',10,2);
function tfu_edit_form_fields($tag, $taxonomy){
	$term_id = $tag->term_id;
	$address = get_term_meta($term_id,'_slug_address',true);
	$slug_code = get_term_meta($term_id,'_slug_code',true);
	$slug_city = get_term_meta($term_id,'_slug_city',true);
	$slug_phone = get_term_meta($term_id,'_slug_phone',true);
	$slug_email = get_term_meta($term_id,'_slug_email',true);
	$slug_website = get_term_meta($term_id,'_slug_website',true);
	?>
	<div class="form-field term-slug-wrap">
		<label for="tag-address"><?php _e( 'Address' ); ?></label>
		<input name="slug_address" id="tag-address" type="text" value="<?php echo $address ?>"/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-code"><?php _e( 'Zip/postal code' ); ?></label>
		<input name="slug_code" id="tag-code" type="text" value="<?php echo $slug_code ?>"/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-city"><?php _e( 'City' ); ?></label><br/>
		<input name="slug_city" id="tag-city" type="text" value="<?php echo $slug_city ?>"/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-phone"><?php _e( 'Phone' ); ?></label>
		<input name="slug_phone" id="tag-phone" type="text" value="<?php echo $slug_phone ?>"/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-email"><?php _e( 'Email' ); ?></label><br/>
		<input name="slug_email" id="tag-email" type="text" value="<?php echo $slug_email ?>"/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-website"><?php _e( 'Website' ); ?></label>
		<input name="slug_website" id="tag-website" type="text" value="<?php echo $slug_website ?>"/>
	</div>
	<?php
}

add_action('create_company_tag','tfu_create_company_tag',10,2);
function tfu_create_company_tag($term_id, $tt_id){
	update_term_meta($term_id,'_slug_address',$_POST['slug_address']);
	update_term_meta($term_id,'_slug_code',$_POST['slug_code']);
	update_term_meta($term_id,'_slug_city',$_POST['slug_city']);
	update_term_meta($term_id,'_slug_phone',$_POST['slug_phone']);
	update_term_meta($term_id,'_slug_email',$_POST['slug_email']);
	update_term_meta($term_id,'_slug_website',$_POST['slug_website']);
}
add_action('company_tag_add_form_fields','tfu_add_form_fields');
function tfu_add_form_fields(){
	global $tax;
	$address = get_term_meta( $tax->ID, 'meta_key', true );
	?>
	<div class="form-field term-slug-wrap">
		<label for="tag-address"><?php _e( 'Address' ); ?></label>
		<input name="slug_address" id="tag-address" type="text" value=""/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-code"><?php _e( 'Zip/postal code' ); ?></label>
		<input name="slug_code" id="tag-code" type="text" value=""/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-city"><?php _e( 'City' ); ?></label>
		<input name="slug_city" id="tag-city" type="text" value=""/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-phone"><?php _e( 'Phone' ); ?></label>
		<input name="slug_phone" id="tag-phone" type="text" value=""/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-email"><?php _e( 'Email' ); ?></label>
		<input name="slug_email" id="tag-email" type="text" value=""/>
	</div>
	<div class="form-field term-slug-wrap">
		<label for="tag-website"><?php _e( 'Website' ); ?></label>
		<input name="slug_website" id="tag-website" type="text" value=""/>
	</div>
	<?php
}