<?php
/**
* Plugin Name:       template for size option
* Plugin URI:        https://cmsmart.net
* Version:           1.0.0
* Description:       template of size option for NBDesigner
* Requires at least: 5.2
* Requires PHP:      7.1
* Author:            The
* Author URI:        https://cmsmart.net
* License:           GPL v2 or later
* License URI:       https://www.gnu.org/licenses/gpl-2.0.html
* Text Domain:       nbdesigner-advanced
* Domain Path:       /languages
*/

add_filter('nbod_create_template_btn','tsov_create_template_btn',10,3);
add_filter('nbd_button_import_temp','tsov_create_template_btn',10,3);
function tsov_create_template_btn($html,$product_id,$link_create_template){
	$field = get_option_size_product($product_id);
	if($field){
		$select['options'] = $field['general']['attributes']['options'];
    	$select['id'] = $field['id'];
	}
	
	if(count($select) > 0){
		ob_start();
		?>
		<?php add_thickbox(); ?>
		<a class="button nbd-admin-tem-link thickbox" href="#TB_inline?width=300&height=160&inlineId=nbod-thickbox-template">
            <span class="dashicons dashicons-art"></span>
            <?php esc_html_e('Create Template', 'web-to-print-online-designer'); ?>
        </a>   
        <div id="nbod-thickbox-template" style="display:none;">
            <table class="form-table">
                <tr valign="top">
                    <th scope="row" class="titledesc"><?php esc_html_e("Choose variation", 'web-to-print-online-designer'); ?></th>
                    <td class="forminp-text">
                        <select onchange="changeLinkTemplate(this)">
                        <?php foreach ($select['options'] as $key => $op): ?>
                            <option value="<?php echo( $key ); ?>"><?php echo( $op['name'] ); ?></option>
                        <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            </table>
            <p class="nbd-admin-setting-text-align-center"><a class="button button-primary nbd-create" href="<?php echo $link_create_template .'&id='.$select['id'].'&key=0'; ?>" data-href="<?php echo( $link_create_template . '&id=' . $select['id'] ); ?>"><?php esc_html_e("Create template", 'web-to-print-online-designer'); ?></a></p>
        </div>  
        <script>
            changeLinkTemplate = function(e){
                var vid = jQuery(e).val(),
                btn = jQuery(e).parents('table').siblings('p').find('a.nbd-create'),
                origin_fref = btn.data('href'),
                new_href = origin_fref + '&key=' + vid;
                btn.attr('href', new_href);
            }
        </script>
		<?php
		$html = ob_get_clean();
	}
	return $html;
}
function get_option_size_product($product_id,$id = ''){
	$option_id = NBD_FRONTEND_PRINTING_OPTIONS::get_product_option( $product_id );
	$select = array();
	if( $option_id ){
   		$_options = NBD_FRONTEND_PRINTING_OPTIONS::get_option( $option_id );
   		if($_options){
   			$options = unserialize($_options['fields']);
	        if( !isset($options['fields']) ){
	            $options['fields'] = array();
	        }
	        $options['fields'] = NBD_FRONTEND_PRINTING_OPTIONS::recursive_stripslashes( $options['fields'] );
	        foreach ($options['fields'] as $key => $field) {
	        	if($id){
	        		if($field['id'] == $id){
	        			return $field;
	        		}
	        	}
	        	else{
	        		if($field['nbd_type'] == 'size' && $field['general']['attributes']['same_size'] == 'n'){
	    				return $field;
	    			}
	        	}
    			
    		}
	    }
	}
	return null;
}
add_filter('nbd_product_info','tsov_product_info');
function tsov_product_info($data){
	if(isset($_GET['id']) && isset($_GET['key'])){
		$product_id     = ( isset( $_GET['product_id'] ) &&  $_GET['product_id'] != '' ) ? absint( $_GET['product_id'] ) : 0;
		$id = $_GET['id'];
		$key = $_GET['key'];
		$field = get_option_size_product($product_id,$id);
		foreach ($data['product'] as $k => $side) {
			$size = $field['general']['attributes']['options'][$key];
			$data['product'][$k]['product_width'] = $size['product_width'];
			$data['product'][$k]['product_height'] = $size['product_height'];
			$data['product'][$k]['real_width'] = $size['real_width'];
			$data['product'][$k]['real_height'] = $size['real_height'];
			$data['product'][$k]['real_top'] = $size['real_top'];
			$data['product'][$k]['real_left'] = $size['real_left'];
		}
		$data['field_size'] = $field;
	}
	$nbd_item_key     = ( isset( $_GET['nbd_item_key'] ) &&  $_GET['nbd_item_key'] != '' ) ? $_GET['nbd_item_key'] : '';
	if($nbd_item_key){
		$path           = NBDESIGNER_CUSTOMER_DIR . '/' . $nbd_item_key;
		$config = nbd_get_data_from_json( $path . '/config.json' );
		if(isset($config->field_size)){
			$data['field_size'] = $config->field_size;
		}
	}
	return $data;
}
add_action('nbd_js_config','tsov_js_config');
function tsov_js_config(){
	echo 'var tsov_js_config = true;';
	?>
	var tsov_js_config = true;
	<?php
}

add_action('add_color','tsov_template_field',10,2);
function tsov_template_field($_temp,$tem){
	$folder = $tem['folder'];
	$path           = NBDESIGNER_CUSTOMER_DIR . '/' . $folder;
	$config = nbd_get_data_from_json( $path . '/config.json' );
	$product = $config->product;
	if(isset($config->field_size)){
		$_temp['product_width'] = $product[0]->product_width;
		$_temp['product_height'] = $product[0]->product_height;
		$_temp['real_width'] = $product[0]->real_width;
		$_temp['real_height'] = $product[0]->real_height;
		$_temp['real_top'] = $product[0]->real_top;
		$_temp['real_left'] = $product[0]->real_left;
	}
	return $_temp;
}

add_filter('nbod_dislay_kind_of_templates','tsov_template_field_list',10,2);
function tsov_template_field_list($html,$valid_license){
	$html = '';
	?>
	 <div ng-style="{'display': settings.task == 'create_template' ? 'none' : 'inline-block' }" class="item" ng-repeat="temp in resource.templates | limitTo: resource.templateLimit" a="{{temp}}" ng-show="filter_size.product_height == '' || (
	 filter_size.product_height == temp.product_height && filter_size.product_width == temp.product_width && filter_size.real_width == temp.real_width && filter_size.real_height == temp.real_height && filter_size.real_left == temp.real_left && filter_size.real_top == temp.real_top)" ng-click="insertTemplate(false, temp)">
        <div class="main-item">
            <div class="item-img" nbd-template-hover="{{temp.id}}">
                <img ng-src="{{temp.thumbnail}}" alt="<?php esc_html_e('Template','web-to-print-online-designer'); ?>">
            </div>
        </div>
    </div>
    <hr ng-show="resource.templates.length > 0 && resource.globalTemplate.data.length > 0" class="seperate2" />
    <div class="item" ng-repeat="temp in resource.globalTemplate.data" ng-click="insertGlobalTemplate(temp.id, $index)">
        <div class="main-item" image-on-load="temp.thumbnail">
            <div class="item-img item-img-global-tem" >
                <img ng-src="{{temp.thumbnail}}" alt="{{temp.name}}">
                <?php if(!$valid_license): ?>
                <span class="nbd-pro-mark-wrap" ng-if="$index > 4">
                    <svg class="nbd-pro-mark" fill="#F3B600" xmlns="http://www.w3.org/2000/svg" viewBox="-505 380 12 10"><path d="M-503 388h8v1h-8zM-494 382.2c-.4 0-.8.3-.8.8 0 .1 0 .2.1.3l-2.3.7-1.5-2.2c.3-.2.5-.5.5-.8 0-.6-.4-1-1-1s-1 .4-1 1c0 .3.2.6.5.8l-1.5 2.2-2.3-.8c0-.1.1-.2.1-.3 0-.4-.3-.8-.8-.8s-.8.4-.8.8.3.8.8.8h.2l.8 3.3h8l.8-3.3h.2c.4 0 .8-.3.8-.8 0-.4-.4-.7-.8-.7z"></path></svg>
                    <?php esc_html_e('Pro','web-to-print-online-designer'); ?>
                </span>
                <?php endif; ?>
            </div>
        </div>
    </div>
	<?php
	return $html;
}

//-----------------

add_action('nbd_extra_css','two_page_line');
function two_page_line(){
    ?>
        <style>
        	.seperateh::before {
			    content: "";
			    position: absolute;
			    border-left: 1px dashed black;
			    height: 100%;
			    display: inline-block;
			    z-index: 1;
			}
        </style>>
    <?php
}

add_filter('add-seperateh-twopage','adds_eperateh_twopage');
function adds_eperateh_twopage() {
    ?>
        <div class="stage-main" ng-class="{'nbd-without-shadow' : stage.config.bgType == 'image', 'seperateh' : stage.config.is_page}" ng-style="{
            'width' : calcStyle(stage.config.cwidth * stage.states.scaleRange[stage.states.currentScaleIndex].ratio),
            'height' : calcStyle(stage.config.cheight * stage.states.scaleRange[stage.states.currentScaleIndex].ratio)
        }">
    <?php
    return ''; 
}