<?php
/**
 * Plugin Name:       Scaling uploaded images for Nbdesigner Advanced
 * Plugin URI:        https://cmsmart.net
 * Description:       Auto scale replace image
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.1
 * Author:            Hoang
 * Author URI:        https://cmsmart.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       rescale-upload-element
 * Domain Path:       /languages
 */

add_action('wp_enqueue_scripts','nbod_rescale_element_nbdesigner_js',31);
function nbod_rescale_element_nbdesigner_js(){
    wp_localize_script('nbdesigner','nbd_rescale_element',true); 
}
add_action('admin_enqueue_scripts','nbod_admin_rescale_element_nbdesigner_js',31);
function nbod_admin_rescale_element_nbdesigner_js(){
    wp_localize_script('admin_nbdesigner','nbd_rescale_element',true);  
}

add_action('nbd_js_config','nbod_rescale_element_frontend_js');
function nbod_rescale_element_frontend_js(){
    echo 'var nbd_rescale_element = true;';
}

add_action( 'wp_ajax_nbdesigner_copy_image_from_url2', 'nbdesigner_copy_image_from_url2' );
add_action( 'wp_ajax_nopriv_nbdesigner_copy_image_from_url2', 'nbdesigner_copy_image_from_url2' );

function create_fit_dropzonejpg( $file, $width, $height, $thumb_width, $thumb_height ,$path = ''){
    $original_aspect = $width / $height;
    $thumb_aspect = $thumb_width / $thumb_height;
    $new_width = $thumb_width;
    $new_height = $thumb_height;
    if ( $original_aspect > $thumb_aspect ){
       // If image is wider than thumbnail (in aspect ratio sense)
       $new_width = $width / ($height / $thumb_height);
    } else {
       // If the thumbnail is wider than the image
       $new_height = $height / ($width / $thumb_width);
    }
    $new_scaleX = $new_width / $width;
    $new_scaleY = $new_height / $height;
    if( is_available_imagick() && $path != '' ){
        imagick_rescale_image($file, $path, $new_width,$new_height,$thumb_width, $thumb_height);
    } else {
        $image = imagecreatefromjpeg($file);
        $thumb = imagecreatetruecolor( $thumb_width, $thumb_height );
        imagecopyresampled(
            $thumb,
            $image,
            0 - ($new_width - $thumb_width) / 2, // Center the image horizontally
            0 - ($new_height - $thumb_height) / 2, // Center the image vertically
            0, 
            0,
            $new_width, 
            $new_height,
            $width, 
            $height);
        imagedestroy( $image );
        if( $path == '' ){
            return $thumb;
        } else{
            imagejpeg($thumb, $path, 100);
            imagedestroy( $thumb );
        }
    }
    
}
function create_fit_dropzonepng( $file, $width, $height, $thumb_width, $thumb_height ,$path = ''){
    $original_aspect = $width / $height;
    $thumb_aspect = $thumb_width / $thumb_height;
    $new_width = $thumb_width;
    $new_height = $thumb_height;
    if ( $original_aspect > $thumb_aspect ){
       // If image is wider than thumbnail (in aspect ratio sense)
       $new_width = $width / ($height / $thumb_height);
    } else {
       // If the thumbnail is wider than the image
       $new_height = $height / ($width / $thumb_width);
    }
    $new_scaleX = $new_width / $width;
    $new_scaleY = $new_height / $height;
    if( is_available_imagick() && $path != '' ){
        imagick_rescale_image($file, $path, $new_width,$new_height,$thumb_width, $thumb_height);
    } else {
        $image = imagecreatefrompng($file);
        $thumb = imagecreatetruecolor( $thumb_width, $thumb_height );
        imagecopyresampled(
            $thumb,
            $image,
            0 - ($new_width - $thumb_width) / 2, // Center the image horizontally
            0 - ($new_height - $thumb_height) / 2, // Center the image vertically
            0, 
            0,
            $new_width, 
            $new_height,
            $width, 
            $height);
        imagedestroy( $image );
        if( $path == '' ){
            return $thumb;
        } else{
            imagepng($thumb, $path, 100);
            imagedestroy( $thumb );
        }
    }
}
function imagick_rescale_image($src, $dst, $resize_w,$resize_h, $new_w, $new_h){
    $image = new Imagick( $src );
    $image->resizeImage($resize_w, $resize_h, Imagick::FILTER_LANCZOS, 0.9);
    $image->cropImage( $new_w, $new_h, ($resize_w - $new_w) / 2, ($resize_h - $new_h) / 2);
    $image->writeImage( $dst );
    $image->clear();
    $image->destroy();
}
function nbdesigner_copy_image_from_url2(){
    if ( !wp_verify_nonce( $_POST['nonce'], 'save-design' ) && NBDESIGNER_ENABLE_NONCE ) {
        die( 'Security error' );
    }
    $url = $_POST['url'];
    $ext = Nbdesigner_Plugin::nbdesigner_get_extension( $url );
    if( isset( $_POST['gapi'] ) && isset( $_POST['gapi']['name'] ) ){
        $ext = Nbdesigner_Plugin::nbdesigner_get_extension( $_POST['gapi']['name'] );
    }
    $allow_extension = array( 'jpg', 'jpeg', 'png', 'gif' );
    if( !in_array( strtolower( $ext ), $allow_extension ) ) $ext = 'png';
    $new_name       = strtotime( "now" ) . substr( md5( rand( 1111,9999 ) ), 0, 8 ) . '.' . $ext;
    $path           = Nbdesigner_IO::create_file_path( NBDESIGNER_TEMP_DIR, $new_name );
    $res['flag']    = 0;
    $res['src']     = NBDESIGNER_TEMP_URL . $path['date_path'];
    if( isset( $_POST['gapi'] ) && strpos( $url, 'drive.google.com/file' ) ){
        $param          = wc_clean( $_POST['gapi'] );
        $oAuthToken     = $param['oAuthToken'];
        $fileId         = $param['fileId'];
        $new_name       = strtotime( "now" ) . substr( md5( rand( 1111, 9999 ) ), 0, 8 ) . '_' . $param['name']; 
        $path           = Nbdesigner_IO::create_file_path( NBDESIGNER_TEMP_DIR, $new_name );
        $getUrl         = 'https://www.googleapis.com/drive/v2/files/' . $fileId . '?alt=media';
        $authHeader     = 'Authorization: Bearer ' . $oAuthToken;
        $ch             = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, $getUrl);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array($authHeader));
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $data   = curl_exec($ch);
        $error  = curl_error($ch);
        curl_close($ch);
        if( !$error ){
            file_put_contents( $path['full_path'], $data );
            $res['src']     = NBDESIGNER_TEMP_URL . $path['date_path'];
            $res['flag']    = 1;
        }
    }else{
        if( @copy( $url, $path['full_path'] ) ){
            $res['flag'] = 1;
        }else{
            $response = wp_remote_get( $url, array( 'timeout' => 30 ) );
            if ( is_wp_error( $response ) ){
                echo json_encode( $res );
                wp_die();
            }else{
                $result = @file_put_contents( $path['full_path'], $response['body'] );
                unset( $response['body'] );
                if ( $result === false ) {
                    $res['flag'] = 0;
                }else{
                    $res['flag'] = 1;
                }
            }
        }
    }
    do_action( 'nbu_upload_image_from_url', $path, $res );

    if( $res['flag'] == 1 ){
        $resizable_extensions = array( 'jpg', 'jpeg', 'png' );
        if( in_array( $ext, $resizable_extensions ) ){
            $full_path                  = is_array( $path ) ? $path['full_path'] : $path;
            $thumb_width                   = $_POST['thumb_w'];
            $thumb_height                  = $_POST['thumb_h'];
            list( $width, $height )     = getimagesize( $full_path );
            if( $width > $thumb_width || $height > $thumb_height ){
                $infos          = pathinfo( $full_path );
                $path_preview   = $infos['dirname'] . '/' . $infos['filename'] . '_preview.' . $infos['extension'];
                if( $ext == 'png' ){
                    create_fit_dropzonepng( $full_path, $width, $height, $thumb_width, $thumb_height, $path_preview );
                } else {
                    create_fit_dropzonejpg( $full_path, $width, $height, $thumb_width, $thumb_height, $path_preview );
                }
                if( file_exists( $path_preview ) ){
                    $res['src']         = Nbdesigner_IO::wp_convert_path_to_url( $path_preview );
                }
            }
        }
    }

    if( $res['flag'] == 1 && !isset( $_POST['nbu_adu'] ) && nbdesigner_get_option( 'nbdesigner_enable_generate_photo_thumb', 'no' ) == 'yes' ){
        $resizable_extensions = array( 'jpg', 'jpeg', 'png' );
        if( in_array( $ext, $resizable_extensions ) ){
            $full_path                  = is_array( $path ) ? $path['full_path'] : $path;
            $preview_size               = apply_filters( 'nbd_max_photo_thumb_size', 800 );
            list( $width, $height )     = getimagesize( $full_path );
            if( $width > $preview_size || $height > $preview_size ){
                $infos          = pathinfo( $full_path );
                $path_preview   = $infos['dirname'] . '/' . $infos['filename'] . '_preview.' . $infos['extension'];
                if( $ext == 'png' ){
                    NBD_Image::nbdesigner_resize_imagepng( $full_path, $preview_size, $preview_size, $path_preview );
                } else {
                    NBD_Image::nbdesigner_resize_imagejpg( $full_path, $preview_size, $preview_size, $path_preview );
                }

                if( file_exists( $path_preview ) ){
                    $res['origin_url']  = $res['src'];
                    $res['src']         = Nbdesigner_IO::wp_convert_path_to_url( $path_preview );
                    $res['width']       = $width;
                    $res['height']      = $height;
                }
            }
        }
    }

    echo json_encode( $res );
    wp_die();
}

if (!function_exists('write_log')) {
    function write_log($log) {
        if (true === WP_DEBUG) {
            if (is_array($log) || is_object($log)) {
                error_log(print_r($log, true));
            } else {
                error_log($log);
            }
        }
    }
}