<?php
/*
    Plugin Name: Customer Lists
    Plugin URI: https://www.helpfulinsightsolution.com/custom-plugin-development/
    Description: A customer listing plugin.
    Version: 1.0
    Author: Helpful Insight Pvt. Ltd.
    Author URI: https://www.helpfulinsightsolution.com/
    License: GPLv2 or later
    Text Domain: pcl
*/
@ini_set('display_errors', 0);
set_time_limit(300);
register_activation_hook(__FILE__,'install_activation');
register_deactivation_hook( __FILE__, 'uninstall_deactivation' );
register_uninstall_hook( __FILE__, 'uninstall_delete' );
add_action('admin_menu', 'add_pcl_menu');
define("assets_url", plugins_url( '/assets', __FILE__ ));

add_action('plugins_loaded', 'plugin_init'); 
function plugin_init() {
    load_plugin_textdomain( 'pcl', false, dirname(plugin_basename(__FILE__)).'/languages' );
}

/**** Make required database table on plugin activation ****/
function install_activation(){
    global $wpdb;
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    $pcl_customers = $wpdb->prefix . "pcl_customers";
    $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";

    $sql1 = "CREATE TABLE IF NOT EXISTS $pcl_customers (
        id int(11) NOT NULL AUTO_INCREMENT,
        customer_id int(11) NOT NULL,
        assignment varchar(255) NOT NULL,
        created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    $sql2 = "CREATE TABLE IF NOT EXISTS $pcl_customers_list (
        id int(11) NOT NULL AUTO_INCREMENT,
        pcl_customers_id int(11) NOT NULL,
        list_name varchar(100) NOT NULL,
        num_address int(11) NOT NULL,
        extra_charges varchar(50) NOT NULL,
        file_url varchar(255) NOT NULL,
        created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    dbDelta( $sql1 );
    dbDelta( $sql2 );
}
/**** Make required database table on plugin activation ****/

/**** Function for delete data on plugin deactivation ****/
function uninstall_deactivation(){
    global $wpdb;
    // $pcl_customers = $wpdb->prefix . "pcl_customers";
    // $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";
    // $wpdb->query( "DROP TABLE IF EXISTS ".$pcl_customers );
    // $wpdb->query( "DROP TABLE IF EXISTS ".$pcl_customers_list );
}
/**** Function for delete data on plugin deactivation ****/

/**** Function for delete data on plugin deletion ****/
function uninstall_delete(){
    global $wpdb;
    // $pcl_customers = $wpdb->prefix . "pcl_customers";
    // $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";
    // $wpdb->query( "DROP TABLE IF EXISTS ".$pcl_customers );
    // $wpdb->query( "DROP TABLE IF EXISTS ".$pcl_customers_list );
}
/**** Function for delete data on plugin deletion ****/

add_action('admin_enqueue_scripts', 'pcl_admin_enqueue_styles');
function pcl_admin_enqueue_styles($hook) {
    $plugin_pages = array('toplevel_page_pcl_customers_list','customer-lists_page_add-customer-list');
    if(!in_array($hook,$plugin_pages)){
        return;
    }
    wp_enqueue_style( 'fontawesome-css', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css');
    wp_enqueue_style( 'sweetalert-css', 'https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.css');
    wp_enqueue_style('pcl-admin-style', plugins_url( '/assets/css/pcl-admin-style.css?var='.time(), __FILE__ ));
    wp_enqueue_style('pcl-select-2', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css');
    wp_enqueue_script( 'sweetalert-js', 'https://unpkg.com/sweetalert/dist/sweetalert.min.js' );
    wp_enqueue_script( 'pcl-select-2-js', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js', array('jquery') );
    wp_register_script( "pcl-admin-script", plugins_url( '/assets/js/pcl-admin-script.js?var='.time(), __FILE__ ), array('jquery') );
    wp_localize_script( 'pcl-admin-script', 'pclAdminAjax', array( 'assetsurl' => plugins_url( '/assets', __FILE__ ),'ajaxurl' => admin_url( 'admin-ajax.php' )));
    wp_enqueue_script( 'pcl-admin-script' );
}

add_action('wp_enqueue_scripts', 'pcl_front_enqueue_styles');
function pcl_front_enqueue_styles(){
    wp_enqueue_style('pcl-quote-css', plugins_url( 'web-to-print-online-designer/assets/css/quote.css'));
    wp_enqueue_style('pcl-select-2-css', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css');
    wp_enqueue_script( 'pcl-select-2-js', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js' );
	wp_enqueue_style('pcl-datatable-css', 'https://cdn.datatables.net/1.11.0/css/jquery.dataTables.min.css');
    wp_enqueue_script( 'pcl-datatable-js', 'https://cdn.datatables.net/1.11.0/js/jquery.dataTables.min.js', array('jquery') );
    wp_enqueue_script( 'pcl-front-js', plugins_url( '/assets/js/pcl-front-script.js?var='.time(), __FILE__ ), array('jquery') );
}

/**** Function for create admin dashboard menu ****/
function add_pcl_menu(){
    $menu = add_menu_page(
        __('Customer Lists', 'tagfiles'), 
        __('Customer Lists', 'tagfiles'), 
        'manage_options', 
        'pcl_customers_list', 
        'pcl_customers_list', 
        "dashicons-welcome-widgets-menus"
    );
    add_submenu_page( 'pcl_customers_list', 'Add Customer List', 'Add Customer List',
    'manage_options', 'add-customer-list', 'pcl_add_customer');
}
/**** Function for create admin dashboard menu ****/

function pcl_customers_list(){
    include_once('inc/pcl-customer-list.php');
}

function pcl_add_customer(){
    include_once('inc/pcl-add-customer.php');
}

function pcl_file_uploader(){
    $response = array('status' => 'failed');
    $uploaded_url = image_uploader($_FILES['upfile']);
    if($uploaded_url['error']){
        $response = array('status' => 'error', 'uploader' => $uploaded_url['error']);
        wp_send_json($response);
        wp_die();
    }else{
        $response = array('status' => 'success', 'uploader' => $uploaded_url['url']);
        wp_send_json($response);
        wp_die();
    }
    wp_die();
}
add_action('wp_ajax_pcl_file_uploader', 'pcl_file_uploader');

function image_uploader($upimage){
    $response = array();
    $response = wp_upload_bits($upimage["name"], null, file_get_contents($upimage["tmp_name"]));
    return $response;
}

function update_customer(){
    extract($_POST);
    global $wpdb;
    $response = array();

    //Update customer
    $data = array();

    $pcl_customers = $wpdb->prefix . "pcl_customers";
    $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";

    $where = array('id' => $edit_id);
    $is_already = $wpdb->get_row($wpdb->prepare( "SELECT * FROM $pcl_customers WHERE `customer_id` = $customer_id" ));

    $already_customer = '';
    $data_list = array();

    $product_saperated = '';
    if($assign_products){
       foreach($assign_products as $assigned_product){
            $product_saperated .= $assigned_product.',';
       }
    }
    $product_saperated = rtrim($product_saperated, ',');

    if($is_already){
        $already_customer = $is_already->id;
        $customer_list_data = $wpdb->get_results($wpdb->prepare( "SELECT * FROM $pcl_customers_list WHERE `pcl_customers_id` = $edit_id" ));
        if($assign_products){
            $data['assignment'] = $product_saperated;
        }
        $customer_updated = $wpdb->update($pcl_customers, $data, array('id' => $already_customer));
        foreach($customer_list_data as $customer_listing){
            $data_list = array('pcl_customers_id' => $already_customer);
            $customer_list_updating = $wpdb->update($pcl_customers_list, $data_list, array('id' => $customer_listing->id));
        }
        if($pre_customer_id != $customer_id){
            $wpdb->delete($pcl_customers, array('id' => $edit_id));
        }
    }else{
        $data = array('customer_id' => $customer_id);
        if($assign_products){
            $data['assignment'] = $product_saperated;
        }
        $customer_updated = $wpdb->update($pcl_customers, $data, $where);
    }

    $response = array('status' => 'success', 'msg' => 'Customer updated.');

    wp_send_json($response);
    wp_die();
}
add_action("wp_ajax_update_customer","update_customer");

function delete_customer(){
    extract($_POST);
    global $wpdb;
    $response = array();

    //delete customer
    $pcl_customers = $wpdb->prefix . "pcl_customers";
    $where = array('id' => $edit_id);
    $customer_deleted = $wpdb->delete($pcl_customers, $where);
    if($customer_deleted){
        $response = array('status' => 'success', 'msg' => 'Customer deleted.');
    }

    wp_send_json($response);
    wp_die();
}
add_action("wp_ajax_delete_customer","delete_customer");

function update_customer_list(){
    extract($_POST);
    global $wpdb;
    $response = array();

    //Update customer list
    $data = array('list_name' => $edit_name, 'num_address' => $edit_address, 'extra_charges' => $extra_charges, 'file_url' => $edit_file);
    $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";
    $where = array('id' => $edit_id);
    $customer_list_updated = $wpdb->update($pcl_customers_list, $data, $where);
    if($customer_list_updated){
        $response = array('status' => 'success', 'msg' => 'Customer List updated.', 'listname' => $edit_name, 'listaddress' => $edit_address, 'extra_charges' => $extra_charges, 'listfile' => $edit_file);
    }

    wp_send_json($response);
    wp_die();
}
add_action("wp_ajax_update_customer_list","update_customer_list");

function delete_customer_list(){
    extract($_POST);
    global $wpdb;
    $response = array();

    //Update customer
    $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";
    $where = array('id' => $edit_id);
    $customer_list_deleted = $wpdb->delete($pcl_customers_list, $where);
    if($customer_list_deleted){
        $response = array('status' => 'success', 'msg' => 'Customer list deleted.');
    }

    wp_send_json($response);
    wp_die();
}
add_action("wp_ajax_delete_customer_list","delete_customer_list");

function pcl_customer_list_data(){
    global $wpdb;
    $customer_id = get_current_user_id();
    $pcl_customers = $wpdb->prefix . "pcl_customers";
    $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";
    $customer_data = $wpdb->get_row("SELECT * FROM $pcl_customers WHERE `customer_id` = $customer_id");
    $list_id = $customer_data->id;
    //$product_ids = explode(",",$customer_data->assignment);
    $html = '<input type="hidden" name="pro_id" value="'.get_the_ID().'" id="pro_id" >';
    if(is_user_logged_in()){
        $customer_list_data = $wpdb->get_results("SELECT * FROM $pcl_customers_list WHERE `pcl_customers_id` = $list_id");
        if($customer_list_data){
            $html = '<div class="pcl_customers_listng"><label>Select List:<br><small style="font-size:13px; color:#36b558">Click on box to view lists.</small></label><select name="pcl_customers[]" id="pcl_customers" multiple onchange="change_quantity(this.value)">';
                foreach ($customer_list_data as $customer) {
                    $html .= '<option value="'.$customer->list_name.'~'.$customer->num_address.'~'.$customer->extra_charges.'">'.$customer->list_name.'</option>';
                }
            $html .= '</select>
            </div>';
        }else{
            $html = '<div class="pcl_customers_listng">You do not have a list on file. To add one <a href="https://waybetterpostcard.com/my-account/my-mailing-list/"><strong>Click Here</strong></a></div>';
        }
    }else{
        $html = '<div class="pcl_customers_listng">Please <a href="/my-account/"><strong>Login or Register</strong></a> to use this feature.</div>';
    }
    echo $html;
}
add_action("customer_address_listing","pcl_customer_list_data");

function get_my_list_on_file(){
    extract($_POST);
    global $wpdb;
    if(is_user_logged_in()){
        $customer_id = get_current_user_id();
        $pcl_customers = $wpdb->prefix . "pcl_customers";
        $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";
        $customer_data = $wpdb->get_row("SELECT * FROM $pcl_customers WHERE `customer_id` = $customer_id");
        $list_id = $customer_data->id;
        $product_ids = explode(",",$customer_data->assignment);
        $html = '';
        //if(in_array($pro_id,$product_ids)){
        $customer_list_data = $wpdb->get_results("SELECT * FROM $pcl_customers_list WHERE `pcl_customers_id` = $list_id");
        if($customer_list_data){
            $html = '<div class="pcl_customers_listng"><label style="line-height:18px;">Select List:<br><small style="font-size:13px; color:#36b558">Click on box to view lists.</small></label><select name="pcl_customers[]" id="pcl_customers" multiple onchange="change_quantity(this.value)">';
                foreach ($customer_list_data as $customer) {
                    $html .= '<option value="'.$customer->list_name.'~'.$customer->num_address.'~'.$customer->extra_charges.'">'.$customer->list_name.'</option>';
                }
            $html .= '</select>
            </div>';
        }else{
            $html = '<div class="pcl_customers_listng">You do not have a list on file. To add one <a href="https://waybetterpostcard.com/my-account/my-mailing-list/"><strong>Click Here</strong></a></div>';
        }
    }else{
        $html = '<div class="pcl_customers_listng">Please <a href="/my-account/"><strong>Login or Register</strong></a> to use this feature.</div>';
    }
    $response = array('htm' => $html);
    wp_send_json($response);
}
add_action("wp_ajax_get_my_list_on_file","get_my_list_on_file");
add_action("wp_ajax_nopriv_get_my_list_on_file","get_my_list_on_file");
  
function bbloomer_add_my_mailing_list_endpoint() {
    add_rewrite_endpoint( 'my-mailing-list', EP_ROOT | EP_PAGES );
}
  
add_action( 'init', 'bbloomer_add_my_mailing_list_endpoint' );
  
// ------------------
// 2. Add new query var
  
function bbloomer_my_mailing_list_query_vars( $vars ) {
    $vars[] = 'my-mailing-list';
    return $vars;
}
  
add_filter( 'query_vars', 'bbloomer_my_mailing_list_query_vars', 0 );
  
// ------------------
// 3. Insert the new endpoint into the My Account menu
  
function bbloomer_add_my_mailing_list_link_my_account( $items ) {

    $newItems = array( 'my-mailing-list' => 'My Mailing Lists' );

    $items = array_slice( $items, 0, 1, true ) 
	+ $newItems 
	+ array_slice( $items, 1, NULL, true );
    
    return $items;
}
  
add_filter( 'woocommerce_account_menu_items', 'bbloomer_add_my_mailing_list_link_my_account' );
  
// ------------------
// 4. Add content to the new tab
  
function bbloomer_my_mailing_list_content() {
   $customer_list_data = '';
   $html = '<h3>My Mailing Lists</h3>';
   global $wpdb;
   $customer_id = get_current_user_id();
   $pcl_customers = $wpdb->prefix . "pcl_customers";
   $pcl_customers_list = $wpdb->prefix . "pcl_customers_list";
   $customer_data = $wpdb->get_row("SELECT * FROM $pcl_customers WHERE `customer_id` = $customer_id");
   $list_id = $customer_data->id;
   $customer_list_data = $wpdb->get_results("SELECT * FROM $pcl_customers_list WHERE `pcl_customers_id` = $list_id");
   if($customer_list_data){

   $html .= '<table id="customer-mailing-list" class="customer-mailing-list woocommerce-orders-table shop_table shop_table_responsive my_account_orders ">';
        $html .= '<thead>';
            $html .= '<tr>';
                $html .= '<th>';
                    $html .= 'List Name';
                $html .= '</th>';
                $html .= '<th>';
                    $html .= 'Number of Addresses (Quantity to Mail)';
                $html .= '</th>';
                $html .= '<th>';
                    $html .= 'Extra Charges';
                $html .= '</th>';
                $html .= '<th>';
                    $html .= 'Download List';
                $html .= '</th>';
            $html .= '</tr>';
        $html .= '</thead>';
        $html .= '<tbody>';
                            foreach ($customer_list_data as $customer) {
                    $html .= '<tr>';
                        $html .= '<td>';
                            $html .= $customer->list_name;
                        $html .= '</td>';
                        $html .= '<td>';
                            $html .= $customer->num_address;
                        $html .= '</td>';
                        $html .= '<td>';
                            $html .= $customer->extra_charges;
                        $html .= '</td>';
                        $html .= '<td>';
                            $html .= '<a href="'.$customer->file_url.'" download><i style="font-size: 18px;" class="fa fa-file-alt"></i></a>';
                        $html .= '</td>';
                    $html .= '</tr>';
                }
            }
        $html .= '</tbody>';
   $html .= '</table>';
   if($customer_list_data){
        $html .= do_shortcode('[gravityform id="26" title="false" description="false" ajax="true"]');
   }else {
        $html .= do_shortcode('[gravityform id="25" title="false" description="false" ajax="true"]');
   }
   echo $html;
}
add_action( 'woocommerce_account_my-mailing-list_endpoint', 'bbloomer_my_mailing_list_content' );

/**
 * Add custom cart item data
 */
function plugin_republic_add_cart_item_data( $cart_item_data, $product_id, $variation_id ) {
    if( isset( $_POST['pcl_customers'] ) ) {
        $list_str = '';
        $extra_charges = 0;
        foreach($_POST['pcl_customers'] as $cs_list){
            $list_str_arr = explode("~",$cs_list);
            $list_str .= $list_str_arr[0].',';
            $extra_charges += $list_str_arr[1] * $list_str_arr[2];
        }
        $cart_item_data['pcl_customers'] = rtrim($list_str, ",");
        $cart_item_data['extra_charges'] = $extra_charges;
    }
    return $cart_item_data;
}
add_filter( 'woocommerce_add_cart_item_data', 'plugin_republic_add_cart_item_data', 10, 3 );

/**
 * Display custom item data in the cart
 */
function plugin_republic_get_item_data( $item_data, $cart_item_data ) {
    if( isset( $cart_item_data['pcl_customers'] ) ) {
        $item_data[] = array(
            'key' => 'Customer Lists',
            'value' => wc_clean( $cart_item_data['pcl_customers'] )
        );
    }
    return $item_data;
}
add_filter( 'woocommerce_get_item_data', 'plugin_republic_get_item_data', 10, 2 );

/**
 * Add custom meta to order
 */
function plugin_republic_checkout_create_order_line_item( $item, $cart_item_key, $values, $order ) {
    if( isset( $values['pcl_customers'] ) ) {
        $item->add_meta_data(
            'Customer Lists',
            $values['pcl_customers'],
            true
        );
    }
}
add_action( 'woocommerce_checkout_create_order_line_item', 'plugin_republic_checkout_create_order_line_item', 10, 4 );


function woocommerce_custom_surcharge( $cart_object ) {    
    ## ---- CALCULATION ---- ##
    foreach ( WC()->cart->get_fees() as $fee ) :
        $feeNameCheck = explode(":", esc_html( $fee->name ));
        if ($feeNameCheck[0] == 'Mailing List Optimization') :
            $getFee = explode("-", $feeNameCheck[1]);
            $fee->name = 'Mailing List Optimization';
            $fee->amount = trim($getFee[0]);
        endif;
    endforeach;
    ## ---- CALCULATION ---- ##
}
add_action( 'woocommerce_cart_calculate_fees','woocommerce_custom_surcharge', 10, 1 );