<?php

declare (strict_types=1);
/*
 * This file is part of the Monolog package.
 *
 * (c) Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace OctolizeShippingCostOnProductPageVendor\Monolog\Handler;

use OctolizeShippingCostOnProductPageVendor\Monolog\Formatter\FormatterInterface;
use OctolizeShippingCostOnProductPageVendor\Monolog\Formatter\NormalizerFormatter;
use OctolizeShippingCostOnProductPageVendor\Monolog\Logger;
/**
 * Handler sending logs to Zend Monitor
 *
 * @author  Christian Bergau <cbergau86@gmail.com>
 * @author  Jason Davis <happydude@jasondavis.net>
 *
 * @phpstan-import-type FormattedRecord from AbstractProcessingHandler
 */
class ZendMonitorHandler extends \OctolizeShippingCostOnProductPageVendor\Monolog\Handler\AbstractProcessingHandler
{
    /**
     * Monolog level / ZendMonitor Custom Event priority map
     *
     * @var array<int, int>
     */
    protected $levelMap = [];
    /**
     * @throws MissingExtensionException
     */
    public function __construct($level = \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::DEBUG, bool $bubble = \true)
    {
        if (!\function_exists('OctolizeShippingCostOnProductPageVendor\\zend_monitor_custom_event')) {
            throw new \OctolizeShippingCostOnProductPageVendor\Monolog\Handler\MissingExtensionException('You must have Zend Server installed with Zend Monitor enabled in order to use this handler');
        }
        //zend monitor constants are not defined if zend monitor is not enabled.
        $this->levelMap = [\OctolizeShippingCostOnProductPageVendor\Monolog\Logger::DEBUG => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_INFO, \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::INFO => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_INFO, \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::NOTICE => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_INFO, \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::WARNING => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_WARNING, \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::ERROR => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_ERROR, \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::CRITICAL => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_ERROR, \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::ALERT => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_ERROR, \OctolizeShippingCostOnProductPageVendor\Monolog\Logger::EMERGENCY => \OctolizeShippingCostOnProductPageVendor\ZEND_MONITOR_EVENT_SEVERITY_ERROR];
        parent::__construct($level, $bubble);
    }
    /**
     * {@inheritDoc}
     */
    protected function write(array $record) : void
    {
        $this->writeZendMonitorCustomEvent(\OctolizeShippingCostOnProductPageVendor\Monolog\Logger::getLevelName($record['level']), $record['message'], $record['formatted'], $this->levelMap[$record['level']]);
    }
    /**
     * Write to Zend Monitor Events
     * @param string $type      Text displayed in "Class Name (custom)" field
     * @param string $message   Text displayed in "Error String"
     * @param array  $formatted Displayed in Custom Variables tab
     * @param int    $severity  Set the event severity level (-1,0,1)
     *
     * @phpstan-param FormattedRecord $formatted
     */
    protected function writeZendMonitorCustomEvent(string $type, string $message, array $formatted, int $severity) : void
    {
        zend_monitor_custom_event($type, $message, $formatted, $severity);
    }
    /**
     * {@inheritDoc}
     */
    public function getDefaultFormatter() : \OctolizeShippingCostOnProductPageVendor\Monolog\Formatter\FormatterInterface
    {
        return new \OctolizeShippingCostOnProductPageVendor\Monolog\Formatter\NormalizerFormatter();
    }
    /**
     * @return array<int, int>
     */
    public function getLevelMap() : array
    {
        return $this->levelMap;
    }
}
