<?php

/**

 * Plugin Name:       New Mapping Field for NBDesigner Advanced

 * Plugin URI:        https://cmsmart.net

 * Description:       Multilines text mapping, Add Office Address, Office Number to Templates field map

 * Version:           2.1

 * Requires at least: 5.2

 * Requires PHP:      7.1

 * Author:            Hoang

 * Author URI:        https://cmsmart.net

 * License:           GPL v2 or later

 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html

 * Text Domain:       new-mapping-fields-for-text

 * Domain Path:       /languages

 */



add_action('wp_enqueue_scripts','nbod_custom_mapping_nbdesigner_js',31);

function nbod_custom_mapping_nbdesigner_js(){

    wp_localize_script('nbdesigner','nbod_custom_mapping',true); 

}

add_action('admin_enqueue_scripts','nbod_admin_custom_mapping_nbdesigner_js',31);

function nbod_admin_custom_mapping_nbdesigner_js(){

    wp_localize_script('admin_nbdesigner','nbod_custom_mapping',true);  

}



add_action('nbd_js_config','nbod_custom_mapping_frontend_js');

function nbod_custom_mapping_frontend_js(){

    echo 'var nbod_custom_mapping= true;';

}



add_filter('nbdesigner_general_settings','addon_enable_new_field');

function addon_enable_new_field($option){

    $bleed_arr = array(

        'title'         => esc_html__( 'Enable custom mapping text field', 'web-to-print-online-designer'),

        'description'   => esc_html__( 'Enable custom mapping text field.', 'web-to-print-online-designer'),

        'id'            => 'nbdesigner_new_map',

        'default'       => 'no',

        'type'          => 'radio',

        'options'       => array(

            'yes'   => esc_html__('Yes', 'web-to-print-online-designer'),

            'no'    => esc_html__('No', 'web-to-print-online-designer')

        )  

    );

    array_push($option['customization'],$bleed_arr);

    return $option; 

}



add_action( 'show_user_profile', 'extra_user_profile_fields' );

add_action( 'edit_user_profile', 'extra_user_profile_fields' );



function extra_user_profile_fields( $user ) { ?>

    <h3><?php _e("Extra profile information", "blank"); ?></h3>



    <table class="form-table">

    <tr>

        <th><label for="office_address"><?php _e("Office Address"); ?></label></th>

        <td>

            <input type="text" name="office_address" id="office_address" value="<?php echo esc_attr( get_the_author_meta( 'office_address', $user->ID ) ); ?>" class="regular-text" /><br />

            <span class="description"><?php _e("If you want to use in multiline using '/' for line break"); ?></span>

        </td>

    </tr>

    <tr>

        <th><label for="office_number"><?php _e("Office Number"); ?></label></th>

        <td>

            <input type="text" name="office_number" id="office_number" value="<?php echo esc_attr( get_the_author_meta( 'office_number', $user->ID ) ); ?>" class="regular-text" /><br />

            <span class="description"><?php _e("If you want to use in multiline using '/' for line break"); ?></span>

        </td>

    </tr>

    <tr>

    </table>

<?php }



add_action( 'personal_options_update', 'save_extra_user_profile_fields' );

add_action( 'edit_user_profile_update', 'save_extra_user_profile_fields' );



function save_extra_user_profile_fields( $user_id ) {

    if ( empty( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'update-user_' . $user_id ) ) {

        return;

    }

    

    if ( !current_user_can( 'edit_user', $user_id ) ) { 

        return false; 

    }

    update_user_meta( $user_id, 'office_address', $_POST['office_address'] );

    update_user_meta( $user_id, 'office_number', $_POST['office_number'] );

}



add_filter('nbd_template_mapping_fields','new_mapping_fields',10,1);

function new_mapping_fields($fields){

    if(nbdesigner_get_option('nbdesigner_new_map') == yes){

        $fields['single_line_billing'] = array(

            "label" =>  esc_html__('Street,City,State,Zip Code Billing', 'web-to-print-online-designer'),

        );

        $fields['multiple_line_billing'] = array(

            "label" =>  esc_html__('Street,/City,State,Zip Code Billing', 'web-to-print-online-designer'),

        );

        $fields['single_line_shipping'] = array(

            "label" =>  esc_html__('Street,City,State,Zip Code Shipping', 'web-to-print-online-designer'),

        );

        $fields['multiple_line_shipping'] = array(

            "label" =>  esc_html__('Street,/City,State,Zip Code Shipping', 'web-to-print-online-designer'),

        );

        $fields['single_office_address'] = array(

            "label" =>  esc_html__('Single Office Address', 'web-to-print-online-designer'),

        );

        $fields['multiple_office_address'] = array(

            "label" =>  esc_html__('Multi Office Address', 'web-to-print-online-designer'),

        );

        $fields['single_office_number'] = array(

            "label" =>  esc_html__('Single Office Number', 'web-to-print-online-designer'),

        );

        $fields['multiple_office_number'] = array(

            "label" =>  esc_html__('Multi Office Number', 'web-to-print-online-designer'),

        );

    } else {

        $fields = $fields;

    }

    return $fields;

}



add_filter('nbd_get_new_field_connect','new_field_connect_value',10,3);

function new_field_connect_value($new_fields,$current_user,$fields){

    $new_fields  = array();

    // $bill_info = array('billing_address_1','billing_address_2','billing_city','billing_state','billing_postcode');

    // $ship_info = array('shipping_address_1','shipping_address_2','shipping_city','shipping_state','shipping_postcode');

    $bill_info = array('billing_address_1','billing_city','billing_state','billing_postcode');

    $ship_info = array('shipping_address_1','shipping_city','shipping_state','shipping_postcode');

    foreach ( $fields as $key => $field ) {

        $input = isset( $field['connect_to'] ) ? $field['connect_to'] : '';

        $values = array();

        $value = '';

        if( $input != '' ){

            if ($input == 'single_line_billing' || $input == 'multiple_line_billing'){

                if ( 0 != $current_user->ID ) {

                    foreach( $bill_info as $info){

                        if ( is_callable( array( WC()->customer, "get_$info" ) ) ) { 

                            if($input == 'multiple_line_billing' && $info == 'billing_city'){

                                $city = WC()->customer->{"get_$info"}() ? WC()->customer->{"get_$info"}() : null;

                                $finalString = implode(array('/', $city));

                                $inf = $finalString;

                            } else {

                                $inf = WC()->customer->{"get_$info"}() ? WC()->customer->{"get_$info"}() : null;

                            }         

                            

                        } elseif ( WC()->customer->meta_exists( $input ) ) {

                            if($input == 'multiple_line_billing' && $info == 'billing_city'){

                                $city = WC()->customer->get_meta( $input, true );

                                $finalString = implode(array('/', $city));

                                $inf = $finalString;

                            } else {

                                $inf = WC()->customer->get_meta( $input, true );

                            } 

                        }

                        array_push($values,$inf);

                        $value = implode(", ", $values);

                    }



                }

            } else if ($input == 'single_line_shipping' || $input == 'multiple_line_shipping'){

                if ( 0 != $current_user->ID ) {

                    foreach( $ship_info as $info){

                        if ( is_callable( array( WC()->customer, "get_$info" ) ) ) {                    

                            if($input == 'multiple_line_shipping' && $info == 'shipping_city'){
                                $city = WC()->customer->{"get_$info"}() ? WC()->customer->{"get_$info"}() : null;

                                $finalString = implode(array('/', $city));

                                $inf = $finalString;

                            } else {

                                $inf = WC()->customer->{"get_$info"}() ? WC()->customer->{"get_$info"}() : null;

                            } 

                        } elseif ( WC()->customer->meta_exists( $input ) ) {

                            if($input == 'multiple_line_shipping' && $info == 'shipping_city'){

                                $city = WC()->customer->get_meta( $input, true );

                                $finalString = implode(array('/', $city));

                                $inf = $finalString;

                            } else {

                                $inf = WC()->customer->get_meta( $input, true );

                            } 

                        }

                        array_push($values,$inf);

                        $value = implode(", ", $values);

                    }



                }

            } else if ($input == 'single_office_address' || $input == 'multiple_office_address'){

                if ( 0 != $current_user->ID ) {

                    if( isset( $current_user->office_address ) ){

                        $value = $current_user->office_address;

                    }

                }

            } else if ($input == 'single_office_number' || $input == 'multiple_office_number'){

                if ( 0 != $current_user->ID ) {

                    if( isset( $current_user->office_number ) ){

                        $value = $current_user->office_number;

                    }

                }

            } else {

                if ( 0 != $current_user->ID ) {

                    if( false === strpos($input, 'billing_') && false === strpos($input, 'shipping_') ){

                        if( isset( $current_user->{"$input"} ) ){

                            $value = $current_user->{"$input"};

                        }else if( $input == 'user_fullname' ){

                            $value = $current_user->user_firstname . ' ' . $current_user->user_lastname;

                        }

                    } else {

                        if ( is_callable( array( WC()->customer, "get_$input" ) ) ) {                    

                            $value = WC()->customer->{"get_$input"}() ? WC()->customer->{"get_$input"}() : null;

                        } elseif ( WC()->customer->meta_exists( $input ) ) {

                            $value = WC()->customer->get_meta( $input, true );

                        }

                    }

                }

            }

            

        }

        $new_fields[]         = array_merge( $field, array(

            'value' =>  is_null( $value ) ? '' : $value,

            'key'   =>  $key

        ) );

    }

    return $new_fields;

}



add_action('nbd_new_image_placeholder','nbd_new_image_placeholder',10,2);

function nbd_new_image_placeholder($task,$design_type){

    if( $task == 'create' || ( $task == 'edit' && $design_type == 'template' ) ): ?>

        <li class="menu-item menu-crop" ng-show="!stages[currentStage].states.isMasked">

            <i class="nbd-tooltip-hover nbd-svg-icon" title="<?php esc_html_e('Create image placeholder','web-to-print-online-designer'); ?>">

                <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 0 24 24" width="24"><path d="M15.96 10.29l-2.75 3.54-1.96-2.36L8.5 15h11l-3.54-4.71zM3 5H1v16c0 1.1.9 2 2 2h16v-2H3V5zm18-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 16H7V3h14v14z"/></svg>

            </i>

            <div class="sub-menu sub-menu-shape_mask" data-pos="left" >

                <div class="shape_mask-wrapper">

                    <div style="margin-left: 5px;font-weight: 600;"><?php esc_html_e('Basic Shape','web-to-print-online-designer'); ?></div>

                    <span class="shape_mask shape-type-{{n}}" ng-click="addPlaceholderMask(n)" ng-repeat="n in [] | range:25"></span>

                </div>

                <div class="custom_shape_mask-wrapper" style="display: block;">

                    <div style="margin-left: 5px;font-weight: 600;"><?php esc_html_e('Custom Shape','web-to-print-online-designer'); ?></div>

                    <textarea class="form-control hover-shadow nbdesigner_svg_code" rows="5" ng-change="getPlaceholderCommand()" ng-model="placeholderPath" placeholder="<?php esc_html_e('Enter svg code','web-to-print-online-designer'); ?>"/></textarea>

                    <button ng-class="placeholderCommand !='' ? '' : 'nbd-disabled'" class="nbd-button" ng-click="addPlaceholderMask(-1)"><?php esc_html_e('Apply Mask','web-to-print-online-designer'); ?></button>

                </div>

            </div>

        </li>

    <?php endif;

}
add_action('nbod_add_new_template_fields','nbod_add_new_template_fields');
function nbod_add_new_template_fields(){
    $task           = (isset($_GET['task']) &&  $_GET['task'] != '') ? $_GET['task'] : 'new';
    if( $task == 'create' || ( $task == 'edit' && ( isset( $_GET['design_type'] ) && $_GET['design_type'] == 'template' ) ) ){
        $product_id = ( isset( $_GET['product_id'] ) &&  $_GET['product_id'] != '' ) ? absint( $_GET['product_id'] ) : 0;
        $option_id = NBD_FRONTEND_PRINTING_OPTIONS::get_product_option( $product_id );
        if( $option_id ){
            $_options = NBD_FRONTEND_PRINTING_OPTIONS::get_option( $option_id );
            if( $_options ){
                $options = unserialize($_options['fields']);
                if( !isset($options['fields']) ){
                    $options['fields'] = array();
                }
                $options['fields'] = NBD_FRONTEND_PRINTING_OPTIONS::recursive_stripslashes( $options['fields'] );
                foreach ( $options['fields'] as $key => $field ){
                    if ($field['nbd_type'] == 'size'){
                        ?>
                            <div class="template-dimension template-field-wrap">
                                <label class="template-label"><?php esc_html_e('Custom dimension','web-to-print-online-designer'); ?></label>
                                <div style="display: inline-block;margin: 0 15px 15px 0;">
                                    <input name="template_dimension" type="checkbox" ng-model="customTemplate.enableDimension" style="margin: 0 5px;"><label for='template_dimension'/><?php esc_html_e('Map with option Size','web-to-print-online-designer'); ?></label>
                                </div>
                                <label class="template-label"><?php esc_html_e('Size dimension','web-to-print-online-designer'); ?></label>
                                <div class="nb-dropdown-wrap">
                                    <select ng-change="updateMapValue()" name="template-map-field" class="template-size-map" ng-model="customTemplate.mapSize">
                                        <option value="" selected disabled hidden>Choose</option>
                                    <?php 
                                        foreach ($field['general']['attributes']["options"] as $key => $attr): 
                                    ?>
                                        <option value="<?php echo $key; ?>"><?php echo $attr['name']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                    </select> 
                                </div>
                            </div>
                        <?php
                    }
                }
            }
        }
    }
}

add_filter('nbo_sub_options','nbo_sub_options',10,3);
function nbo_sub_options($options, $product_id,$get){
    if ($get['enableDimension'] == true){
        $options['mapSizeValue'] = $get['mapSizeValue'];
    }
    return $options;
}
add_filter('nbod_gallery_customize','nbod_gallery_customize',10,3);
function nbod_gallery_customize($link_template,$temp,$UrlPageNBD){
    $link_template  = add_query_arg( array(
        'product_id'    => $temp['product_id'],
        'variation_id'  => $temp['variation_id'],
        'reference'     => $temp['folder'],
        'page_previous' => 'gallery',
    ), $UrlPageNBD );
    return $link_template;
}

add_filter('nbd_gallery_notice','nbd_gallery_notice',10,2);
function nbd_gallery_notice($product_data,$get){
    $page_gallery           = (isset($get['page_previous']) &&  $get['page_previous'] != '') ? $get['page_previous'] : 'none';
    $product_data['page_gallery'] = $page_gallery;
    return $product_data;
}