<?php if (!defined('ABSPATH')) exit; // Exit if accessed directly  ?>

<?php do_action('nbod_style_dropdown_button'); ?>

<h2><?php esc_html_e('Uploaded Images', 'web-to-print-online-designer'); ?></h2>

<?php if( count($designs) ): ?>

<div class="container-design">

    <table class="shop_table shop_table_responsive my_account_orders">

        <thead>

            <tr>

                <th><?php esc_html_e('Preview', 'web-to-print-online-designer'); ?></th>

                <th><?php esc_html_e('Name', 'web-to-print-online-designer'); ?></th>

                <th><?php esc_html_e('Action ', 'web-to-print-online-designer'); ?></th>

            </tr>

        </thead>

        <tbody>

            <?php foreach ($designs as $key => $design): ?>

            <tr class="order">

                <td data-title="<?php esc_html_e('Preview', 'web-to-print-online-designer'); ?>">

                    <img class="nbd-preview" src="<?php echo $design['url']; ?>" />

                </td>

                <td data-title="<?php esc_html_e('Date', 'web-to-print-online-designer'); ?>"><?php esc_html_e( $design['name'] ); ?></td>

                <td data-title="<?php esc_html_e('Action ', 'web-to-print-online-designer'); ?>">

                    <a href="javascript:void(0)" data-design="<?php esc_html_e( $key );  ?>" onclick="NBDESIGNERPRODUCT.delete_img( this )"><?php esc_html_e('Delete', 'web-to-print-online-designer'); ?></a><br />

                </td>

            </tr>

            <?php endforeach; ?>

        </tbody>

    </table>

    <?php 

        $max_page = ceil( $total / $item_per_page );

        if( $max_page > 1 ): 

    ?>

    <div class="nbd-nav">

        <?php if ( 1 !== $current_page ) : ?>

        <a class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button" href="<?php echo wc_get_endpoint_url( 'user-images', $current_page - 1, wc_get_page_permalink( 'myaccount' ) ); ?>" ><?php esc_html_e( 'Previous', 'web-to-print-online-designer' ); ?></a>

        <?php endif;?>

        <?php if( $max_page != $current_page ): ?>

        <a class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button" href="<?php echo wc_get_endpoint_url( 'user-images', $current_page + 1, wc_get_page_permalink( 'myaccount' ) ); ?>"><?php esc_html_e( 'Next', 'web-to-print-online-designer' ); ?></a>

        <?php endif;?>

    </div>

    <?php endif;?>

</div>

<?php else: ?>

<div class="woocommerce-message woocommerce-message--info woocommerce-Message woocommerce-Message--info woocommerce-info">

    <?php esc_html_e( 'No image has been uploaded yet.', 'web-to-print-online-designer' ); ?>

</div>

<?php endif;