<?php
/**
 * Single Product Price
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/price.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product;

?>
<p class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?>">
    <?php echo $product->get_price_html();
    $price = $product->get_regular_price();
    if($product->get_sale_price()){
        $sale = round(($price - $product->get_sale_price()) / $price , 2) * 100;
        ?>
        <span class="pr-sale__pd d-none d-md-inline">-<?php echo $sale; ?>%</span>
        <?php
    }
    ?>

</p>
<?php
$attributes = $product->get_attributes();

?>
<div class="variations">
    <?php if(isset($attributes['pa_kich-thuoc'])) : ?>
    <div class="variation" data-target="#size">
        <div class="variation_title align-items-center d-flex justify-content-between">
            <div class="text">
                Size
            </div>
            <div class="value align-items-center d-flex">
                <span id="val_size"></span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.29289 5.29289C8.68342 4.90237 9.31658 4.90237 9.70711 5.29289L15.7071 11.2929C16.0976 11.6834 16.0976 12.3166 15.7071 12.7071L9.70711 18.7071C9.31658 19.0976 8.68342 19.0976 8.29289 18.7071C7.90237 18.3166 7.90237 17.6834 8.29289 17.2929L13.5858 12L8.29289 6.70711C7.90237 6.31658 7.90237 5.68342 8.29289 5.29289Z" fill="#111111"/>
                </svg>
            </div>
        </div>
        <div class="variation_list">
            <div></div>
        </div>
    </div>
    <?php endif; ?>
    <?php if(isset($attributes['pa_mau-sac'])) : ?>
    <div class="variation" data-target="#color">
        <div class="variation_title align-items-center d-flex justify-content-between">
            <div class="text">
                Màu sắc
            </div>
            <div class="value align-items-center d-flex">
                <span id="val_color"></span>
                <span class="current_color"></span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.29289 5.29289C8.68342 4.90237 9.31658 4.90237 9.70711 5.29289L15.7071 11.2929C16.0976 11.6834 16.0976 12.3166 15.7071 12.7071L9.70711 18.7071C9.31658 19.0976 8.68342 19.0976 8.29289 18.7071C7.90237 18.3166 7.90237 17.6834 8.29289 17.2929L13.5858 12L8.29289 6.70711C7.90237 6.31658 7.90237 5.68342 8.29289 5.29289Z" fill="#111111"/>
                </svg>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
