<?php
global $product;

$post_thumbnail_id = $product->get_image_id();
$image             = wp_get_attachment_image($post_thumbnail_id , 'full');
$price = $product->get_regular_price();
$sale = '';
if($product->get_sale_price()){
    $sale = round(($price - $product->get_sale_price()) / $price , 2) * 100;
}

$brands = wp_get_post_terms( $product->get_id(), 'pwb-brand' );
$_brand = '';
if ( !empty($brands) && !is_wp_error($brands) ) {
    foreach ( $brands as $brand ) {
        $_brand .= $_brand == '' ? $brand->name : ', ' . $brand->name;
    }
}
?>
<div class="modal-product" id="compare_products">
    <div class="modal-wrapper">
        <div class="modal-title align-items-center d-flex justify-content-between">
            <div class="title_text">
                So sánh sản phẩm
            </div>
            <svg class="close_modal" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M18.7071 5.29289C19.0976 5.68342 19.0976 6.31658 18.7071 6.70711L6.70711 18.7071C6.31658 19.0976 5.68342 19.0976 5.29289 18.7071C4.90237 18.3166 4.90237 17.6834 5.29289 17.2929L17.2929 5.29289C17.6834 4.90237 18.3166 4.90237 18.7071 5.29289Z" fill="#111111"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.29289 5.29289C5.68342 4.90237 6.31658 4.90237 6.70711 5.29289L18.7071 17.2929C19.0976 17.6834 19.0976 18.3166 18.7071 18.7071C18.3166 19.0976 17.6834 19.0976 17.2929 18.7071L5.29289 6.70711C4.90237 6.31658 4.90237 5.68342 5.29289 5.29289Z" fill="#111111"/>
            </svg>
        </div>
        <div class="modal-content">
            <div class="current_product d-flex">
                <div class="product_image">
                    <?php echo $image; ?>
                </div>
                <div class="product_infomation">
                    <div class="before_brand">
                        <?php echo $product->get_sku(); ?>
                    </div>
                    <div class="brands">
                        <?php echo $_brand; ?>
                    </div>
                    <div class="product_name">
                        <?php echo $product->get_name(); ?>
                    </div>
                    <div class="product_price">
                        <p class="price">
                            <?php echo $product->get_price_html(); ?>
                            <?php if($sale) : ?>
                            <span class="pr-sale__pd">-<?php echo $sale; ?>%</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>
            <div class="text_choose">
                Chọn 1 sản phẩm để so sánh
            </div>
            <div class="compare_note">
                Chỉ có thể so sánh sản phẩm trong cùng danh mục
            </div>
            <?php
            $args = array( 'home' => __('The Seasons Authentic' , 'storeethan') );
            woocommerce_breadcrumb($args);
            ?>
            <div class="list_compare_products d-flex">

            </div>
            <div class="compare_loading">
                <div class="loader">

                </div>
            </div>
        </div>

    </div>
</div>

