<?php
/**
 * Order Item Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-item.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
    return;
}

$brands = wp_get_post_terms( $product->get_id(), 'pwb-brand' );
$_brand = '';
if ( !empty($brands) && !is_wp_error($brands) ) {
    foreach ( $brands as $brand ) {
        $_brand .= $_brand == '' ? $brand->name : ', ' . $brand->name;
    }
}

$quantity = $item->get_quantity();

$sale = '';
$price = $product->get_regular_price();
if($product->get_sale_price()){
    $sale = round(($price - $product->get_sale_price()) / $price , 2) * 100;
}
?>
<div class="order_item">
    <div class="d-flex">
        <div class="product-image">
            <?php echo $product->get_image('thumbnail'); ?>
        </div>
        <div class="product-name">
            <div class="product_infomation">
                <div class="before_brand">
                    <?php echo $product->get_sku(); ?>
                </div>
                <div class="brands">
                    <?php echo $_brand; ?>
                </div>
                <div class="product_name">
                    <?php echo $product->get_name(); ?>
                </div>
            </div>
            <?php
            do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false );

            wc_display_item_meta( $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

            do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, false );
            ?>
        </div>
        <div class="item-quantity">
            <input type="text" class="" readonly value="<?php echo $quantity; ?>">
        </div>
        <div class="product-total">
            <p class="price">
                <?php echo $product->get_price_html(); ?>
            </p>
        </div>
    </div>
</div>

<?php if ( $show_purchase_note && $purchase_note ) : ?>

    <tr class="woocommerce-table__product-purchase-note product-purchase-note">

        <td colspan="2"><?php echo wpautop( do_shortcode( wp_kses_post( $purchase_note ) ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>

    </tr>

<?php endif; ?>
