<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="woocommerce-order">
    <?php if ( $order ) : ?>
    <div class="thankyou_wrap">
        <div class="text-center heading">
            <img src="<?php echo STORE_ASSETS_URL . 'images/check_circle.png' ?>" alt="check order">
            <h2 class="thankyou_heading"><?php _e('Đặt hàng thành công' , 'storeethan'); ?></h2>
            <p class="mb-0"><?php _e('Đơn hàng của bạn đã được ghi nhận.' , 'storeethan'); ?></p>
            <p class="mb-0"><?php _e('Chúng tôi sẽ liên hệ với bạn để xác nhận đơn hàng sớm nhất. ' , 'storeethan'); ?></p>
        </div>
        <div class="thankyou_content">
            <div class="information_order">
                <h6><?php _e('Thông tin đơn hàng' , 'storeethan'); ?></h6>
                <table class="table">
                    <tbody>
                        <tr>
                            <td><?php _e('Mã đơn hàng' , 'storeethan'); ?></td>
                            <td><?php echo $order->get_order_number(); ?></td>
                        </tr>
                        <tr>
                            <td><?php _e('Ngày đặt hàng' , 'storeethan'); ?></td>
                            <td><?php echo wc_format_datetime( $order->get_date_created() ); ?></td>
                        </tr>
                        <tr>
                            <td><?php _e('Email' , 'storeethan'); ?></td>
                            <td><?php echo $order->get_billing_email(); ?></td>
                        </tr>
                        <tr>
                            <td><?php _e('Số điện thoại' , 'storeethan'); ?></td>
                            <td><?php echo $order->get_billing_phone() ? $order->get_billing_phone() : ''; ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <?php woocommerce_order_details_table($order->get_id()) ?>
            <div class="d-flex btn_back_home justify-content-center">
                <a href="<?php echo home_url(); ?>" class="btn btn_see_all">
                    <?php _e('Quay lại Trang chủ' , 'storeethan') ?>
                </a>
            </div>

        </div>
    </div>
        <?php
        do_action( 'woocommerce_before_thankyou', $order->get_id() );
        ?>

        <?php if ( $order->has_status( 'failed' ) ) : ?>

            <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>

            <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
                <a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'woocommerce' ); ?></a>
                <?php if ( is_user_logged_in() ) : ?>
                    <a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'woocommerce' ); ?></a>
                <?php endif; ?>
            </p>

        <?php else : ?>

        <?php //wc_get_template( 'checkout/order-received.php', array( 'order' => $order ) ); ?>


        <?php endif; ?>



    <?php else : ?>

        <?php wc_get_template( 'checkout/order-received.php', array( 'order' => false ) ); ?>

    <?php endif; ?>

</div>
