<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.9.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_cart' ); ?>

<form class="woocommerce-cart-form fomt-cart_checkout" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
	<?php do_action( 'woocommerce_before_cart_table' ); ?>

	<?php
		foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
			$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
			$product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
            $_brand = '';
            $brands = wp_get_post_terms( $_product->get_id(), 'pwb-brand' );
            if ( !empty($brands) && !is_wp_error($brands) ) {
                foreach ( $brands as $brand ) {
                    $_brand .= $_brand == '' ? $brand->name : ', ' . $brand->name;
                }
            }
            if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
				$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
	?>
	<div class="container-fluid container-cart_checkout">
		<div class="row">
			<div class="col-lg-8 col-md-8 col-12 left-cart">
				<span class="product-remove">
					<?php
						echo apply_filters(
							'woocommerce_cart_item_remove_link',
							sprintf(
								'<a href="%s" class="remove-mini_cart remove" data-cartkey=' .$cart_item_key. ' aria-label="%s" data-product_id="%s" data-product_sku="%s"></a>',
								esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
								esc_attr( sprintf( __( 'Remove %s from cart', 'woocommerce' ), wp_strip_all_tags( $product_name ) ) ),
								esc_attr( $product_id ),
								esc_attr( $_product->get_sku() )
							),
							$cart_item_key
						);
					?>
				</span>
				<div class="product-thumbnail">
					<?php
						$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

						if ( ! $product_permalink ) {
							echo $thumbnail; // PHPCS: XSS ok.
						} else {
							printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
						}
					?>
				</div>
				<div class="product-name">
					<div>
                        <div class="before_brand">
                            <?php echo $_product->get_sku(); ?>
                        </div>
                        <div class="brands">
                            <?php echo $_brand; ?>
                        </div>
					<?php
						if ( ! $product_permalink ) {
							echo wp_kses_post( $product_name . '&nbsp;' );
						} else {
							echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
						}

						do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );

						echo wc_get_formatted_cart_item_data( $cart_item );

						if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
							echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'woocommerce' ) . '</p>', $product_id ) );
						}
					?>

					</div>
				</div>

				

			</div>
			<div class="col-12 col-md-4 col-lg-4 right-cart">
				<div class="product-quantity">
					<span class="tru" key="<?php echo $cart_item_key; ?>">
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M2.66602 8C2.66602 7.63181 2.96449 7.33333 3.33268 7.33333H12.666C13.0342 7.33333 13.3327 7.63181 13.3327 8C13.3327 8.36819 13.0342 8.66667 12.666 8.66667H3.33268C2.96449 8.66667 2.66602 8.36819 2.66602 8Z" fill="#111111"/>
                        </svg>
                    </span>
					<?php
						if ( $_product->is_sold_individually() ) {
							$min_quantity = 1;
							$max_quantity = 1;
						} else {
							$min_quantity = 0;
							$max_quantity = $_product->get_max_purchase_quantity();
						}

						$product_quantity = woocommerce_quantity_input(
							array(
								'input_name'   => "cart[{$cart_item_key}][qty]",
								'input_value'  => $cart_item['quantity'],
                                'classes'      => array( 'input-text', 'qty', 'text', 'inp_'.$cart_item_key ),
                                'key'          => $cart_item_key,
								'max_value'    => $max_quantity,
								'min_value'    => $min_quantity,
								'product_name' => $product_name,
							),
							$_product,
							false
						);

						echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
					?>
					<span class="plus" key="<?php echo $cart_item_key; ?>">
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.00065 2.66667C8.36884 2.66667 8.66732 2.96514 8.66732 3.33333V12.6667C8.66732 13.0349 8.36884 13.3333 8.00065 13.3333C7.63246 13.3333 7.33398 13.0349 7.33398 12.6667V3.33333C7.33398 2.96514 7.63246 2.66667 8.00065 2.66667Z" fill="#111111"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M2.66602 8C2.66602 7.63181 2.96449 7.33333 3.33268 7.33333H12.666C13.0342 7.33333 13.3327 7.63181 13.3327 8C13.3327 8.36819 13.0342 8.66667 12.666 8.66667H3.33268C2.96449 8.66667 2.66602 8.36819 2.66602 8Z" fill="#111111"/>
                        </svg>
                    </span>
				</div>
				<div class="product-price">
					<?php
//						echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                        echo WC()->cart->get_product_price( $_product );
					?>
				</div>
			</div>
		</div>
	</div>
<?php }} ?>
	
	<div class="product-subtotal">
		<span>Tổng <?php echo WC()->cart->get_cart_contents_count(); ?> sản phẩm</span>
		<p>
			<?php
				echo wc_cart_totals_order_total_html();
			?>
		</p>
	</div>

	<div class="end-checkout">Tiến hành mua hàng</div>

	<?php do_action( 'woocommerce_after_cart_table' ); ?>
</form>

<?php do_action( 'woocommerce_before_cart_collaterals' ); ?>

<div class="cart-collaterals">
	<?php
		/**
		 * Cart collaterals hook.
		 *
		 * @hooked woocommerce_cross_sell_display
		 * @hooked woocommerce_cart_totals - 10
		 */
		do_action( 'woocommerce_cart_collaterals' );
	?>
</div>

<?php do_action( 'woocommerce_after_cart' ); ?>
