<?php
/**
 * Template part for displaying card post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package storeethan
 */
defined( 'ABSPATH' ) || exit;
global $post;
$post_id = get_the_ID();
$thumbnail_id = get_post_thumbnail_id($post_id);
$image_url = wp_get_attachment_image_src($thumbnail_id, 'full');
$url = '';
if ($image_url) {
    $url = $image_url[0];
}
$categories = get_the_category($post_id);
$cate = '';
foreach ($categories as $category) {
    $cate .= $cate == '' ? $category->name : ', ' . $category->name;
}
$datetime = new DateTime($post->post_date);
$day_with_suffix = addOrdinalSuffix($datetime->format('j'));
$d =  $datetime->format('M') . ' ' .$day_with_suffix . ', ' . $datetime->format('Y');
?>
<a href="<?php echo get_permalink(); ?>">
    <div class="card_post">
        <img src="<?php echo $url; ?>" alt="Ảnh bài viết">
        <div class="props-of-post">
            <div class="type_post">
                <?php echo $cate; ?>
            </div>
            <div class="name_post">
                <?php the_title(); ?>
            </div>
            <div class="date_post">
                <!--July 14th, 2024-->
                <?php echo $d; ?>
            </div>
        </div>
    </div>
</a>
