<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package storeethan
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function storeethan_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'storeethan_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function storeethan_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'storeethan_pingback_header' );

add_filter('wc_price','change_fomat_price_template',10,5);
function change_fomat_price_template($return, $price, $args, $unformatted_price, $original_price) {
    return $price;
}

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

add_action('single_product_archive_thumbnail_size', 'ethan_single_product_archive_thumbnail_size');
function ethan_single_product_archive_thumbnail_size($size)
{
    return 'full';
}

add_action( 'woocommerce_before_shop_loop_item_title', 'ethan_woocommerce_template_loop_product_thumbnail', 10 );

function ethan_woocommerce_template_loop_product_thumbnail(){
    global $product;
    $attachment_ids = $product->get_gallery_image_ids();
    $image_size = apply_filters( 'single_product_archive_thumbnail_size', 'woocommerce_thumbnail' );

    $output = $product ? $product->get_image( $image_size, array(), true ) : '';
    if(empty($attachment_ids)) {
        echo $output;
        return;
    }

    $output = '<div class="product-slider__cat">';
    foreach ($attachment_ids as $attachment_id) {
        $image_url = wp_get_attachment_url($attachment_id);
        $output .= '<div><img src="' . esc_url($image_url) . '" alt=""></div>';
    }
    $output .= '</div>';
    echo $output;
}
//add_action('woocommerce_before_shop_loop' , 'ethan_before_loops');
function ethan_before_loops($products)
{
    global $post , $wp_query;
    if(is_product_category()) :
        $count_filter = get_query_var('count_filter', 0);
        $text = $count_filter == 0 ? '0' : $count_filter;
        ?>
        <div class="product_modal_bg">

        </div>
        <?php
        wc_get_template( 'category/modal/filter.php' );
        ?>
        <div class="img-top_breadcrumb d-none d-md-block"></div>
        <div class="breadcrum_category">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-6 col-sm-6 col-md-6 col-12">
                        <?php woocommerce_breadcrumb(); ?>
                        <h1 class="category-title d-none d-sm-block"><?php echo $wp_query->get_queried_object()->name; ?></h1>
                    </div>
                    <div class="col-7 d-block d-sm-none">
                        <h1 class="category-title"><?php echo $wp_query->get_queried_object()->name; ?></h1>
                    </div>
                    <div class="col-lg-6 col-5 d-flex justify-content-end align-items-center">
                        <a href="" class="btn btn_filter d-flex">
                            <span><?php _e('Bộ lọc (' . $text . ')' , 'storeethan'); ?></span>
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M1.0929 2.57912C1.25675 2.22596 1.61069 2 2.00001 2H22C22.3893 2 22.7433 2.22596 22.9071 2.57912C23.071 2.93229 23.015 3.34845 22.7636 3.64573L15 12.8261V21C15 21.3466 14.8206 21.6684 14.5257 21.8507C14.2309 22.0329 13.8628 22.0494 13.5528 21.8944L9.5528 19.8944C9.21402 19.725 9.00001 19.3788 9.00001 19V12.8261L1.23644 3.64573C0.985046 3.34845 0.929037 2.93229 1.0929 2.57912ZM4.15532 4L10.7636 11.8143C10.9162 11.9948 11 12.2236 11 12.46V18.382L13 19.382V12.46C13 12.2236 13.0838 11.9948 13.2364 11.8143L19.8447 4H4.15532Z" fill="#111111"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="img-top_breadcrumb d-block d-md-none"></div>
        <?php if(count($products->ids) == 0) : ?>
            <div class="container-fluid">
                <p class="no_product">
                    <?php _e('0 Sản phẩm nào phù hợp với bộ lọc'); ?>
                </p>
            </div>
        <?php endif ?>
    <?php
    endif;
}
// add_action('woocommerce_shortcode_before_products_loop', 'ethan_before_loops');
function add_image_bottom_list_product() {
    ?>
    <div class="img-top_breadcrumbbt"></div>
    <div class="xt_bottom">
        <span>Xem thêm</span>
    </div>
    <?php
}

function ethan_get_template( $template_name, $args = array() ) {
    $template_path = STORE_THEME_PATH . '/templates';
    $template = $template_path . '/' . $template_name . '.php';

    $action_args = array(
        'template_name' => $template_name,
        'template_path' => $template_path,
        'located'       => $template,
        'args'          => $args,
    );

    if ( ! empty( $args ) && is_array( $args ) ) {

        extract( $args );
    }

    include $action_args['located'];
}

add_filter( 'body_class', 'ethan_body_class' );
function ethan_body_class($classes)
{
    if(is_product_category()){
        $classes[] = 'product-category';
    }
    return $classes;
}

add_filter('woocommerce_breadcrumb_defaults' , 'ethan_breadcrumb_defaults');
function ethan_breadcrumb_defaults($args)
{
    $args['wrap_before'] = '<nav class="woocommerce-breadcrumb d-flex align-items-center" aria-label="Breadcrumb">';
    return $args;
}

add_action('woocommerce_shortcode_after_products_loop', 'ethan_after_products_loop');
function ethan_after_products_loop(){

}
