<?php
/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://woocommerce.com/document/template-structure/
 * @package    WooCommerce\Templates
 * @version    1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
global $product;
$brands = wp_get_post_terms( $product->get_id(), 'pwb-brand' );
$_brand = '';
if ( !empty($brands) && !is_wp_error($brands) ) {
    foreach ( $brands as $brand ) {
        $_brand .= $_brand == '' ? $brand->name : ', ' . $brand->name;
    }
}
?>
<div class="before_brand">
    <?php echo $product->get_sku(); ?>
</div>
<div class="brands">
    <?php echo $_brand; ?>
</div>
<?php
the_title( '<h1 class="product_title entry-title">', '</h1>' );
