<?php
/**
 * Template part for displaying list product by category
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package storeethan
 */
defined( 'ABSPATH' ) || exit;
$args = array(
    'taxonomy'     => 'product_cat',
    'hierarchical' => 1,
    'hide_empty'   => 1,
    'number'       => 4,
);

$categories = get_categories($args);

foreach ($categories as $category):
    $thumbnail_id = get_term_meta( $category->term_id, 'thumbnail_id', true );
    $image = wp_get_attachment_url( $thumbnail_id );
    if(!$image) $image = ethan_get_url_placeholder_image();
    $products = ethan_get_product_by_category($category->term_id);

?>
    <section class="section_category">
        <div class="container-fluid p-0">
            <h4 class="section_title"><?php echo $category->name; ?></h4>
            <img class="category_image" src="<?php echo $image; ?>" alt="<?php _e('Ảnh danh mục' , 'storeethan'); ?>">
        </div>
        <?php
        $original_post = $GLOBALS['post'];
        woocommerce_product_loop_start();
        foreach ( $products as $product ) {
            $GLOBALS['post'] = get_post( $product );
            setup_postdata( $GLOBALS['post'] );

            wc_get_template_part( 'content', 'product' );
        }

        $GLOBALS['post'] = $original_post;
        woocommerce_product_loop_end();
        ?>
        <div class="d-flex justify-content-center align-items-center">
            <a href="<?php echo get_term_link($category); ?>"  class="btn btn_see_all">
                <?php _e('Xem tất cả sản phẩm' , 'storeethan') ?>
            </a>
        </div>
        <?php
        wp_reset_postdata();
        wc_reset_loop();
        ?>
    </section>

<?php
endforeach;

