<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package storeethan
 */

global $post;
$post_id = get_the_ID();
$categories = get_the_category($post_id);
$cate = '';
foreach ($categories as $category) {
    $cate .= $cate == '' ? $category->name : ', ' . $category->name;
}
$tags = get_the_tags($post_id);
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="banner">
        <img src="<?php echo STORE_ASSETS_URL . '/images/post_banner.png'; ?>" alt="post_banner" />
    </div>
    <div class="container-fluid">
        <div class="post_head">
            <div class="category_name">
                <?php echo $cate; ?>
            </div>
            <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
            <?php if(!is_wp_error($tags)): ?>
            <ul class="tags">
                <?php foreach ($tags as $tag): ?>
                <li><?php echo $tag->name; ?></li>
                <?php endforeach; ?>
            </ul>
            <?php endif; ?>
            <p class="post_date"><?php _e('Ngày đăng'); ?>: <?php echo date('d/m/Y' ,strtotime($post->post_date)) ;?></p>
        </div>
    </div>
    <div class="post_banner">
        <img src="<?php echo STORE_ASSETS_URL . '/images/post_banner2.png'; ?>" alt="post_banner" />
    </div>
	<div class="entry-content">
		<?php
		the_content();

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'storeethan' ),
				'after'  => '</div>',
			)
		);
		?>
	</div>
    <div class="d-flex after_content">
        <div class="share_post">
            <p><?php _e('Chia sẻ bài viết này') ?></p>
            <ul class="share_items">
                <li>
                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect width="32" height="32" rx="16" fill="#F4F4F4"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M24.9999 11.6601V12.0001C25.0007 13.0662 24.576 14.0885 23.8199 14.84L20.9999 17.67C20.4738 18.1911 19.6261 18.1911 19.1 17.67L19 17.56C18.8094 17.3656 18.8094 17.0544 19 16.86L22.4399 13.4201C22.807 13.0394 23.0083 12.5288 22.9999 12.0001V11.6601C23.0003 11.127 22.788 10.6159 22.4099 10.2401L21.7599 9.59011C21.3841 9.21207 20.873 8.99969 20.3399 9.00011H19.9999C19.4669 8.99969 18.9558 9.21207 18.58 9.59011L15.14 13.0001C14.9456 13.1906 14.6344 13.1906 14.44 13.0001L14.33 12.8901C13.8089 12.3639 13.8089 11.5162 14.33 10.9901L17.16 8.15012C17.9165 7.40505 18.9382 6.99133 19.9999 7.00014H20.3399C21.4011 6.9993 22.4191 7.42018 23.1699 8.17012L23.8299 8.83012C24.5798 9.5809 25.0007 10.5989 24.9999 11.6601ZM12.6499 17.94L17.9399 12.6501C18.0338 12.5554 18.1616 12.5022 18.2949 12.5022C18.4282 12.5022 18.556 12.5554 18.6499 12.6501L19.3499 13.3501C19.4445 13.4439 19.4978 13.5717 19.4978 13.7051C19.4978 13.8384 19.4445 13.9662 19.3499 14.0601L14.0599 19.35C13.966 19.4447 13.8382 19.4979 13.7049 19.4979C13.5716 19.4979 13.4438 19.4447 13.3499 19.35L12.6499 18.65C12.5553 18.5561 12.502 18.4283 12.502 18.295C12.502 18.1617 12.5553 18.0339 12.6499 17.94ZM17.5599 19C17.3655 18.8094 17.0543 18.8094 16.8599 19L13.4299 22.41C13.0517 22.7905 12.5365 23.003 12 22.9999H11.66C11.1269 23.0004 10.6158 22.788 10.24 22.41L9.58997 21.76C9.21194 21.3842 8.99956 20.873 8.99998 20.34V20C8.99956 19.4669 9.21194 18.9558 9.58997 18.58L13.0099 15.14C13.2005 14.9456 13.2005 14.6345 13.0099 14.44L12.8999 14.33C12.3738 13.8089 11.5261 13.8089 11 14.33L8.17999 17.16C7.42392 17.9116 6.99916 18.9339 7 20V20.35C7.00182 21.4077 7.42249 22.4216 8.16999 23.1699L8.82998 23.8299C9.58076 24.5799 10.5988 25.0008 11.66 24.9999H12C13.0534 25.0061 14.0667 24.5964 14.8199 23.8599L17.6699 21.01C18.191 20.4838 18.191 19.6361 17.6699 19.11L17.5599 19Z" fill="black"/>
                    </svg>
                </li>
                <li>
                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect width="32" height="32" rx="16" fill="#F4F4F4"/>
                        <path d="M20.5 10H17.5C16.9477 10 16.5 10.4477 16.5 11V14H20.5C20.6137 13.9975 20.7216 14.0504 20.7892 14.1419C20.8568 14.2334 20.8758 14.352 20.84 14.46L20.1 16.66C20.0318 16.8619 19.8431 16.9984 19.63 17H16.5V24.5C16.5 24.7761 16.2761 25 16 25H13.5C13.2239 25 13 24.7761 13 24.5V17H11.5C11.2239 17 11 16.7761 11 16.5V14.5C11 14.2239 11.2239 14 11.5 14H13V11C13 8.79086 14.7909 7 17 7H20.5C20.7761 7 21 7.22386 21 7.5V9.5C21 9.77614 20.7761 10 20.5 10Z" fill="black"/>
                    </svg>
                </li>
            </ul>
        </div>
        <div class="tag_post">
            <?php if(!is_wp_error($tags)): ?>
                <ul class="tags">
                    <?php foreach ($tags as $tag): ?>
                        <li><?php echo $tag->name; ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>

    </div>
    <?php ethan_get_related_post(); ?>
</article>
