<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package storeethan
 */

get_header();
global $wp_query;
$number = $wp_query->post_count ? $wp_query->post_count : 0;
if($number > 24) $number = 24;
?>

	<main id="primary" class="site-main">
        <div class="container-fluid">
            <header class="page-header">
                <h1 class="page-title">
                    <?php
                    /* translators: %s: search query. */
                    printf( esc_html__( $number . ' kết quả tìm kếm cho: %s', 'storeethan' ), '<span>' . get_search_query() . '</span>' );
                    ?>
                </h1>
            </header><!-- .page-header -->

            <div class="post_wrap">
                <?php if ( have_posts() ) : ?>
                    <div class="row">
                        <?php
                        while ( have_posts() ) :
                            the_post();
                            global $post;
                            $post_id = get_the_ID();
                            $thumbnail_id = get_post_thumbnail_id($post_id);
                            $image_url = wp_get_attachment_image_src($thumbnail_id, 'full');
                            $url = '';
                            if ($image_url) {
                                $url = $image_url[0];
                            }
                            $categories = get_the_category($post_id);
                            $cate = '';
                            foreach ($categories as $category) {
                                $cate .= $cate == '' ? $category->name : ', ' . $category->name;
                            }
                            $datetime = new DateTime($post->post_date);
                            $day_with_suffix = addOrdinalSuffix($datetime->format('j'));
                            $d =  $datetime->format('M') . ' ' .$day_with_suffix . ', ' . $datetime->format('Y');
                            ?>
                            <div class="col-md-3 col-6 post">
                                <a href="<?php echo get_permalink(); ?>">
                                    <div class="card_post">
                                        <img src="<?php echo $url; ?>" alt="Ảnh bài viết">
                                        <div class="props-of-post">
                                            <div class="type_post">
                                                <?php echo $cate; ?>
                                            </div>
                                            <div class="name_post">
                                                <?php the_title(); ?>
                                            </div>
                                            <div class="date_post">
                                                <!--July 14th, 2024-->
                                                <?php echo $d; ?>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php
//                    the_posts_navigation();?>
            </div>
            <?php
            else :
                get_template_part( 'template-parts/content', 'none' );
            endif;
            ?>
        </div>
	</main><!-- #main -->
<?php
get_footer();
