<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package storeethan
 */

//$menu_items = array(
//    __('Đồ nam' , 'storeethan'),
//    __('Đồ Nữ' , 'storeethan'),
//    __('Phụ Kiện Luxury' , 'storeethan'),
//    __('Đồng Hồ' , 'storeethan'),
//    __('Bài Viết' , 'storeethan')
//);
//$chids = array(
//    array(
//        'label' => __('Giày' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/giay/',
//    ),
//    array(
//        'label' => __('Trang sức' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/trang-suc/',
//    ),
//    array(
//        'label' => __('Áo' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/ao/',
//    ),
//    array(
//        'label' => __('Guốc' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/guoc/',
//    ),
//    array(
//        'label' => __('Kính' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/kinh/',
//    ),
//    array(
//        'label' => __('Vali' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/vali/',
//    ),
//    array(
//        'label' => __('Sục' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/suc/',
//    ),
//    array(
//        'label' => __('Ví' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/vi/',
//    ),
//    array(
//        'label' => __('Dopp kit' , 'storeethan'),
//        'link'  => 'https://project.cmsmart.net/store/product-category/dopp-kit/',
//    ),
//);

$menu_items = getMenuItem();

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
<!--    <link href="https://fonts.cdnfonts.com/css/helvetica-neue-55" rel="stylesheet">-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">


    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<!--    <video id="video_intro" class="video_intro" muted>-->
<!--        <source src="--><?php //echo STORE_ASSETS_URL . 'media/intro.mp4'; ?><!--" type="video/mp4">-->
<!--        Your browser does not support the video tag.-->
<!--    </video>-->
<div id="page" class="site">
	<header id="masthead" class="site-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-5 col-lg-5 col-4">
                    <div class="d-flex d-md-flex justify-content-start">
                        <div class="header_item">
                            <div>
                                <a href="" id="toogle_menu">
                                    <svg class="toggle_icon" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 18C2 17.4477 2.44772 17 3 17H21C21.5523 17 22 17.4477 22 18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18Z" fill="black"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 12C2 11.4477 2.44772 11 3 11H21C21.5523 11 22 11.4477 22 12C22 12.5523 21.5523 13 21 13H3C2.44772 13 2 12.5523 2 12Z" fill="black"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M2 6C2 5.44772 2.44772 5 3 5H21C21.5523 5 22 5.44772 22 6C22 6.55228 21.5523 7 21 7H3C2.44772 7 2 6.55228 2 6Z" fill="black"/>
                                    </svg>
                                    <svg class="close_menu_btn d-block d-md-none" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">-->
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M22.7071 9.29289C23.0976 9.68342 23.0976 10.3166 22.7071 10.7071L10.7071 22.7071C10.3166 23.0976 9.68342 23.0976 9.29289 22.7071C8.90237 22.3166 8.90237 21.6834 9.29289 21.2929L21.2929 9.29289C21.6834 8.90237 22.3166 8.90237 22.7071 9.29289Z" fill="#111111"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.29289 9.29289C9.68342 8.90237 10.3166 8.90237 10.7071 9.29289L22.7071 21.2929C23.0976 21.6834 23.0976 22.3166 22.7071 22.7071C22.3166 23.0976 21.6834 23.0976 21.2929 22.7071L9.29289 10.7071C8.90237 10.3166 8.90237 9.68342 9.29289 9.29289Z" fill="black"/>
                                    </svg>
                                </a>
                            </div>
                            <span class="d-none d-md-inline"><?php _e('Danh mục', 'storeethan'); ?></span>
                        </div>
                        <div class="header_item item_search">
                            <div>
                                <a href="" id="btn_search">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M11 4C7.13401 4 4 7.13401 4 11C4 14.866 7.13401 18 11 18C14.866 18 18 14.866 18 11C18 7.13401 14.866 4 11 4ZM2 11C2 6.02944 6.02944 2 11 2C15.9706 2 20 6.02944 20 11C20 15.9706 15.9706 20 11 20C6.02944 20 2 15.9706 2 11Z" fill="black"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.9428 15.9429C16.3333 15.5524 16.9665 15.5524 17.357 15.9429L21.707 20.2929C22.0975 20.6834 22.0975 21.3166 21.707 21.7071C21.3165 22.0976 20.6833 22.0976 20.2928 21.7071L15.9428 17.3571C15.5523 16.9666 15.5523 16.3334 15.9428 15.9429Z" fill="black"/>
                                    </svg>
                                </a>
                            </div>
                            <span class="d-none d-md-inline"><?php _e('Tìm kiếm', 'storeethan'); ?></span>
                            <div class="search_box">
                                <form class="search_form" method="get" action="<?php echo home_url(); ?>">
                                    <input type="text" name="s">
                                    <input type="submit" value="Tìm kiếm">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-4">
                    <div class="header_logo">
                        <a class="d-flex d-md-block justify-content-center" href="<?php echo home_url(); ?>">

                            <img class="d-none d-md-block logo_dark" src="<?php echo esc_url(STORE_ASSETS_URL . 'media/logo_white.svg'); ?>" alt="Logo">
                            <img class="d-none d-md-block logo" src="<?php echo esc_url(STORE_ASSETS_URL . 'media/logo.svg'); ?>" alt="Logo">
                            <img class="d-block d-md-none" src="<?php echo esc_url(STORE_ASSETS_URL . 'media/mobile_logo.png'); ?>" alt="">
                            <img class="d-block d-md-none mb_logo_dark" src="<?php echo esc_url(STORE_ASSETS_URL . 'media/mobile_logo_white.png'); ?>" alt="">
                        </a>

                    </div>
                </div>
                <div class="col-lg-5 col-md-5 col-4">
                    <div class="header_item cart_menu">
                        <a href="<?php echo wc_get_checkout_url(); ?>">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.2 1.4C5.38885 1.14819 5.68524 1 6 1H18C18.3148 1 18.6111 1.14819 18.8 1.4L21.8 5.4C21.9298 5.5731 22 5.78363 22 6V20C22 20.7957 21.6839 21.5587 21.1213 22.1213C20.5587 22.6839 19.7957 23 19 23H5C4.20435 23 3.44129 22.6839 2.87868 22.1213C2.31607 21.5587 2 20.7957 2 20V6C2 5.78363 2.07018 5.5731 2.2 5.4L5.2 1.4ZM6.5 3L4 6.33333V20C4 20.2652 4.10536 20.5196 4.29289 20.7071C4.48043 20.8946 4.73478 21 5 21H19C19.2652 21 19.5196 20.8946 19.7071 20.7071C19.8946 20.5196 20 20.2652 20 20V6.33333L17.5 3H6.5Z" fill="black"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M8 9C8.55228 9 9 9.44772 9 10C9 10.7956 9.31607 11.5587 9.87868 12.1213C10.4413 12.6839 11.2044 13 12 13C12.7956 13 13.5587 12.6839 14.1213 12.1213C14.6839 11.5587 15 10.7956 15 10C15 9.44772 15.4477 9 16 9C16.5523 9 17 9.44772 17 10C17 11.3261 16.4732 12.5979 15.5355 13.5355C14.5979 14.4732 13.3261 15 12 15C10.6739 15 9.40215 14.4732 8.46447 13.5355C7.52678 12.5979 7 11.3261 7 10C7 9.44772 7.44772 9 8 9Z" fill="black"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M2 6C2 5.44772 2.44772 5 3 5H21C21.5523 5 22 5.44772 22 6C22 6.55228 21.5523 7 21 7H3C2.44772 7 2 6.55228 2 6Z" fill="black"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="fixed_menu">
<!--            <div class="container-fluid">-->
<!--                <div class="row m-0 d-flex d-md-none">-->
<!--                    <div class="col-md-5 col-lg-5 col-4">-->
<!--                        <div class="d-flex d-md-flex justify-content-start">-->
<!--                            <div class="header_item">-->
<!--                                <div class="close_menu">-->
<!--                                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">-->
<!--                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M22.7071 9.29289C23.0976 9.68342 23.0976 10.3166 22.7071 10.7071L10.7071 22.7071C10.3166 23.0976 9.68342 23.0976 9.29289 22.7071C8.90237 22.3166 8.90237 21.6834 9.29289 21.2929L21.2929 9.29289C21.6834 8.90237 22.3166 8.90237 22.7071 9.29289Z" fill="#111111"/>-->
<!--                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.29289 9.29289C9.68342 8.90237 10.3166 8.90237 10.7071 9.29289L22.7071 21.2929C23.0976 21.6834 23.0976 22.3166 22.7071 22.7071C22.3166 23.0976 21.6834 23.0976 21.2929 22.7071L9.29289 10.7071C8.90237 10.3166 8.90237 9.68342 9.29289 9.29289Z" fill="black"/>-->
<!--                                    </svg>-->
<!--                                </div>-->
<!---->
<!--                            </div>-->
<!--                            <div class="header_item">-->
<!--                                <div>-->
<!--                                    <a href="">-->
<!--                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">-->
<!--                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M11 4C7.13401 4 4 7.13401 4 11C4 14.866 7.13401 18 11 18C14.866 18 18 14.866 18 11C18 7.13401 14.866 4 11 4ZM2 11C2 6.02944 6.02944 2 11 2C15.9706 2 20 6.02944 20 11C20 15.9706 15.9706 20 11 20C6.02944 20 2 15.9706 2 11Z" fill="black"/>-->
<!--                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M15.9428 15.9429C16.3333 15.5524 16.9665 15.5524 17.357 15.9429L21.707 20.2929C22.0975 20.6834 22.0975 21.3166 21.707 21.7071C21.3165 22.0976 20.6833 22.0976 20.2928 21.7071L15.9428 17.3571C15.5523 16.9666 15.5523 16.3334 15.9428 15.9429Z" fill="black"/>-->
<!--                                        </svg>-->
<!--                                    </a>-->
<!--                                </div>-->
<!---->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                    <div class="col-lg-2 col-md-2 col-4">-->
<!--                        <div class="header_logo">-->
<!--                            <a class="d-flex d-md-block justify-content-center" href="--><?php //echo home_url(); ?><!--">-->
<!--                                <img class="d-block d-md-none" src="--><?php //echo esc_url(STORE_ASSETS_URL . 'media/mobile_logo.png'); ?><!--" alt="">-->
<!--                            </a>-->
<!---->
<!--                        </div>-->
<!--                    </div>-->
<!--                    <div class="col-lg-5 col-md-5 col-4">-->
<!--                        <div class="header_item cart_menu">-->
<!--                            <a href="--><?php //echo wc_get_cart_url(); ?><!--">-->
<!--                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">-->
<!--                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.2 1.4C5.38885 1.14819 5.68524 1 6 1H18C18.3148 1 18.6111 1.14819 18.8 1.4L21.8 5.4C21.9298 5.5731 22 5.78363 22 6V20C22 20.7957 21.6839 21.5587 21.1213 22.1213C20.5587 22.6839 19.7957 23 19 23H5C4.20435 23 3.44129 22.6839 2.87868 22.1213C2.31607 21.5587 2 20.7957 2 20V6C2 5.78363 2.07018 5.5731 2.2 5.4L5.2 1.4ZM6.5 3L4 6.33333V20C4 20.2652 4.10536 20.5196 4.29289 20.7071C4.48043 20.8946 4.73478 21 5 21H19C19.2652 21 19.5196 20.8946 19.7071 20.7071C19.8946 20.5196 20 20.2652 20 20V6.33333L17.5 3H6.5Z" fill="black"/>-->
<!--                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8 9C8.55228 9 9 9.44772 9 10C9 10.7956 9.31607 11.5587 9.87868 12.1213C10.4413 12.6839 11.2044 13 12 13C12.7956 13 13.5587 12.6839 14.1213 12.1213C14.6839 11.5587 15 10.7956 15 10C15 9.44772 15.4477 9 16 9C16.5523 9 17 9.44772 17 10C17 11.3261 16.4732 12.5979 15.5355 13.5355C14.5979 14.4732 13.3261 15 12 15C10.6739 15 9.40215 14.4732 8.46447 13.5355C7.52678 12.5979 7 11.3261 7 10C7 9.44772 7.44772 9 8 9Z" fill="black"/>-->
<!--                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M2 6C2 5.44772 2.44772 5 3 5H21C21.5523 5 22 5.44772 22 6C22 6.55228 21.5523 7 21 7H3C2.44772 7 2 6.55228 2 6Z" fill="black"/>-->
<!--                                </svg>-->
<!--                            </a>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                </div>-->
<!--            </div>-->
            <div class="wrapper_menu">
                <div class="close_menu d-none d-md-flex justify-content-start align-items-center">
                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M22.7071 9.29289C23.0976 9.68342 23.0976 10.3166 22.7071 10.7071L10.7071 22.7071C10.3166 23.0976 9.68342 23.0976 9.29289 22.7071C8.90237 22.3166 8.90237 21.6834 9.29289 21.2929L21.2929 9.29289C21.6834 8.90237 22.3166 8.90237 22.7071 9.29289Z" fill="#111111"/>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M9.29289 9.29289C9.68342 8.90237 10.3166 8.90237 10.7071 9.29289L22.7071 21.2929C23.0976 21.6834 23.0976 22.3166 22.7071 22.7071C22.3166 23.0976 21.6834 23.0976 21.2929 22.7071L9.29289 10.7071C8.90237 10.3166 8.90237 9.68342 9.29289 9.29289Z" fill="black"/>
                    </svg>
                    <span>
                        <?php _e('Đóng' , 'storeethan'); ?>
                    </span>
                </div>
                <ul class="menus">
                    <?php foreach ($menu_items as $items) : ?>
                        <li class="menu_item">
                            <a href="" class="d-flex menu_parent justify-content-between align-items-center">
                                <?php _e($items->title , 'storeethan'); ?>
                                <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M11.0572 7.05715C11.5778 6.53645 12.4221 6.53645 12.9428 7.05715L20.9428 15.0572C21.4635 15.5778 21.4635 16.4221 20.9428 16.9428L12.9428 24.9428C12.4221 25.4635 11.5778 25.4635 11.0572 24.9428C10.5365 24.4221 10.5365 23.5779 11.0572 23.0572L18.1143 16L11.0572 8.94277C10.5365 8.42207 10.5365 7.57785 11.0572 7.05715Z" fill="#111111"/>
                                </svg>
                            </a>
                            <?php if(isset($items->childs)) : ?>
                                <ul class="menu_child">
                                    <li class="menu_item first d-list-item d-md-none">
                                        <svg class="d-inline-block d-md-none" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M4 12C4 11.4477 4.44772 11 5 11H19C19.5523 11 20 11.4477 20 12C20 12.5523 19.5523 13 19 13H5C4.44772 13 4 12.5523 4 12Z" fill="black"/>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M12.7071 4.29289C13.0976 4.68342 13.0976 5.31658 12.7071 5.70711L6.41421 12L12.7071 18.2929C13.0976 18.6834 13.0976 19.3166 12.7071 19.7071C12.3166 20.0976 11.6834 20.0976 11.2929 19.7071L4.29289 12.7071C3.90237 12.3166 3.90237 11.6834 4.29289 11.2929L11.2929 4.29289C11.6834 3.90237 12.3166 3.90237 12.7071 4.29289Z" fill="black"/>
                                        </svg>
                                        <?php _e($items->title , 'storeethan'); ?>
                                    </li>
                                    <?php foreach ($items->childs as $child) : ?>
                                        <li class="menu_item">
                                            <a href="<?php echo $child->url; ?>"><?php echo $child->title; ?></a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif;?>
                        </li>
                    <?php endforeach; ?>
                </ul>
<!--                <div class="menu_foot menu_item_lang d-flex justify-content-between align-items-center">-->
<!--                    <div class="menu_foot_text">-->
<!--                        --><?php //_e('Đổi ngôn ngữ Tiếng Anh' , 'storeethan'); ?>
<!--                    </div>-->
<!--                    <div class="toggle_enable">-->
<!--                        <a href="" class="btn_toggle">-->
<!---->
<!--                        </a>-->
<!--                    </div>-->
<!--                </div>-->
                <div class="menu_foot d-flex justify-content-between align-items-center">
                    <div class="menu_foot_text">
                        <?php _e('View in dark mode' , 'storeethan'); ?>
                    </div>
                    <div class="toggle_enable">
                        <a href="" id="toggle_mode" class="btn_toggle">

                        </a>
                    </div>
                </div>
            </div>
        </div>
	</header>
