<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package storeethan
 */
$menu_items = getMenuItem();

?>
<?php
if(ethan_show_faq()){
    get_template_part( 'templates/global/faq' );
}
?>
	<footer id="colophon" class="site-footer">
		<div class="container-fluid">
            <div class="row d-flex align-items-stretch">
                <div class="col-md-6 col-12 footer_left">
                    <div class="d-flex footer_menu_section">
                        <?php foreach ($menu_items as $item) : ?>
                        <div class="footer_menu">
                            <p class="menu_label"><?php echo $item->title; ?></p>
                            <?php if(isset($item->childs)) : ?>
                            <ul>
                                <?php foreach ($item->childs as $child) : ?>
                                <li>
                                    <a href="<?php echo $child->url; ?>"><?php echo $child->title; ?></a>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="footer_menu_address">
                        <div class="address_item">
                            <div class="address_title">HOTLINNE</div>
                            <p class="mb-0">(+84) 988 888 888</p>
                        </div>
                        <div class="d-flex address_box">
                            <div class="address_item">
                                <div class="address_title">ĐỊA CHỈ</div>
                                <p class="mb-0">79 Nguyễn Du, Hai Bà Trưng,
                                    Hà Nội</p>
                            </div>
                            <div class="address_item">
                                <div class="address_title">EMAIL</div>
                                <p class="mb-0">theseasons.authentic@gmail.com</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="d-flex footer_right">
                        <img src="<?php echo STORE_ASSETS_URL . 'images/logo_footer.png' ?>" alt="">
                        <img class="dark_logo" src="<?php echo STORE_ASSETS_URL . 'images/logo_footer_white.png' ?>" alt="">
                        <ul class="footer_socials">
                            <li>
                                <a href="">
                                    <img src="<?php echo STORE_ASSETS_URL . 'images/facebook.png' ?>" alt="facebook" loading="lazy">
                                </a>
                            </li>
                            <li>
                                <a href="">
                                    <img src="<?php echo STORE_ASSETS_URL . 'images/instagram.png' ?>" alt="instagram" loading="lazy">
                                </a>
                            </li>
                            <li>
                                <a href="">
                                    <img src="<?php echo STORE_ASSETS_URL . 'images/youtube.png' ?>" alt="youtube" loading="lazy">
                                </a>
                            </li>
                            <li>
                                <a href="">
                                    <img src="<?php echo STORE_ASSETS_URL . 'images/tiktok.png' ?>" alt="tiktok" loading="lazy">
                                </a>
                            </li>
                        </ul>
                        <div class="image_map">
                            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15284.630413391676!2d105.84691258610745!3d21.020333906311116!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3135ab9018e829cb%3A0xb8a860b1838d56e5!2zNzkgUC4gTmd1eeG7hW4gRHUsIE5ndXnhu4VuIER1LCBIYWkgQsOgIFRyxrBuZywgSMOgIE7hu5lpLCBWaeG7h3QgTmFt!5e0!3m2!1svi!2sus!4v1728460017812!5m2!1svi!2sus" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</footer>
</div>

<?php wp_footer(); ?>

</body>
</html>
