<?php
global $product;

$post_thumbnail_id = $product->get_image_id();
$image             = wp_get_attachment_image($post_thumbnail_id , 'full');
$price = $product->get_regular_price();
$sale = '';
if($product->get_sale_price()){
    $sale = round(($price - $product->get_sale_price()) / $price , 2) * 100;
}

$brands = wp_get_post_terms( $product->get_id(), 'pwb-brand' );
$_brand = '';
if ( !empty($brands) && !is_wp_error($brands) ) {
    foreach ( $brands as $brand ) {
        $_brand .= $_brand == '' ? $brand->name : ', ' . $brand->name;
    }
}

$sku = '';
if($product->get_type() == 'variable'){
    $variations = $product->get_available_variations();
    if(count($variations) > 0){
        $sku = $variations[0]['sku'];
    }
}else{
    $sku = $product->get_sku();
}
$chart = new ChartInterface(get_the_ID());

$chart->ethan_get_sizes();
$colums = array();
$rows = array();
if(!empty($chart->data)){
    $colums = $chart->data['columns'];
    $rows = $chart->data['rows'];
}
?>
<div class="modal-product" id="compare_product">
    <div class="modal-wrapper">
        <div class="modal-title align-items-center d-flex justify-content-between">
            <div class="title_text">
                So sánh sản phẩm
            </div>
            <svg class="close_modal" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M18.7071 5.29289C19.0976 5.68342 19.0976 6.31658 18.7071 6.70711L6.70711 18.7071C6.31658 19.0976 5.68342 19.0976 5.29289 18.7071C4.90237 18.3166 4.90237 17.6834 5.29289 17.2929L17.2929 5.29289C17.6834 4.90237 18.3166 4.90237 18.7071 5.29289Z" fill="#111111"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.29289 5.29289C5.68342 4.90237 6.31658 4.90237 6.70711 5.29289L18.7071 17.2929C19.0976 17.6834 19.0976 18.3166 18.7071 18.7071C18.3166 19.0976 17.6834 19.0976 17.2929 18.7071L5.29289 6.70711C4.90237 6.31658 4.90237 5.68342 5.29289 5.29289Z" fill="#111111"/>
            </svg>
        </div>
        <div class="modal-content">
            <div class="compare">
                <div class="item_compare item_left">
                    <div class="current_product d-flex">
                        <div class="product_image">
                            <?php echo $image; ?>
                        </div>
                        <div class="product_infomation">
                            <div class="before_brand">
                                <?php echo $sku; ?>
                            </div>
                            <div class="brands">
                                <?php echo $_brand; ?>
                            </div>
                            <div class="product_name">
                                <?php echo $product->get_name(); ?>
                            </div>
                            <div class="product_price">
                                <p class="price">
                                    <?php echo $product->get_price_html(); ?>
                                    <?php if($sale) : ?>
                                    <span class="pr-sale__pd">-<?php echo $sale; ?>%</span>
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="product_size_chart">
                        <table class="table table_size">
                            <thead>
                            <tr>
                                <?php foreach ($colums as $k => $cl) : ?>
                                    <th class="<?php echo $k > 0 ? 'text-center' : ''; ?>"><?php echo $cl; ?></th>
                                <?php endforeach; ?>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($rows as $r) : ?>
                                <tr>
                                    <?php foreach ($colums as $k => $cl) : ?>
                                        <td class="<?php echo $k > 0 ? 'text-center' : ''; ?>"><?php echo $r[$k]; ?></td>
                                    <?php endforeach; ?>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="faq_item">
                        <div class="question collapsed" data-bs-toggle="collapse" data-bs-target="#left_desc" aria-expanded="false" aria-controls="left_desc">
                            <div class="label">
                                Mô tả sản phẩm
                            </div>
                            <div class="faq_icon">
                                <svg class="icon_plus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.33301C16.7363 5.33301 17.3333 5.92996 17.3333 6.66634V25.333C17.3333 26.0694 16.7363 26.6663 16 26.6663C15.2636 26.6663 14.6666 26.0694 14.6666 25.333V6.66634C14.6666 5.92996 15.2636 5.33301 16 5.33301Z" fill="#111111"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                                </svg>
                                <svg class="icon_minius" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                                </svg>
                            </div>
                        </div>
                        <div class="answer collapse" id="left_desc">
                            <p class="mb-0 mt-4">
                                <?php the_content(); ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="item_compare">
                    <div class="current_product d-flex">
                        <div class="product_image">
                            <?php echo $image; ?>
                        </div>
                        <div class="other_product">
                            <div class="product_infomation">
                                <div class="before_brand">
                                    1AB4ZO
                                </div>
                                <div class="brands">
                                    Louis Vuitton
                                </div>
                                <div class="product_name">
                                    Made To Order Tools Embroidered Multi-Button Single-Breasted Jacket
                                </div>
                                <div class="product_price">
                                    <p class="price">
                                        16,880,000
                                    </p>
                                </div>
                            </div>
                            <div class="d-none group_btn_compare d-md-flex">
                                <a href="" class="choose_other" id="choose_other">
                                    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2896_2498)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M11.1667 9.33366C11.1667 8.96547 11.4652 8.66699 11.8334 8.66699H15.8334C16.2016 8.66699 16.5001 8.96547 16.5001 9.33366V13.3337C16.5001 13.7018 16.2016 14.0003 15.8334 14.0003C15.4652 14.0003 15.1667 13.7018 15.1667 13.3337V10.0003H11.8334C11.4652 10.0003 11.1667 9.70185 11.1667 9.33366Z" fill="#111111"/>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M1.16667 2C1.53486 2 1.83333 2.29848 1.83333 2.66667V6H5.16667C5.53486 6 5.83333 6.29848 5.83333 6.66667C5.83333 7.03486 5.53486 7.33333 5.16667 7.33333H1.16667C0.798477 7.33333 0.5 7.03486 0.5 6.66667V2.66667C0.5 2.29848 0.798477 2 1.16667 2Z" fill="black"/>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M6.6513 1.59749C7.73311 1.28457 8.87655 1.2508 9.97493 1.49933C11.0733 1.74785 12.0908 2.27057 12.9326 3.0187C13.7743 3.76684 14.4128 4.71601 14.7885 5.77765C14.9113 6.12475 14.7295 6.5057 14.3824 6.62853C14.0353 6.75135 13.6544 6.56955 13.5315 6.22245C13.231 5.37314 12.7202 4.6138 12.0468 4.01529C11.3734 3.41678 10.5594 2.99861 9.68069 2.79979C8.80198 2.60097 7.88723 2.62798 7.02178 2.87831C6.15634 3.12864 5.36841 3.59413 4.73152 4.23134C4.7266 4.23626 4.7216 4.24112 4.71652 4.24589L1.62319 7.15255C1.35487 7.40468 0.932961 7.39155 0.680833 7.12324C0.428706 6.85492 0.441831 6.43301 0.710151 6.18088L3.79607 3.28118C4.59084 2.48856 5.57293 1.9094 6.6513 1.59749ZM16.3192 8.87687C16.5713 9.14519 16.5582 9.56709 16.2899 9.81922L13.2039 12.7189C12.4092 13.5115 11.4271 14.0907 10.3487 14.4026C9.2669 14.7155 8.12346 14.7493 7.02507 14.5008C5.92668 14.2523 4.90915 13.7295 4.06743 12.9814C3.2257 12.2333 2.5872 11.2841 2.21152 10.2224C2.0887 9.87535 2.27051 9.4944 2.6176 9.37157C2.9647 9.24875 3.34565 9.43055 3.46848 9.77765C3.76902 10.627 4.27982 11.3863 4.9532 11.9848C5.62658 12.5833 6.44061 13.0015 7.31932 13.2003C8.19802 13.3991 9.11278 13.3721 9.97822 13.1218C10.8437 12.8715 11.6316 12.406 12.2685 11.7688C12.2714 11.7658 12.2744 11.7629 12.2774 11.76C12.2794 11.758 12.2815 11.7561 12.2835 11.7542L15.3768 8.84755C15.6451 8.59542 16.067 8.60855 16.3192 8.87687Z" fill="black"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2896_2498">
                                                <rect width="16" height="16" fill="white" transform="translate(0.5)"/>
                                            </clipPath>
                                        </defs>
                                    </svg><?php _e('Chọn sản phẩm khác'); ?>
                                </a>
                                <a href="<?php echo get_permalink(); ?>" class="view_products">
                                    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2896_6989)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M1.92716 8C2.00002 8.12591 2.09662 8.28637 2.21628 8.47165C2.52362 8.94754 2.97878 9.5804 3.56969 10.2107C4.76368 11.4843 6.433 12.6667 8.5 12.6667C10.567 12.6667 12.2363 11.4843 13.4303 10.2107C14.0212 9.5804 14.4764 8.94754 14.7837 8.47165C14.9034 8.28637 15 8.12591 15.0728 8C15 7.87409 14.9034 7.71363 14.7837 7.52835C14.4764 7.05246 14.0212 6.4196 13.4303 5.78929C12.2363 4.51571 10.567 3.33333 8.5 3.33333C6.433 3.33333 4.76368 4.51571 3.56969 5.78929C2.97878 6.4196 2.52362 7.05246 2.21628 7.52835C2.09662 7.71363 2.00002 7.87409 1.92716 8ZM15.8333 8C16.4296 7.70186 16.4295 7.70163 16.4294 7.70139L16.4283 7.69925L16.426 7.69469L16.4184 7.67988C16.4121 7.66752 16.4031 7.65021 16.3915 7.62829C16.3683 7.58447 16.3347 7.52215 16.2907 7.44399C16.2028 7.28776 16.0734 7.06768 15.9038 6.80498C15.5653 6.28088 15.0621 5.5804 14.403 4.87737C13.097 3.48429 11.0997 2 8.5 2C5.90033 2 3.90299 3.48429 2.59698 4.87737C1.93789 5.5804 1.43471 6.28088 1.09622 6.80498C0.926567 7.06768 0.797195 7.28776 0.709314 7.44399C0.665349 7.52215 0.631693 7.58447 0.608502 7.62829C0.596904 7.65021 0.587917 7.66752 0.581559 7.67988L0.573993 7.69469L0.571693 7.69925L0.570913 7.7008C0.570791 7.70104 0.570382 7.70186 1.16667 8L0.570382 7.70186C0.476539 7.88954 0.476539 8.11046 0.570382 8.29814L1.16667 8C0.570382 8.29814 0.570259 8.2979 0.570382 8.29814L0.571693 8.30075L0.573993 8.30531L0.581559 8.32012C0.587917 8.33248 0.596904 8.34979 0.608502 8.37171C0.631693 8.41553 0.665349 8.47785 0.709314 8.55601C0.797195 8.71224 0.926567 8.93232 1.09622 9.19502C1.43471 9.71913 1.93789 10.4196 2.59698 11.1226C3.90299 12.5157 5.90033 14 8.5 14C11.0997 14 13.097 12.5157 14.403 11.1226C15.0621 10.4196 15.5653 9.71913 15.9038 9.19502C16.0734 8.93232 16.2028 8.71224 16.2907 8.55601C16.3347 8.47785 16.3683 8.41553 16.3915 8.37171C16.4031 8.34979 16.4121 8.33248 16.4184 8.32012L16.426 8.30531L16.4283 8.30075L16.4291 8.2992C16.4292 8.29896 16.4296 8.29814 15.8333 8ZM15.8333 8L16.4296 8.29814C16.5235 8.11046 16.5232 7.88907 16.4294 7.70139L15.8333 8Z" fill="#111111"/>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49992 6.66634C7.76354 6.66634 7.16659 7.26329 7.16659 7.99967C7.16659 8.73605 7.76354 9.33301 8.49992 9.33301C9.2363 9.33301 9.83325 8.73605 9.83325 7.99967C9.83325 7.26329 9.2363 6.66634 8.49992 6.66634ZM5.83325 7.99967C5.83325 6.52692 7.02716 5.33301 8.49992 5.33301C9.97268 5.33301 11.1666 6.52692 11.1666 7.99967C11.1666 9.47243 9.97268 10.6663 8.49992 10.6663C7.02716 10.6663 5.83325 9.47243 5.83325 7.99967Z" fill="black"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2896_6989">
                                                <rect width="16" height="16" fill="white" transform="translate(0.5)"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                    <?php _e('Xem chi tiết sản phẩm'); ?>
                                </a>
                            </div>
                        </div>
                        <div class="d-flex group_btn_compare d-md-none">
                            <a href="" class="choose_other">
                                <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_2896_2498)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M11.1667 9.33366C11.1667 8.96547 11.4652 8.66699 11.8334 8.66699H15.8334C16.2016 8.66699 16.5001 8.96547 16.5001 9.33366V13.3337C16.5001 13.7018 16.2016 14.0003 15.8334 14.0003C15.4652 14.0003 15.1667 13.7018 15.1667 13.3337V10.0003H11.8334C11.4652 10.0003 11.1667 9.70185 11.1667 9.33366Z" fill="#111111"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M1.16667 2C1.53486 2 1.83333 2.29848 1.83333 2.66667V6H5.16667C5.53486 6 5.83333 6.29848 5.83333 6.66667C5.83333 7.03486 5.53486 7.33333 5.16667 7.33333H1.16667C0.798477 7.33333 0.5 7.03486 0.5 6.66667V2.66667C0.5 2.29848 0.798477 2 1.16667 2Z" fill="black"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M6.6513 1.59749C7.73311 1.28457 8.87655 1.2508 9.97493 1.49933C11.0733 1.74785 12.0908 2.27057 12.9326 3.0187C13.7743 3.76684 14.4128 4.71601 14.7885 5.77765C14.9113 6.12475 14.7295 6.5057 14.3824 6.62853C14.0353 6.75135 13.6544 6.56955 13.5315 6.22245C13.231 5.37314 12.7202 4.6138 12.0468 4.01529C11.3734 3.41678 10.5594 2.99861 9.68069 2.79979C8.80198 2.60097 7.88723 2.62798 7.02178 2.87831C6.15634 3.12864 5.36841 3.59413 4.73152 4.23134C4.7266 4.23626 4.7216 4.24112 4.71652 4.24589L1.62319 7.15255C1.35487 7.40468 0.932961 7.39155 0.680833 7.12324C0.428706 6.85492 0.441831 6.43301 0.710151 6.18088L3.79607 3.28118C4.59084 2.48856 5.57293 1.9094 6.6513 1.59749ZM16.3192 8.87687C16.5713 9.14519 16.5582 9.56709 16.2899 9.81922L13.2039 12.7189C12.4092 13.5115 11.4271 14.0907 10.3487 14.4026C9.2669 14.7155 8.12346 14.7493 7.02507 14.5008C5.92668 14.2523 4.90915 13.7295 4.06743 12.9814C3.2257 12.2333 2.5872 11.2841 2.21152 10.2224C2.0887 9.87535 2.27051 9.4944 2.6176 9.37157C2.9647 9.24875 3.34565 9.43055 3.46848 9.77765C3.76902 10.627 4.27982 11.3863 4.9532 11.9848C5.62658 12.5833 6.44061 13.0015 7.31932 13.2003C8.19802 13.3991 9.11278 13.3721 9.97822 13.1218C10.8437 12.8715 11.6316 12.406 12.2685 11.7688C12.2714 11.7658 12.2744 11.7629 12.2774 11.76C12.2794 11.758 12.2815 11.7561 12.2835 11.7542L15.3768 8.84755C15.6451 8.59542 16.067 8.60855 16.3192 8.87687Z" fill="black"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_2896_2498">
                                            <rect width="16" height="16" fill="white" transform="translate(0.5)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                                <?php _e('Chọn sản phẩm khác'); ?>
                            </a>
                            <a href="<?php echo get_permalink(); ?>" class="view_products">
                                <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_2896_6989)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M1.92716 8C2.00002 8.12591 2.09662 8.28637 2.21628 8.47165C2.52362 8.94754 2.97878 9.5804 3.56969 10.2107C4.76368 11.4843 6.433 12.6667 8.5 12.6667C10.567 12.6667 12.2363 11.4843 13.4303 10.2107C14.0212 9.5804 14.4764 8.94754 14.7837 8.47165C14.9034 8.28637 15 8.12591 15.0728 8C15 7.87409 14.9034 7.71363 14.7837 7.52835C14.4764 7.05246 14.0212 6.4196 13.4303 5.78929C12.2363 4.51571 10.567 3.33333 8.5 3.33333C6.433 3.33333 4.76368 4.51571 3.56969 5.78929C2.97878 6.4196 2.52362 7.05246 2.21628 7.52835C2.09662 7.71363 2.00002 7.87409 1.92716 8ZM15.8333 8C16.4296 7.70186 16.4295 7.70163 16.4294 7.70139L16.4283 7.69925L16.426 7.69469L16.4184 7.67988C16.4121 7.66752 16.4031 7.65021 16.3915 7.62829C16.3683 7.58447 16.3347 7.52215 16.2907 7.44399C16.2028 7.28776 16.0734 7.06768 15.9038 6.80498C15.5653 6.28088 15.0621 5.5804 14.403 4.87737C13.097 3.48429 11.0997 2 8.5 2C5.90033 2 3.90299 3.48429 2.59698 4.87737C1.93789 5.5804 1.43471 6.28088 1.09622 6.80498C0.926567 7.06768 0.797195 7.28776 0.709314 7.44399C0.665349 7.52215 0.631693 7.58447 0.608502 7.62829C0.596904 7.65021 0.587917 7.66752 0.581559 7.67988L0.573993 7.69469L0.571693 7.69925L0.570913 7.7008C0.570791 7.70104 0.570382 7.70186 1.16667 8L0.570382 7.70186C0.476539 7.88954 0.476539 8.11046 0.570382 8.29814L1.16667 8C0.570382 8.29814 0.570259 8.2979 0.570382 8.29814L0.571693 8.30075L0.573993 8.30531L0.581559 8.32012C0.587917 8.33248 0.596904 8.34979 0.608502 8.37171C0.631693 8.41553 0.665349 8.47785 0.709314 8.55601C0.797195 8.71224 0.926567 8.93232 1.09622 9.19502C1.43471 9.71913 1.93789 10.4196 2.59698 11.1226C3.90299 12.5157 5.90033 14 8.5 14C11.0997 14 13.097 12.5157 14.403 11.1226C15.0621 10.4196 15.5653 9.71913 15.9038 9.19502C16.0734 8.93232 16.2028 8.71224 16.2907 8.55601C16.3347 8.47785 16.3683 8.41553 16.3915 8.37171C16.4031 8.34979 16.4121 8.33248 16.4184 8.32012L16.426 8.30531L16.4283 8.30075L16.4291 8.2992C16.4292 8.29896 16.4296 8.29814 15.8333 8ZM15.8333 8L16.4296 8.29814C16.5235 8.11046 16.5232 7.88907 16.4294 7.70139L15.8333 8Z" fill="#111111"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M8.49992 6.66634C7.76354 6.66634 7.16659 7.26329 7.16659 7.99967C7.16659 8.73605 7.76354 9.33301 8.49992 9.33301C9.2363 9.33301 9.83325 8.73605 9.83325 7.99967C9.83325 7.26329 9.2363 6.66634 8.49992 6.66634ZM5.83325 7.99967C5.83325 6.52692 7.02716 5.33301 8.49992 5.33301C9.97268 5.33301 11.1666 6.52692 11.1666 7.99967C11.1666 9.47243 9.97268 10.6663 8.49992 10.6663C7.02716 10.6663 5.83325 9.47243 5.83325 7.99967Z" fill="black"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_2896_6989">
                                            <rect width="16" height="16" fill="white" transform="translate(0.5)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                                <?php _e('Xem sản phẩm'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="product_size_chart">
                        <table id="table_right" class="table table_size">

                        </table>
                    </div>
                    <div class="faq_item">
                        <div class="question collapsed" data-bs-toggle="collapse" data-bs-target="#right_desc" aria-expanded="false" aria-controls="right_desc">
                            <div class="label">
                                Mô tả sản phẩm
                            </div>
                            <div class="faq_icon">
                                <svg class="icon_plus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.33301C16.7363 5.33301 17.3333 5.92996 17.3333 6.66634V25.333C17.3333 26.0694 16.7363 26.6663 16 26.6663C15.2636 26.6663 14.6666 26.0694 14.6666 25.333V6.66634C14.6666 5.92996 15.2636 5.33301 16 5.33301Z" fill="#111111"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                                </svg>
                                <svg class="icon_minius" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                                </svg>
                            </div>
                        </div>
                        <div class="answer collapse" id="right_desc">
                            <p class="mb-0 mt-4">
                                <?php the_content(); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
</div>

