<?php
/**
 * Loop Price
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/price.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

$colors = $terms = wp_get_post_terms( $product->get_id(), 'pa_mau-sac' );


?>

<?php if ( $price_html = $product->get_price_html() ) : ?>
    <div class="d-flex justify-content-between">
        <span class="price"><?php echo $price_html; ?>
            <?php if($product->is_on_sale()) :
                $price = $product->get_regular_price();
                $sale = round((floatval($price) - floatval($product->get_sale_price())) / $price , 2) * 100;
                ?>
                <span class="pr-sale__pd d-md-inline">-<?php echo $sale; ?>%</span>
            <?php endif; ?>
	    </span>
        <?php if(!is_wp_error($colors)):
        ?>
        <ul class="product_color">
            <?php foreach ($colors as $term):
                $color = get_term_meta($term->term_id , 'color_term' , true);
                ?>
                <li style="background-color: <?php echo $color ? $color : '#000'; ?>"></li>
            <?php endforeach; ?>
        </ul>
        <?php
        endif; ?>
    </div>
<?php endif; ?>


