<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}

?>

<div id="popupct" class="popup-overlay_checkout">
  <div class="popup-content">
       <span class="fi-icon"></span>
       <h2>Đặt hàng thành công</h2>
       <p>Đơn hàng của bạn đã được ghi nhận thành công.</p>
       <p>Chúng tôi sẽ liên hệ với bạn để xác nhận đơn hàng trong thời gian sớm nhất.</p>

       <div class="popup-bottom">
	  		<a href="<?php echo home_url(); ?>" class="button_action_popup">Quay lại trang chủ</a>
	  </div>
  </div>
</div>

<div class="checkout-container container-fluid">
	<div class="row">
		<div class="col-lg-6 col-sm-12 col-12 checkout-container__sp ">
			<h3>Chi tiết giỏ hàng</h3>
			<p>Quý khách vui lòng kiểm tra lại các sản phẩm trong giỏ hàng trước khi tiến hành đặt hàng.</p>
			<?php echo do_shortcode('[woocommerce_cart]'); ?>
		</div>
		<div class="col-lg-6 col-sm-12 col-12 checkout-container__tt">
			<div class="container__header">
				<h3>Thông tin mua hàng</h3>
				<p>Quý khách vui lòng để lại thông tin và chúng tôi sẽ liên hệ trực tiếp để xác nhận đơn hàng.</p>
			</div>
			<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

				<?php if ( $checkout->get_checkout_fields() ) : ?>

					<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

					<div class="" id="customer_details">
						<div class="">
							<?php do_action( 'woocommerce_checkout_billing' ); ?>
						</div>

						<div class="">
							<?php do_action( 'woocommerce_checkout_shipping' ); ?>
						</div>
					</div>

					<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

				<?php endif; ?>
				
				<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
				
				<div id="order_review" class="woocommerce-checkout-review-order">
					<?php do_action( 'woocommerce_checkout_order_review' ); ?>
				</div>

				<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

				<div class="two_button_action_ct">
					<p class="button_action_dh">
						<?php echo apply_filters( 'woocommerce_order_button_html', '<button type="submit" class="button alt' . esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ) . '" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '">' .'Đặt hàng'. '</button>' ); ?>
						<!-- Đặt hàng -->
					</p>
					<a class="d-none d-md-block button_action_ql">Quay lại mua sắm</a>
					<p class="button_action_ql-mobie">Quay lại</p>
				</div>

			</form>

		</div>
	</div>
</div>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
