<?php
$args_brand = array(
    'taxonomy'     => 'pwb-brand',
    'hierarchical' => 1,
    'hide_empty'   => 1,
    'number'       => 20,
);
$key = 0;

$brands = get_categories($args_brand);
$count_filter = get_query_var('count_filter', 0);
$order_by =  isset( $_REQUEST['orderby'] ) ? wc_clean( (string) wp_unslash( $_REQUEST['orderby'] ) ) : '';
$brand = isset( $_REQUEST['brand'] ) ?  $_REQUEST['brand']  : '';
$_brands = array();
if($brand){
    $_brands = explode(',',$brand);
}
$from = isset( $_REQUEST['price_from'] ) ? abs( $_REQUEST['price_from'] ) : 0;
$to = isset( $_REQUEST['price_to'] ) ? abs( $_REQUEST['price_to'] ) : 0;
$start = 10000;
$end = 500000000;
if($from && $to && $to > $from){
    $start = $from;
    $end = $to;
}
$size_terms = get_terms( array(
    'taxonomy' => 'pa_kich-thuoc',
    'hide_empty' => true,
) );
$color_terms = get_terms( array(
    'taxonomy' => 'pa_mau-sac',
    'hide_empty' => true,
) );
?>
<div class="modal-product filter-modal" id="filter">
    <div class="modal-wrapper">
        <div class="modal-title align-items-center d-flex justify-content-between">
            <div class="title_text">
                Bộ lọc
            </div>
            <div class="align-items-center d-flex justify-content-between">
                <div class="remove_filter">
                    <a href="">Xóa bộ lọc</a>
                </div>
                <svg class="close_modal" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M18.7071 5.29289C19.0976 5.68342 19.0976 6.31658 18.7071 6.70711L6.70711 18.7071C6.31658 19.0976 5.68342 19.0976 5.29289 18.7071C4.90237 18.3166 4.90237 17.6834 5.29289 17.2929L17.2929 5.29289C17.6834 4.90237 18.3166 4.90237 18.7071 5.29289Z" fill="#111111"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.29289 5.29289C5.68342 4.90237 6.31658 4.90237 6.70711 5.29289L18.7071 17.2929C19.0976 17.6834 19.0976 18.3166 18.7071 18.7071C18.3166 19.0976 17.6834 19.0976 17.2929 18.7071L5.29289 6.70711C4.90237 6.31658 4.90237 5.68342 5.29289 5.29289Z" fill="#111111"/>
                </svg>
            </div>

        </div>
        <div class="modal-content">
            <div class="filter_products">
                <div class="filter_item">
                    <div class="title_filter align-items-center d-flex justify-content-between" data-bs-toggle="collapse"
                         data-bs-target="#filter_orderby" aria-expanded="false" aria-controls="filter_orderby">
                        <div class="text">
                            Sắp xếp theo
                        </div>
                        <svg class="icon_plus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.33301C16.7363 5.33301 17.3333 5.92996 17.3333 6.66634V25.333C17.3333 26.0694 16.7363 26.6663 16 26.6663C15.2636 26.6663 14.6666 26.0694 14.6666 25.333V6.66634C14.6666 5.92996 15.2636 5.33301 16 5.33301Z" fill="#111111"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                        <svg class="icon_minius" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                    </div>
                    <div class="filter_field collapse show" id="filter_orderby">
                        <p class="mb-2 mt-2">
                            <input type="radio" <?php checked($order_by == 'date') ?> value="date" id="new_update" name="orderby">
                            <label for="new_update"> Mới cập nhật</label>
                        </p>
                        <p class="mb-2 mt-0">
                            <input id="price_desc" <?php checked($order_by == 'price_desc') ?> value="price_desc" type="radio" name="orderby">
                            <label for="price_desc"> Giá: Cao tới thấp</label>
                        </p>
                        <p class="mb-2 mt-0">
                            <input type="radio" <?php checked($order_by == 'price_asc') ?> value="price_asc" id="price_asc" name="orderby">
                            <label for="price_asc"> Giá: Thấp tới cao</label>
                        </p>
                    </div>
                </div>
                <div class="filter_item">
                    <div class="title_filter align-items-center d-flex justify-content-between collapsed" data-bs-toggle="collapse"
                         data-bs-target="#filter_brand" aria-expanded="false" aria-controls="filter_brand">
                        <div class="text">
                            Thương hiệu
                        </div>
                        <svg class="icon_plus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.33301C16.7363 5.33301 17.3333 5.92996 17.3333 6.66634V25.333C17.3333 26.0694 16.7363 26.6663 16 26.6663C15.2636 26.6663 14.6666 26.0694 14.6666 25.333V6.66634C14.6666 5.92996 15.2636 5.33301 16 5.33301Z" fill="#111111"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                        <svg class="icon_minius" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                    </div>
                    <div class="filter_field collapse" id="filter_brand">
                        <?php $key = 0; foreach ($brands as $key => $category) : ?>
                            <p class="mb-2 mt-<?php echo $key == 0 ? '2' : '0'; ?>">
                                <input type="checkbox" <?php checked(in_array($category->term_id , $_brands)); ?> value="<?php echo $category->term_id; ?>" id="category_<?php echo $category->term_id; ?>" name="brand">
                                <label for="category_<?php echo $category->term_id; ?>"><?php echo $category->name; ?></label>
                            </p>
                        <?php $key++; endforeach; ?>
                    </div>
                </div>
                <div class="filter_item">
                    <div class="title_filter align-items-center d-flex justify-content-between collapsed" data-bs-toggle="collapse"
                         data-bs-target="#filter_price" aria-expanded="false" aria-controls="filter_price">
                        <div class="text">
                            Khoảng giá
                        </div>
                        <svg class="icon_plus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.33301C16.7363 5.33301 17.3333 5.92996 17.3333 6.66634V25.333C17.3333 26.0694 16.7363 26.6663 16 26.6663C15.2636 26.6663 14.6666 26.0694 14.6666 25.333V6.66634C14.6666 5.92996 15.2636 5.33301 16 5.33301Z" fill="#111111"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                        <svg class="icon_minius" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                    </div>
                    <div class="filter_field collapse" id="filter_price">
                        <p class="mb-2 mt-<?php echo $key == 0 ? '2' : '0'; ?>">
                            <div class="slider-value">
                                <span id="rangeMin">10000</span><span id="rangeMax">100000</span>
                            </div>
                            <div id="slider-range" data-start="<?php echo $start; ?>" data-end="<?php echo $end; ?>"></div>

                        </p>
                    </div>
                </div>
                <div class="filter_item">
                    <div class="title_filter align-items-center d-flex justify-content-between collapsed" data-bs-toggle="collapse"
                         data-bs-target="#filter_price" aria-expanded="false" aria-controls="filter_price">
                        <div class="text">
                            Màu sắc
                        </div>
                        <svg class="icon_plus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.33301C16.7363 5.33301 17.3333 5.92996 17.3333 6.66634V25.333C17.3333 26.0694 16.7363 26.6663 16 26.6663C15.2636 26.6663 14.6666 26.0694 14.6666 25.333V6.66634C14.6666 5.92996 15.2636 5.33301 16 5.33301Z" fill="#111111"/>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                        <svg class="icon_minius" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                        </svg>
                    </div>
                    <div class="filter_field collapse" id="filter_price">
                        <ul class="list_color">
                            <?php foreach ($color_terms as $term) :
                                $color = get_term_meta($term->term_id , 'color_term' , true);
                                ?>
                                <li class="color_filter" data-value="<?php echo $term->slug; ?>">
                                    <div class="item_color" style="background-color: <?php echo $color ? $color : '#000000'; ?>"></div>
                                    <div class="color_name"><?php echo $term->name ?></div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <?php if(!is_wp_error($size_terms)) : ?>
                    <div class="filter_item">
                        <div class="title_filter align-items-center d-flex justify-content-between collapsed" data-bs-toggle="collapse"
                             data-bs-target="#filter_price" aria-expanded="false" aria-controls="filter_price">
                            <div class="text">
                                Kích cỡ
                            </div>
                            <svg class="icon_plus" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M16 5.33301C16.7363 5.33301 17.3333 5.92996 17.3333 6.66634V25.333C17.3333 26.0694 16.7363 26.6663 16 26.6663C15.2636 26.6663 14.6666 26.0694 14.6666 25.333V6.66634C14.6666 5.92996 15.2636 5.33301 16 5.33301Z" fill="#111111"/>
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                            </svg>
                            <svg class="icon_minius" width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33337 16.0003C5.33337 15.2639 5.93033 14.667 6.66671 14.667H25.3334C26.0698 14.667 26.6667 15.2639 26.6667 16.0003C26.6667 16.7367 26.0698 17.3337 25.3334 17.3337H6.66671C5.93033 17.3337 5.33337 16.7367 5.33337 16.0003Z" fill="#111111"/>
                            </svg>
                        </div>
                        <div class="filter_field collapse" id="filter_price">
                            <ul class="list_size">
                                <?php foreach ($size_terms as $term) : ?>
                                <li class="size_filter" data-value="<?php echo $term->slug; ?>"><?php echo $term->name ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="filter_submit">
                    <a href="#" id="filter_product" class="btn btn_submit">Hiển thị sản phẩm</a>
                </div>
            </div>
        </div>
    </div>
</div>
