<?php
/**
 * Template part for displaying new post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package storeethan
 */
defined( 'ABSPATH' ) || exit;
$image = 'post1.png';
$args = array(
    'post_type'      => 'post',
    'posts_per_page' => 4,
    'orderby'        => 'date',
    'order'          => 'DESC'
);

$query = new WP_Query( $args );
?>
<section class="newest_post">
    <div class="container-fluid">
        <h4 class="section_title">
            <?php _e('Bài viết mới nhất' , 'storeethan'); ?>
        </h4>
        <div class="list_post">
            <div class="row">
                <?php if ( $query->have_posts() ) :
                while ( $query->have_posts() ) {
                    $query->the_post();
                    ?>
                    <div class="col-lg-3 col-md-3 col-sm-4 col-12 mb-4 post">
                        <?php ethan_get_template( 'global/card_post' , array()); ?>
                    </div>
                    <?php
                }
                wp_reset_postdata(); // Đặt lại dữ liệu bài viết
                endif;
                ?>
            </div>

            <div class="d-flex justify-content-center after_list_post">
                <a href="/bai-viet" id="all_post" class="btn btn_see_all">
                    <?php _e('Xem tất cả bài viết' , 'storeethan') ?>
                </a>
            </div>
        </div>
    </div>
</section>
