<?php
function ethan_get_categories($args)
{
    $all_categories = get_categories( $args );
    return $all_categories;
}

function ethan_get_url_placeholder_image(){
    return STORE_ASSETS_URL . 'images/placeholder.png';
}

function ethan_get_product_by_category($category_id)
{
    $products = get_posts(
        array(
            'post_type' => 'product',
            'tax_query' => [
                [
                    'taxonomy' => 'product_cat',
                    'field'    => 'term_id',
                    'terms' => [$category_id],
                    'operator'  => 'IN',
                    'include_children' => false
                ],
            ],
            'numberposts' => 8
        )
    );
    return $products;
}
function getMasterFromList($_products , $product)
{
    $index = false;
    foreach($_products as $key => $pro){
        if($pro['nameMaster'] == $product['name']){
            $index = $key;
            break;
        }
    }
    return $index;
}

function removeAccents($str) {
    $accents = array(
        'á', 'à', 'ả', 'ã', 'ạ', 'â', 'ấ', 'ầ', 'ẩ', 'ẫ', 'ậ', 'ă', 'ắ', 'ằ', 'ẳ', 'ẵ', 'ặ',
        'Á', 'À', 'Ả', 'Ã', 'Ạ', 'Â', 'Ấ', 'Ầ', 'Ẩ', 'Ẫ', 'Ậ', 'Ă', 'Ắ', 'Ằ', 'Ẳ', 'Ẵ', 'Ặ',
        'é', 'è', 'ẻ', 'ẽ', 'ẹ', 'ê', 'ế', 'ề', 'ể', 'ễ', 'ệ',
        'É', 'È', 'Ẻ', 'Ẽ', 'Ẹ', 'Ê', 'Ế', 'Ề', 'Ể', 'Ễ', 'Ệ',
        'í', 'ì', 'ỉ', 'ĩ', 'ị',
        'Í', 'Ì', 'Ỉ', 'Ĩ', 'Ị',
        'ó', 'ò', 'ỏ', 'õ', 'ọ', 'ô', 'ố', 'ồ', 'ổ', 'ỗ', 'ộ', 'ơ', 'ớ', 'ờ', 'ở', 'ỡ', 'ợ',
        'Ó', 'Ò', 'Ỏ', 'Õ', 'Ọ', 'Ô', 'Ố', 'Ồ', 'Ổ', 'Ỗ', 'Ộ', 'Ơ', 'Ớ', 'Ờ', 'Ở', 'Ỡ', 'Ợ',
        'ú', 'ù', 'ủ', 'ũ', 'ụ', 'ư', 'ứ', 'ừ', 'ử', 'ữ', 'ự',
        'Ú', 'Ù', 'Ủ', 'Ũ', 'Ụ', 'Ư', 'Ứ', 'Ừ', 'Ử', 'Ữ', 'Ự',
        'ý', 'ỳ', 'ỷ', 'ỹ', 'ỵ',
        'Ý', 'Ỳ', 'Ỷ', 'Ỹ', 'Ỵ',
        'đ', 'Đ'
    );

    // Mảng các ký tự thay thế tương ứng
    $no_accents = array(
        'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a',
        'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A',
        'e', 'e', 'e', 'e', 'e', 'e', 'e', 'e', 'e', 'e', 'e',
        'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E',
        'i', 'i', 'i', 'i', 'i',
        'I', 'I', 'I', 'I', 'I',
        'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o', 'o',
        'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O', 'O',
        'u', 'u', 'u', 'u', 'u', 'u', 'u', 'u', 'u', 'u', 'u',
        'U', 'U', 'U', 'U', 'U', 'U', 'U', 'U', 'U', 'U', 'U',
        'y', 'y', 'y', 'y', 'y',
        'Y', 'Y', 'Y', 'Y', 'Y',
        'd', 'D'
    );

    // Thay thế các ký tự có dấu bằng ký tự không dấu
    $str = str_replace($accents, $no_accents, $str);

    // Loại bỏ các ký tự không phải chữ cái, số và khoảng trắng
    $str = preg_replace('/[^A-Za-z0-9 ]/', '', $str);

    return $str;
}

function addOrdinalSuffix($day) {
    if (!in_array(($day % 100), array(11, 12, 13))) {
        switch ($day % 10) {
            case 1: return $day . 'st';
            case 2: return $day . 'nd';
            case 3: return $day . 'rd';
        }
    }
    return $day . 'th';
}

function ethan_get_item_by_key($arr , $key, $val){
    $flag = false;
    foreach ($arr as $k => $item){
        if($item->$key == $val){
            $flag = $k;
        }
    }
    return $flag;
}
add_filter('get_the_archive_title_prefix' , 'ethan_archive_title_prefix');
function ethan_archive_title_prefix($prefix)
{
    if(is_category()){
        $prefix = '';
    }
    return $prefix;
}

function getMenuItem(){
    $location = 'menu-1'; // Vị trí menu 'primary' trong theme
    $locations = get_nav_menu_locations(); // Lấy danh sách tất cả các vị trí menu

    if (isset($locations[$location])) {
        $menu_id = $locations[$location];
        $menu_items = wp_get_nav_menu_items($menu_id);
        $items = array();
        foreach ($menu_items as $menu_item) {
            if($menu_item->menu_item_parent == 0){
                $items[] = $menu_item;
            }else{
                $index = ethan_get_item_by_key($items , 'ID' , $menu_item->menu_item_parent);
                if($index !== false){
                    if(isset($items[$index]->childs)){
                        $items[$index]->childs[] = $menu_item;
                    }else{
                        $items[$index]->childs = array($menu_item);
                    }
                }
            }
        }
        return $items;
    } else {
        return false;
    }
}

function ethan_get_related_post()
{
    $post_id = get_the_ID();

    $categories = wp_get_post_terms($post_id, 'category');

    if ($categories) {
        $category_ids = array();

        foreach ($categories as $category) {
            $category_ids[] = $category->term_id;
        }
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => 4, // Số lượng bài viết liên quan
            'post__not_in' => array($post_id), // Loại trừ bài viết hiện tại
            'category__in' => $category_ids, // Lấy bài viết từ các danh mục chung
        );

        $related_posts_query = new WP_Query($args);

        if ($related_posts_query->have_posts()) {
            ?>
                <div class="d-none d-md-block related_post">
                    <div class="container-fluid">
                        <h4><?php _e('Xem thêm các bài viết khác' , 'storeethan'); ?></h4>
                        <div class="row">
                            <?php
                            while ( $related_posts_query->have_posts() ) :
                                $related_posts_query->the_post();
                                global $post;
                                $post_id = get_the_ID();
                                $thumbnail_id = get_post_thumbnail_id($post_id);
                                $image_url = wp_get_attachment_image_src($thumbnail_id, 'full');
                                $url = '';
                                if ($image_url) {
                                    $url = $image_url[0];
                                }
                                $categories = get_the_category($post_id);
                                $cate = '';
                                foreach ($categories as $category) {
                                    $cate .= $cate == '' ? $category->name : ', ' . $category->name;
                                }
                                $datetime = new DateTime($post->post_date);
                                $day_with_suffix = addOrdinalSuffix($datetime->format('j'));
                                $d =  $datetime->format('M') . ' ' .$day_with_suffix . ', ' . $datetime->format('Y');
                                ?>
                                <div class="col-md-6 col-12 post">
                                    <a href="<?php echo get_permalink(); ?>">
                                        <div class="card_post">
                                            <img src="<?php echo $url; ?>" alt="Ảnh bài viết">
                                            <div class="props-of-post">
                                                <div class="type_post">
                                                    <?php echo $cate; ?>
                                                </div>
                                                <div class="name_post">
                                                    <?php the_title(); ?>
                                                </div>
                                                <div class="date_post">
                                                    <!--July 14th, 2024-->
                                                    <?php echo $d; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                            <?php endwhile; ?>
                        </div>
                    </div>
                </div>
            <?php
        }

        // Reset lại query sau khi sử dụng
        wp_reset_postdata();
    }
}

function search_by_title_only( $where, $wp_query ) {
    global $wpdb;

    if ( $wp_query->is_search() ) {
        // Tìm kiếm chỉ trong cột post_title
        $search = $wp_query->get( 's' );
        if ( !empty( $search ) ) {
            $where = str_replace(
                "AND (({$wpdb->posts}.post_title LIKE",
                "AND (({$wpdb->posts}.post_title LIKE '%" . esc_sql( $wpdb->esc_like( $search ) ) . "%'",
                $where
            );
        }
    }
    return $where;
}

function ethan_show_faq()
{
    return !is_singular('post') && !is_search();
}
class ChartInterface {
    public $data = array();

    public $id = 0;

    public function __construct($id)
    {
        $this->id = $id;
    }
    public function ethan_render_interface($element_id, $elements_by_id)
    {
        if(isset($elements_by_id[$element_id])){
            $element = $elements_by_id[$element_id];
            if($element['type'] == 'row'){
                foreach ( $element['children'] as $child_id ) {
                    $this->ethan_render_interface( $child_id, $elements_by_id );
                }
            }
            if($element['type'] == 'column'){
                foreach ( $element['children'] as $child_id ) {
                    $this->ethan_render_interface( $child_id, $elements_by_id );
                }
            }
            if($element['type'] == 'table'){
                $this->data = $element;
            }
        }
    }

    public function ethan_get_sizes()
    {
        $frontend = new PSCWF\Inc\Frontend\Front_End();
        list( $product_sc_mode, $size_chart_id ) = $frontend->pscw_helper_show_size_chart( $this->id, true );

        if ( isset( $size_chart_id[0] ) ) {
            $chart_id = $size_chart_id[0];
            $interface = get_post_meta( $chart_id, 'pscw_interface', true );

            if ( !empty( $interface ) ) {
                $layout = $interface['layout'];
                $sizes = array();
                foreach ( $layout['children'] as $child_id ) {
                    $this->ethan_render_interface( $child_id, $interface['elementsById'] );
                }
            }
        }
    }
}
