<?php
/**
 * Plugin Name:       Custom Arie van Esch for NBDesigner Advanced
 * Plugin URI:        https://cmsmart.net
 * Description:       Custom Arie van Esch for NBDesigner Advanced
 * Version:           1.0.1
 * Requires at least: 5.2
 * Requires PHP:      7.1
 * Author:            Hieu
 * Author URI:        https://cmsmart.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       custom_Arie_van_Esch
 * Domain Path:       /languages
 */

add_action( 'nbd_menu',  'nbdesigner_menu_swatches' );
function nbdesigner_menu_swatches(){
    if(current_user_can('manage_nbd_swatches')){
        add_submenu_page(
                'nbdesigner', esc_html__( 'Manager Swatches', 'web-to-print-online-designer' ), esc_html__( 'Swatches', 'web-to-print-online-designer' ), 'manage_nbd_swatches', 'nbdesigner_manager_swatches',  'nbdesigner_manager_swatches',2);
    }
}

add_filter( 'nbod_capabilties_variable_admin','nbdesigner_user_role_swatches');
function nbdesigner_user_role_swatches($capabilities){
    array_push($capabilities, 'manage_nbd_swatches');
    return $capabilities;
}

function nbdesigner_manager_swatches(){
    $nbd = new Nbdesigner_Plugin();
    $plugin_id    = 'nbdesigner';
    $path_swatches = NBDESIGNER_DATA_DIR . '/art_swatches.json';
    $swatches = NBDESIGNER_DATA_DIR . '/swatches.json';
    if(!file_exists($path_swatches) && !file_exists($swatches)){
        fopen($path_swatches, "a+");
        fopen($swatches, "a+");
    }
    $notice             = '';
    $art_id             = 0;
    $cat                = $nbd->nbdesigner_read_json_setting( $path_swatches );
    $list               = $nbd->nbdesigner_read_json_setting( $swatches );
    $update             = false;
    $current_art_cat_id = 0;
    $total              = sizeof($list);
    $limit              = 40;
    if ( is_array( $cat ) )
            $current_art_cat_id = sizeof( $cat );
    if ( isset( $_GET['id'] ) ) {
        $art_id = absint( $_GET['id'] );
        $update = true;
        if ( isset( $list[$art_id] ) ) {
            $art_data   = $list[$art_id];
            $cats       = $art_data->cat;
        }
    }
    $page           = filter_input( INPUT_GET, "p", FILTER_VALIDATE_INT );
    $current_cat    = filter_input( INPUT_GET, "cat_id", FILTER_VALIDATE_INT );
    if ( isset( $_POST[$plugin_id . '_hidden'] ) && wp_verify_nonce( $_POST[$plugin_id . '_hidden'], $plugin_id ) && current_user_can( 'edit_nbd_art' ) ) {
            $art        = array();
            $art['id']  = absint( $_POST['nbdesigner_swat_id'] );
            $art['cat'] = $cats;
            if ( isset( $_POST['nbdesigner_art_cat'] ) ) $art['cat'] = $_POST['nbdesigner_art_cat'];
            if ( isset( $_FILES['svg'] ) ) {
                $files = $_FILES['svg'];
                foreach ( $files['name'] as $key => $value ) {
                    $file = array(
                      'name'     => $files['name'][$key],
                      'type'     => $files['type'][$key],
                      'tmp_name' => $files['tmp_name'][$key],
                      'error'    => $files['error'][$key],
                      'size'     => $files['size'][$key]
                    );
                    $uploaded_file_name = sanitize_file_name( basename($file['name']) );
                    $exc = explode(".",$uploaded_file_name);
                    $allowed_file_types = array( 'csv' );
                    if ( Nbdesigner_IO::checkFileType( $uploaded_file_name, $allowed_file_types ) ) {
                        $upload_overrides   = array( 'test_form' => false );
                        $uploaded_file      = wp_handle_upload( $file, $upload_overrides );
                        if ( isset( $uploaded_file['url'] ) ) {
                            $new_path_art   = Nbdesigner_IO::create_file_path( NBDESIGNER_ART_DIR, $uploaded_file_name );
                            if($exc[1] == 'csv'){
                                $art['file']    = $uploaded_file['file'];
                                $line = array();
                                if ( !copy( $art['file'], $new_path_art['full_path'] ) ) {
                                    $notice = apply_filters( 'nbdesigner_notices', nbd_custom_notices( 'error', esc_html__( 'Failed to copy.', 'web-to-print-online-designer' ) ) );
                                }else{
                                    $handle = fopen($new_path_art['full_path'], "r");
                                    while (($data = fgetcsv($handle)) !== FALSE) {
                                        $art['color'] = $data;
                                        $art['name'] = $data[0];
                                        $art['search_color'] = $data[0].' '.$data[5].' '.$data[6].' '.$data[7].' '.$data[8];
                                        if ( $update ) {
                                            nbdesigner_update_list_swat( $art, $art_id );
                                        } else {
                                            nbdesigner_update_list_swat( $art );
                                        }
                                    }
                                }
                                $notice = apply_filters( 'nbdesigner_notices', nbd_custom_notices( 'success', esc_html__( 'Your art has been saved.', 'web-to-print-online-designer' ) ) );
                            }
                        } else {
                            $notice = apply_filters( 'nbdesigner_notices', nbd_custom_notices( 'error', sprintf( __( 'Error while upload art, please try again! <a target="_blank" href="%s">Force upload SVG</a>', 'web-to-print-online-designer' ), esc_url( admin_url( 'admin.php?page=nbdesigner&tab=general#nbdesigner_option_download_type' ) ) ) ) );
                        }
                    } else {
                        $notice = apply_filters('nbdesigner_notices', nbd_custom_notices('error', esc_html__( 'Incorrect file extensions.', 'web-to-print-online-designer' ) ) );
                    }
                }
            }
            $list   = $nbd->nbdesigner_read_json_setting( $swatches);
            $cats   = $art['cat'];
            $total  = sizeof( $list );
    }
    $current_cat_id     = 0;
    $name_current_cat   = 'uploaded';
    if( $total ){
        if( isset( $current_cat ) ){
            $current_cat_id = $current_cat;
            $new_list       = array();
            foreach( $list as $art ){
                if( in_array( (string)$current_cat, $art->cat ) ) $new_list[] = $art;
                if( ( $current_cat == 0 ) && sizeof( $art->cat ) == 0) $new_list[] = $art;
            }
            foreach( $cat as $c ){
                if( $c->id == $current_cat ){
                    $name_current_cat = $c->name;
                    break;
                }
                $name_current_cat = 'uploaded';
            }
            $list = $new_list;
            $total = sizeof( $list );
        }else{
            $name_current_cat = 'uploaded';
        }
        if( isset( $page ) ){
            $_tp = ceil( $total / $limit );
            if($page > $_tp) $page = $_tp;
            $_list = array_slice( $list, ( $page-1 ) * $limit, $limit );
        }else{
            $_list = $list;
            if($total > $limit) $_list = array_slice( $list, 0, $limit );
        }
    } else{
        $_list = array();
    }
    if( isset( $current_cat ) ){
        $url = add_query_arg( array( 'cat_id' => $current_cat ), admin_url( 'admin.php?page=nbdesigner_manager_swatches' ) );
    }else{
        $url = admin_url( 'admin.php?page=nbdesigner_manager_swatches' );
    }
    require_once NBDESIGNER_PLUGIN_DIR . 'includes/class.nbdesigner.pagination.php';
    $paging = new Nbdesigner_Pagination();
    $config = array(
        'current_page'  => isset( $page ) ? $page : 1,
        'total_record'  => $total,
        'limit'         => $limit,
        'link_full'     => $url.'&p={p}',
        'link_first'    => $url
    );
    $paging->init( $config );
    include_once( __dir__ . '/manager-swatches.php' );
}
function nbdesigner_update_list_swat($art, $id = null) {
    $nbd = new Nbdesigner_Plugin();
    $path = NBDESIGNER_DATA_DIR . '/swatches.json';
    if ( isset( $id ) ) {
        $nbd->nbdesigner_update_json_setting( $path, $art, $id );
        return;
    }
    $list_art = array();
    $list = $nbd->nbdesigner_read_json_setting($path);
    if (is_array($list)) {
        $list_art   = $list;
        $id         = sizeOf($list_art);
        $art['id']  = (string) $id;
    }
    $list_art[] = $art;
    $res = json_encode($list_art);
    file_put_contents($path, $res);
}
add_action( 'admin_enqueue_scripts',  'add_admin_enqueue_scripts' , 30, 1 );    
function add_admin_enqueue_scripts($hook){
    $nbd_plugin_dir_url = plugin_dir_url( __FILE__ );
    wp_register_style( 'admin_nbdesigner_swat', NBDESIGNER_CSS_URL . 'admin-nbdesigner.css', array('wp-color-picker'), NBDESIGNER_VERSION );
    wp_register_script( 'admin_nbdesigner_swat', $nbd_plugin_dir_url . 'js/manager_swatches.js', array('jquery', 'jquery-ui-resizable', 'jquery-ui-draggable', 'jquery-ui-autocomplete', 'wp-color-picker', 'jquery-ui-datepicker', 'jquery-ui-sortable' ), NBDESIGNER_VERSION );
    wp_localize_script( 'admin_nbdesigner_swat', 'admin_nbds_swat', array(
                'url'               => admin_url( 'admin-ajax.php' ),
                'nonce'             => wp_create_nonce('nbdesigner_add_swatches'),
                'mes_success'       => esc_html__( 'Success!', 'web-to-print-online-designer' ),
                'url_check'         => NBDESIGNER_AUTHOR_SITE,
                'sku'               => NBDESIGNER_SKU,
                'url_gif'           => NBDESIGNER_PLUGIN_URL . 'assets/images/loading.gif',
                'assets_images'     => NBDESIGNER_PLUGIN_URL . 'assets/images/',
                'setting_page'      => admin_url( 'admin.php?page=nbdesigner' ),
                'max_file_uploads'  => function_exists( 'ini_get' ) ? ini_get( 'max_file_uploads' ) : 9999,
                'nbds_lang'         => nbd_get_i18n_javascript() ) );
    wp_enqueue_style( array( 'wp-pointer', 'wp-jquery-ui-dialog', 'admin_nbdesigner_swat' ) );
    wp_enqueue_script( array( 'wp-pointer', 'wpdialogs', 'admin_nbdesigner_swat' ) );
    wp_enqueue_style( 'nbdesigner_sweetalert_css', NBDESIGNER_CSS_URL . 'sweetalert.css' );
    wp_enqueue_script( 'nbdesigner_sweetalert_js', NBDESIGNER_JS_URL . 'sweetalert.min.js' , array( 'jquery' ) );
}

add_action( 'wp_ajax_nbdesigner_add_swatches_cat', 'nbdesigner_add_swatches_cat' );
function nbdesigner_add_swatches_cat(){
    $nbd = new Nbdesigner_Plugin();
    $data = array(
        'mes'   => esc_html__( 'You do not have permission to add/edit clipart category!', 'web-to-print-online-designer' ),
        'flag'  => 0
    );
    if ( !wp_verify_nonce( $_POST['nonce'], 'nbdesigner_add_swatches' ) || !current_user_can( 'edit_nbd_art' ) ) {
        echo json_encode( $data );
        wp_die();
    }
    $path   = NBDESIGNER_DATA_DIR . '/art_swatches.json';
    $cat    = array(
        'name'  => sanitize_text_field($_POST['name']),
        'id'    => absint( $_POST['id'] )
    );
    $nbd->nbdesigner_update_json_setting( $path, $cat, $cat['id'] );
    $data['mes']    = esc_html__( 'Category has been added/edited successfully!', 'web-to-print-online-designer' );
    $data['flag']   = 1;
    echo json_encode( $data );
    wp_die();
}

add_action( 'wp_ajax_nbdesigner_remove_swat', 'nbdesigner_remove_swat' );
function nbdesigner_remove_swat(){
    $nbd = new Nbdesigner_Plugin();
    $data = array(
        'mes'   => esc_html__( 'You do not have permission to delete clipart category!', 'web-to-print-online-designer' ),
        'flag'  => 0
    );
    if (!wp_verify_nonce($_POST['nonce'], 'nbdesigner_add_swatches') || !current_user_can('delete_nbd_art')) {
        echo json_encode( $data );
        wp_die();
    }
    $path = NBDESIGNER_DATA_DIR . '/swatches.json';
    $list = $nbd->nbdesigner_read_json_setting($path);
    $new_aray = [];
    foreach ($list as $key => $value) {
        if($value->cat[0] != $_POST['id']){
            array_push($new_aray, $value);
        }
    }
    if(file_put_contents($path, json_encode($new_aray))){
        $data['mes'] = esc_html__('Swatches has been deleted successfully!', 'web-to-print-online-designer');
        $data['flag'] = 1;
        echo json_encode($data);
        wp_die();
    }
}

add_action( 'wp_ajax_nbdesigner_delete_swatches_cat', 'nbdesigner_delete_swatches_cat' );
function nbdesigner_delete_swatches_cat(){
    $nbd = new Nbdesigner_Plugin();
    $data = array(
        'mes'   => esc_html__( 'You do not have permission to delete clipart category!', 'web-to-print-online-designer' ),
        'flag'  => 0
    );
    if (!wp_verify_nonce($_POST['nonce'], 'nbdesigner_add_swatches') || !current_user_can('delete_nbd_art')) {
        echo json_encode( $data );
        wp_die();
    }
    $path   = NBDESIGNER_DATA_DIR . '/art_swatches.json';
    $id     = $_POST['id'];
    $nbd->nbdesigner_delete_json_setting( $path, $id, true );
    // $art_path = NBDESIGNER_DATA_DIR . '/arts.json';
    // $nbd->nbdesigner_update_json_setting_depend( $art_path, $id );
    $data['mes']    = esc_html__( 'Category has been delete successfully!', 'web-to-print-online-designer' );
    $data['flag']   = 1;
    echo json_encode( $data );
    wp_die();
}

add_action( 'wp_ajax_nbdesigner_delete_swat', 'nbdesigner_delete_swat' );
function nbdesigner_delete_swat() {
    $nbd = new Nbdesigner_Plugin();
    $data = array(
        'mes'   =>  esc_html__('You do not have permission to delete swatches!', 'web-to-print-online-designer'),
        'flag'  => 0
    );
    if (!wp_verify_nonce($_POST['nonce'], 'nbdesigner_add_swatches') || !current_user_can('delete_nbd_art')) {
        echo json_encode($data);
        wp_die();
    }
    $id = $_POST['id'];
    $path = NBDESIGNER_DATA_DIR . '/swatches.json';
    $list = $nbd->nbdesigner_read_json_setting($path);
    $file_art = $list[$id]->file;
    if(file_exists($file_art)){
        unlink($file_art);
    }else{
        $file_art = NBDESIGNER_ART_DIR . $list[$id]->file;
        unlink($file_art);
    }
    $nbd->nbdesigner_delete_json_setting($path, $id);
    $data['mes'] = esc_html__('Swatches has been deleted successfully!', 'web-to-print-online-designer');
    $data['flag'] = 1;
    echo json_encode($data);
    wp_die();
}

add_filter('nbod_extra_active_tabs','bagr_add_swatches_active_tab',10,9);
function bagr_add_swatches_active_tab($nbav_active_tabs, $active_product, $active_design ,$active_typos ,$active_cliparts ,$active_photos ,$active_elements ,$active_template ,$active_layers){
    $nbav_active_tabs['active_swatches'] = (!$active_product && !$active_design && !$active_typos && !$active_cliparts && !$active_photos && !$active_elements && !$active_template && !$active_layers) ? true : false;
    return $nbav_active_tabs;
}

add_action('nbd_js_config','bagr_swatches_js_config');
function bagr_swatches_js_config(){
     echo "var bagr_swatches = true;";
     echo 'NBDESIGNCONFIG.nbdlangs.swatches = "'.__('Swatches', 'web-to-print-online-designer').'";';
}

add_action('nbod_after_tab_typography','bagr_add_swatches_tab');
function bagr_add_swatches_tab($nbav_active_tabs){
    ?>
    <div class="<?php if( $nbav_active_tabs['active_swatches'] ) echo 'active'; ?> tab nbd-onload" id="tab-swatches" data-container="#tab-swatches" nbd-scroll="scrollLoadMore(container, type)" data-type="swatches" data-offset="20">
        <div class="loading-photo" >
            <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/>
            </svg>
        </div>
        <div class="tab-main tab-scroll">
                <div class="nbd-search">
                    <input type="text" name="search" placeholder="<?php esc_html_e('Search color', 'web-to-print-online-designer'); ?>" ng-model="resource.swatches.filter.search"/>
                    <i class="icon-nbd icon-nbd-fomat-search"></i>
                </div>
                <div class="backgrounds-category" ng-class="resource.swatches.data.cat.length > 0 ? '' : 'nbd-hiden'">           
                    <div class="nbd-button nbd-dropdown">
                        <span>{{resource.swatches.filter.currentCat.name}}</span>
                        <i class="icon-nbd icon-nbd-chevron-right rotate90"></i>
                        <div class="nbd-sub-dropdown" data-pos="center">
                            <ul class="nbd-perfect-scroll">
                                <li ng-click="changeCat('swatches', cat)" ng-repeat="cat in resource.swatches.data.cat"><span>{{cat.name}}</span><span>{{cat.amount}}</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="tab-main tab-scroll" style=" margin-top: 15px;margin-left: 15px;">
                    <ul class="main-color-palette nbd-perfect-scroll" >
                        <li style="width:45%;"  ng-repeat="swatches in resource.swatches.filterSwatches" class="color-palette-item" id="swatches_color" ng-click="show_popcolor(swatches.color[4])" data-color="{{swatches.color[4]}}" title="{{swatches.color[4]}}" ng-style="{'background': swatches.color[4]}">{{swatches.color[0]}}</li>
                    </ul>
                </div>
                <div class="hover_bkgr_fricc">
                    <span class="helper"></span>
                     <div>
                        <div class="popupCloseButton" >&times;</div>
                        <div ng-show="!check_draw_color" ng-click="check_color('fill')" ><span>Fill</span><span ng-style="{'background': colorpantone}" class="nbd-tooltip-hover color-fill nbd-color-picker-preview tooltipstered" style="background: {{colorpantone}};"></span></div>
                        <div ng-show="!check_draw_color" ng-click="check_color('stokes')"><span>Outline</span><span ng-style="{'background': colorpantone}" class="nbd-tooltip-hover color-fill nbd-color-picker-preview tooltipstered" style="background: {{colorpantone}};"></span></div>
                        <div ng-click="check_color('stock-draw')" class="color_draw"><span>Shadow</span><span ng-style="{'background': colorpantone}" class="nbd-tooltip-hover color-fill nbd-color-picker-preview tooltipstered" style="background: {{colorpantone}};"></span></div>
                    </div>
                </div>
        </div>
    </div>
    <style type="text/css">
        .hover_bkgr_fricc{
            background:rgba(0,0,0,.4);
            cursor:pointer;
            display:none;
            height:100%;
            position:fixed;
            text-align:center;
            top:0;
            width:100%;
            z-index:10000;
        }
        .hover_bkgr_fricc .helper{
            display:inline-block;
            height:100%;
            vertical-align:middle;
        }
        .hover_bkgr_fricc > div {
            right: 20%;
            background-color: #fff;
            box-shadow: 10px 10px 60px #555;
            display: inline-block;
            height: auto;
            max-width: 551px;
            min-height: 100px;
            vertical-align: middle;
            width: 6%;
            position: relative;
            border-radius: 8px;
            padding: 15px 2%;
        }
        .popupCloseButton {
            visibility: hidden;
            background-color: #fff;
            border: 3px solid #999;
            border-radius: 50px;
            cursor: pointer;
            display: inline-block;
            font-family: arial;
            font-weight: bold;
            position: absolute;
            top: -20px;
            right: -20px;
            font-size: 25px;
            line-height: 30px;
            width: 30px;
            height: 30px;
            text-align: center;
        }
        .popupCloseButton:hover {
            background-color: #ccc;
        }
        .trigger_popup_fricc {
            cursor: pointer;
            font-size: 20px;
            margin: 20px;
            display: inline-block;
            font-weight: bold;
        }
        /* Popup box BEGIN */
        #swatches_color{color:black !important; text-align: center;padding-top: 10px;}
        .sp-container{background-color: unset;border: none; width: auto;}
        .sp-picker-container{border:none;clear: both;}
        #tab-swatches .sp-container .sp-palette-container{width: 90%;border: none;}
        #nav-background #background-icon{fill:#fff;}
        #nav-background.active #background-icon{fill:#404762;}
        .nbd-workspace .tabs-content.mobile{height: 190px !important}
        .nbd-workspace .main.mobile{z-index: 111111}
        .nbd-workspace .tabs-content.mobile #tab-swatches .sp-container .sp-palette-container{display: none;}
        .nbd-sidebar #tab-swatches .tab-main{height:calc(100% - 20px);}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown span{font-size:12px;color:#404762}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .info-support span{font-size:16px}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .main-items{position:relative}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .main-items .items .item{width:33.33%}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .main-items .items .item .main-item{border-radius:2px;cursor:pointer;-webkit-transition:-webkit-box-shadow .3s;transition:-webkit-box-shadow .3s;transition:box-shadow .3s;transition:box-shadow .3s,-webkit-box-shadow .3s;border:none}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .main-items .items .item .main-item:hover .item-svg{-webkit-box-shadow:1px 0 10px rgba(0,0,0,.1);box-shadow:1px 0 10px rgba(0,0,0,.1)}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .main-items .items .item .main-item .item-svg{background:#fff;padding:20px;border-radius:2px}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .main-items .items .item .main-item .item-svg svg{width:40px}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .main-items .items .item .main-item .item-info{-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:5px}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .result-loaded{margin-top:0}
        .nbd-sidebar #tab-swatches .nbd-items-dropdown .result-loaded .nbdesigner-gallery .nbdesigner-item{width:33.33%}
        .nbd-sidebar #tab-swatches .backgrounds-category{padding:0 10px;display: flex;}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button{width:100%;margin:0;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;-webkit-box-align:center;-ms-flex-align:center;align-items:center;overflow:unset;font-size:12px;text-transform:capitalize;}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button .nbd-sub-dropdown{width:100%;top:calc(100% + 5px)}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button .nbd-sub-dropdown:after,.nbd-sidebar #tab-swatches .backgrounds-category .nbd-button .nbd-sub-dropdown:before{display:none}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button ul{min-width:220px;max-height:250px;margin:10px 0}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button ul li{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;-webkit-box-align:center;-ms-flex-align:center;align-items:center;padding:0 20px}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button ul li span{color:#404762;text-transform:capitalize}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button ul li:hover{background-color:hsla(0,0%,62%,.2)}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button i,.nbd-sidebar #tab-swatches .backgrounds-category .nbd-button span{color:#fff}
        .nbd-sidebar #tab-swatches .backgrounds-category .nbd-button i{font-size:24px}
        .nbd-sidebar #tab-swatches .nbd-search {position: relative;left:0;}
        /*style.min.css*/
        <?php include_once(__DIR__.'/include/style.min.css'); ?>
        <?php if(is_rtl()):?>
            /*nbdesigner-rtl.css*/
            .nbdesigner_background_modal_header > span {
                float: right;
            }
        <?php endif; ?>
        /*modern-additional.css*/
        .background-wrap .background-item {
            visibility: visible !important; 
            width: 33.33%;
            padding: 2px;
            opacity: 0;
            z-index: 3;
            cursor: pointer;
        }
        .background-wrap .background-item.in-view {
            opacity: 1;
        }
        .mansory-wrap .mansory-item
        .nbd-sidebar #tab-swatches .backgrounds-category {
            margin-top: 70px;
            padding: 0px 10px 10px;        
        }

    </style>
    <?php
}

add_action('nbod_after_nav_typos','bagr_add_swatches_nav');
function bagr_add_swatches_nav($nbav_active_tabs){
    ?>
    <li id="nav-background" data-tour="swatches" data-tour-priority="7" class="<?php if( $nbav_active_tabs['active_swatches'] ) echo 'active' ;?> tab animated <?php echo $animation_dir; ?> animate900 tab-swatches" ng-click="disableDrawMode();getResource('swatches', '#tab-swatches', true)">
            <svg id="background-icon" xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor" class="bi bi-square-fill" viewBox="0 0 16 16">
              <path d="M0 2a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2z"/>
            </svg>
            <span><?php _e('Color','web-to-print-online-designer'); ?></span></li>     
    <?php
}

add_filter('nbod_get_resource_before_send','bagr_get_swatches_resource',10,2);
function bagr_get_swatches_resource($return,$rq_type){
    if ($rq_type=='swatches'){
        $path_cat = NBDESIGNER_DATA_DIR . '/art_swatches.json';
        $path_background = NBDESIGNER_DATA_DIR . '/swatches.json';
        $return['data']['cat'] = $return['data']['backgrounds'] =array();
        if( file_exists($path_cat) ){
            $_cat = file_get_contents($path_cat);
            $return['data']['cat'] = $_cat == '' ? array() : json_decode($_cat);
        }
        if( file_exists($path_background) ){
            $_background = file_get_contents($path_background);
            $return['data']['backgrounds'] = $_background == '' ? array() : json_decode($_background);
        }
    }
    return $return;
}

add_action('nbd_rest_part_svg_swacht','add_nbd_rest_part_svgs',10,4);
function add_nbd_rest_part_svgs($nbd_item_key,$key,$pdf,$_pdf){
    $svg_path = NBDESIGNER_CUSTOMER_DIR  . '/' . $nbd_item_key . '/frame_' . $key . '_svg.svg';
    $svg_path2 = NBDESIGNER_CUSTOMER_DIR  . '/' . $nbd_item_key . '/svgpath/frame_' . $key . '_svg.svg';
    $nbd = new Nbdesigner_Plugin();
    $swatches = NBDESIGNER_DATA_DIR . '/swatches.json';
    $list = $nbd->nbdesigner_read_json_setting($swatches);
    $doc = new DOMDocument();
    $doc->Load($svg_path);
    $pantone = [];
    if($doc->getElementsByTagName('text')->length != 0){
        foreach($doc->getElementsByTagName('text') as $element) {
            $values = explode(';', $element->getAttribute('style'));
            foreach ($values as $key => $cl) {
                $value_fill = explode(':', $cl);
                if(trim($value_fill[0] , ' ') == 'fill'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('fill',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                if(trim($value_fill[0] , ' ') == 'stroke'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('stroke',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                
            }
        }
    }
    if ($doc->getElementsByTagName('g')->length != 0) {
        foreach($doc->getElementsByTagName('g') as $element) {
            $values = explode(';', $element->getAttribute('style'));
            foreach ($values as $key => $cl) {
                $value_fill = explode(':', $cl);
                if(trim($value_fill[0] , ' ') == 'fill'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('fill',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                if(trim($value_fill[0] , ' ') == 'stroke'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('stroke',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
            }
        }
    }
    if ($doc->getElementsByTagName('rect')->length != 0) {
         foreach($doc->getElementsByTagName('rect') as $element) {
            $values = explode(';', $element->getAttribute('style'));
            foreach ($values as $key => $cl) {
                $value_fill = explode(':', $cl);
                if(trim($value_fill[0] , ' ') == 'fill'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('fill',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                if(trim($value_fill[0] , ' ') == 'stroke'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('stroke',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
            }

        }
    }
    if ($doc->getElementsByTagName('polygon')->length != 0) {
         foreach($doc->getElementsByTagName('polygon') as $element) {
            $values = explode(';', $element->getAttribute('style'));
            foreach ($values as $key => $cl) {
                $value_fill = explode(':', $cl);
                if(trim($value_fill[0] , ' ') == 'fill'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('fill',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                if(trim($value_fill[0] , ' ') == 'stroke'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('stroke',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                
            }
        }
    }
    if ($doc->getElementsByTagName('circle')->length != 0) {
         foreach($doc->getElementsByTagName('circle') as $element) {
            $values = explode(';', $element->getAttribute('style'));
            foreach ($values as $key => $cl) {
                $value_fill = explode(':', $cl);
                if(trim($value_fill[0] , ' ') == 'fill'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('fill',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                if(trim($value_fill[0] , ' ') == 'stroke'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('stroke',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                
            }
        }
    }
    if ($doc->getElementsByTagName('line')->length != 0) {
         foreach($doc->getElementsByTagName('line') as $element) {
            $values = explode(';', $element->getAttribute('style'));
            foreach ($values as $key => $cl) {
                $value_fill = explode(':', $cl);
                if(trim($value_fill[0] , ' ') == 'fill'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('fill',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                if(trim($value_fill[0] , ' ') == 'stroke'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('stroke',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                
            }
        }
    }
    if ($doc->getElementsByTagName('path')->length != 0) {
         foreach($doc->getElementsByTagName('path') as $element) {
            $values = explode(';', $element->getAttribute('style'));
            foreach ($values as $key => $cl) {
                $value_fill = explode(':', $cl);
                if(trim($value_fill[0] , ' ') == 'fill'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('fill',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
                if(trim($value_fill[0] , ' ') == 'stroke'){
                    if (strpos($value_fill[1], 'rgb(') !== false) {
                        foreach ($list as $key_colo => $value_colo) {
                            $rgb = ' rgb('.$value_colo->color[1].','.$value_colo->color[2].','.$value_colo->color[3].')';
                            if($rgb == $value_fill[1]){
                                $foo_path =str_replace(' ','', $value_colo->color[0]);
                                $element->setAttribute('stroke',$foo_path);
                                array_push($pantone,$value_colo->color);
                                
                            }                  
                        }
                    }
                }
            }
        }
    }

    $doc->saveXML();
    $new_svg_path = $doc->saveXML(); 
    file_put_contents($svg_path,$new_svg_path);
    file_put_contents($svg_path2,$new_svg_path);
    foreach ($pantone as $key => $value) {
        $color=rgb2cmyk(hex2rgb($value[4]));
        $foo =str_replace(' ','', $value[0]);
        TCPDF_COLORS::$spotcolor[strtolower($foo)] = array( $color['c'], $color['m'], $color['y'], $color['k'], $foo);
        $pdf->AddSpotColor(strtolower($foo), $color['c'], $color['m'], $color['y'], $color['k']);
    }
}

function hex2rgb($hex) {
   $color = str_replace('#','',$hex);
   $rgb = array(
      'r' => hexdec(substr($color,0,2)),
      'g' => hexdec(substr($color,2,2)),
      'b' => hexdec(substr($color,4,2)),
   );
   return $rgb;
}
function check_isnan($color){
    if(is_nan($color)){
        return 0;
    }
    return $color;
}
function rgb2cmyk($var1,$g=0,$b=0) {
    if (is_array($var1)) {
            $r = $var1['r'];
            $g = $var1['g'];
            $b = $var1['b'];
    } else {
            $r = $var1;
    }
    $cyan = 1 - $r/255;
    $magenta = 1 - $g/255;
    $yellow = 1 - $b/255;
    $black = min($cyan, $magenta, $yellow);
    $cyan = check_isnan(@round(($cyan - $black) / (1 - $black) * 100));
    $magenta = check_isnan(@round(($magenta - $black) / (1 - $black) * 100));
    $yellow = check_isnan(@round(($yellow - $black) / (1 - $black) * 100));
    $black = check_isnan(@round($black * 100));
    return array(
            'c' => $cyan,
            'm' => $magenta,
            'y' => $yellow,
            'k' => $black,
    );
}

function fromRGB($R, $G, $B)
{

    $R = dechex($R);
    if (strlen($R)<2)
    $R = '0'.$R;

    $G = dechex($G);
    if (strlen($G)<2)
    $G = '0'.$G;

    $B = dechex($B);
    if (strlen($B)<2)
    $B = '0'.$B;

    return '#' . $R . $G . $B;
}

add_filter('nbo_custom_mere_color','add_nbo_custom_mere_color');
function add_nbo_custom_mere_color($html){
    $html = '';
    return $html;
}

add_filter('nbod_color_palette_hide','add_nbod_color_palette_hide');
function add_nbod_color_palette_hide($html){
    $html = '';
    return $html;
}

add_filter('nbd_remove_color_element','add_nbd_remove_color_element');
function add_nbd_remove_color_element(){
    ?>
    <ul class="main-color-palette nbd-perfect-scroll" >
        <li class="color-palette-add" ng-init="showBrushColorPicker = false" ng-click="showBrushColorPicker = !showBrushColorPicker;" ng-style="{'background-color': currentColor}"></li>
    </ul>
    <?php
}

