<?php
add_action( 'wp_enqueue_scripts', 'flatsome_child_scripts', 100 );

function flatsome_child_scripts(){
	$uri     = get_stylesheet_directory_uri();

	$theme   = wp_get_theme( get_template() );
	$version = $theme->get( 'Version' );
	wp_register_script( 'flatsome-child-js', $uri . '/assets/js/custom.js', array( 'jquery' ), $version, true );
	wp_enqueue_script('flatsome-child-js');
}

add_action('flatsome_after_header', 'flatsome_search');
function flatsome_search(){
	?>
	<div class="container box-search">
		<div id="logo" class="logo">
		    <?php get_template_part('template-parts/header/partials/element','logo'); ?>
		</div>
		<div class="form-wrapper">
			<form class="form-search" action="">
				<div class="input-s">
					<ul class="search-results">
						
					</ul>
					<input type="text" name="search" placeholder="zoeken" autocomplete="off">
					<div class="innericon">
						<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 512 512"><path d="M460.355 421.59l-106.51-106.512c20.04-27.553 31.884-61.437 31.884-98.037C385.73 124.935 310.792 50 218.685 50c-92.106 0-167.04 74.934-167.04 167.04 0 92.107 74.935 167.042 167.04 167.042 34.912 0 67.352-10.773 94.184-29.158L419.945 462l40.41-40.41zM100.63 217.04c0-65.095 52.96-118.055 118.056-118.055 65.098 0 118.057 52.96 118.057 118.056 0 65.097-52.96 118.057-118.057 118.057-65.096 0-118.055-52.96-118.055-118.056z"></path></svg>
					</div>
					<div class="before-text">
						<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 512 512"><path d="M460.355 421.59l-106.51-106.512c20.04-27.553 31.884-61.437 31.884-98.037C385.73 124.935 310.792 50 218.685 50c-92.106 0-167.04 74.934-167.04 167.04 0 92.107 74.935 167.042 167.04 167.042 34.912 0 67.352-10.773 94.184-29.158L419.945 462l40.41-40.41zM100.63 217.04c0-65.095 52.96-118.055 118.056-118.055 65.098 0 118.057 52.96 118.057 118.056 0 65.097-52.96 118.057-118.057 118.057-65.096 0-118.055-52.96-118.055-118.056z"></path></svg>
					</div>
					
				</div>
			</form>
		</div>
	</div>
	
	<?php
}


add_action('asp_after_search','flatsome_after_search',10,3);
function flatsome_after_search($s, $results, $id){
	if(isset($_POST['flat_some_search'])){
		echo json_encode($results);
		die();
	}
	
}

add_action('woocommerce_after_add_to_cart_quantity','flatsome_after_add_to_cart_quantity');
function flatsome_after_add_to_cart_quantity(){
	global $product;
	$classes = array();
	if($product->is_on_sale()) $classes[] = 'price-on-sale';
	if(!$product->is_in_stock()) $classes[] = 'price-not-in-stock'; ?>
		<div class="price-wrapper">
			<p class="price product-page-price <?php echo implode(' ', $classes); ?>">
		  <?php echo $product->get_price_html(); ?></p>
		</div>
	<?php
}

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
remove_action('woocommerce_single_variation', 'fafa_variation_extra_dropdowns');
remove_action('woocommerce_after_add_to_cart_quantity', 'fafa_add_price_button');


