<?php
/**
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * FOR CUSTOM CSS USE THE PLUGIN THEME OPTIONS->CUSTOM CSS PANEL.
 */

/* Prevent direct access */
defined('ABSPATH') or die("You can't access this file directly.");
?>
/*
AJAX SEARCH PRO FOR WORDPRESS PLUGIN BASIC CSS
*/

/*
CONTENTS:
    0. ANIMATIONS AND TRANSITIONS
	1. GENERICS AND CSS RESET - Some basic CSS classes and reset
	2. INPUT BOX - input box and form layout
	3. ICONS - loading, closing, magnifier, settings icons
	4. RESULT STYLES
	    4.1 GENERAL RESULT STYLES
	    4.2 VERTICAL RESULT STYLES
	    4.3 HORIZONTAL RESULT STYLES
	    4.4 ISOTOPIC RESULT STYLES
	    4.5 POLAROID RESULT STYLES
	5. SETTINGS STYLES
	6. CUSTOM FIELD FIELDSETS
	7. ARROW BOX
	8. COLUMN STYLES
	9. NO-UI DRAGGER STYLES
	10. SUGGESTED KEYWORDS
    11. SCROLLBAR STYLES
    12. JQUERY UI STYLES
    13. AUTOCOMPLETE STYLES
    14. RTL SPECIFIC STYLES AND CHANGES
    15. SELECT2 SCRIPT STYLES
    16. MISC


SHORTHAND CLASSES
    .asp_w -> Main class, each element is a descendant
    .asp_m .asp_m_1 .asp_m_1_1 -> Main search box class, with instance ID, with instance and count ID
    .asp_s .asp_s_1 .asp_s_1_1 -> Settings box class, with instance ID, with instance and count ID
    .asp_r .asp_r_1 .asp_r_1_1 -> Results box class, with instance ID, with instance and count ID
    .asp_sb -> Block settings layout
    .asp_rb -> Block results layout
*/



/*  *******************************************************************************************************************\
    0. ANIMATIONS AND TRANSITIONS & FONTS
\**********************************************************************************************************************/
@keyframes aspAnFadeIn {
    0%   {opacity: 0;}
    50%  {opacity: 0.6;}
    100% {opacity: 1;}
}

@-webkit-keyframes aspAnFadeIn {
    0%   {opacity: 0;}
    50%  {opacity: 0.6;}
    100% {opacity: 1;}
}

@keyframes aspAnFadeOut {
    0%   {opacity: 1;}
    50%  {opacity: 0.6;}
    100% {opacity: 0;}
}

@-webkit-keyframes aspAnFadeOut {
    0%   {opacity: 1;}
    50%  {opacity: 0.6;}
    100% {opacity: 0;}
}

@keyframes aspAnFadeInDrop {
    0%   {opacity: 0; transform: translate(0, -50px);}
    100% {opacity: 1; transform: translate(0, 0);}
}

@-webkit-keyframes aspAnFadeInDrop {
    0%   {opacity: 0; transform: translate(0, -50px); -webkit-transform: translate(0, -50px);}
    100% {opacity: 1; transform: translate(0, 0); -webkit-transform: translate(0, 0);}
}

@keyframes aspAnFadeOutDrop {
    0% {opacity: 1; transform: translate(0, 0); -webkit-transform: translate(0, 0);}
    100%   {opacity: 0; transform: translate(0, -50px); -webkit-transform: translate(0, -50px);}
}

@-webkit-keyframes aspAnFadeOutDrop {
    0% {opacity: 1; transform: translate(0, 0); -webkit-transform: translate(0, 0);}
    100%   {opacity: 0; transform: translate(0, -50px); -webkit-transform: translate(0, -50px);}
}

div.ajaxsearchpro.asp_an_fadeIn,
div.ajaxsearchpro.asp_an_fadeOut,
div.ajaxsearchpro.asp_an_fadeInDrop,
div.ajaxsearchpro.asp_an_fadeOutDrop {
    -webkit-animation-duration: 100ms;
    animation-duration: 100ms;
    -webkit-animation-fill-mode: forwards; /* Chrome, Safari, Opera */
    animation-fill-mode: forwards;
}

.asp_an_fadeIn,
div.ajaxsearchpro.asp_an_fadeIn {
    animation-name: aspAnFadeIn;
    -webkit-animation-name: aspAnFadeIn;
}

.asp_an_fadeOut,
div.ajaxsearchpro.asp_an_fadeOut {
    animation-name: aspAnFadeOut;
    -webkit-animation-name: aspAnFadeOut;
}

div.ajaxsearchpro.asp_an_fadeInDrop {
    animation-name: aspAnFadeInDrop;
    -webkit-animation-name: aspAnFadeInDrop;
}

div.ajaxsearchpro.asp_an_fadeOutDrop {
    animation-name: aspAnFadeOutDrop;
    -webkit-animation-name: aspAnFadeOutDrop;
}

div.ajaxsearchpro.asp_main_container {
    transition: width 130ms linear;
    -webkit-transition: width 130ms linear;
}


/*  *******************************************************************************************************************\
    1. GENERIC CSS RESET
\**********************************************************************************************************************/

asp_w_container,
div.asp_w.ajaxsearchpro,
div.asp_w.asp_r,
div.asp_w.asp_s,
div.asp_w.asp_sb,
div.asp_w.asp_sb * {
    -webkit-box-sizing: content-box; /* Safari/Chrome, other WebKit */
    -moz-box-sizing: content-box; /* Firefox, other Gecko */
    -ms-box-sizing: content-box;
    -o-box-sizing: content-box;
    box-sizing: content-box;
    padding: 0;
    margin: 0;
    border: 0;
    border-radius: 0;
    text-transform: none;
    text-shadow: none;
    box-shadow: none;
    text-decoration: none;
    text-align: left;
    text-indent: initial;
    letter-spacing: normal;
	font-display: swap;
}

div.asp_w_container div[id*=__original__] {
	display: none !important;
}

div.asp_w.ajaxsearchpro {
    -webkit-box-sizing: border-box;
    -moz-box-sizing: border-box;
    -ms-box-sizing: border-box;
    -o-box-sizing: border-box;
    box-sizing: border-box;
}

div.asp_w.asp_r,
div.asp_w.asp_r * {
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    -khtml-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
}

div.asp_w.ajaxsearchpro input[type=text]::-ms-clear {  display: none; width : 0; height: 0; }
div.asp_w.ajaxsearchpro input[type=text]::-ms-reveal {  display: none; width : 0; height: 0; }

div.asp_w.ajaxsearchpro input[type="search"]::-webkit-search-decoration,
div.asp_w.ajaxsearchpro input[type="search"]::-webkit-search-cancel-button,
div.asp_w.ajaxsearchpro input[type="search"]::-webkit-search-results-button,
div.asp_w.ajaxsearchpro input[type="search"]::-webkit-search-results-decoration { display: none; }

div.asp_w.ajaxsearchpro input[type="search"] {
	appearance: auto !important;
	-webkit-appearance: none !important;
}

.clear {
    clear: both;
}

/* This clear class is bulletproof */
.asp_clear {
    clear: both !important;
    margin: 0 !important;
    padding: 0 !important;
    width: auto !important;
    height: 0 !important;
}

.hiddend {
    display: none !important;
}

div.asp_w.ajaxsearchpro {
    width: 100%;
    height: auto;
    border-radius: 0;
    background: rgba(255, 255, 255, 0);
    overflow: hidden;
}

div.asp_w.ajaxsearchpro.asp_non_compact {
    min-width: 200px;
}

#asp_absolute_overlay {
    width: 0;
    height: 0;
    position: fixed;
    text-align: center;
    background: rgba(255, 255, 255, 0.5);
    top: 0;
    left: 0;
    display: block;
    z-index: 0;
    opacity: 0;
    transition: opacity 200ms linear;
    -webkit-transition: opacity 200ms linear;
}


/*  *******************************************************************************************************************\
    2. INPUT FORM and BOX
\**********************************************************************************************************************/

div.asp_m.ajaxsearchpro .proinput input:before,
div.asp_m.ajaxsearchpro .proinput input:after,
div.asp_m.ajaxsearchpro .proinput form:before,
div.asp_m.ajaxsearchpro .proinput form:after {
    display: none;
}

div.asp_w.ajaxsearchpro textarea:focus,
div.asp_w.ajaxsearchpro input:focus {
    outline: none;
}

/* Remove IE X from the input */
div.asp_m.ajaxsearchpro .probox .proinput input::-ms-clear {
    display: none;
}

div.asp_m.ajaxsearchpro .probox {
    width: auto;
    border-radius: 5px;
    background: #FFF;
    overflow: hidden;
    border: 1px solid #FFF;
    box-shadow: 1px 0 3px #CCCCCC inset;
    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: row;
    flex-direction: row;
    direction: ltr;
    align-items: stretch;
	isolation: isolate; /* Safari bleeding background corner with border radius fix */
}

div.asp_m.ajaxsearchpro .probox .proinput {
    width: 1px;
    height: 100%;
    margin: 0px 0px 0px 10px;
    padding: 0 5px;
    float: left;
    box-shadow: none;
    position: relative;
    flex: 1 1 auto;    /* Let it grow, shrink, auto basis*/
    -webkit-flex: 1 1 auto; /* Let it grow, shrink, auto basis*/
    z-index: 0;
}

div.asp_m.ajaxsearchpro .probox .proinput form {
    height: 100%;
    /* some themes like to add un-removable margin and padding.. */
    margin: 0 !important;
    padding: 0 !important;
}

div.asp_m.ajaxsearchpro .probox .proinput input {
    height: 100%;
    width: 100%;
    border: 0px;
    background: transparent;
    width: auto;
    box-shadow: none;
    margin: -1px;
    padding: 0;
    left: 0;
    padding-top: 2px;
    min-width: 120px;
}

div.asp_m.ajaxsearchpro .probox .proinput input.autocomplete {
    border: 0px;
    background: transparent;
    width: 100%;
    box-shadow: none;
    margin: 0;
    padding: 0;
    left: 0;
}

div.asp_m.ajaxsearchpro .probox .proinput.iepaddingfix {
    padding-top: 0;
}


/*  *******************************************************************************************************************\
    3. ICONS - loading, closing, magnifier, settings icons
\**********************************************************************************************************************/

div.asp_m.ajaxsearchpro .probox .proloading,
div.asp_m.ajaxsearchpro .probox .proclose,
div.asp_m.ajaxsearchpro .probox .promagnifier,
div.asp_m.ajaxsearchpro .probox .prosettings {
    width: 20px;
    height: 20px;
    background: none;
    background-size: 20px 20px;
    float: right;
    box-shadow: none;
    margin: 0;
    padding: 0;
    text-align: center;
    z-index: 1;
}

div.asp_m.ajaxsearchpro button.promagnifier:focus-visible {
	box-shadow: inset 0 0 0 2px rgba(0, 0, 0, 0.4);
}

div.asp_m.ajaxsearchpro .probox .proloading,
div.asp_m.ajaxsearchpro .probox .proclose {
    background-position: center center;
    display: none;
    background-size: auto;
    background-repeat: no-repeat;
    background-color: transparent;
}

div.asp_m.ajaxsearchpro .probox .proloading {
    padding: 2px;
    box-sizing: border-box;
}

div.asp_m.ajaxsearchpro .probox .proclose {
    position: relative;
    cursor: pointer;
    z-index: 2;
}

div.asp_m.ajaxsearchpro .probox .promagnifier .innericon,
div.asp_m.ajaxsearchpro .probox .prosettings .innericon,
div.asp_m.ajaxsearchpro .probox .proclose .innericon {
    background-size: 20px 20px;
    background-position: center center;
    background-repeat: no-repeat;
    background-color: transparent;
    width: 100%;
    height: 100%;
    line-height: initial;
    text-align: center;
    overflow: hidden;
}

div.asp_m.ajaxsearchpro .probox .promagnifier .innericon svg,
div.asp_m.ajaxsearchpro .probox .prosettings .innericon svg,
div.asp_m.ajaxsearchpro .probox .proloading svg {
    height: 100%;
    width: 22px;
    vertical-align: baseline;
    display: inline-block;
}

div.asp_m.ajaxsearchpro .probox .proclose svg  {
    background: #333333;
    border-radius: 50%;
    position: absolute;
    top: 50%;
    width: 20px;
    height: 20px;
    margin-top: -10px;
    left: 50%;
    margin-left: -10px;
    fill: #fefefe;
    padding: 4px;
    box-sizing: border-box;
    box-shadow: 0px 0px 0px 2px rgba(255, 255, 255, 0.9);
}


/*  *******************************************************************************************************************\
    4. RESULT STYLES
\**********************************************************************************************************************/


/*      4.1 GENERAL RESULT STYLES
\**********************************************************************************************************************/

.opacityOne {
    opacity: 1;
}

.opacityZero {
    opacity: 0;
}

div.asp_w.asp_s [disabled].noUi-connect,
div.asp_w.asp_s [disabled] .noUi-connect {
    background: #B8B8B8;
}
div.asp_w.asp_s [disabled] .noUi-handle {
    cursor: not-allowed;
}

div.asp_w.asp_r p.showmore {
    display: none;
    margin: 5px 0;
}
div.asp_w.asp_r.asp_more_res_loading p.showmore a,
div.asp_w.asp_r.asp_more_res_loading p.showmore a span{
    color: transparent !important;
}

@-webkit-keyframes shm-rot-simple {
    0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
        opacity: 1;
    }
    50% {
        -webkit-transform: rotate(180deg);
        transform: rotate(180deg);
        opacity: 0.85;
    }
    100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
        opacity: 1;
    }
}

@keyframes shm-rot-simple {
    0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
        opacity: 1;
    }
    50% {
        -webkit-transform: rotate(180deg);
        transform: rotate(180deg);
        opacity: 0.85;
    }
    100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
        opacity: 1;
    }
}
div.asp_w.asp_r div.asp_showmore_container {
    position: relative;
}
div.asp_w.asp_r. div.asp_moreres_loader {
    display: none;
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    background: rgba(255, 255, 255, 0.2);
}
div.asp_w.asp_r.asp_more_res_loading div.asp_moreres_loader {
    display: block !important;
}
div.asp_w.asp_r div.asp_moreres_loader-inner {
    height: 24px;
    width: 24px;
    animation: shm-rot-simple 0.8s infinite linear;
    -webkit-animation: shm-rot-simple 0.8s infinite linear;
    border: 4px solid #353535;
    border-right-color: transparent;
    border-radius: 50%;
    box-sizing: border-box;
    position: absolute;
    top: 50%;
    margin: -12px auto auto -12px;
    left: 50%;
}

div.asp_hidden_data,
div.asp_hidden_data * {
    display: none;
}

div.asp_w.asp_r {
    display: none;
}

div.asp_w.asp_r * {
    text-decoration: none;
    text-shadow: none;
}

div.asp_w.asp_r .results {
    overflow: hidden;
    width: auto;
    height: 0;
    margin: 0;
    padding: 0;
}

div.asp_w.asp_r .results .asp_nores {
    overflow: hidden;
    width: 100%;
    height: auto;
    line-height: initial;
    text-align: center;
    margin: 0;
    background: #FFF;
    padding: 10px 3px;
    color: #222;
}

div.asp_w.asp_r .results .item {
    overflow: hidden;
    width: auto;
    margin: 0;
    padding: 3px;
    position: relative;
    background: #f4f4f4;
    border-left: 1px solid rgba(255, 255, 255, 0.6);
    border-right: 1px solid rgba(255, 255, 255, 0.4);
}

div.asp_w.asp_r .results .item,
div.asp_w.asp_r .results .asp_group_header {
    animation-delay: 0s;
    animation-duration: 0.5s;
    animation-fill-mode: both;
    animation-timing-function: ease;
    backface-visibility: hidden;
    -webkit-animation-delay: 0s;
    -webkit-animation-duration: 0.5s;
    -webkit-animation-fill-mode: both;
    -webkit-animation-timing-function: ease;
    -webkit-backface-visibility: hidden;
}

div.asp_w.asp_r .results .item .asp_image {
    overflow: hidden;
    background: transparent;
    padding: 0;
    float: left;
    background-position: center;
    background-size: cover;
    position: relative;
}

div.asp_w.asp_r .results .asp_image canvas {
    display: none;
}

div.asp_w.asp_r .results .asp_image .asp_item_canvas {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    margin: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
    display: block;
    opacity: 1;
    background-position: inherit;
    background-size: inherit;
    transition: opacity 0.5s;
}

div.asp_w.asp_r .results .item:hover .asp_image .asp_item_canvas,
div.asp_w.asp_r .results figure:hover .asp_image .asp_item_canvas{
    opacity: 0;
}

div.asp_w.asp_r a.asp_res_image_url,
div.asp_w.asp_r a.asp_res_image_url:hover,
div.asp_w.asp_r a.asp_res_image_url:focus,
div.asp_w.asp_r a.asp_res_image_url:active {
    box-shadow: none !important;
    border: none !important;
    margin: 0 !important;
    padding: 0 !important;
    display: inline !important;
}

div.asp_w.asp_r .results .item .asp_image_auto {
    width: auto !important;
    height: auto !important;
}

div.asp_w.asp_r .results .item .asp_image img {
    width: 100%;
    height: 100%;
}

div.asp_w.asp_r .results a span.overlap {
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    z-index: 1;
}

div.asp_w.asp_r .resdrg {
    height: auto;
}

div.asp_w.ajaxsearchpro .asp_group_header:first-of-type {
    margin: 0px 0 -3px !important;
}


/*      4.2 VERTICAL RESULT STYLES
\**********************************************************************************************************************/
/*[vertical]*/
div.asp_w.asp_r.vertical .results .item:first-child {
    border-radius: 0;
}

div.asp_w.asp_r.vertical .results .item:last-child {
    border-radius: 0;
    margin-bottom: 0;
}

div.asp_w.asp_r.vertical .results .item:last-child:after {
    height: 0;
    margin: 0;
    width: 0;
}
/*[vertical]*/

/*      4.3 HORIZONTAL RESULT STYLES
\**********************************************************************************************************************/
/*[horizontal]*/
div.asp_w.asp_r.horizontal {
    padding: 2px 0 10px;
}

div.asp_w.asp_r.horizontal .results .asp_nores {
    background: transparent;
}


div.asp_w.asp_r.horizontal .results {
    height: auto;
    width: auto;
}

div.asp_w.asp_r.horizontal .results .item .asp_content {
    height: auto;
    width: 100%;
    padding: 0;
}

div.asp_w.asp_r.horizontal .resdrg {
    height: auto;
    width: auto;
}

div.asp_w.asp_r.horizontal .resdrg:after {
  content: "";
  clear: both;
  display: table;
}
/*[horizontal]*/

/*      4.4 ISOTOPIC RESULT STYLES, ISOTOPIC NAVIGATION
\**********************************************************************************************************************/
/*[isotopic]*/
div.asp_w.asp_r.isotopic>nav,
div.asp_w.asp_r.isotopic nav.asp_navigation {
    display: none;
    background: rgba(255, 255, 255, 0.6);
    margin: 0;
    position: relative;
}

div.asp_w.asp_r.isotopic nav.asp_navigation[style='display: block;']+.results {
    margin-top: 2px;
    margin-bottom: 2px;
}

div.asp_w.asp_r.isotopic a.asp_prev,
div.asp_w.asp_r.isotopic a.asp_next {
    display: block;
    float: left;
    z-index: 100;
    max-height: 36px;
    position: relative;
    word-wrap: nowrap;
}

div.asp_w.asp_r.isotopic a.asp_next {
    float: right;
}

div.asp_w.asp_r.isotopic nav.asp_navigation a svg {
    -webkit-backface-visibility: hidden;
}

div.asp_w.asp_r.isotopic nav.asp_navigation a.asp_prev,
div.asp_w.asp_r.isotopic nav.asp_navigation a.asp_next {
    background: #3F3F3F;
    height: 36px;
    padding: 0 10px;
    cursor: pointer;
}

div.asp_w.asp_r.isotopic nav.asp_navigation ul {
    float: left;
    word-wrap: nowrap;
    overflow: hidden;
    max-height: 36px;
    z-index: 0;
    position: absolute;
    left: 36px;
    top: 0;
    width: 300000px;
    -webkit-transition: left 120ms linear;
    transition: left 120ms linear;
}

div.asp_w.asp_r.isotopic nav.asp_navigation a.asp_next {
    float: right;
}

div.asp_w.asp_r.isotopic nav.asp_navigation a.asp_prev svg,
div.asp_w.asp_r.isotopic nav.asp_navigation a.asp_next svg {
    fill: #eee;
    height: 100%;
    width: 18px;
}

div.asp_w.asp_r.isotopic nav.asp_navigation a.asp_prev svg {
    -moz-transform: scale(-1, 1);
    -webkit-transform: scale(-1, 1);
    -o-transform: scale(-1, 1);
    -ms-transform: scale(-1, 1);
    transform: scale(-1, 1);
}

div.asp_w.asp_r.isotopic nav.asp_navigation ul li {
    display: inline-block;
    list-style-type: none;
    margin: 0;
    height: 36px;
    width: 36px;
    cursor: pointer;
    text-align: center;
}

div.asp_w.asp_r.isotopic nav.asp_navigation ul li.asp_active {
    background: rgba(255, 255, 255, 0.6);
}

div.asp_w.asp_r.isotopic nav.asp_navigation ul li:hover {
    background: rgba(255, 255, 255, 0.6);
}

div.asp_w.asp_r.isotopic nav.asp_navigation ul li span {
    font-family: sans-serif;
    font-size: 11px;
    vertical-align: middle;
    color: #333;
    line-height: 36px;
    font-weight: bold;
    text-shadow: none;
}

div.asp_w.asp_r.isotopic .results .item {
    box-sizing: border-box;
    background-clip: padding-box;
    border: 0px solid rgba(0, 0, 0, 0);
}

div.asp_w.asp_r.isotopic .results .item .asp_item_overlay,
div.asp_w.asp_r.isotopic .results .item .asp_item_overlay_m{
    width: 100%;
    height: 100%;
    position: absolute;
    text-align: center;
    background: rgba(0, 0, 0, 0.2);
    top: 0;
    left: 0;
    display: block;
	opacity: 0;
    z-index: 4;
    cursor: pointer;
	transition: all 0.3s;
}

div.asp_w.asp_r.isotopic .results .item .asp_item_overlay_m {
    display: block;
    background: transparent;
}

div.asp_w.asp_r.isotopic .results .item .asp_item_inner {
    position: absolute;
    top: 50%;
    left: 50%;
    width: 70px;
    height: 70px;
    margin: -35px 0 0 -35px;
    background: #ddd;
    box-sizing: padding-box;
    border-radius: 50%;
    background: rgba(0, 0, 0, 0.7);
    text-align: center;
    z-index: 2;
    line-height: 66px;
}

div.asp_w.asp_r.isotopic .results .item .asp_item_inner svg,
div.asp_w.asp_r.isotopic .results .item .asp_item_inner img {
    height: 100%;
    width: 32px;
    fill: #fff;
    display: inline-block;
}

div.asp_w.asp_r.isotopic .results .item .asp_item_inner img {
    height: 32px;
    vertical-align: middle;
    display: inline-block;
}


div.asp_w.asp_r.isotopic .results .item .asp_content  {
    width: 100%;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    background: rgba(255, 255, 255, 0.8);
    border: 0;
    backface-visibility: visible;
    -webkit-backface-visibility: visible;
    box-sizing: border-box;
    z-index: 3;
    padding: 4px 6px;
}

div.asp_w.asp_r.isotopic .results .item .asp_image+.asp_content  {
    height: auto;
    top: auto;
    bottom: 0;
}

div.asp_w.asp_r.isotopic .results .item .asp_image {
    width: 100%;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 1;
    backface-visibility: hidden;
    -webkit-backface-visibility: hidden;
    background-size: cover;
    background-position: center;
}

div.asp_w.asp_r.isotopic .results .item .asp_item_overlay_img {
    width: 100%;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    z-index: 3;
    filter: url('#aspblur');
    -moz-filter: url('#aspblur');
    -webkit-filter: url('#aspblur');
    -ms-filter: url('#aspblur');
    -o-filter: url('#aspblur');
	transition: all 0.2s;
    display: block;
	opacity: 0;
    cursor: pointer;
    -webkit-background-size: cover;
    -moz-background-size: cover;
    -o-background-size: cover;
    background-size: cover;
    background-position: center;
}
/*[isotopic]*/

/*      4.4 POLAROID RESULT STYLES
\**********************************************************************************************************************/
/*[polaroid]*/
div.asp_w.asp_r .photostack,
div.asp_w.asp_r .photostack * {
    -webkit-box-sizing: border-box; /* Safari/Chrome, other WebKit */
    -moz-box-sizing: border-box; /* Firefox, other Gecko */
    -ms-box-sizing: border-box;
    -o-box-sizing: border-box;
    box-sizing: border-box;
}

div.asp_w.asp_r .photostack {
    background: transparent;
    position: relative;
    text-align: center;
    overflow: hidden;
}

div.asp_w.asp_r .photostack-start {
    cursor: pointer;
}

div.asp_w.asp_r .photostack > div {
    width: 100%;
    height: 100%;
    margin: 0 auto;
}

.js div.asp_w.asp_r .photostack figure {
    position: absolute;
    display: block;
    margin: 0;
}

div.asp_w.asp_r figure .asp_image {
    outline: none;
    display: block;
    background: #f9f9f9;
    background-position: center;
    background-size: cover;
    position: relative;
}

div.asp_w.asp_r .photostack-back {
    display: none;
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    background: #fff;
    padding: 50px 40px;
    text-align: left;
}

div.asp_w.asp_r .photostack-back p {
    margin: 0;
}

div.asp_w.asp_r .photostack-back p span {
    text-decoration: line-through;
}

/* Navigation dots */
div.asp_w.asp_r .photostack nav {
    position: absolute;
    width: 100%;
    bottom: 30px;
    z-index: 90;
    text-align: center;
    left: 0;
    -webkit-transition: opacity 0.3s;
    transition: opacity 0.3s;
}

div.asp_w.asp_r .photostack-start nav {
    opacity: 0;
}

div.asp_w.asp_r .photostack nav span {
    position: relative;
    display: inline-block;
    margin: 0 5px;
    width: 30px;
    height: 30px;
    cursor: pointer;
    background: #aaa;
    border-radius: 50%;
    text-align: center;
    -webkit-transition: -webkit-transform 0.6s ease-in-out, background 0.3s;
    transition: transform 0.6s ease-in-out, background 0.3s;
    -webkit-transform: scale(0.48);
    transform: scale(0.48);
}

div.asp_w.asp_r .photostack nav span:last-child {
    margin-right: 0;
}

div.asp_w.asp_r .photostack nav span::after {
    content: "\e801";
    font-family: 'asppsicons2';
    font-size: 80%;
    speak: none;
    display: inline-block;
    vertical-align: top;
    font-style: normal;
    font-weight: normal;
    font-variant: normal;
    text-transform: none;
    line-height: 30px;
    color: #fff;
    opacity: 0;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-transition: opacity 0.3s;
    transition: opacity 0.3s;
}

div.asp_w.asp_r .photostack nav span.current {
    background: #888;
    -webkit-transform: scale(1);
    transform: scale(1);
}

div.asp_w.asp_r .photostack nav span.current.flip {
    -webkit-transform: scale(1) rotateY(-180deg) translateZ(-1px);
    transform: scale(1) rotateY(-180deg) translateZ(-1px);
    background: #555;
}

div.asp_w.asp_r .photostack nav span.flippable::after {
    opacity: 1;
    -webkit-transition-delay: 0.4s;
    transition-delay: 0.4s;
}

.js div.asp_w.asp_r .photostack::before {
    content: '';
    position: absolute;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    top: 0;
    left: 0;
    z-index: 100;
    -webkit-transition: opacity 0.3s, visibility 0s 0.3s;
    transition: opacity 0.3s, visibility 0s 0.3s;
}

.js div.asp_w.asp_r .photostack-start::before {
    -webkit-transition: opacity 0.3s;
    transition: opacity 0.3s;
}

/* Button on photostack container */
.js div.asp_w.asp_r .photostack::after {
    content: 'View Gallery';
    font-weight: 400;
    position: absolute;
    border: 3px solid #fff;
    text-align: center;
    white-space: nowrap;
    left: 50%;
    top: 50%;
    -webkit-transform: translateY(-50%) translateX(-50%);
    transform: translateY(-50%) translateX(-50%);
    padding: 10px 20px;
    color: #fff;
    text-transform: uppercase;
    letter-spacing: 1px;
    cursor: pointer;
    z-index: 101;
}

.js div.asp_w.asp_r .photostack::before,
.js div.asp_w.asp_r .photostack::after {
    opacity: 0;
    visibility: hidden;
}

.js div.asp_w.asp_r .photostack-start::before,
.js div.asp_w.asp_r .photostack-start:hover::after,
.touch .photostack-start::after {
    opacity: 1;
    visibility: visible;
}

div.asp_w.asp_r .photostack figure::after {
    content: '';
    position: absolute;
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    visibility: visible;
    opacity: 1;
    background: rgba(0, 0, 0, 0.05);
    -webkit-transition: opacity 0.6s;
    transition: opacity 0.6s;
}

/* Hide figure overlay when it becomes current */
div.asp_w.asp_r figure.photostack-current::after {
    -webkit-transition: opacity 0.6s, visibility 0s 0.6s;
    transition: opacity 0.6s, visibility 0s 0.6s;
    opacity: 0;
    visibility: hidden;
}

/* Special classes for transitions and perspective */
div.asp_w.asp_r .photostack-transition figure {
    -webkit-transition: -webkit-transform 0.6s ease-in-out;
    transition: transform 0.6s ease-in-out;
}

div.asp_w.asp_r .photostack-perspective {
    -webkit-perspective: 1800px;
    perspective: 1800px;
}

div.asp_w.asp_r .photostack-perspective > div,
div.asp_w.asp_r .photostack-perspective figure {
    -webkit-transform-style: preserve-3d;
    transform-style: preserve-3d;
}

div.asp_w.asp_r .photostack-perspective figure,
div.asp_w.asp_r .photostack-perspective figure div {
    -webkit-backface-visibility: hidden;
    backface-visibility: hidden;
}

div.asp_w.asp_r .photostack-perspective figure.photostack-flip {
    -webkit-transform-origin: 0% 50%;
    transform-origin: 0% 50%;
}

.csstransformspreserve3d figure.photostack-flip .photostack-back {
    -webkit-transform: rotateY(180deg) !important;
    transform: rotateY(180deg) !important;
    display: block !important;
    z-index: 1 !important;
}

.no-csstransformspreserve3d figure.photostack-showback .photostack-back {
    display: block !important;
}

/* The no-JS fallback look does not need to be boring ;) */
.no-js .photostack figure {
    box-shadow: -2px 2px 0 rgba(0, 0, 0, 0.05) !important;
}

.no-js .photostack figure::after {
    display: none !important;
}

.no-js .photostack figure:nth-child(3n) {
    -webkit-transform: translateX(-10%) rotate(5deg) !important;
    transform: translateX(-10%) rotate(5deg) !important;
}

.no-js .photostack figure:nth-child(3n-2) {
    -webkit-transform: translateY(10%) rotate(-3deg) !important;
    transform: translateY(10%) rotate(-3deg) !important;
}
/*[polaroid]*/

/*  *******************************************************************************************************************\
    5. SETTINGS STYLES
\**********************************************************************************************************************/
/*[settings]*/
div.asp_w.asp_s.searchsettings {
    width: auto;
    height: auto;
    position: absolute;
    display: none;
    z-index: 11001;
    border-radius: 0 0 3px 3px;
    visibility: hidden;
    opacity: 0;
    overflow: visible;
}

div.asp_w.asp_sb.searchsettings {
    display: none;
    visibility: hidden;
    direction: ltr;
    overflow: visible;
    position: relative;
    z-index: 1;
}

div.asp_w.asp_sb.searchsettings .asp_sett_scroll::-webkit-scrollbar-thumb {
	background: transparent;
	border-radius: 5px;
	border: none;
}

div.asp_w.asp_s.searchsettings form,
div.asp_w.asp_sb.searchsettings form {
    display: flex;
    flex-wrap: wrap;
    /* some themes like to add un-removable margin and padding.. */
    margin: 0 0 12px 0 !important;
    padding: 0 !important;
}

div.asp_w.asp_s.searchsettings .asp_option_inner,
div.asp_w.asp_sb.searchsettings .asp_option_inner,
div.asp_w.asp_sb.searchsettings input[type='text']{
    margin: 2px 10px 0 10px;
    *padding-bottom: 10px;
}

div.asp_w.asp_s.searchsettings input[type='text']:not(.asp_select2-search__field),
div.asp_w.asp_sb.searchsettings input[type='text']:not(.asp_select2-search__field) {
    width: 86% !important;
    padding: 8px 6px !important;
    margin: 0 0 0 10px !important;
    background-color: #FAFAFA !important;
    font-size: 13px;
    border: none !important;
    line-height: 17px;
    height: 20px;
}

div.asp_w.asp_s.searchsettings.ie78 .asp_option_inner,
div.asp_w.asp_sb.searchsettings.ie78 .asp_option_inner {
    margin-bottom: 0 !important;
    padding-bottom: 0 !important;
}

div.asp_w.asp_s.searchsettings div.asp_option_label,
div.asp_w.asp_sb.searchsettings div.asp_option_label {
    font-size: 14px;
    line-height: 20px !important;
    margin: 0;
    width: 150px;
    text-shadow: none;
    padding: 0;
    min-height: 20px;
    border: none;
    background: transparent;
    float: none;
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
}

div.asp_w.asp_s.searchsettings .asp_label,
div.asp_w.asp_sb.searchsettings .asp_label {
    line-height: 24px !important;
    vertical-align: middle;
    display: inline-block;
    cursor: pointer;
}

div.asp_w.asp_s.searchsettings input[type=radio],
div.asp_w.asp_sb.searchsettings input[type=radio] {
    vertical-align: middle;
    margin: 0 6px 0 17px;
    display: inline-block;
    appearance: normal;
    -moz-appearance: normal; /* Firefox */
    -webkit-appearance: radio; /* Safari and Chrome */
}


/* SQUARED THREE */
div.asp_w.asp_s.searchsettings .asp_option_inner input[type=checkbox],
div.asp_w.asp_sb.searchsettings .asp_option_inner input[type=checkbox] {
    display: none !important;
}

div.asp_w.asp_s.searchsettings.ie78 .asp_option_inner input[type=checkbox],
div.asp_w.asp_sb.searchsettings.ie78 .asp_option_inner input[type=checkbox]{
    display: block;
}

div.asp_w.asp_s.searchsettings.ie78 div.asp_option_label,
div.asp_w.asp_sb.searchsettings.ie78 div.asp_option_label{
    float: right !important;
}

div.asp_w.asp_s.searchsettings .asp_option_inner,
div.asp_w.asp_sb.searchsettings .asp_option_inner {
    width: 17px;
    height: 17px;
    position: relative;
    flex-grow: 0;
    -webkit-flex-grow: 0;
    flex-shrink: 0;
    -webkit-flex-shrink: 0;
}

div.asp_w.asp_sb.searchsettings .asp_option_inner {
    border-radius: 3px;
    background: rgb(66, 66, 66);
    box-shadow: none;
}

div.asp_w.asp_s.searchsettings .asp_option_inner label,
div.asp_w.asp_sb.searchsettings .asp_option_inner label {
    cursor: pointer;
    position: absolute;
    width: 17px;
    height: 17px;
    top: 0;
    padding: 0;
    border-radius: 2px;
    box-shadow: none;
    font-size: 0px !important;
    color: rgba(0, 0, 0, 0);
}

div.asp_w.asp_s.searchsettings.ie78 .asp_option_inner label,
div.asp_w.asp_sb.searchsettings.ie78 .asp_option_inner label {
    display: none;
}

div.asp_w.asp_s.searchsettings .asp_option_inner label:before,
div.asp_w.asp_sb.searchsettings .asp_option_inner label:before{
    display: none !important;
}

div.asp_w.asp_s.searchsettings .asp_option_inner label:after,
div.asp_w.asp_sb.searchsettings .asp_option_inner label:after{
    opacity: 0;
    font-family: 'asppsicons2';
    content: "\e800";
    background: transparent;
    border-top: none;
    border-right: none;
    box-sizing: content-box;
    height: 100%;
    width: 100%;
    padding: 0 !important;
    position: absolute;
    top: 0;
    left: 0;
}

div.asp_w.asp_s.searchsettings.ie78 .asp_option_inner label:after,
div.asp_w.asp_sb.searchsettings.ie78 .asp_option_inner label:after{
    display: none;
}

div.asp_w.asp_s.searchsettings .asp_option_inner label:hover::after,
div.asp_w.asp_sb.searchsettings .asp_option_inner label:hover::after{
    opacity: 0.3;
}

div.asp_w.asp_s.searchsettings .asp_option_inner input[type=checkbox]:checked ~ label:after,
div.asp_w.asp_sb.searchsettings .asp_option_inner input[type=checkbox]:checked ~ label:after {
    opacity: 1;
}

/* foundation.min.js compatibility */
div.asp_w.asp_sb.searchsettings span.checked ~ label:after,
div.asp_w.asp_s.searchsettings span.checked ~ label:after {
    opacity: 1 !important;
}

div.asp_w.asp_s.searchsettings fieldset,
div.asp_w.asp_sb.searchsettings fieldset {
    position: relative;
    float: left;
}

div.asp_w.asp_s.searchsettings fieldset,
div.asp_w.asp_sb.searchsettings fieldset {
    background: transparent;
    font-size: 0.9em;
    /* some themes like to add un-removable margin and padding.. */
    margin: 12px 0 0 !important;
    padding: 0 !important;
    width: 200px;
    min-width: 200px;
}
div.asp_w.asp_sb.searchsettings fieldset:last-child {
    margin: 5px 0 0 !important;
}

div.asp_w.asp_sb.searchsettings fieldset {
    margin: 10px 0 0;
}

div.asp_w.asp_sb.searchsettings fieldset legend {
    padding: 0 0 0 10px;
    margin: 0;
    font-weight: normal;
    font-size: 13px;
}

div.asp_w.asp_sb.searchsettings .asp_option,
div.asp_w.asp_s.searchsettings .asp_option {
    display: flex;
    flex-direction: row;
    -webkit-flex-direction: row;
    align-items: flex-start;
    margin: 0 0 10px 0;
    cursor: pointer;
}

div.asp_w.asp_s.searchsettings .asp_option.asp-o-last,
div.asp_w.asp_s.searchsettings .asp_option:last-child {
    margin-bottom: 0;
}

div.asp_w.asp_s.searchsettings fieldset .asp_option,
div.asp_w.asp_s.searchsettings fieldset .asp_option_cat,
div.asp_w.asp_sb.searchsettings fieldset .asp_option,
div.asp_w.asp_sb.searchsettings fieldset .asp_option_cat {
    width: auto;
    max-width: none;
}

div.asp_w.asp_s.searchsettings fieldset .asp_option_cat_level-1,
div.asp_w.asp_sb.searchsettings fieldset .asp_option_cat_level-1 {
    margin-left: 12px;
}

div.asp_w.asp_s.searchsettings fieldset .asp_option_cat_level-2,
div.asp_w.asp_sb.searchsettings fieldset .asp_option_cat_level-2 {
    margin-left: 24px;
}

div.asp_w.asp_s.searchsettings fieldset .asp_option_cat_level-3,
div.asp_w.asp_sb.searchsettings fieldset .asp_option_cat_level-3 {
    margin-left: 36px;
}

div.asp_w.asp_s.searchsettings fieldset div.asp_option_label,
div.asp_w.asp_sb.searchsettings fieldset div.asp_option_label {
    width: 70%;
    display: block;
}

div.asp_w.asp_s.searchsettings fieldset div.asp_option_label {
    width: auto;
    display: block;
    box-sizing: border-box;
}

div.asp_w.asp_s.searchsettings fieldset .asp_option_cat_level-2 div.asp_option_label {
    padding-right: 12px;
}

div.asp_w.asp_s.searchsettings fieldset .asp_option_cat_level-3 div.asp_option_label {
    padding-right: 24px;
}

div.asp_w.asp_s select,
div.asp_w.asp_sb select {
    width: 100%;
    max-width: 100%;
    border-radius: 0;
    padding: 5px !important;
    background: #f9f9f9;
    background-clip: padding-box;
    -webkit-box-shadow: none;
    box-shadow: none;
    margin: 0;
    border: none;
    color: #111;
    margin-bottom: 0px !important;
    box-sizing: border-box;
    line-height: initial;
    outline: none !important;
    font-family: Roboto, Helvetica;
    font-size: 14px;
    height: 34px;
    min-height: unset !important;
}

div.asp_w.asp_s select[multiple],
div.asp_w.asp_sb select[multiple] {
    background: #ffffff;
}

div.asp_w.asp_s select:not([multiple]),
div.asp_w.asp_sb select:not([multiple]) {
    overflow: hidden !important;
}

/*  *******************************************************************************************************************\
    6. CUSTOM FIELD FIELDSETS
\**********************************************************************************************************************/

div.ajaxsearchpro.searchsettings  fieldset.asp_custom_f {
	margin-top: 9px;
}

/* Give the legend elements some margin... */
div.ajaxsearchpro.searchsettings  fieldset legend {
	margin-bottom: 8px !important;
	-webkit-touch-callout: none;
	-webkit-user-select: none;
	-moz-user-select: none;
	-ms-user-select: none;
	user-select: none;
}

/* .. but exclude some cases where checkboxes are presented */
div.ajaxsearchpro.searchsettings  fieldset legend + div.asp_option_inner {
	margin-top: 0px !important;
}
div.ajaxsearchpro.searchsettings .asp_sett_scroll > .asp_option_cat:first-child > .asp_option_inner {
	margin-top: 0px !important;
}

div.ajaxsearchpro.searchsettings  fieldset .asp_select_single,
div.ajaxsearchpro.searchsettings  fieldset .asp_select_multiple {
	padding: 0 10px;
}

/*  *******************************************************************************************************************\
    7. ARROW BOX
\**********************************************************************************************************************/
.asp_arrow_box {
	position: absolute;
	background: #444;
	padding: 12px;
	color: white;
	border-radius: 4px;
	font-size: 14px;
	max-width: 240px;
	display: none;
	z-index: 99999999999999999;
}
.asp_arrow_box:after {
	top: 100%;
	left: 50%;
	border: solid transparent;
	content: " ";
	height: 0;
	width: 0;
	position: absolute;
	pointer-events: none;
	border-color: transparent;
	border-top-color: #444;
	border-width: 6px;
	margin-left: -6px;
}

.asp_arrow_box.asp_arrow_box_bottom:after {
	bottom: 100%;
	top: unset;
	border-bottom-color: #444;
	border-top-color: transparent;
}
/*[settings]*/

/*  *******************************************************************************************************************\
    8. COLUMN STYLES
\**********************************************************************************************************************/

.asp_two_column {
    margin: 8px 0 12px 0;
}

.asp_two_column .asp_two_column_first,
.asp_two_column .asp_two_column_last {
    width: 48%;
    padding: 1% 2% 1% 0;
    float: left;
    box-sizing: content-box;
}

.asp_two_column .asp_two_column_last {
    padding: 1% 0% 1% 2%;
}

.asp_shortcodes_container {
    display: -webkit-flex;
    display: flex;
    -webkit-flex-wrap: wrap;
    flex-wrap: wrap;
    margin: -10px 0 12px -10px;
    box-sizing: border-box;
}

.asp_shortcodes_container .asp_shortcode_column {
    -webkit-flex-grow: 0;
    flex-grow: 0;
    -webkit-flex-shrink: 1;
    flex-shrink: 1;
    min-width: 120px;
    padding: 10px 0 0 10px;
    flex-basis: 33%;
    -webkit-flex-basis: 33%;
    box-sizing: border-box;
}

/*  *******************************************************************************************************************\
    9. NO-UI DRAGGER STYLES
\**********************************************************************************************************************/
/*[noui]*/
/* OLD STYLES BELOW */
div.ajaxsearchpro.searchsettings .asp_noui_lu,
div.asp_w.asp_sb .asp_noui_lu {
    width: auto;
    max-width: 100%;
    margin-left: 18px;
    margin-right: 18px;
}

div.ajaxsearchpro.searchsettings .asp_noui_l_pre,
div.ajaxsearchpro.searchsettings .slider-handles-low,
div.ajaxsearchpro.searchsettings .asp_noui_l_suff {
    float: left;
    color: #444;
}

div.ajaxsearchpro.searchsettings .asp_noui_u_pre,
div.ajaxsearchpro.searchsettings .slider-handles-up,
div.ajaxsearchpro.searchsettings .asp_noui_u_suff {
    float: right;
    color: #444;
}

div.ajaxsearchpro.searchsettings .noUi-target,
div.ajaxsearchpro.searchsettings .noUi-target * {
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    -ms-touch-action: none;
    -ms-user-select: none;
    -moz-user-select: none;
    -moz-box-sizing: border-box;
    box-sizing: border-box;
}
div.ajaxsearchpro.searchsettings .noUi-target {
    position: relative;
    width: auto;
    max-width: 100%;
    margin: 9px 18px 10px 18px;
}
div.ajaxsearchpro.searchsettings .noUi-base {
    width: 100%;
    height: 100%;
    position: relative;
}
div.ajaxsearchpro.searchsettings .noUi-origin {
    position: absolute;
    right: 0;
    top: 0;
    left: 0;
    bottom: 0;
}
div.ajaxsearchpro.searchsettings .noUi-handle {
    position: absolute;
    z-index: 1;
}
div.ajaxsearchpro.searchsettings .noUi-stacking .noUi-handle {
    /* This class is applied to the lower origin when
       its values is > 50%. */
    z-index: 10;
}
div.ajaxsearchpro.searchsettings .noUi-stacking + .noUi-origin {
    /* Fix stacking order in IE7, which incorrectly
       creates a new context for the origins. */
    *z-index: -1;
}
div.ajaxsearchpro.searchsettings .noUi-state-tap .noUi-origin {
    -webkit-transition: left 0.3s, top 0.3s;
    transition: left 0.3s, top 0.3s;
}
div.ajaxsearchpro.searchsettings .noUi-state-drag * {
    cursor: inherit !important;
}

div.ajaxsearchpro.searchsettings .noUi-base {
    /* NOTE: do NOT use translate3d(), it is buggy on Chrome, hides the dragger in some cases */
    -webkit-transform: translate(0,0);
    transform: translate(0,0);
}

div.ajaxsearchpro.searchsettings .noUi-horizontal {
    height: 8px;
}
div.ajaxsearchpro.searchsettings .noUi-horizontal .noUi-handle {
    width: 22px;
    height: 22px;
    left: -8px;
    top: -7px;
}
div.ajaxsearchpro.searchsettings .noUi-vertical {
    width: 18px;
}
div.ajaxsearchpro.searchsettings .noUi-vertical .noUi-handle {
    width: 28px;
    height: 34px;
    left: -6px;
    top: -17px;
}

html:not([dir="rtl"]) div.ajaxsearchpro.searchsettings .noUi-horizontal .noUi-handle {
    right: -8px;
    left: auto;
}

div.ajaxsearchpro.searchsettings .noUi-background {
    background: #FAFAFA;
    box-shadow: inset 0 1px 1px #f0f0f0;
}
div.ajaxsearchpro.searchsettings .noUi-connect {
    background: #3FB8AF;
    box-shadow: inset 0 0 3px rgba(51,51,51,0.45);
    -webkit-transition: background 450ms;
    transition: background 450ms;
}

div.ajaxsearchpro.searchsettings .noUi-vertical .noUi-origin {
    width: 0;
}
div.ajaxsearchpro.searchsettings .noUi-horizontal .noUi-origin {
    height: 0;
}

div.ajaxsearchpro.searchsettings .noUi-origin {
    border-radius: 2px;
}
div.ajaxsearchpro.searchsettings .noUi-target {
    border-radius: 4px;
    box-shadow: 0 0 4px -1px rgba(0,0,0,0.45);
    background: white;
}
div.ajaxsearchpro.searchsettings .noUi-target.noUi-connect {
    box-shadow: inset 0 0 3px rgba(51,51,51,0.45), 0 3px 6px -5px #BBB;
}

div.ajaxsearchpro.searchsettings .noUi-dragable {
    cursor: w-resize;
}
div.ajaxsearchpro.searchsettings .noUi-vertical .noUi-dragable {
    cursor: n-resize;
}
div.ajaxsearchpro.searchsettings .noUi-handle {
    border: none;
    border-radius: 3px;
    background: #FFF;
    cursor: default;
    box-shadow: 0 0 4px -1px rgba(0,0,0,0.45);
    cursor: pointer;
}
div.ajaxsearchpro.searchsettings .noUi-active {
    box-shadow: 0 0 7px -2px rgba(0,0,0,0.45);
}

div.ajaxsearchpro.searchsettings .noUi-handle:before,
div.ajaxsearchpro.searchsettings .noUi-handle:after {
    content: "";
    display: block;
    position: absolute;
    height: 9px;
    width: 1px;
    background: #E8E7E6;
    left: 12px;
    top: 6px;
}
div.ajaxsearchpro.searchsettings .noUi-handle:after {
    left: 9px;
}
div.ajaxsearchpro.searchsettings .noUi-vertical .noUi-handle:before,
div.ajaxsearchpro.searchsettings .noUi-vertical .noUi-handle:after {
    width: 14px;
    height: 1px;
    left: 6px;
    top: 14px;
}
div.ajaxsearchpro.searchsettings .noUi-vertical .noUi-handle:after {
    top: 17px;
}
/*[noui]*/

/*  *******************************************************************************************************************\
    10. SUGGESTED KEYWORDS
\**********************************************************************************************************************/

p.asp-try {
    color: #555;
    font-size: 14px;
    margin-top: 5px;
    line-height: 28px;
    font-weight: 300;
    visibility: hidden;
}

p.asp-try a {
    color: #FFB556;
    margin-left: 10px;
    cursor: pointer;
    display: inline-block;
}

/*  *******************************************************************************************************************\
    11. SCROLLBAR STYLES
\**********************************************************************************************************************/
/*[simplebar]*/
/* NEW SIMPLEBAR SCROLLBAR */
[data-asp_simplebar] {
    position: relative;
    flex-direction: column;
    flex-wrap: wrap;
    justify-content: flex-start;
    align-content: flex-start;
    align-items: flex-start;
}

.asp_simplebar-wrapper {
    overflow: hidden;
    width: inherit;
    height: inherit;
    max-width: inherit;
    max-height: inherit;
}

.asp_simplebar-mask {
    direction: inherit;
    position: absolute;
    overflow: hidden;
    padding: 0;
    margin: 0;
    left: 0;
    top: 0;
    bottom: 0;
    right: 0;
    width: auto !important;
    height: auto !important;
    z-index: 0;
}

.asp_simplebar-offset {
    direction: inherit !important;
    box-sizing: inherit !important;
    resize: none !important;
    position: absolute;
    top: 0;
    left: 0;
    bottom: 0;
    right: 0;
    padding: 0;
    margin: 0;
    -webkit-overflow-scrolling: touch;
}

.asp_simplebar-content-wrapper {
    direction: inherit;
    box-sizing: border-box !important;
    position: relative;
    display: block;
    height: 100%; /* Required for horizontal native scrollbar to not appear if parent is taller than natural height */
    width: auto;
    visibility: visible;
    max-width: 100%; /* Not required for horizontal scroll to trigger */
    max-height: 100%; /* Needed for vertical scroll to trigger */
    scrollbar-width: none;
}

.asp_simplebar-content-wrapper::-webkit-scrollbar,
.asp_simplebar-hide-scrollbar::-webkit-scrollbar {
    display: none;
}

.asp_simplebar-content:before,
.asp_simplebar-content:after {
    content: ' ';
    display: table;
}

.asp_simplebar-placeholder {
    max-height: 100%;
    max-width: 100%;
    width: 100%;
    pointer-events: none;
}

.asp_simplebar-height-auto-observer-wrapper {
    box-sizing: inherit !important;
    height: 100%;
    width: 100%;
    max-width: 1px;
    position: relative;
    float: left;
    max-height: 1px;
    overflow: hidden;
    z-index: -1;
    padding: 0;
    margin: 0;
    pointer-events: none;
    flex-grow: inherit;
    flex-shrink: 0;
    flex-basis: 0;
}

.asp_simplebar-height-auto-observer {
    box-sizing: inherit;
    display: block;
    opacity: 0;
    position: absolute;
    top: 0;
    left: 0;
    height: 1000%;
    width: 1000%;
    min-height: 1px;
    min-width: 1px;
    overflow: hidden;
    pointer-events: none;
    z-index: -1;
}

.asp_simplebar-track {
    z-index: 1;
    position: absolute;
    right: 0;
    bottom: 0;
    pointer-events: none;
    overflow: hidden;
}

[data-asp_simplebar].asp_simplebar-dragging .asp_simplebar-content {
    pointer-events: none;
    user-select: none;
    -webkit-user-select: none;
}

[data-asp_simplebar].asp_simplebar-dragging .asp_simplebar-track {
    pointer-events: all;
}

.asp_simplebar-scrollbar {
    position: absolute;
    right: 2px;
    width: 7px;
    min-height: 10px;
}

.asp_simplebar-scrollbar:before {
    position: absolute;
    content: '';
    background: rgba(0, 0, 0, 0.5);
    border-radius: 7px;
    left: 0;
    right: 0;
    opacity: 0;
    transition: opacity 0.2s linear;
}

.asp_simplebar-scrollbar.asp_simplebar-visible:before {
    /* When hovered, remove all transitions from drag handle */
    opacity: 1;
    transition: opacity 0s linear;
}

.asp_simplebar-track.asp_simplebar-vertical {
    top: 0;
    width: 11px;
    margin-top: 4px !important;
    margin-bottom: 4px !important;
}

.asp_simplebar-track.asp_simplebar-vertical .asp_simplebar-scrollbar:before {
    top: 2px;
    bottom: 2px;
}

.asp_simplebar-track.asp_simplebar-horizontal {
    left: 0;
    height: 11px;
    margin-left: 12px !important;
    margin-right: 12px !important;
}

.asp_simplebar-track.asp_simplebar-horizontal .asp_simplebar-scrollbar:before {
    height: 100%;
    left: 2px;
    right: 2px;
}

.asp_simplebar-track.asp_simplebar-horizontal .asp_simplebar-scrollbar {
    right: auto;
    left: 0;
    top: 2px;
    height: 7px;
    min-height: 0;
    min-width: 10px;
    width: auto;
}

/* Rtl support */
[data-asp_simplebar-direction='rtl'] .asp_simplebar-track.asp_simplebar-vertical {
    right: auto;
    left: 0;
}

.hs-dummy-scrollbar-size {
    direction: rtl;
    position: fixed;
    opacity: 0;
    visibility: hidden;
    height: 500px;
    width: 500px;
    overflow-y: hidden;
    overflow-x: scroll;
}

.asp_simplebar-hide-scrollbar {
    position: fixed;
    left: 0;
    visibility: hidden;
    overflow-y: scroll;
    scrollbar-width: none;
}
/*[simplebar]*/

/*  *******************************************************************************************************************\
    12. DATEPICKER STYLES
\**********************************************************************************************************************/
/*[datepicker]*/
.asp-ui,
.asp-ui * {
    font-size: 12px;
    line-height: 1.75;
    box-sizing: content-box;
}

.ui-helper-hidden { display: none; }
.ui-helper-hidden-accessible { position: absolute !important; clip: rect(1px 1px 1px 1px); clip: rect(1px,1px,1px,1px); }
.ui-helper-reset { margin: 0; padding: 0; border: 0; outline: 0; line-height: 1.3; text-decoration: none; font-size: 100%; list-style: none; }
.ui-helper-clearfix:after { content: "."; display: block; height: 0; clear: both; visibility: hidden; }
.asp-ui.ui-helper-clearfix { display: inline-block; }
/* required comment for clearfix to work in Opera \*/
* html .asp-ui.ui-helper-clearfix { height:1%; }
.asp-ui.ui-helper-clearfix { display:block; }
/* end clearfix */
.ui-helper-zfix { width: 100%; height: 100%; top: 0; left: 0; position: absolute; opacity: 0; }


/* Interaction Cues
----------------------------------*/
.ui-state-disabled { cursor: default !important; }


/* Icons
----------------------------------*/

/* states and images */
.asp-ui .ui-icon { display: block; text-indent: -99999px; overflow: hidden; background-repeat: no-repeat; }


/* Misc visuals
----------------------------------*/

/* Overlays */
.ui-widget-overlay { position: absolute; top: 0; left: 0; width: 100%; height: 100%; }

/* Component containers
----------------------------------*/
.asp-ui.ui-widget { font-family: Verdana,Arial,sans-serif; font-size: 1.1em; }
.asp-ui.ui-widget .asp-ui.ui-widget { font-size: 1em; }
.asp-ui.ui-widget input, .asp-ui.ui-widget select, .asp-ui.ui-widget textarea, .asp-ui.ui-widget button { font-family: Verdana,Arial,sans-serif; font-size: 1em; }
.asp-ui.ui-widget-content {
    border: 1px solid #FFF;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    color: #222222;
    background: #fff;
}
.asp-ui.ui-widget-content a { color: #222222; }
.asp-ui .ui-widget-header {
    background: #2EA2CC;
    color: #e5e5e5;
    font-weight: bold;
    border: 0;
    border-radius: 0 !important;
    width: 100%;
    padding: 8px 3px;
    position: relative;
    margin: -3px;
}

.asp-ui .ui-widget-header a { color: #e5e5e5; }

/* Interaction states
----------------------------------*/
.asp-ui .ui-state-default, .asp-ui.ui-widget-content .ui-state-default, .asp-ui .ui-widget-header .ui-state-default { border: 1px solid #E1E1E1; background: #F9F9F9; font-weight: normal; color: #555555; }
.asp-ui .ui-state-default a, .asp-ui .ui-state-default a:link, .asp-ui .ui-state-default a:visited { color: #555555; text-decoration: none; }
.asp-ui .ui-state-hover, .asp-ui.ui-widget-content .ui-state-hover, .asp-ui .ui-widget-header .ui-state-hover, .asp-ui .ui-state-focus, .asp-ui.ui-widget-content .ui-state-focus, .asp-ui .ui-widget-header .ui-state-focus { border: 1px solid #999999; background: #dadada; font-weight: normal; color: #212121; }
.asp-ui .ui-state-hover a, .ui-state-hover a:hover { color: #212121; text-decoration: none; }
.asp-ui .ui-state-active, .asp-ui.ui-widget-content .ui-state-active, .asp-ui .ui-widget-header .ui-state-active { border: 1px solid #aaaaaa; background: #ffffff; font-weight: normal; color: #212121; }
.asp-ui .ui-state-active a, .ui-state-active a:link, .asp-ui .ui-state-active a:visited { color: #212121; text-decoration: none; }
.asp-ui .asp-ui.ui-widget :active { outline: none; }

/* Interaction Cues
----------------------------------*/
.asp-ui .ui-state-highlight, .asp-ui.ui-widget-content .ui-state-highlight, .asp-ui .ui-widget-header .ui-state-highlight  {border: 1px solid #1cb1f2; background: #5bc6f5; color: #ffffff; }
.asp-ui .ui-state-highlight a, .asp-ui.ui-widget-content .ui-state-highlight a,.asp-ui .ui-widget-header .ui-state-highlight a { color: #ffffff; }
.asp-ui .ui-state-error, .asp-ui.ui-widget-content .ui-state-error, .asp-ui .ui-widget-header .ui-state-error {border: 1px solid #cd0a0a; background: #fef1ec; color: #cd0a0a; }
.asp-ui .ui-state-error a, .asp-ui.ui-widget-content .ui-state-error a, .asp-ui .ui-widget-header .ui-state-error a { color: #cd0a0a; }
.asp-ui .ui-state-error-text, .asp-ui.ui-widget-content .ui-state-error-text, .asp-ui .ui-widget-header .ui-state-error-text { color: #cd0a0a; }
.asp-ui .ui-priority-primary, .asp-ui.ui-widget-content .ui-priority-primary, .asp-ui .ui-widget-header .ui-priority-primary { font-weight: bold; }
.asp-ui .ui-priority-secondary, .asp-ui.ui-widget-content .ui-priority-secondary,  .asp-ui .ui-widget-header .ui-priority-secondary { opacity: .7; font-weight: normal; }
.asp-ui .ui-state-disabled, .asp-ui.ui-widget-content .ui-state-disabled, .asp-ui .ui-widget-header .ui-state-disabled { opacity: .35; background-image: none; }

/* positioning */
.asp-ui .ui-icon-carat-1-n { background-position: 0 0; }
.asp-ui .ui-icon-carat-1-ne { background-position: -16px 0; }
.asp-ui .ui-icon-carat-1-e { background-position: -32px 0; }
.asp-ui .ui-icon-carat-1-se { background-position: -48px 0; }
.asp-ui .ui-icon-carat-1-s { background-position: -64px 0; }
.asp-ui .ui-icon-carat-1-sw { background-position: -80px 0; }
.asp-ui .ui-icon-carat-1-w { background-position: -96px 0; }
.asp-ui .ui-icon-carat-1-nw { background-position: -112px 0; }
.asp-ui .ui-icon-carat-2-n-s { background-position: -128px 0; }
.asp-ui .ui-icon-carat-2-e-w { background-position: -144px 0; }
.asp-ui .ui-icon-triangle-1-n { background-position: 0 -16px; }
.asp-ui .ui-icon-triangle-1-ne { background-position: -16px -16px; }
.asp-ui .ui-icon-triangle-1-e { background-position: -32px -16px; }
.asp-ui .ui-icon-triangle-1-se { background-position: -48px -16px; }
.asp-ui .ui-icon-triangle-1-s { background-position: -64px -16px; }
.asp-ui .ui-icon-triangle-1-sw { background-position: -80px -16px; }
.asp-ui .ui-icon-triangle-1-w { background-position: -96px -16px; }
.asp-ui .ui-icon-triangle-1-nw { background-position: -112px -16px; }
.asp-ui .ui-icon-triangle-2-n-s { background-position: -128px -16px; }
.asp-ui .ui-icon-triangle-2-e-w { background-position: -144px -16px; }
.asp-ui .ui-icon-arrow-1-n { background-position: 0 -32px; }
.asp-ui .ui-icon-arrow-1-ne { background-position: -16px -32px; }
.asp-ui .ui-icon-arrow-1-e { background-position: -32px -32px; }
.asp-ui .ui-icon-arrow-1-se { background-position: -48px -32px; }
.asp-ui .ui-icon-arrow-1-s { background-position: -64px -32px; }
.asp-ui .ui-icon-arrow-1-sw { background-position: -80px -32px; }
.asp-ui .ui-icon-arrow-1-w { background-position: -96px -32px; }
.asp-ui .ui-icon-arrow-1-nw { background-position: -112px -32px; }
.asp-ui .ui-icon-arrow-2-n-s { background-position: -128px -32px; }
.asp-ui .ui-icon-arrow-2-ne-sw { background-position: -144px -32px; }
.asp-ui .ui-icon-arrow-2-e-w { background-position: -160px -32px; }
.asp-ui .ui-icon-arrow-2-se-nw { background-position: -176px -32px; }
.asp-ui .ui-icon-arrowstop-1-n { background-position: -192px -32px; }
.asp-ui .ui-icon-arrowstop-1-e { background-position: -208px -32px; }
.asp-ui .ui-icon-arrowstop-1-s { background-position: -224px -32px; }
.asp-ui .ui-icon-arrowstop-1-w { background-position: -240px -32px; }
.asp-ui .ui-icon-arrowthick-1-n { background-position: 0 -48px; }
.asp-ui .ui-icon-arrowthick-1-ne { background-position: -16px -48px; }
.asp-ui .ui-icon-arrowthick-1-e { background-position: -32px -48px; }
.asp-ui .ui-icon-arrowthick-1-se { background-position: -48px -48px; }
.asp-ui .ui-icon-arrowthick-1-s { background-position: -64px -48px; }
.asp-ui .ui-icon-arrowthick-1-sw { background-position: -80px -48px; }
.asp-ui .ui-icon-arrowthick-1-w { background-position: -96px -48px; }
.asp-ui .ui-icon-arrowthick-1-nw { background-position: -112px -48px; }
.asp-ui .ui-icon-arrowthick-2-n-s { background-position: -128px -48px; }
.asp-ui .ui-icon-arrowthick-2-ne-sw { background-position: -144px -48px; }
.asp-ui .ui-icon-arrowthick-2-e-w { background-position: -160px -48px; }
.asp-ui .ui-icon-arrowthick-2-se-nw { background-position: -176px -48px; }
.asp-ui .ui-icon-arrowthickstop-1-n { background-position: -192px -48px; }
.asp-ui .ui-icon-arrowthickstop-1-e { background-position: -208px -48px; }
.asp-ui .ui-icon-arrowthickstop-1-s { background-position: -224px -48px; }
.asp-ui .ui-icon-arrowthickstop-1-w { background-position: -240px -48px; }
.asp-ui .ui-icon-arrowreturnthick-1-w { background-position: 0 -64px; }
.asp-ui .ui-icon-arrowreturnthick-1-n { background-position: -16px -64px; }
.asp-ui .ui-icon-arrowreturnthick-1-e { background-position: -32px -64px; }
.asp-ui .ui-icon-arrowreturnthick-1-s { background-position: -48px -64px; }
.asp-ui .ui-icon-arrowreturn-1-w { background-position: -64px -64px; }
.asp-ui .ui-icon-arrowreturn-1-n { background-position: -80px -64px; }
.asp-ui .ui-icon-arrowreturn-1-e { background-position: -96px -64px; }
.asp-ui .ui-icon-arrowreturn-1-s { background-position: -112px -64px; }
.asp-ui .ui-icon-arrowrefresh-1-w { background-position: -128px -64px; }
.asp-ui .ui-icon-arrowrefresh-1-n { background-position: -144px -64px; }
.asp-ui .ui-icon-arrowrefresh-1-e { background-position: -160px -64px; }
.asp-ui .ui-icon-arrowrefresh-1-s { background-position: -176px -64px; }
.asp-ui .ui-icon-arrow-4 { background-position: 0 -80px; }
.asp-ui .ui-icon-arrow-4-diag { background-position: -16px -80px; }
.asp-ui .ui-icon-extlink { background-position: -32px -80px; }
.asp-ui .ui-icon-newwin { background-position: -48px -80px; }
.asp-ui .ui-icon-refresh { background-position: -64px -80px; }
.asp-ui .ui-icon-shuffle { background-position: -80px -80px; }
.asp-ui .ui-icon-transfer-e-w { background-position: -96px -80px; }
.asp-ui .ui-icon-transferthick-e-w { background-position: -112px -80px; }
.asp-ui .ui-icon-folder-collapsed { background-position: 0 -96px; }
.asp-ui .ui-icon-folder-open { background-position: -16px -96px; }
.asp-ui .ui-icon-document { background-position: -32px -96px; }
.asp-ui .ui-icon-document-b { background-position: -48px -96px; }
.asp-ui .ui-icon-note { background-position: -64px -96px; }
.asp-ui .ui-icon-mail-closed { background-position: -80px -96px; }
.asp-ui .ui-icon-mail-open { background-position: -96px -96px; }
.asp-ui .ui-icon-suitcase { background-position: -112px -96px; }
.asp-ui .ui-icon-comment { background-position: -128px -96px; }
.asp-ui .ui-icon-person { background-position: -144px -96px; }
.asp-ui .ui-icon-print { background-position: -160px -96px; }
.asp-ui .ui-icon-trash { background-position: -176px -96px; }
.asp-ui .ui-icon-locked { background-position: -192px -96px; }
.asp-ui .ui-icon-unlocked { background-position: -208px -96px; }
.asp-ui .ui-icon-bookmark { background-position: -224px -96px; }
.asp-ui .ui-icon-tag { background-position: -240px -96px; }
.asp-ui .ui-icon-home { background-position: 0 -112px; }
.asp-ui .ui-icon-flag { background-position: -16px -112px; }
.asp-ui .ui-icon-calendar { background-position: -32px -112px; }
.asp-ui .ui-icon-cart { background-position: -48px -112px; }
.asp-ui .ui-icon-pencil { background-position: -64px -112px; }
.asp-ui .ui-icon-clock { background-position: -80px -112px; }
.asp-ui .ui-icon-disk { background-position: -96px -112px; }
.asp-ui .ui-icon-calculator { background-position: -112px -112px; }
.asp-ui .ui-icon-zoomin { background-position: -128px -112px; }
.asp-ui .ui-icon-zoomout { background-position: -144px -112px; }
.asp-ui .ui-icon-search { background-position: -160px -112px; }
.asp-ui .ui-icon-wrench { background-position: -176px -112px; }
.asp-ui .ui-icon-gear { background-position: -192px -112px; }
.asp-ui .ui-icon-heart { background-position: -208px -112px; }
.asp-ui .ui-icon-star { background-position: -224px -112px; }
.asp-ui .ui-icon-link { background-position: -240px -112px; }
.asp-ui .ui-icon-cancel { background-position: 0 -128px; }
.asp-ui .ui-icon-plus { background-position: -16px -128px; }
.asp-ui .ui-icon-plusthick { background-position: -32px -128px; }
.asp-ui .ui-icon-minus { background-position: -48px -128px; }
.asp-ui .ui-icon-minusthick { background-position: -64px -128px; }
.asp-ui .ui-icon-close { background-position: -80px -128px; }
.asp-ui .ui-icon-closethick { background-position: -96px -128px; }
.asp-ui .ui-icon-key { background-position: -112px -128px; }
.asp-ui .ui-icon-lightbulb { background-position: -128px -128px; }
.asp-ui .ui-icon-scissors { background-position: -144px -128px; }
.asp-ui .ui-icon-clipboard { background-position: -160px -128px; }
.asp-ui .ui-icon-copy { background-position: -176px -128px; }
.asp-ui .ui-icon-contact { background-position: -192px -128px; }
.asp-ui .ui-icon-image { background-position: -208px -128px; }
.asp-ui .ui-icon-video { background-position: -224px -128px; }
.asp-ui .ui-icon-script { background-position: -240px -128px; }
.asp-ui .ui-icon-alert { background-position: 0 -144px; }
.asp-ui .ui-icon-info { background-position: -16px -144px; }
.asp-ui .ui-icon-notice { background-position: -32px -144px; }
.asp-ui .ui-icon-help { background-position: -48px -144px; }
.asp-ui .ui-icon-check { background-position: -64px -144px; }
.asp-ui .ui-icon-bullet { background-position: -80px -144px; }
.asp-ui .ui-icon-radio-off { background-position: -96px -144px; }
.asp-ui .ui-icon-radio-on { background-position: -112px -144px; }
.asp-ui .ui-icon-pin-w { background-position: -128px -144px; }
.asp-ui .ui-icon-pin-s { background-position: -144px -144px; }
.asp-ui .ui-icon-play { background-position: 0 -160px; }
.asp-ui .ui-icon-pause { background-position: -16px -160px; }
.asp-ui .ui-icon-seek-next { background-position: -32px -160px; }
.asp-ui .ui-icon-seek-prev { background-position: -48px -160px; }
.asp-ui .ui-icon-seek-end { background-position: -64px -160px; }
.asp-ui .ui-icon-seek-start { background-position: -80px -160px; }
/* ui-icon-seek-first is deprecated, use ui-icon-seek-start instead */
.asp-ui .ui-icon-seek-first { background-position: -80px -160px; }
.asp-ui .ui-icon-stop { background-position: -96px -160px; }
.asp-ui .ui-icon-eject { background-position: -112px -160px; }
.asp-ui .ui-icon-volume-off { background-position: -128px -160px; }
.asp-ui .ui-icon-volume-on { background-position: -144px -160px; }
.asp-ui .ui-icon-power { background-position: 0 -176px; }
.asp-ui .ui-icon-signal-diag { background-position: -16px -176px; }
.asp-ui .ui-icon-signal { background-position: -32px -176px; }
.asp-ui .ui-icon-battery-0 { background-position: -48px -176px; }
.asp-ui .ui-icon-battery-1 { background-position: -64px -176px; }
.asp-ui .ui-icon-battery-2 { background-position: -80px -176px; }
.asp-ui .ui-icon-battery-3 { background-position: -96px -176px; }
.asp-ui .ui-icon-circle-plus { background-position: 0 -192px; }
.asp-ui .ui-icon-circle-minus { background-position: -16px -192px; }
.asp-ui .ui-icon-circle-close { background-position: -32px -192px; }
.asp-ui .ui-icon-circle-triangle-e { background-position: -48px -192px; }
.asp-ui .ui-icon-circle-triangle-s { background-position: -64px -192px; }
.asp-ui .ui-icon-circle-triangle-w { background-position: -80px -192px; }
.asp-ui .ui-icon-circle-triangle-n { background-position: -96px -192px; }
.asp-ui .ui-icon-circle-arrow-e { background-position: -112px -192px; }
.asp-ui .ui-icon-circle-arrow-s { background-position: -128px -192px; }
.asp-ui .ui-icon-circle-arrow-w { background-position: -144px -192px; }
.asp-ui .ui-icon-circle-arrow-n { background-position: -160px -192px; }
.asp-ui .ui-icon-circle-zoomin { background-position: -176px -192px; }
.asp-ui .ui-icon-circle-zoomout { background-position: -192px -192px; }
.asp-ui .ui-icon-circle-check { background-position: -208px -192px; }
.asp-ui .ui-icon-circlesmall-plus { background-position: 0 -208px; }
.asp-ui .ui-icon-circlesmall-minus { background-position: -16px -208px; }
.asp-ui .ui-icon-circlesmall-close { background-position: -32px -208px; }
.asp-ui .ui-icon-squaresmall-plus { background-position: -48px -208px; }
.asp-ui .ui-icon-squaresmall-minus { background-position: -64px -208px; }
.asp-ui .ui-icon-squaresmall-close { background-position: -80px -208px; }
.asp-ui .ui-icon-grip-dotted-vertical { background-position: 0 -224px; }
.asp-ui .ui-icon-grip-dotted-horizontal { background-position: -16px -224px; }
.asp-ui .ui-icon-grip-solid-vertical { background-position: -32px -224px; }
.asp-ui .ui-icon-grip-solid-horizontal { background-position: -48px -224px; }
.asp-ui .ui-icon-gripsmall-diagonal-se { background-position: -64px -224px; }
.asp-ui .ui-icon-grip-diagonal-se { background-position: -80px -224px; }


/* Misc visuals
----------------------------------*/

/* Corner radius */
.asp-ui.ui-corner-all, .ui-corner-top, .ui-corner-left, .ui-corner-tl { -moz-border-radius-topleft: 4px; -webkit-border-top-left-radius: 4px; -khtml-border-top-left-radius: 4px; border-top-left-radius: 4px; }
.asp-ui.ui-corner-all, .ui-corner-top, .ui-corner-right, .ui-corner-tr { -moz-border-radius-topright: 4px; -webkit-border-top-right-radius: 4px; -khtml-border-top-right-radius: 4px; border-top-right-radius: 4px; }
.asp-ui.ui-corner-all, .ui-corner-bottom, .ui-corner-left, .ui-corner-bl { -moz-border-radius-bottomleft: 4px; -webkit-border-bottom-left-radius: 4px; -khtml-border-bottom-left-radius: 4px; border-bottom-left-radius: 4px; }
.asp-ui.ui-corner-all, .ui-corner-bottom, .ui-corner-right, .ui-corner-br { -moz-border-radius-bottomright: 4px; -webkit-border-bottom-right-radius: 4px; -khtml-border-bottom-right-radius: 4px; border-bottom-right-radius: 4px; }

/* Overlays */
.ui-widget-overlay { background: #aaaaaa; opacity: .30; }
.ui-widget-shadow { margin: -8px 0 0 -8px; padding: 8px; background: #aaaaaa; opacity: .30; -moz-border-radius: 8px; -khtml-border-radius: 8px; -webkit-border-radius: 8px; border-radius: 8px; }/*
 * jQuery UI Datepicker 1.8.14
 *
 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Datepicker#theming
 */
#ui-datepicker-div {
    z-index: 100000000 !important;
    display: none;
}
.asp-ui.ui-datepicker { width: 17em; padding: .2em .2em 0; display: none; border-radius: 0 !important; }
.asp-ui.ui-datepicker .ui-datepicker-header {  }
.asp-ui.ui-datepicker .ui-datepicker-prev, .asp-ui.ui-datepicker .ui-datepicker-next { position:absolute; top: 2px; width: 1.8em; height: 1.8em; display: none; }
.asp-ui.ui-datepicker .ui-datepicker-prev-hover, .asp-ui.ui-datepicker .ui-datepicker-next-hover { top: 1px; }
.asp-ui.ui-datepicker .ui-datepicker-prev { left:2px; }
.asp-ui.ui-datepicker .ui-datepicker-next { right:2px; }
.asp-ui.ui-datepicker .ui-datepicker-prev-hover { left:1px; }
.asp-ui.ui-datepicker .ui-datepicker-next-hover { right:1px; }
.asp-ui.ui-datepicker .ui-datepicker-prev span, .asp-ui.ui-datepicker .ui-datepicker-next span { display: block; position: absolute; left: 50%; margin-left: -8px; top: 50%; margin-top: -8px;  }
.asp-ui.ui-datepicker .ui-datepicker-title { margin: 0; text-align: center; }
.asp-ui.ui-datepicker .ui-datepicker-title select { font-size:1em; margin:0 0 0 2%; }
.asp-ui.ui-datepicker select.ui-datepicker-month-year {width: 100%;}
.asp-ui.ui-datepicker select.ui-datepicker-month,
.asp-ui.ui-datepicker select.ui-datepicker-year {
    width: 43%;
    padding: 4px;
    font-size: 12px;
    font-weight: normal;
    border: 0;
    height: 20px;
    margin: 3px;
    box-sizing: content-box;
}
.asp-ui.ui-datepicker table {width: 100%; font-size: .9em; border-collapse: collapse; margin:0 0 .4em; border: 0; }
.asp-ui.ui-datepicker th { padding: .7em .3em; text-align: center; font-weight: bold; border: 0; width: 14%; }
.asp-ui.ui-datepicker td { border: 0; padding: 1px; }
.asp-ui.ui-datepicker td span, .asp-ui.ui-datepicker td a { display: block; padding: .2em; text-align: right; text-decoration: none; }
.asp-ui.ui-datepicker .ui-datepicker-buttonpane { background-image: none; margin: .7em 0 0 0; padding:0 .2em; border-left: 0; border-right: 0; border-bottom: 0; }
.asp-ui.ui-datepicker .ui-datepicker-buttonpane button { float: right; margin: .5em .2em .4em; cursor: pointer; padding: .2em .6em .3em .6em; width:auto; overflow:visible; }
.asp-ui.ui-datepicker .ui-datepicker-buttonpane button.ui-datepicker-current { float:left; }

/* with multiple calendars */
.ui-datepicker.ui-datepicker-multi { width:auto; }
.ui-datepicker-multi .ui-datepicker-group { float:left; }
.ui-datepicker-multi .ui-datepicker-group table { width:95%; margin:0 auto .4em; }
.ui-datepicker-multi-2 .ui-datepicker-group { width:50%; }
.ui-datepicker-multi-3 .ui-datepicker-group { width:33.3%; }
.ui-datepicker-multi-4 .ui-datepicker-group { width:25%; }
.ui-datepicker-multi .ui-datepicker-group-last .ui-datepicker-header { border-left-width:0; }
.ui-datepicker-multi .ui-datepicker-group-middle .ui-datepicker-header { border-left-width:0; }
.ui-datepicker-multi .ui-datepicker-buttonpane { clear:left; }
.ui-datepicker-row-break { clear:both; width:100%; font-size:0em; }

/* RTL support */
.ui-datepicker-rtl { direction: rtl; }
.ui-datepicker-rtl .ui-datepicker-prev { right: 2px; left: auto; }
.ui-datepicker-rtl .ui-datepicker-next { left: 2px; right: auto; }
.ui-datepicker-rtl .ui-datepicker-prev:hover { right: 1px; left: auto; }
.ui-datepicker-rtl .ui-datepicker-next:hover { left: 1px; right: auto; }
.ui-datepicker-rtl .ui-datepicker-buttonpane { clear:right; }
.ui-datepicker-rtl .ui-datepicker-buttonpane button { float: left; }
.ui-datepicker-rtl .ui-datepicker-buttonpane button.ui-datepicker-current { float:right; }
.ui-datepicker-rtl .ui-datepicker-group { float:right; }
.ui-datepicker-rtl .ui-datepicker-group-last .ui-datepicker-header { border-right-width:0; border-left-width:1px; }
.ui-datepicker-rtl .ui-datepicker-group-middle .ui-datepicker-header { border-right-width:0; border-left-width:1px; }

/* IE6 IFRAME FIX (taken from datepicker 1.5.3 */
.ui-datepicker-cover {
    display: none; /*sorry for IE5*/
    display/**/: block; /*sorry for IE5*/
    position: absolute; /*must have*/
    z-index: -1; /*must have*/
    filter: mask(); /*must have*/
    top: -4px; /*must have*/
    left: -4px; /*must have*/
    width: 200px; /*must have*/
    height: 200px; /*must have*/
}

.asp-ui.ui-datepicker  .ui-datepicker-buttonpane {
    background: #EAF2FA;
    border-top: 1px solid #E1E1E1;
    width: 100%;
    padding: 3px;
    margin: 0;
    margin: 0 0 0 -3px;
    position: relative;
    overflow: hidden;
}

.asp-ui.ui-datepicker .ui-datepicker-buttonpane button {
    margin: 0;
    padding: 0px;
    font-size: 12px;
    background: transparent;
    border: 0 none;
    text-shadow: 0 1px 0 #FFFFFF;
    color: #7A9BBE;
    opacity: 1;
    display: block;line-height: 1em;
    padding: 5px;
}

.asp-ui.ui-datepicker .ui-state-highlight {
    background: #EAF2FA;
    color: #555555;
    border: 1px solid #95B1CE;
}

.asp-ui.ui-datepicker .ui-state-active {
    background: #2EA2CC;
    color: #FFFFFF;
    border: #0074A2 solid 1px;
}

/* Date filter (post date) */
div.ajaxsearchpro.searchsettings fieldset .asp_post_date_from {
    margin-bottom: 12px;
}
/*[datepicker]*/

/*  *******************************************************************************************************************\
    13. AUTOCOMPLETE STYLES
\**********************************************************************************************************************/
/*[autocomplete]*/
.asp_ac_autocomplete,
.asp_ac_autocomplete div,
.asp_ac_autocomplete span{
    /*	-moz-box-sizing: border-box !important;
        box-sizing: border-box !important;*/
}

.asp_ac_autocomplete {
    display:inline;
    position:relative;
    word-spacing: normal;
    text-transform: none;
    text-indent: 0px;
    text-shadow: none;
    text-align: start;
}

.asp_ac_autocomplete .asp_ac_autocomplete_dropdown {
    position:absolute;
    border: 1px solid #ccc;
    border-top-color: #d9d9d9;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    -webkit-box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    cursor: default;
    display:none;
    z-index: 1001;
    margin-top:-1px;
    background-color:#fff;
    min-width:100%;
    overflow:auto;
}
.asp_ac_autocomplete .asp_ac_autocomplete_hint {
    position:absolute;
    z-index:1;
    color:#ccc !important;
    -webkit-text-fill-color:#ccc !important;
    text-fill-color:#ccc  !important;
    overflow:hidden !important;
    white-space: pre  !important;
}

.asp_ac_autocomplete .asp_ac_autocomplete_hint span {
    color:transparent;
    opacity: 0.0;
}

.asp_ac_autocomplete .asp_ac_autocomplete_dropdown > div{
    background:#fff;
    white-space: nowrap;
    cursor: pointer;
    line-height: 1.5em;
    padding: 2px 0px 2px 0px;
}
.asp_ac_autocomplete .asp_ac_autocomplete_dropdown > div.active{
    background: #0097CF;
    color: #FFFFFF;
}
/*[autocomplete]*/

/*  *******************************************************************************************************************\
    13. RTL SPECIFIC STYLES AND CHANGES
\**********************************************************************************************************************/
.rtl .asp_content,
.rtl .asp_nores,
.rtl .asp_content *,
.rtl .asp_nores *,
.rtl .searchsettings form {
    text-align: right !important;
    direction: rtl !important;
}

.rtl .asp_nores >* {
    display: inline-block;
}

.rtl .searchsettings .asp_option  {
    flex-direction: row-reverse !important;
    -webkit-flex-direction: row-reverse !important;
}

.rtl .asp_option {
    direction: ltr; /* Needs to stay like this */
}

.rtl .asp_label,
.rtl .asp_option div.asp_option_label {
    text-align: right !important;
}

.rtl .asp_label {
    max-width: 1000px !important;
    width: 100%;
    direction: rtl !important;
}

.rtl .asp_label input[type=radio] {
    margin: 0 0 0 6px !important;
}

.rtl .asp_option_cat_level-0 div.asp_option_label {
    font-weight: bold !important;
}

.rtl fieldset .asp_option_cat_level-1 {
    margin-right: 12px !important;
    margin-left: 0;
}

.rtl fieldset .asp_option_cat_level-2 {
    margin-right: 24px !important;
    margin-left: 0;
}

.rtl fieldset .asp_option_cat_level-3 {
    margin-right: 36px !important;
    margin-left: 0;
}

.rtl .searchsettings legend {
    text-align: right !important;
    display: block;
    width: 100%;
}


.rtl .searchsettings input[type=text],
.rtl .searchsettings select {
    direction: rtl !important;
    text-align: right !important;
}

.rtl div.asp_w.asp_s.searchsettings form,
.rtl div.asp_w.asp_sb.searchsettings form {
    flex-direction: row-reverse !important;
}

.rtl div.horizontal.asp_r div.item {
    float: right !important;
}

.rtl p.asp-try {
    direction: rtl;
    text-align: right;
    margin-right: 10px;
    width: auto !important;
}

/*  *******************************************************************************************************************\
    14. SELECT2 SCRIPT STYLES
\**********************************************************************************************************************/
/*[select2]*/
.asp_select2,
.asp_select2 * {
    outline: none;
}
div.asp_w .asp_select2-container {
  box-sizing: border-box !important;
  display: inline-block;
  margin: 0;
  position: relative;
  vertical-align: middle;
  line-height: initial;
  }
  div.asp_w .asp_select2-container .asp_select2-selection--single {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    height: auto;
    user-select: none;
    -webkit-user-select: none; }
    div.asp_w .asp_select2-container .asp_select2-selection--single .asp_select2-selection__rendered {
      display: block;
      padding-left: 8px;
      padding-right: 20px;
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap; }
    .asp_select2-container .asp_select2-selection--single .asp_select2-selection__clear {
      position: relative; }
  .asp_select2-container[dir="rtl"] .asp_select2-selection--single .asp_select2-selection__rendered {
    padding-right: 8px;
    padding-left: 20px; }
  .asp_select2-container .asp_select2-selection--multiple {
    box-sizing: border-box;
    cursor: pointer;
    display: block;
    min-height: 34px;
    user-select: none;
    -webkit-user-select: none;
    }
    .asp_select2-container .asp_select2-selection--multiple .asp_select2-selection__rendered {
      display: inline-block;
      overflow: hidden;
      padding-left: 8px;
      text-overflow: ellipsis;
      }
  .asp_select2-container .asp_select2-search--inline {
    float: left; }
    .asp_select2-container .asp_select2-search--inline .asp_select2-search__field {
      background: transparent !important;
      box-sizing: border-box;
      border: none;
      font-size: 100%;
      margin-top: 5px;
      padding: 0; }
      .asp_select2-container .asp_select2-search--inline .asp_select2-search__field::-webkit-search-cancel-button {
        -webkit-appearance: none; }

.asp_select2-dropdown {
  background-color: white;
  border: 1px solid #fff;
  border-radius: 4px;
  box-sizing: border-box;
  display: block;
  position: absolute;
  left: -100000px;
  z-index: 99999999999999 !important;
  width: 100%;
  z-index: 1051;
  }

.asp_select2-results {
  display: block; }

.asp_select2-results__options {
  list-style: none;
    max-height: 200px;
    overflow-y: auto;
  margin: 0;
  padding: 0; }

.asp_select2-results__option {
  padding: 6px;
  margin: 0;
  user-select: none;
  -webkit-user-select: none; }
  .asp_select2-results__option[aria-selected] {
    cursor: pointer; }

.asp_select2-container--open .asp_select2-dropdown {
  left: 0; }

.asp_select2-container--open .asp_select2-dropdown--above {
  border-bottom: none;
  border-bottom-left-radius: 0;
  border-bottom-right-radius: 0; }

.asp_select2-container--open .asp_select2-dropdown--below {
  border-top: none;
  border-top-left-radius: 0;
  border-top-right-radius: 0; }

.asp_select2-search--dropdown {
  display: block;
  padding: 4px; }
  .asp_select2-search--dropdown .asp_select2-search__field {
    padding: 4px;
    width: 100%;
    box-sizing: border-box; }
    .asp_select2-search--dropdown .asp_select2-search__field::-webkit-search-cancel-button {
      -webkit-appearance: none; }
  .asp_select2-search--dropdown.asp_select2-search--hide {
    display: none; }

  /*
.asp_select2-search.asp_select2-search--inline:first-child .asp_select2-search__field {
	width: auto !important;
}*/

.asp_select2-close-mask {
  border: 0;
  margin: 0;
  padding: 0;
  display: block;
  position: fixed;
  left: 0;
  top: 0;
  min-height: 100%;
  min-width: 100%;
  height: auto;
  width: auto;
  opacity: 0;
  z-index: 99;
  background-color: #fff;
  filter: alpha(opacity=0); }

.asp_select2-hidden-accessible {
  border: 0 !important;
  clip: rect(0 0 0 0) !important;
  -webkit-clip-path: inset(50%) !important;
  clip-path: inset(50%) !important;
  height: 1px !important;
  overflow: hidden !important;
  padding: 0 !important;
  position: absolute !important;
  width: 1px !important;
  white-space: nowrap !important; }

.asp_select2-container {
    background: #fafafa;
    color: black;
}

.asp_select2-container,
.asp_select2-container ul,
.asp_select2-container ul li,
.asp_select2-container span {
    font-family: Roboto, Helvetica !important;
    font-size: 14px !important;
    line-height: initial;
}

.asp_select2-container--open .asp_select2-dropdown--below,
.asp_select2-container--open .asp_select2-dropdown--above {
  background: #eaeaea;
}

.asp_select2-container--flat .asp_select2-container--focus .asp_select2-selection--multiple {
  border: 1px solid #16a085;
}
.asp_select2-container--flat .asp_select2-results__option--highlighted[aria-selected] {
  background: #525252 !important;
  color: #ffffff;
}
.asp_select2-container--flat .asp_select2-results__option[aria-selected=true] {
  background: #777777;
  color: #fff;
  opacity: 0.8;
}
.asp_select2-container--flat .asp_select2-selection--single {
  border-radius: 0px;
}
.asp_select2-container--flat.asp_select2-container--open .asp_select2-selection__arrow b {
  transform: rotate(180deg);
  -webkit-transform: rotate(180deg);
  -moz-transform: rotate(180deg);
}
.asp_select2-container--flat span.asp_select2-search input {
  height: 30px !important;
    background: white;
}

.asp_select2-container .asp_select2-choice {
  border: 2px solid #dce4ec;
  height: 36px;
  border-radius: 0px;
  font-family: "Lato", sans-serif;
  font-size: 14px;
  text-indent: 1px;
  box-shadow: none;
  background-image: none;
}
.asp_select2-container .asp_select2-choice div {
  border-left: 2px solid #dce4ec;
  border-radius: 0 4px 4px 0;
  background-clip: padding-box;
}
.asp_select2-container .asp_select2-choice .asp_select2-arrow {
  border: 0px;
  border-radius: 0px;
  background: transparent;
  background-image: none;
}
.asp_select2-container *:focus {
  outline: 0px;
}
.asp_select2-container.asp_select2-drop-above .asp_select2-choice {
  border-bottom-color: #dce4ec;
  border-radius: 0px;
}

.asp_select2-drop {
  margin-top: -2px;
  border: 2px solid #dce4ec;
  border-top: 0;
  border-radius: 0px !important;
  border-radius: 0 0 6px 6px;
  box-shadow: none;
}
.asp_select2-drop.asp_select2-drop-above {
  margin-top: 2px;
  border-top: 2px solid #dce4ec;
  border-bottom: 0;
  border-radius: 6px 6px 0 0;
  box-shadow: none;
}

.asp_select2-search {
  margin-top: 3px;
}
.asp_select2-search input {
  height: 26px;
    min-height: unset !important;
  border: 2px solid #dce4ec;
}

.asp_select2-container-active .asp_select2-choice,
.asp_select2-container-active .asp_select2-choices {
  border: 2px solid #dce4ec;
  outline: none;
  box-shadow: none;
}

.asp_select2-dropdown-open .asp_select2-choice {
  box-shadow: none;
  border-bottom-left-radius: 0;
  border-bottom-right-radius: 0;
}
.asp_select2-dropdown-open .asp_select2-choice .asp_select2-choice div {
  background: transparent;
  border-left: none;
  -webkit-filter: none;
          filter: none;
}

.asp_select2-results {
  padding: 0 0 0 0px;
  margin: 4px 0px 0px 0;
}
.asp_select2-results .asp_select2-highlighted {
  background: #16a085;
  color: #fff;
  border-radius: 0px;
}

.asp_select2-container-multi .asp_select2-choices {
  height: auto !important;
  height: 1%;
  border: 2px solid #dce4ec;
}
.asp_select2-container-multi.asp_select2-container-active .asp_select2-choices {
  border: 2px solid #dce4ec;
  border-radius: 6px;
  box-shadow: none;
}

div.asp_w .asp_select2-container--flat .asp_select2-selection--single {
  background: #f9f9f9;
  border: none;
  height: 34px;
}
.asp_select2-container--flat .asp_select2-selection--single .asp_select2-selection__rendered {
  color: #212121;
  line-height: 34px;
}
.asp_select2-container--flat .asp_select2-selection--single .asp_select2-selection__arrow {
  height: 26px;
  position: absolute;
  top: 1px;
  right: 1px;
  width: 20px;
}
.asp_select2-container--flat .asp_select2-selection--single .asp_select2-selection__arrow b {
  border-color: #272727 transparent transparent transparent;
  top: 60%;
  border-style: solid;
  border-width: 5px 4px 0 4px;
  height: 0;
  left: 50%;
  margin-left: -4px;
  margin-top: -2px;
  position: absolute;
  width: 0;
}
.asp_select2-container--flat .asp_select2-selection--single .asp_select2-selection__placeholder {
  color: #5a5a5a;;
}
.asp_select2-container--flat .asp_select2-selection--single .asp_select2-selection__clear {
  cursor: pointer;
  float: right;
  font-weight: bold;
}

.asp_select2-container--flat .asp_select2-selection--multiple .asp_select2-selection__choice__remove:hover {
  color: #ffffff;
  cursor: pointer;
}
.asp_select2-container--flat .asp_select2-selection--multiple .asp_select2-selection__rendered {
  box-sizing: border-box !important;
  list-style: none !important;
  margin: 0;
  padding: 0 5px;
  width: 100%;
}
.asp_select2-container--flat .asp_select2-selection--multiple .asp_select2-selection__choice {
  background-color: #7b7b7b !important;
  color: #fff;
  border: 1px solid #797979 !important;
  border-radius: 0px !important;
  padding: 3px 5px !important;
  cursor: default;
  float: left;
  margin-right: 5px;
  margin-top: 5px;
}
.asp_select2-container--flat .asp_select2-selection--multiple .asp_select2-selection__choice__remove {
  color: #2f2f2f;
  margin-right: 6px;
  margin-left: 6px;
  float: right;
}
/*[select2]*/

/*  *******************************************************************************************************************\
    16. Misc
\**********************************************************************************************************************/
.asp_elementor_nores {
    text-align: center;
}

.elementor-sticky__spacer .asp_w,
.elementor-sticky__spacer .asp-try {
    visibility: hidden !important;
    opacity: 0 !important;
    z-index: -1 !important;
}

<?php
// Highlight on single result page
foreach ( wd_asp()->instances->get() as $instance ) {
	if ( $instance['data']['single_highlight'] == 1 ) {
		echo "body span.asp_single_highlighted_" . $instance['id'] . "{
			display: inline !important;
			color: ".$instance['data']['single_highlightcolor']." !important;
			background-color: ".$instance['data']['single_highlightbgcolor']." !important;
		}";
	}
}
?>