<?php
add_action( 'vc_before_init', 'dhc_title_section_shortcode_params' );

function dhc_title_section_shortcode_params() {	
	$params  =  array(
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Title', 'dhc' ),
			'param_name'  => 'title'
		),

		array(
			'type'       => 'textarea',
			'heading'    => esc_html__( 'Content', 'dhc' ),
			'param_name' => 'content'
		),
		
		array(
			'type'       => 'textfield',
			'heading'    => esc_html__( 'Extra Class', 'dhc' ),
			'param_name' => 'class'
		),

		array(
			'type' => 'css_editor',
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'dhc' )
		)	
	);	

	vc_map( array(
		'base'        => 'dhc_title_section',
		'name'        => esc_html__( 'dhc: Title Section', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => $params	
	) );
}

add_shortcode( 'dhc_title_section', 'dhc_title_section_shortcode_render' );
// Title section render
function dhc_title_section_shortcode_render( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_title_section', $atts );
	
	$output  = '<div class="title-section '.esc_attr( $atts['class'] ).'">';
	$output .= '<h1>'.esc_attr( $atts['title'] ).'</h1>';
	$output .= '<div class="desc-title">'.wp_kses_post ($content).'</div>';
	$output .= '</div>';
	return $output;
	
}

