<?php
add_filter( 'dhc/shortcode/dhc_testimonial_class', 'dhc_testimonial_shortcode_class', 10, 2 );
add_filter( 'dhc/shortcode/dhc_testimonial_slider_class', 'dhc_custom_shortcodes_class', 10, 2 );
add_action( 'vc_before_init', 'dhc_testimonial_shortcode_params' );

function dhc_testimonial_shortcode_class(  $atts) {
	
	if (function_exists('vc_shortcode_custom_css_class')) {
		$vcclass = vc_shortcode_custom_css_class( $atts['css'], ' ' );
	}
	$classes[] =$vcclass;
	$classes[] = $atts['class'];
	$classes[] = $atts['style'];
	return $classes;
}

function dhc_testimonial_shortcode_params() {
	/**
	 * Map the testimonial slider shortcode
	 */
	vc_map( array(
		'name'                    => esc_html__( 'dhc: Testimonial Slider', 'dhc' ),
		'base'                    => 'dhc_testimonial_slider',
		'icon'        => dhc_icon,
		'category'                => esc_html__( 'dhc', 'dhc' ),
		'params'                  => array(		
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'dhc' ),
				'param_name' => 'style',
				'value' => array(
					esc_html__( 'Style 1', 'dhc' )           => 'style1',
					esc_html__( 'Style 2', 'dhc' )   => 'style2',
					esc_html__( 'Style 3', 'dhc' )   => 'style3',
					),
				'std' => 'style1'
			),

			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Slider autoplay', 'dhc' ),
				'param_name' => 'autoplay',
				'description' => esc_html__( 'Autoplay mode.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => true ),
				'std' => false
			),

			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide pagination control', 'dhc' ),
				'param_name' => 'show_control',
				'description' => esc_html__( 'If YES pagination control will be remove.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 1 ),
				'std' => 0
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Number Of Testimonials', 'dhc' ),
				'param_name' => 'limit',
				'value'      => 3,
				'std'	     => 3
			),		

			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Slides per view', 'dhc' ),
				'param_name' => 'slides_per_view',
				'value' => '3',
				'description' => esc_html__( 'The number of items you want to see on the screen.', 'dhc' )
			),

			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Exclude', 'dhc' ),
				'param_name'  => 'exclude',
				'description' => esc_html__( 'Not Show these testimonial by IDs EX:1,2,3', 'dhc' ),
				),	

			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide prev/next buttons', 'dhc' ),
				'param_name' => 'show_direction',
				'description' => esc_html__( 'If "YES" prev/next control will be remove.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => true ),
				'std'	     => false
			),		

			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'dhc' ),
				'param_name' => 'class',
				'description' => esc_html__( 'Your custom class', 'dhc' )
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			)
		),
	) );

	
}

add_shortcode( 'dhc_testimonial_slider', 'dhc_shortcode_testimonial_slider' );

/**
 * This function will be use to handle testimonial slider
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function dhc_shortcode_testimonial_slider( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_testimonial_slider', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_testimonial_slider_atts',$atts));

	$args = array(
		'post_type' => 'testimonial',
		'posts_per_page' => $limit,
		);

	$classes = apply_filters( 'dhc/shortcode/dhc_testimonial_class', $atts );

	if ($exclude != '') {
		$args['post__not_in'] = explode(',',$exclude);
	}
	
	$allow = array(
    'a' => array(
        'href' => array(),
        'title' => array(),
        'class' => array()
    ));  

	$testimonials = new WP_Query($args);
	$nav_thumb = '';
	$testimonial_content = '';
	while ($testimonials->have_posts()) :
		$testimonials -> the_post();
		$star = dhc_meta('testimonial_rating');
		$stars ='';
		for ( $i = 0 ; $i < $star;$i++) {
			$stars .= '<a href="#" class="fa fa-star"></a>';
		}
		$nav_thumb .= sprintf('<li>%1$s</li>',get_the_post_thumbnail(null,'dhc-testimonial'));
		$testimonial_content .= sprintf('<div class="item">
			<blockquote>
				%1$s
			</blockquote>
			<div class="testimonial-content">				
				<div class="testimonial-image">
					%4$s
				</div>
				<div class="testimonial-author">
					<h6 class="author-name"><a href="%6$s">%2$s</a></h6>
					<div class="author-info">%3$s <span> - %7$s</span></div>
					%5$s
				</div>
			</div>	
		</div>',
		get_the_content(),
		get_the_title(),
		esc_attr(dhc_meta('testimonial_subtitle')),
		get_the_post_thumbnail(null,'dhc-testimonial'),
		wp_kses($stars,$allow),
		esc_url(dhc_meta('testimonial_link')),
		esc_html(dhc_meta('testimonial_company'))
		);
	endwhile;
	
	$config = $atts;

	// Enqueue shortcode assets
	wp_enqueue_script( 'dhc-carousel' );
	
	return sprintf( '
		<div class="testimonial-sliders %s" data-autoplay="%s" data-show_control="%s" data-show_direction="%s" data-slides-per-view="%s">
				%s	
		</div>
	',esc_attr(implode( ' ', $classes )), esc_attr( $autoplay ), esc_attr( $show_control ), esc_attr( $show_direction ),esc_attr($slides_per_view),$testimonial_content );
}