<?php
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Extended class to integrate testimonial slider with
	 * visual composer
	 */
    class WPBakeryShortCode_dhc_teammember_slider extends WPBakeryShortCodesContainer {
    }
}

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'dhc/shortcode/dhc_teammember_class', 'dhc_teammember_shortcodes_class', 10, 3 );
add_action( 'vc_before_init', 'dhc_team_member_shortcode_params' );

add_filter( 'dhc/shortcode/dhc_teammember_atts', 'dhc_teammember_shortcode_atts' );

function dhc_teammember_shortcodes_class($atts) {
	if (function_exists('vc_shortcode_custom_css_class')) {
		$vcclass = vc_shortcode_custom_css_class( $atts['css'], ' ' );
	}
	$class[] = 'dhc-team';
	$class[] =$vcclass;
	$class[] = $atts['style'];
	$class[] = $atts['class'];
	return $class;
}

function dhc_teammember_shortcode_atts( $atts ) {
	$icons_params = dhc_available_icons('icon');
	$atts = array_merge($atts,$icons_params);
	return $atts;
}

function dhc_team_member_shortcode_params() {
	/**
	 * Map the testimonial slider shortcode
	 */
	vc_map( array(
		'name'                    => esc_html__( 'dhc: Team Member Slider', 'dhc' ),
		'base'                    => 'dhc_teammember_slider',
		'as_parent'               => array( 'only' => 'dhc_member' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		'icon'        => dhc_icon,
		'content_element'         => true,
		'show_settings_on_create' => false,
		'category'                => esc_html__( 'dhc', 'dhc' ),
		'params'                  => array(			
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Margin', 'dhc' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'Margin item for slide', 'dhc' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Slides per view', 'dhc' ),
				'param_name' => 'slides_per_view',
				'value' => '1',
				'description' => esc_html__( 'The number of items you want to see on the screen.', 'dhc' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Slider autoplay', 'dhc' ),
				'param_name' => 'autoplay',
				'description' => esc_html__( 'Disable autoplay mode.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide pagination control', 'dhc' ),
				'param_name' => 'hide_control',
				'description' => esc_html__( 'If YES pagination control will be removed.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide prev/next buttons', 'dhc' ),
				'param_name' => 'hide_buttons',
				'description' => esc_html__( 'If "YES" prev/next control will be removed.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),			
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'dhc' ),
				'param_name' => 'class',
				'description' => esc_html__( 'Your custom class', 'dhc' )
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			)
		),
		'js_view' => 'VcColumnView'
	) );

	/**
	 * Map the member item
	 */
	$icons_params = dhc_map_icons('icon','Icon for readmore');
	vc_map( array(
		'base'        => 'dhc_member',
		'name'        => esc_html__( 'dhc: Team Member', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => array_merge(
			array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Name', 'dhc' ),
					'param_name'  => 'name'
				),

				array(
					'type'       => 'attach_image',
					'heading'    => esc_html__( 'Image', 'dhc' ),
					'param_name' => 'image'
				),

				array(
					'type'             => 'textfield',
					'heading'          => esc_html__( 'Subtitle', 'dhc' ),
					'param_name'       => 'subtitle',
				),

				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Content', 'dhc' ),
					'param_name' => 'content'
				),

				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Style', 'dhc' ),
					'param_name' => 'style',
					'value'		=> array(
							'Grid'	=> 'grid',
							'List'	=> 'list'
						),
					'std'	=> 'grid'
				),

				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Facebook URL', 'dhc' ),
					'param_name' => 'facebook'
				),

				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Twitter URL', 'dhc' ),
					'param_name' => 'twitter'
				),

				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'LinkedIn URL', 'dhc' ),
					'param_name' => 'linkedin'
				),

				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Google+ URL', 'dhc' ),
					'param_name' => 'google'
				),

				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Read More Link', 'dhc' ),
					'param_name' => 'link',
					'description' => esc_html__( 'Enter custom url for read more button', 'dhc' )
				),

				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Read More Text', 'dhc' ),
					'param_name' => 'text',
					'description' => esc_html__( 'Enter custom text for read more button', 'dhc' ),
					'value' => esc_html__( 'View Profile', 'dhc' )
				)),
			$icons_params,
			array(

				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Extra Class', 'dhc' ),
					'param_name' => 'class'
				),

				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'Show Social Icons On Hover', 'dhc' ),
					'param_name' => 'hover_show_icons',
					'value'      => array(
						esc_html__( 'Yes, please', 'dhc' ) => 'yes'
					)
				),

				array(
					'type' => 'css_editor',
					'param_name' => 'css',
					'group' => esc_html__( 'Design Options', 'dhc' )
				)
			)
		)
	) );
}

add_shortcode( 'dhc_member', 'dhc_shortcode_member' );
add_shortcode( 'dhc_teammember_slider', 'dhc_shortcode_teammember_slider' );

/**
 * Testimonial shortcode handle
 * 
 * @param   string  $atts  Shortcode attributes
 * @return  void
 */
function dhc_shortcode_member( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_member', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_member_atts',$atts));
	$icon_name = dhc_shortcode_icon_name('icon_',$icon_type);	
	$icon_value = !empty( $icon_name ) ? $atts[$icon_name] : '';

	$member_image = '';
	$member_info ='';
	$class = apply_filters( 'dhc/shortcode/dhc_teammember_class',  $atts );
	if ( ! empty( $atts['image'] ) ) {
		if ( is_numeric( $atts['image'] ) && $images = wp_get_attachment_image_src( $atts['image'], 'full' ) )
			$atts['image'] = array_shift( $images );

		$class[] = 'has-image';
		$member_image = sprintf( '
			<div class="team-image">
				<img src="%s" alt="%s" />
			</div>
		', esc_attr( $atts['image'] ), esc_attr( $atts['name'] ) );
	}

	if ( ! empty( $atts['subtitle'] ) )
		$member_info.= sprintf( '<div class="team-subtitle">%s</div>', wp_kses_post( $atts['subtitle'] ) );

	$member_info .= sprintf( '<h4 class="team-name">%s</h4>', wp_kses_post( $atts['name'] ) );

	$social_links = '';

	if ( ! empty( $atts['facebook'] ) )
		$social_links.= sprintf( ' <a href="%s" data-title="Facebook" class="facebook"><i class="fa fa-facebook"></i></a>', esc_url( $atts['facebook'] ) );

	if ( ! empty( $atts['twitter'] ) )
		$social_links.= sprintf( ' <a href="%s" data-title="Twitter" class="twitter"><i class="fa fa-twitter"></i></a>', esc_url( $atts['twitter'] ) );

	if ( ! empty( $atts['linkedin'] ) )
		$social_links.= sprintf( ' <a href="%s" data-title="LinkedIn" class="linkedin"><i class="fa fa-linkedin"></i></a>', esc_url( $atts['linkedin'] ) );

	if ( ! empty( $atts['google'] ) )
		$social_links.= sprintf( ' <a href="%s" data-title="Google Plus" class="google-plus"><i class="fa fa-google-plus"></i></a>', esc_url( $atts['google'] ) );

	if ( ! empty( $social_links ) )
		$social_links = sprintf( '<div class="social-links">%s</div>', $social_links );

	$box_readmore = '';

	$button_class = ($atts['style'] == 'grid'? 'no-background' :'');

	if ( ! empty( $atts['link'] ) && ! empty( $atts['text'] ) ) {
		$box_readmore = sprintf( '
				<a class="dhc-button %3$s" href="%1$s">%2$s<i class="readmore-icon %4$s"></i></a>
			', esc_url( $atts['link'] ), esc_html( $atts['text'] ),esc_attr($button_class),esc_attr($icon_value ));
	}

	return sprintf( '
		<div class="%s">
			%s			
			<div class="team-info">	
				%s			
				<div class="team-desc">%s</div>
				%s
				%s
			</div>
		</div>
	', esc_attr( implode( ' ', $class ) ), $member_image, $member_info, $content, $social_links
	 ,$box_readmore );
}

/**
 * This function will be use to handle testimonial slider
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function dhc_shortcode_teammember_slider( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_teammember_slider', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_teammember_slider_atts',$atts));
	$config = $atts;

	unset( $config['class'] );
	unset( $config['css'] );

	$class = apply_filters( 'dhc/shortcode/dhc_testimonial_slider_class', array( 'testimonial-slider', $atts['class'] ), $atts );

	// Enqueue shortcode assets
	wp_enqueue_script( 'finance-carousel' );
	
	return sprintf( '
		<div class="%s" data-margin="%s" data-slides_per_view="%s" data-autoplay="%s" data-hide_control="%s" data-hide_buttons="%s">			
			%s				
		</div>
	', implode( ' ', $class ), esc_attr( $margin ) , esc_attr( $slides_per_view ), esc_attr( $autoplay ), esc_attr( $hide_cotrol ), esc_attr( $hide_buttons ),  do_shortcode( $content ) );
}

