<?php
/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'dhc_spacer_shortcode_params' );

/**
 * Register parameters for iconbox shortcode
 * 
 * @return  void
 */
function dhc_spacer_shortcode_params() {
	vc_map( array(
		'base'        => 'dhc_spacer',
		'name'        => esc_html__( 'dhc: Spacer', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => array(

			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Desktop', 'dhc' ),
				'param_name'       => 'desktop',
				'value'            => 80
			),

			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Mobile', 'dhc' ),
				'param_name'       => 'mobile',
				'value'            => 40
			),			

			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'SMobile', 'dhc' ),
				'param_name'       => 'smobile',
				'value'            => 30
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Extra Class', 'dhc' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			)
		)
	) );
}

add_shortcode( 'dhc_spacer', 'dhc_shortcode_spacer' );

/**
 * Iconbox shortcode handle
 * 
 * @param   array  $atts  Shortcode attributes
 * @return  void
 */
function dhc_shortcode_spacer( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_spacer', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_spacer_atts',$atts));

	$class = apply_filters( 'dhc/shortcode/dhc_spacer', array( 'dhc-spacer', $atts['class'] ), $atts );
	
	return sprintf( '
		<div class="%1$s" data-desktop="%2$s" data-mobile="%3$s" data-smobile="%4$s">			
		</div>', esc_attr( implode( ' ', $class ) ), $atts['desktop'], $atts['mobile'], $atts['smobile'] );
}



