<?php
/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'dhc_simple_button_shortcode_params' );

/**
 * Register parameters for iconbox shortcode
 * 
 * @return  void
 */
function dhc_simple_button_shortcode_params() {
	$icons_params2 = dhc_map_icons('readmore','Icon for Button');
	$button  = array(
		array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'link', 'dhc' ),
				'param_name'  => 'button_link',
				'value'	=> ''
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Text', 'dhc' ),
				'param_name' => 'button_text',
				'value'	=> ''
			));
	$_params = array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'dhc' ),
				'param_name' => 'button_style',
				'value'      => array(
					esc_html__('Have Background','dhc') => 'have_background',
					esc_html__('No Background','dhc') => 'no-background'
					)
				),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Align', 'dhc' ),
				'param_name' => 'btn_align',
				'value' => array(
					esc_html__( 'Left', 'dhc' ) => 'text-left',
					esc_html__( 'Center', 'dhc' ) => 'text-center',
					esc_html__( 'Right', 'dhc' ) => 'text-right'
					)
				),
		
			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Extra Class', 'dhc' ),
				'param_name' => 'class'
			)
		);
	$params = array_merge($button,$icons_params2,$_params);
	vc_map( array(
		'base'        => 'dhc_simple_button',
		'name'        => esc_html__( 'dhc: Simple Button', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => $params
	) );
}

add_shortcode( 'dhc_simple_button', 'dhc_simple_button_shortcode_render' );

add_filter( 'dhc/shortcode/simple_button_atts', 'dhc_simple_button_shortcode_atts' );
add_filter( 'dhc/shortcode/simple_button_style', 'dhc_simple_button_shortcode_style' );

function dhc_simple_button_shortcode_atts( $atts ) {
	$icons_params2 = dhc_available_icons('readmore');
	$atts = array_merge($atts,$icons_params2);
	return $atts;
}

function dhc_simple_button_shortcode_style($atts) {
	$style[] = $atts['button_style'];
	if ($atts['button_style'] == 'have_background') {
		if (function_exists('vc_shortcode_custom_css_class')) {
			$vcclass = vc_shortcode_custom_css_class( $atts['css'], ' ' );
		}
		$style[] = $vcclass;
	}
	return $style;
}

// Title section render
function dhc_simple_button_shortcode_render( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_simple_button', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_simple_button_atts',$atts));
	$icon_name = dhc_shortcode_icon_name('readmore_',$readmore_type);
	$icon_value = $atts[$icon_name];
	$class = apply_filters( 'dhc/shortcode/simple_button_class', array( 'simple_button', $atts['class'],$atts['btn_align']  ), $atts );
	 $button_style = apply_filters('dhc/shortcode/simple_button_style',$atts);

	return sprintf('<div class="dhc_button_container %1$s">
		<a class="dhc-button %2$s" href="%3$s">%4$s <i class="%5$s"></i></a>
	</div>', esc_attr( implode( ' ', $class ) ), esc_attr(implode(' ', $button_style)),esc_url($button_link),esc_html($button_text),esc_attr($icon_value));
	
}

