<?php
add_shortcode( 'dhc_maps', 'dhc_shortcode_maps' );

// Map render
function dhc_shortcode_maps( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_maps', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_maps_atts',$atts));

	$content = wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content

	$img = "";
	if ( wp_get_attachment_url($image) ) {
		$img = wp_get_attachment_url($image);
	}
	
	wp_enqueue_script('dhc-google');
	wp_enqueue_script('dhc-gmap3');

	$return = '<div class="dhc-maps" data-address="' . esc_attr( $address ) . '" data-height="' . intval($height). '" data-images="' . esc_attr( $img ) . '" data-name="' . esc_attr( $name ) . '">
        <div id="map"></div>
    	</div><!-- /.dhc-maps -->';

	return $return;
}



	add_action( 'vc_before_init', 'dhc_shortcode_maps_vc' );

	function dhc_shortcode_maps_vc() {
		vc_map( array(			
			'name'                    => esc_html__( 'dhc: Google Maps', 'dhc' ),
			'base'                    => 'dhc_maps',	
			'icon'        => dhc_icon,		
			'content_element'         => true,			
			'category'                => esc_html__( 'dhc', 'dhc' ),
			'params'                  => array(	

				array(
					"type" => "textfield",
					"holder" => "h3",
					"heading" => esc_html__("name", 'dhc'),
					"param_name" => "name",
					"value" => esc_html__("dhc map", 'dhc'),
					"description" => esc_html__("Name display on map.", 'dhc'),
				),			
                array(
					"type" => "textfield",
					"holder" => "h3",
					"heading" => esc_html__("address", 'dhc'),
					"param_name" => "address",
					"value" => esc_html__("3 London Rd London SE1 6JZ United Kingdom", 'dhc'),
					"description" => esc_html__("Address for map.", 'dhc'),
				),			  	
              	array(
					"type" => "attach_image",
					"holder" => "img",
					"heading" => esc_html__("Image", 'dhc'),
					"param_name" => "image",
					"value" => '',
					"description" => esc_html__("Choose a image display on map", 'dhc')
              	),
              	array(
					"type" => "textfield",
					"holder" => "h3",
					"heading" => esc_html__("height", 'dhc'),
					"param_name" => "height",
					"value" => esc_html__("450px", 'dhc'),
					"description" => esc_html__("Set height for section map", 'dhc'),
				),				
			)
		) );
	}

