<?php
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Extended class to integrate testimonial slider with
	 * visual composer
	 */
    class WPBakeryShortCode_dhc_imagebox_slider extends WPBakeryShortCodesContainer {
    }
}

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'dhc_imagebox_shortcode_params' );

function dhc_imagebox_shortcode_params() {
	/**
	 * Map the imagebox slider shortcode
	 */
	vc_map( array(
		'name'                    => esc_html__( 'dhc: ImageBox Slider', 'dhc' ),
		'base'                    => 'dhc_imagebox_slider',
		'as_parent'               => array( 'only' => 'dhc_imagebox' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
		'content_element'         => true,
		'icon'        => dhc_icon,
		'show_settings_on_create' => false,
		'category'                => esc_html__( 'dhc', 'dhc' ),
		'params'                  => array(				
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Margin', 'dhc' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'Margin item for slide', 'dhc' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Slides per view', 'dhc' ),
				'param_name' => 'slides_per_view',
				'value' => '2',
				'description' => esc_html__( 'Number slide you want display', 'dhc' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Slider autoplay', 'dhc' ),
				'param_name' => 'autoplay',
				'description' => esc_html__( 'Disable autoplay mode.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide pagination control', 'dhc' ),
				'param_name' => 'hide_control',
				'description' => esc_html__( 'If YES pagination control will be removed.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide prev/next buttons', 'dhc' ),
				'param_name' => 'hide_buttons',
				'description' => esc_html__( 'If "YES" prev/next control will be removed.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),			
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'dhc' ),
				'param_name' => 'class',
				'description' => esc_html__( 'Enter your class', 'dhc' )
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			)
		),
		'js_view' => 'VcColumnView'
	) );

	/**
	 * Map the single imagebox item
	 */
	//$icons_params = dhc_map_icons('icon','Icon for readmore');

	vc_map( array(
		'base'        => 'dhc_imagebox',
		'name'        => esc_html__( 'Dex: Image Box', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => array(
			// Title
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Title', 'dhc' ),
				'param_name'       => 'title'
			),

			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Subtitle', 'dhc' ),
				'param_name'       => 'subtitle'
			),

			array(
				'type'       => 'textarea_html',
				'heading'    => esc_html__( 'Description', 'dhc' ),
				'param_name' => 'content'
			),

			array(
				'type'       => 'attach_image',
				'heading'    => esc_html__( 'Image', 'dhc' ),
				'param_name' => 'image'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Image Size', 'dhc' ),
				'description'    => esc_html__( '( Enter your image size Ex: 80x80 Default: Full )', 'dhc' ),
				'param_name' => 'image_size',
				'std'		 => 'full'
			),			

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Link', 'dhc' ),
				'param_name' => 'link',
				'value' => esc_html__("#",'dhc')
			),			

			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Button Text', 'dhc' ),
				'param_name'       => 'button_text',
				'value'			   => esc_html__('Continue','dhc')
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', 'dhc' ),
				'param_name' => 'style',
				'value' => array(
					esc_html__('Style 1','dhc') => 'style1',
					esc_html__('Style 2','dhc') => 'style2'
					),
				'description' => esc_html__( 'Margin item for slide', 'dhc' )
			),						

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Extra Class', 'dhc' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			)
		)
	));
}

add_shortcode( 'dhc_imagebox_slider', 'dhc_shortcode_imagebox_slider' );
add_shortcode( 'dhc_imagebox', 'dhc_shortcode_imagebox' );

/**
 * Iconbox shortcode handle
 * 
 * @param   array  $atts  Shortcode attributes
 * @return  void
 */
add_filter( 'dhc/shortcode/imagebox_atts', 'dhc_imagebox_shortcode_atts' );
add_filter( 'dhc/shortcode/dhc_imagebox_class', 'dhc_imagebox_shortcode_class' );

function dhc_imagebox_shortcode_atts( $atts ) {
	$atts['icon_position'] = 'top';
	$atts['icon_style']    = 'transparent';	
	$icons_params = dhc_available_icons('readmore');
	$icons_params2 = dhc_available_icons('icon');
	$atts = array_merge($atts,$icons_params,$icons_params2);
	return $atts;
}

function dhc_imagebox_shortcode_class(  $atts) {
	if (function_exists('vc_shortcode_custom_css_class')) {
		$vcclass = vc_shortcode_custom_css_class( $atts['css'], ' ' );
	}
		$classes[] =$vcclass;
		$classes[] = 'dhc_imagebox';
		$classes[] = $atts['class'];
		$classes[] = $atts['style'];
		return $classes;
}

function dhc_shortcode_imagebox( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_imagebox', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_imagebox_atts',$atts));
	ob_start();
	//$icon_name = dhc_shortcode_icon_name('icon_',$icon_type);	
	// Preparing the shortcode attributes	
	$show_button = 'yes';
	$button_text = empty( $button_text ) ? esc_html__( 'Continue', 'dhc' ) : $button_text;

	// Build the element classes

	$classes = apply_filters('dhc/shortcode/dhc_imagebox_class',$atts);

	$button_class = array(
		'style1' => 'no-background',
		'style2' => ''
		);

	$box_readmore = '';

	if ( ! empty( $link ) && ! empty( $button_text ) ) {
		$box_readmore = sprintf( '
				<a class="dhc-button %1$s" target="_blank" href="%2$s">%3$s</a>',
				 esc_attr($button_class[$style]),
				 esc_url( $link ),  
				 esc_attr($button_text)				
				 );
	}

	// Preparing image for the box
	if ( is_numeric( $image ) ) {
		$wpimage = wpb_getImageBySize( array( 'attach_id' =>$image, 'thumb_size' => $image_size ) );
		$image = $wpimage['thumbnail'];
	}
	elseif ( filter_var( $image, FILTER_VALIDATE_URL ) ) {
		$image = sprintf( '<img src="%s" />', esc_url( $image ) );
	}	?>
	<div class="<?php echo esc_attr( join( ' ', $classes ) ) ?>">
		<div class="imagebox-wrapper">
			<?php if ( ! empty( $image ) ): ?>
				<div class="imagebox-image">
					<?php
						if ( ! $show_button):
							printf( '<a href="%s" target="_blank">%s</a>',
								esc_url( $link ), $image );
						else:
							print( $image );
						endif;
					?>
				</div>

			<?php endif ?>

			<div class="imagebox-header">
				<h3 class="imagebox-title">
					<a href="<?php echo esc_url( $link ) ?>" target="_blank">
						<?php echo wp_kses_post( $atts['title'] ) ?>
					</a>	
				</h3>

				<?php if ( ! empty( $atts['subtitle'] ) ): ?>
					<div class="imagebox-subtitle"><?php echo wp_kses_post( $atts['subtitle'] ) ?></div>
				<?php endif ?>
			</div>


			<div class="imagebox-content">
				<?php if ( ! empty( $content ) ): ?>
					<div class="imagebox-desc">
						<?php 
						$args = array(
						    //formatting
						    'ul' => array(),
						    'li'     => array(),

						    //links
						    'a'     => array(
						        'href' => array()
						    )
						);
						echo wp_kses( $content, $args ); 
						
						?>
					</div>
				<?php endif ?>
				
					<?php echo wp_kses_post($box_readmore);?>

			</div>
		</div>
	</div>	
<?php 
return ob_get_clean();
}

/**
 * This function will be use to handle imagebox slider
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function dhc_shortcode_imagebox_slider( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_imagebox_slider', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_imagebox_slider_atts',$atts));
	$config = $atts;
	unset( $config['class'] );
	unset( $config['css'] );
	$class = apply_filters( 'dhc/shortcode/dhc_imagebox_slider_class', array( 'dhc_imagebox_slider', $atts['class'] ), $atts );

	// Enqueue shortcode assets
	wp_enqueue_script( 'dhc-carousel' );
	
	return sprintf( '
		<div class="%s" data-margin="%s" data-slides_per_view="%s" data-autoplay="%s" data-hide_control="%s" data-hide_buttons="%s">			
			%s				
		</div>
	', implode( ' ', $class ), esc_attr( $atts['margin'] ) , esc_attr( $atts['slides_per_view'] ), esc_attr( $atts['autoplay'] ), esc_attr( $atts['hide_control'] ), esc_attr( $atts['hide_buttons'] ),  do_shortcode( $content ) );
}



