<?php
add_action( 'vc_before_init', 'dhc_iconbox_shortcode_params' );

function dhc_iconbox_shortcode_params() {
	$icons_params = dhc_map_icons('icon','IconBox');	
	$params = array_merge( $icons_params, array(
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__( 'Title', 'dhc' ),
			'param_name'       => 'fl_title',
			'value'			   =>  esc_html__( 'Enter your title', 'dhc' )
		),			

		array(
			'type'             => 'textfield',
			'heading'          => esc_html__( 'Sub Title', 'dhc' ),
			'param_name'       => 'fl_subtitle',
			'value'			   =>  ''
		),

		array(
			'type'       => 'textarea_html',
			'heading'    =>esc_html__( 'Content', 'dhc' ),
			'param_name' => 'content'
		),

		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Button Link', 'dhc' ),
			'param_name' => 'link',
			'description' =>esc_html__( 'Enter custom url for read more button', 'dhc' )
		),

		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Button Text', 'dhc' ),
			'param_name' => 'text',
			'description' =>esc_html__( 'Enter custom text for read more button', 'dhc' ),
			'value' =>esc_html__( 'more...', 'dhc' )
		),		

		array(
			'type'       => 'dropdown',
			'heading'    =>esc_html__( 'Icon align', 'dhc' ),
			'param_name' => 'icon_position',
			'value' => array(
				__( 'Top', 'dhc' ) => 'icon-top',
				__( 'Left', 'dhc' ) => 'icon-left',
				__( 'Left Inline', 'dhc' ) => 'icon-inline-left',
				__( 'Right', 'dhc' ) => 'icon-right'
			)
		),

		array(
			'type'       => 'dropdown',
			'heading'    =>esc_html__( 'Icon Type', 'dhc' ),
			'param_name' => 'icon_style',
			'value' => array(
				__( 'Default', 'dhc' )         => 'default',
				__( 'Circle', 'dhc' )          => 'circle',
				__( 'Circle Background', 'dhc' )  => 'circle-background',
				__( 'Square Radius Background', 'dhc' )         => 'square-radius-background',
				__( 'Square Radius Border', 'dhc' ) => 'square-radius-border',
				__( 'Square', 'dhc' )          => 'square',
				__( 'Square Border', 'dhc' )  => 'square-border'
			)
		),

		array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'dhc' ),
				'param_name' => 'class',
				'description' => esc_html__( 'Enter your class', 'dhc' )
			),
		
		array(
			'type' => 'css_editor',
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'dhc' )
		),		
	));	

	vc_map( array(
		'base'        => 'dhc_iconbox',
		'name'        => esc_html__( 'dhc: iconbox', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => $params
	) );
}

add_shortcode( 'dhc_iconbox', 'dhc_shortcode_iconbox' );

function dhc_shortcode_iconbox( $atts , $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_iconbox', $atts );	
	$icon_name = dhc_shortcode_icon_name('icon_',$atts['icon_type']);
   	$icon_value = !empty( $icon_name ) ? $atts[$icon_name] : '';
	$output  = '<div class="fl-iconbox '.$atts['class'].' '.$atts['icon_position'].' '.$atts['icon_style'].'">'; 
	$output .= '<h3 class="fl-icon">'.esc_attr ( $atts['fl_title'] ).'</h3>';
	$output .= '<div class="icon-wrap">';
	$output .= '<span class="'.$icon_value.'"></span>';
	$output .= '</div>';	
	if ( $atts['fl_subtitle'] != '' ) {
		$output .= '<div class="sub-title">'.$atts['fl_subtitle'].'</div>';
	}	

	$output .=  '<div class="fl-desc">'.wp_kses_post ($content).'</div>';
	if ( ( $atts['link'] != '' ) && ( $atts['text'] != '' ) ) {
		$output .=  '<div class="box-button">';
		$output .=  '<a href="'.esc_url($atts['link']).'">'.esc_attr( $atts['text'] ).'</a>';
		$output .=  '</div>';
	}
	$output .=  '</p>';
	$output .=  '</div>';
	return $output;
}



