<?php

add_filter( 'dhc/shortcode/faq_atts', 'dhc_faq_shortcode_atts');

function dhc_faq_shortcode_atts( $atts ) {
	$icons_params = dhc_available_icons('icon');
	$atts = array_merge($atts,$icons_params);
	return $atts;
}

if ( ! class_exists('dhc_VCExtend') ) {
	class dhc_VCExtend {
		function __construct() {
			// We safely integrate with VC with this hook
			add_action( 'init', array( $this, 'integrateWithVC' ) );

			// Use this when creating a shortcode addon
			$shortcodes = 'dhc_portfolio,dhc_posts,dhc_faq';
			$shortcodes = explode(",", $shortcodes);
			$shortcodes = array_map("trim", $shortcodes);
			foreach ( $shortcodes as $shortcode ) {
				add_shortcode($shortcode, array( $this, $shortcode ) );
			} 
		}

		public function integrateWithVC() {
	        // Check if Visual Composer is installed
			if ( ! defined( 'WPB_VC_VERSION' ) ) {
	            // Display notice that Visual Compser is required
				add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
				return;
			}		
			
			//portfolio option
			$category_portfolio = get_terms( 'portfolios_category','orderby=name&hide_empty=0' );
			$category_portfolio_name[] = 'All';

			foreach ( $category_portfolio as $category ) {
				
				$category_portfolio_name[$category->name] = $category->slug;
				$category_order[] = $category->slug;		
			}

			//$category_order = implode(',', $category_order);
			

			vc_map( array(
				'base'        => 'dhc_portfolio',
				'icon'        => dhc_icon,
				'name'        => esc_html__( 'dhc: Portfolio', 'dhc' ),
				'category'    => esc_html__( 'dhc', 'dhc' ),
				'params'      => array(
					array(
						"type"        => "dropdown",
						"heading" => esc_html__("Category", 'dhc'),
						"param_name" => "category",
						"value"       => $category_portfolio_name,
						"description" => esc_html__("Display posts from some categories.", 'dhc'),
						),	

					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style', 'dhc' ),
						'param_name' => 'style',
						'value' => array(
							esc_html__( 'Grid 1', 'dhc' )           => 'grid',
							esc_html__( 'Grid 2', 'dhc' )   => 'grid2',
							esc_html__( 'Grid No Padding', 'dhc' )   => 'grid-no-padding',
							)
						),

					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Grid Columns', 'dhc' ),
						'param_name' => 'columns',
						'value'      => array(
							esc_html__( '3 Columns', 'dhc' ) => 'one-three',
							esc_html__( '2 Columns', 'dhc' ) => 'one-half',							
							esc_html__( '4 Columns', 'dhc' ) => 'one-four',
							esc_html__( '5 Columns', 'dhc' ) => 'one-five'
							)
						),

					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Number Of Items', 'dhc' ),
						'param_name' => 'limit',
						'value'      => 8
						),			

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Exclude', 'dhc' ),
						'param_name'  => 'exclude',
						'description' => esc_html__( 'Not Show these portfolios by IDs EX:1,2,3', 'dhc' ),
						),	

					array(
						'type' => 'checkbox',
						'heading' => esc_html__( 'Enable Carousel Mode', 'dhc' ),
						'param_name' => 'enable_carousel',
						'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
						),

					array(
						'type' => 'checkbox',
						'heading' => esc_html__( 'Hide title portfolio', 'dhc' ),
						'param_name' => 'hide_title',
						'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
						),

					array(
						'type' => 'checkbox',
						'heading' => esc_html__( 'Hide category portfolio', 'dhc' ),
						'param_name' => 'hide_category',
						'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
						),

					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Show Filter', 'dhc' ),
						'param_name' => 'show_filter',
						'description' => esc_html__( 'If "YES" portfolio filter will be shown.', 'dhc' ),
						'value' => array(
							esc_html__( 'No', 'dhc' ) => 'no',
							esc_html__( 'Yes, please', 'dhc' ) => 'yes'							
							)
						),

					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Categories order', 'dhc' ),
						'param_name' => 'cat_order',
						'dependency' => array(
							'element' => 'show_filter',
							'value'	=> 'yes'
							),
						'description'=> 'Categories order split by ","',
						'value'      => $category_order
						),

					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Show Portfolio Content', 'dhc' ),
						'param_name' => 'show_content',
						'value'      => array(
							esc_html__( 'Yes, please', 'dhc' ) => 'yes'
							)
						),

					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Portfolio Content Length', 'dhc' ),
						'param_name' => 'content_length',
						'value'      => 41
						),

					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Extra Class', 'dhc' ),
						'param_name' => 'class'
						),

					array(
						'type' => 'css_editor',
						'param_name' => 'css',
						'group' => esc_html__( 'Design Options', 'dhc' )
						)
					)

				));    
			
			/**
			 * Map the post shortcode
			 */
			$category_posts = get_terms( 'category' );
			$category_posts_name[] = 'All';
			foreach ( $category_posts as $category_post ) {
				$category_posts_name[] = $category_post->name;		
			}

			vc_map( array(
				'name'                    => esc_html__( 'dhc: Blog Posts', 'dhc' ),
				'base'                    => 'dhc_posts',
				'icon'        => dhc_icon,
				'params'                  => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Widget Title', 'dhc' ),
						'param_name'  => 'title',
						'description' => esc_html__( 'Enter text which will be used as widget title. Leave blank if no title is needed.', 'dhc' )
						),
					array(
						"type"        => "dropdown",
						"heading" => esc_html__("Category", 'dhc'),
						"param_name" => "category_post",
						"value"       => $category_posts_name,
						"description" => esc_html__("Display posts from some categories.", 'dhc'),
						),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Layout', 'dhc' ),
						'param_name' => 'layout',
						'value'      => array(
							esc_html__( 'List', 'dhc' ) => 'blog-list',
							esc_html__( 'List small', 'dhc' ) => 'blog-list-small',
							esc_html__( 'Grid', 'dhc' ) => 'blog-grid'

							)
						),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Grid Columns', 'dhc' ),
						'param_name'  => 'grid_columns',
						'description' => esc_html__( 'The number of columns for grid and grid masonry layout', 'dhc' ),
						'dependency' => array(
							'element' => 'layout',
							'value'	=> 'blog-grid'
							),
						'value'       => array(
							esc_html__( '2 Columns', 'dhc' ) => 2,
							esc_html__( '3 Columns', 'dhc' ) => 3,
							esc_html__( '4 Columns', 'dhc' ) => 4
							)
						),

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Limit', 'dhc' ),
						'param_name'  => 'limit',
						'description' => esc_html__( 'The number of posts will be shown', 'dhc' ),
						'value'       => 9
						),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Hide Post Content', 'dhc' ),
						'param_name' => 'hide_content',
						'value'      => array(
							esc_html__( 'Yes, please', 'dhc' ) => 'yes'
							)
						),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Enable Carousel', 'dhc' ),
						'param_name' => 'blog_carousel',
						'value'      => array(
							esc_html__( 'Yes, please', 'dhc' ) => 'yes'
							)
						),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Post Content Length', 'dhc' ),
						'param_name' => 'content_length',
						'value'      => 150
						),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Hide Read More', 'dhc' ),
						'param_name' => 'hide_readmore',
						'value'      => array(
							esc_html__( 'Yes, please', 'dhc' ) => 'yes'
							)
						),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Read More Text', 'dhc' ),
						'param_name' => 'readmore_text',
						'value'      => htmlspecialchars_decode(esc_html__( 'Read More <i class="fa fa-chevron-right" aria-hidden="true"></i>', 'dhc' ))
						),

					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Extra class name', 'dhc' ),
						'param_name'  => 'class',
						'description' => esc_html__( 'Your custom class', 'dhc' )
						),

					array(
						'type'       => 'css_editor',
						'param_name' => 'css',
						'group'      => esc_html__( 'Design Options', 'dhc' )
						)
					)
				) );

			//faq option
			$category_faq= get_terms( 'faq_category' );
			$category_faqname[] = 'All';

			foreach ( $category_faq as $category ) {
				$category_faqname[$category->name] = $category->slug;		
			}

			$icons_params = dhc_map_icons('icon','Icon for readmore');

			vc_map( array(
				'name'                    => esc_html__( 'dhc: FAQ', 'dhc' ),
				'base'                    => 'dhc_faq',
				'icon'        => dhc_icon,
				'params'                  => array_merge(
					array(
						
						array(
							"type"        => "dropdown",
							"heading" => esc_html__("Category", 'dhc'),
							"param_name" => "category_post",
							"value"       => $category_faqname,
							"description" => esc_html__("Display posts from some categories.", 'dhc'),
							),

						array(
							'type'        => 'dropdown',
							'heading'     => esc_html__( 'Style', 'dhc' ),
							'param_name'  => 'faq_style',
							'value'       => array(
								esc_html__( 'Style 1', 'dhc' ) => 'style-1',
								esc_html__( 'Style 2', 'dhc' ) => 'style-2',
								)
							),
						
						array(
							'type'        => 'textfield',
							'heading'     => esc_html__( 'Limit', 'dhc' ),
							'param_name'  => 'limit',
							'description' => esc_html__( 'The number of posts will be shown', 'dhc' ),
							'value'       => 9
							),

						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__( 'Hide Post Content', 'dhc' ),
							'param_name' => 'hide_content',
							'value'      => array(
								esc_html__( 'Yes, please', 'dhc' ) => 'yes'
								)
							),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__( 'Show pagination', 'dhc' ),
							'param_name' => 'show_pagination',
							'value'      => array(
								esc_html__( 'Yes, please', 'dhc' ) => 'yes'
								)
							),

						
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__( 'Post Content Length', 'dhc' ),
							'param_name' => 'content_length',
							'value'      => 150
							),
						array(
							'type'       => 'checkbox',
							'heading'    => esc_html__( 'Hide Read More', 'dhc' ),
							'param_name' => 'hide_readmore',
							'value'      => array(
								esc_html__( 'Yes, please', 'dhc' ) => 'yes'
								)
							),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__( 'Read More Text', 'dhc' ),
							'param_name' => 'readmore_text',
							'value'      => esc_html__( 'Read More', 'dhc' )
							)
					), $icons_params,
					array(

						array(
							'type'        => 'textfield',
							'heading'     => esc_html__( 'Extra class name', 'dhc' ),
							'param_name'  => 'class',
							'description' => esc_html__( 'Your custom class', 'dhc' )
							)
						)
					)
				) );

		}    

		public static function dhc_faq( $atts, $content = null ) {
			$atts = vc_map_get_attributes( 'dhc_faq', $atts );
			extract (apply_filters( 'dhc/shortcode/dhc_faq_atts',$atts));
			if ( get_query_var('paged') ) {
				$paged = get_query_var('paged');
			} elseif ( get_query_var('page') ) {
				$paged = get_query_var('page');
			} else {
				$paged = 1;
			}    
			global $paging_style;
			global $paging_for;
			$paging_style = 'loadmore';
			$paging_for = 'faq';
			$icon_name = 'icon_'.$atts['icon_type'];
			$icon_value = $atts[$icon_name];
			wp_enqueue_style( 'vc_'.$atts['icon_type'] );

			if ($icon_value != '') {
				$readmore_text = $readmore_text . sprintf('<i class="%s"></i>',esc_attr($icon_value));
			}
			
			$limit = intval( $limit );		
			$terms_slug = wp_list_pluck( get_terms( 'faq_category','orderby=name&hide_empty=0'), 'slug' );   
			$tax =  $terms_slug;

			if ( empty( $atts['enable_carousel'] ) ) $atts['enable_carousel'] = 'no';
			if ( empty( $atts['show_filter'] ) ) $atts['show_filter'] = 'no';
			if ( empty( $atts['hide_content'] ) ) $atts['hide_content'] = 'no';
				$query_args = array(
					'post_type' => 'faq',
					'posts_per_page' => $limit,
					'paged' => $paged,          
					);
				if ($category_post != 'All') {
					$query_args['tax_query'] = array(
						array(
							'taxonomy' => 'faq_category',   
							'field'    => 'slug',                   
							'terms'    => $category_post,
							)
						);
				}
				$query = new WP_Query($query_args);
				$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages; 
				$_class[] = $faq_style;
				$_class[] = $class;

				ob_start();
				?>
				<div class="dhc-faq-shortcodes grid one-half <?php echo esc_attr(implode(" ",$_class));?>">
					<?php 
					while ( $query->have_posts() ) : $query->the_post();
						printf('<div class="item %s">',esc_attr(get_post_format()));
							echo '<div class="item-inner">';
								global $dhc_thumbnail;
								$dhc_thumbnail = 'dhc-faq';
								get_template_part('tpl/feature-post'); 
								if ($atts['hide_title']  != 'yes') {
									printf('<h2 class="faq-title"><a href="%1$s">%2$s</a></h2>',esc_url(get_the_permalink()),esc_html(get_the_title()));
								}
								$layout = ($style == 'style-2' ? 'blog-list' : 'blog-grid');
								if ($atts['hide_content'] != 'yes') {?>
									<div class="entry-content">
										<?php
										$readmore = $atts['hide_readmore'] != 'yes'  ? wp_kses_post( $readmore_text ) : ' ';
										dhc_render_post($layout,$readmore,$atts['content_length']);
										?>

									</div>
								<?php }
							echo '</div>';
						echo '</div>';
					endwhile; 
					?>
				</div>
				<?php if ( $atts['show_pagination'] == 'yes') {
					add_filter('dhc/template/loadmore_text',array('dhc_VCExtend','dhc_faq_loadmore_text'));
					get_template_part('tpl/pagination');
				}
				?>
		<?php 
				return ob_get_clean();
		}

		function dhc_faq_loadmore_text($string){
			return 'VIEW MORE FAQ';
		}
		
		// Portfolio render
		public static function dhc_portfolio( $atts, $content = null ) {
			$atts = vc_map_get_attributes( 'dhc_portfolio', $atts );
			extract (apply_filters( 'dhc/shortcode/dhc_portfolio_atts',$atts));

			if ( empty( $atts['enable_carousel'] ) ) $atts['enable_carousel'] = 'no';
			if ( empty( $atts['show_filter'] ) ) $atts['show_filter'] = 'no';
			if ( empty( $atts['show_content'] ) ) $atts['show_content'] = 'no';

			ob_start();
			$content = wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content

			$limit = intval( $limit );		
			$terms_slug = wp_list_pluck( get_terms( 'portfolios_category','orderby=name&hide_empty=0'), 'slug' );
			$filters =      wp_list_pluck( get_terms( 'portfolios_category','orderby=name&hide_empty=0'), 'name','slug' ); 

			$tax =  $terms_slug;

			if ( $category != 'All' ) {            
				$tax = $category;
			}		

			if ( get_query_var('paged') ) {
				$paged = get_query_var('paged');
			} elseif ( get_query_var('page') ) {
				$paged = get_query_var('page');
			} else {
				$paged = 1;
			}    

			$query_args = array(
				'post_type' => 'portfolios',				
				'posts_per_page' => $limit,
				'paged' => $paged,          
				'tax_query' => array(
					array(
						'taxonomy' => 'portfolios_category',   
						'field'    => 'slug',                   
						'terms'    => $tax,
						),
					),
				);

			if ( ! empty( $atts['exclude'] ) ) {
				$exclude = $atts['exclude'];				
				if ( ! is_array( $exclude ) )
					$exclude = explode( ',', $exclude );

				$query_args['post__not_in'] = $exclude;
			}


			$query = new WP_Query( $query_args );
			$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages; 

			if ( ! $query->have_posts() )
				return;			

			wp_enqueue_script( 'dhc-carousel' );

			echo '<div class="dhc-portfolio clearfix '.$atts['enable_carousel'].'">'; 
			$show_filter_portfolio = '';

			//Build the filter navigation
			if ( $show_filter == "yes" ) {	   
				$show_filter_portfolio = 'show_filter_portfolio';     	
					echo '<ul class="portfolio-filter '.esc_attr( $class ).'"><li class="active"><a data-filter="*" href="#">' . esc_html__( 'All', 'dhc' ) . '</a></li>'; 
					if ($cat_order == '') { 

						foreach ($filters as $key => $value) {
							echo '<li><a data-filter=".' . esc_attr( strtolower($key)) . '" href="#" title="' . esc_attr( $value ) . '">' . esc_html( $value ) . '</a></li>'; 
						}
					
					}
					else {
						$cat_order = split(",", $cat_order);
						foreach ($cat_order as $key) {
							$key = trim($key);
							echo '<li><a data-filter=".' . esc_attr( strtolower($key)) . '" href="#" title="' . esc_attr( $filters[$key] ) . '">' . esc_html( $filters[$key] ) . '</a></li>'; 
						}
					}
	                echo '</ul>'; //portfolio-filter
	        } 
	        echo '<div class="portfolio-container '.esc_attr( $class ).' '.esc_attr( $style ).' '.esc_attr( $columns ).' '.esc_attr( $show_filter_portfolio ).'">';        
	        while ( $query->have_posts() ) : $query->the_post();
	        global $post;
	        $id = $post->ID;
	        $termsArray = get_the_terms( $id, 'portfolios_category' );
	        $termsString = "";

	        if ( $termsArray ) {
	        	foreach ( $termsArray as $term ) {
	        		$itemname = strtolower( $term->slug ); 
	        		$itemname = str_replace( ' ', '-', $itemname );
	        		$termsString .= $itemname.' ';
	        	}
	        }

	        $imgs = array(
	        	'grid' => 'dhc-case',
	        	'grid2' => 'dhc-case2',
	        	'grid-no-padding' => 'dhc-case3'
	        	);
	        $img_portfolio = $imgs[$style];

	        //if ( has_post_thumbnail() ):	

	        	// Enqueue shortcode assets
	        	wp_enqueue_script( 'dhc-manific-popup' );
	        echo '<div class="item ' . $termsString . '">';
	        echo '<div class="wrap-border">';
	       
	        if ( dhc_meta( 'icon_portfolio') != "" ) {
	        	echo '<div class="portfolio-icon">';
	        	echo dhc_meta( 'icon_portfolio');
	        	echo '</div>';
	        } else {
	        	echo '<div class="featured-post ">';	            
		        echo '<img src="'.dhc_thumbnail_url( $img_portfolio ).'" alt="'.get_the_title() .'">';	                                                                   
		        echo '</div>';
	        }
	        
	        echo '<div class="portfolio-details">';
	        if ( $hide_category != 'yes' ) {	
	        	echo '<div class="category-post">';
	        	echo the_terms( get_the_ID(), 'portfolios_category', 
	        		'', ' / ', '' );                        
	        	echo '</div>';     
	        }	          
	        if ( $hide_title != 'yes' ) {
	        	echo '<div class="title-post"><a title="' . get_the_title() . '" href="' . get_the_permalink() . '">' . get_the_title() . '</a></div>';
	        }

	        if ( $atts['show_content'] != 'no' ):
	        	?>

	        <div class="entry-content">

	        	<?php
	        	$content = get_the_content();
	        	$content = trim( strip_tags( $content ) );
	        	$length  = intval( '0' . $atts['content_length'] );
	        	$length  = max( $length, 1 );

	        	if ( mb_strlen( $content ) > $length ) {
	        		$content = mb_substr( $content, 0, $length );
	        		$content.= '...';
	        	}

	        	echo wp_kses_post( $content );
	        	?>					

	        </div>

	    <?php endif;  

	    echo '</div>';
	    echo '</div>';
	    echo '</div>';

	    //endif;
	    endwhile;	
	    wp_reset_postdata();

	    echo "</div>";
	    echo "</div>";
	    $out_put = ob_get_clean();
	    return $out_put;
	}	

	// Blog post render
	public static function dhc_posts( $atts, $content = null ) {
		$atts = vc_map_get_attributes( 'dhc_posts', $atts );
		extract (apply_filters( 'dhc/shortcode/dhc_posts_atts',$atts));
		ob_start();
			$content = wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content	

			if ( get_query_var('paged') ) {
				$paged = get_query_var('paged');
			} elseif ( get_query_var('page') ) {
				$paged = get_query_var('page');
			} else {
				$paged = 1;
			}     				

			$query_args = array(					
				'post_status'         => 'publish',
				'post_type'           => 'post',
				'paged' => $paged,
				'ignore_sticky_posts' => true,
				);  

			if ( is_numeric( $atts['limit'] ) && $atts['limit'] >= 0 ) {
				$query_args['posts_per_page'] = $atts['limit'];
			}

			if ( ! empty( $atts['exclude'] ) ) {
				$exclude = $atts['exclude'];

				if ( ! is_array( $exclude ) )
					$exclude = explode( ',', $exclude );

				$query_args['post__not_in'] = $exclude;
			}
			
			if ( $atts['category_post'] != 'All' )
				$query_args['category_name'] = $atts['category_post'];

			$query = new WP_Query( $query_args );	
			$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages; 

			$class_names = array(
				1 => 'blog-one-column',
				2 => 'blog-two-columns',
				3 => 'blog-three-columns',
				4 => 'blog-four-columns',
				);		

			if ( ! $query->have_posts() )
				return;

			$class = apply_filters( 'dhc/shortcode/posts_class', array( 'blog-shortcode', $atts['class'],  $atts['layout'] ), $atts );

			if ( isset( $class_names[$atts['grid_columns']] ) && in_array( $atts['layout'], array( 'blog-grid', 'blog-masonry' ) ) ) {
				$class[] = $class_names[$atts['grid_columns']];
			}

			if ( $atts['hide_content'] != 'yes' ) {
				$class[] = 'has-post-content';
			}	

			if ( $atts['blog_carousel'] == 'yes' ) {
				$class[] = 'has-carousel';
			}

			$imgs = array(
				'blog-list' => 'dhc-blog',
				'blog-grid' => 'dhc-blog-grid',
				'blog-list-small' => 'dhc-blog-listsmall'
				);
			global $dhc_thumbnail;
			$dhc_thumbnail = $imgs[$atts['layout']];
			wp_enqueue_script( 'dhc-carousel' );
			$items = $atts['layout'] == 'blog-grid' ? $atts['grid_columns'] : 1;
			?>
			<?php if ( ! empty( $atts['title'] ) ): ?>
				<h3 class="widget-title"><?php esc_html_e( $atts['title'] ) ?></h3>
			<?php endif ?>

			<div class="<?php esc_attr_e( implode( ' ', $class ) ) ?>" data-items ="<?php dhc_esc_attr($items);?>">
				
				<?php while ( $query->have_posts() ) : $query->the_post(); ?>
					<article class="entry format-<?php echo esc_attr(get_post_format()); ?>">
						<div class="entry-border">
							<?php 
							get_template_part('tpl/feature-post'); ?>
							<?php if ($atts['layout'] == 'blog-grid') { ?>
							<div class="entry-meta clearfix">
								<?php dhc_posted_on();?>
							</div><!-- /.entry-meta -->
							<?php } ?>
							<div class="content-post">
								<?php if ($atts['layout'] != 'blog-grid') { ?>
								<div class="entry-meta clearfix">
									<?php dhc_posted_on();?>
								</div><!-- /.entry-meta -->
								<?php } ?>
								
								<h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>

								<?php if ( $atts['hide_content'] != 'yes' ): ?>
									
									<div class="entry-content">

										<?php
										$readmore = $atts['hide_readmore'] != 'yes'  ? wp_kses_post( $atts['readmore_text'] ) : ' ';
										dhc_render_post($atts['layout'],$readmore,$atts['content_length']);
										?>

									</div>

								<?php endif ?>
							</div>
						</div>
					</article><!-- /.entry -->

					<?php
					endwhile;
					wp_reset_postdata();
					echo '</div>'; 	
					$out_put = ob_get_clean();
					return $out_put;		
					?>
					<?php 				
				}	
			}
		}

// Finally initialize code
new dhc_VCExtend();



