<?php
add_action( 'vc_before_init', 'dhc_counter_shortcode_params' );

function dhc_counter_shortcode_params() {
	$icons_params = dhc_map_icons('icon','Icon Title Section');	
	$params = array_merge( $icons_params, array(
		array(
			'type'             => 'textfield',
			'heading'          => esc_html__( 'Title', 'dhc' ),
			'param_name'       => 'fl_title',
			'value'			   =>  esc_html__( 'Enter your title', 'dhc' )
		),			

		array(
			'type'             => 'textfield',
			'heading'          => esc_html__( 'Count To', 'dhc' ),
			'param_name'       => 'fl_value',
			'value'			   =>  ''
		),		

		array(
			'type'             => 'textfield',
			'heading'          => esc_html__( 'Duration', 'dhc' ),
			'param_name'       => 'fl_duration',
			'value'			   =>  1000
		),		

		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'dhc' ),
			'param_name' => 'class',
			'description' => esc_html__( 'Enter your class', 'dhc' )
		),
		
		array(
			'type' => 'css_editor',
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'dhc' )
		),		
	));	

	vc_map( array(
		'base'        => 'dhc_counter',
		'name'        => esc_html__( 'dhc: counter', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => $params
	) );
}

add_shortcode( 'dhc_counter', 'dhc_shortcode_counter' );

function dhc_shortcode_counter( $atts , $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_counter', $atts );
	$icon_name = dhc_shortcode_icon_name('icon_',$atts['icon_type']);
   	$icon_value = !empty( $icon_name ) ? $atts[$icon_name] : '';

   	// Enqueue shortcode assets		
	wp_enqueue_script( 'dhc-counter' );	

	$output  = '<div class="fl-counter '.esc_attr( $atts['class'] ).'">'; 
	$output .= '<div class="fl-counter-value">';

	if ( $icon_value != '' ) {
		$output .= '<div class="icon-wrap">';
		$output .= '<span class="'.esc_attr( $icon_value ).'"></span>';
		$output .= '</div>';
	}
	
	$output .= '<span class="numb-count" data-from="0" data-to="'.esc_attr( $atts['fl_value'] ).'" data-speed="'.$atts['fl_duration'].'" data-waypoint-active="yes">'.esc_attr( $atts['fl_value'] ).'</span>';
	$output .= '</div>';

	$output .= '<div class="flat-counter-content">';
	$output .= '<p class="title">'.esc_attr(  $atts['fl_title'] ).'</p>';
	$output .= '</div>';

	$output .=  '</div>';
	return $output;
}



