<?php

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Extended class to integrate testimonial slider with
	 * visual composer
	 */
    class WPBakeryShortCode_dhc_client_slider extends WPBakeryShortCodesContainer {
    }
}

/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */
add_filter( 'dhc/shortcode/member_class', 'dhc_custom_shortcodes_class', 10, 3 );
add_action( 'vc_before_init', 'dhc_client_shortcode_params' );

function dhc_client_shortcode_params() {
	/**
	 * Map the client slider shortcode
	 */
	vc_map( array(
		'name'                    => esc_html__( 'dhc: Client Slider', 'dhc' ),
		'base'                    => 'dhc_client_slider',
		'as_parent'               => array( 'only' => 'dhc_client' ), 
		'icon'       			  => dhc_icon,
		'content_element'         => true,
		'show_settings_on_create' => false,
		'category'                => esc_html__( 'dhc', 'dhc' ),
		'params'                  => array(			
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Margin', 'dhc' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'Margin item for slide', 'dhc' )
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Slides per view', 'dhc' ),
				'param_name' => 'slides_per_view',
				'value' => '6',
				'description' => esc_html__( 'The number of items you want to see on the screen.', 'dhc' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Slider autoplay', 'dhc' ),
				'param_name' => 'autoplay',
				'description' => esc_html__( 'Disable autoplay mode.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide pagination control', 'dhc' ),
				'param_name' => 'hide_control',
				'description' => esc_html__( 'If YES pagination control will be removed.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Hide prev/next buttons', 'dhc' ),
				'param_name' => 'hide_buttons',
				'description' => esc_html__( 'If "YES" prev/next control will be removed.', 'dhc' ),
				'value' => array( esc_html__( 'Yes, please', 'dhc' ) => 'yes' )
			),			
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'dhc' ),
				'param_name' => 'class',
				'description' => esc_html__( 'Your custom class', 'dhc' )
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			)
		),
		'js_view' => 'VcColumnView'
	) );

	/**
	 * Map the client item
	 */
	vc_map( array(
		'base'        => 'dhc_client',
		'name'        => esc_html__( 'dhc: Client', 'dhc' ),
		'icon'        => dhc_icon,
		'category'    => esc_html__( 'dhc', 'dhc' ),
		'params'      => array(	
			array(
				'type'       => 'attach_image',
				'heading'    => esc_html__( 'Image', 'dhc' ),
				'param_name' => 'image'
			),
		
			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'dhc' )
			)
		)
	) );
}

add_shortcode( 'dhc_client', 'dhc_shortcode_client' );
add_shortcode( 'dhc_client_slider', 'dhc_shortcode_client_slider' );

/**
 * Testimonial shortcode handle
 * 
 * @param   string  $atts  Shortcode attributes
 * @return  void
 */
function dhc_shortcode_client( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_client', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_client_atts',$atts));
	if ( ! empty( $image ) ) {
		if ( is_numeric( $image ) && $images = wp_get_attachment_image_src( $image, 'full' ) )
			$image = array_shift( $images );
	}
	
	return sprintf( '
		<div class="dhc_client-image">
			<img src="%s" alt="images" />
		</div>'
	,esc_attr( $image ) );
}

/**
 * This function will be use to handle client slider
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function dhc_shortcode_client_slider( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'dhc_client_slider', $atts );
	extract (apply_filters( 'dhc/shortcode/dhc_client_slider_atts',$atts));
	$config = $atts;
	unset( $config['class'] );
	unset( $config['css'] );
	$class = apply_filters( 'dhc/shortcode/dhc_client_slider_class', array( 'dhc_client_slider_inner', $class ), $atts );

	// Enqueue shortcode assets
	wp_enqueue_script( 'dhc-carousel' );
	
	return sprintf( '
		<div class="dhc_client_slider">
			<div class="%s" data-margin="%s" data-slides_per_view="%s" data-autoplay="%s" data-hide_control="%s" data-hide_buttons="%s">			
				%s				
			</div>
		</div>
	', implode( ' ', $class ), esc_attr( $margin) , esc_attr($slides_per_view ), esc_attr( $autoplay ), esc_attr( $hide_control ), esc_attr( $hide_buttons ),  do_shortcode( $content ) );
}

