<?php
add_action( 'wp_enqueue_scripts', 'dhc_portfolios_scripts' );
/**
  * Load the scripts
*/
function dhc_portfolios_scripts() {  
    wp_enqueue_script( 'dhc-isotope', plugin_dir_url( __FILE__ ) . '/lib/js/isotope.min.js', array('jquery'), true );
    wp_enqueue_script( 'dhc-imagesloaded', plugin_dir_url( __FILE__ ) . '/lib/js/imagesloaded.min.js', array('jquery'), true );    
}

add_action('init', 'register_portfolio_post_type');

/**
  * Register Portfolios post type
*/
function register_portfolio_post_type() {
    
    $labels = array(
    'name'                  => esc_html__( 'Testimonial', 'dhc' ),
    'singular_name'         => esc_html__( 'Testimonial', 'dhc' ),
    'rewrite'               => array( 'slug' => esc_html__( 'testimonial' ) ),
    'menu_name'             => esc_html__( 'Testimonial', 'dhc' ),
    'add_new'               => esc_html__( 'New Testimonial', 'dhc' ),
    'add_new_item'          => esc_html__( 'Add New Testimonial', 'dhc' ),
    'new_item'              => esc_html__( 'New Testimonial Item', 'dhc' ),
    'edit_item'             => esc_html__( 'Edit Testimonial Item', 'dhc' ),
    'view_item'             => esc_html__( 'View Testimonial', 'dhc' ),
    'all_items'             => esc_html__( 'All Testimonial', 'dhc' ),
    'search_items'          => esc_html__( 'Search Testimonial', 'dhc' ),
    'not_found'             => esc_html__( 'No Testimonial Items Found', 'dhc' ),
    'not_found_in_trash'    => esc_html__( 'No Testimonial Items Found In Trash', 'dhc' ),
    'parent_item_colon'     => esc_html__( 'Parent Testimonial:', 'dhc' ),
    'not_found'             => esc_html__( 'No Testimonial found', 'dhc' ),
    'not_found_in_trash'    => esc_html__( 'No Testimonial found in Trash', 'dhc' )

    );
    $args = array(
        'labels'      => $labels,
        'supports'    => array( 'title', 'editor', 'thumbnail' ),
        'public'      => true,
        'has_archive' => false,
        'menu_icon'   => 'dashicons-format-quote',
    );
    register_post_type( 'testimonial', $args );
        
    $args = array(
        'labels'      => $labels,
        'supports'    => array( 'title', 'editor', 'thumbnail','post-formats' ),
        'public'      => true,
        'has_archive' => false,
        'menu_icon'   => 'dashicons-testimonial',
    );   

    flush_rewrite_rules();
}

add_filter( 'post_updated_messages', 'portfolios_updated_messages' );


/**
  * Portfolios update messages.
*/
function portfolios_updated_messages ( $messages ) {
    Global $post, $post_ID;
    $messages[esc_html__( 'portfolios' )] = array(
        0  => '',
        1  => sprintf( esc_html__( 'Portfolios Updated. <a href="%s">View portfolios</a>', 'dhc' ), esc_url( get_permalink( $post_ID ) ) ),
        2  => esc_html__( 'Custom Field Updated.', 'dhc' ),
        3  => esc_html__( 'Custom Field Deleted.', 'dhc' ),
        4  => esc_html__( 'Portfolios Updated.', 'dhc' ),
        5  => isset( $_GET['revision']) ? sprintf( esc_html__( 'Portfolios Restored To Revision From %s', 'dhc' ), wp_post_revision_title((int)$_GET['revision'], false)) : false,
        6  => sprintf( esc_html__( 'Portfolios Published. <a href="%s">View Portfolios</a>', 'dhc' ), esc_url( get_permalink( $post_ID ) ) ),
        7  => esc_html__( 'Portfolios Saved.', 'dhc' ),
        8  => sprintf( esc_html__('Portfolios Submitted. <a target="_blank" href="%s">Preview Portfolios</a>', 'dhc' ), esc_url( add_query_arg( 'preview', 'true', get_permalink( $post_ID ) ) ) ),
        9  => sprintf( esc_html__( 'Portfolios Scheduled For: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview Portfolios</a>', 'dhc' ),date_i18n( esc_html__( 'M j, Y @ G:i', 'dhc' ), strtotime( $post->post_date ) ), esc_url( get_permalink( $post_ID ) ) ),
        10 => sprintf( esc_html__( 'Portfolios Draft Updated. <a target="_blank" href="%s">Preview Portfolios</a>', 'dhc' ), esc_url( add_query_arg( 'preview', 'true', get_permalink( $post_ID ) ) ) ),
    );
    return $messages;
}

add_action( 'init', 'register_portfolios_taxonomy' );

/**
  * Register portfolios taxonomy
*/
function register_portfolios_taxonomy() {
    $labels = array(
        'name'                       => esc_html__( 'Categories', 'dhc' ),
        'singular_name'              => esc_html__( 'Categories', 'dhc' ),
        'search_items'               => esc_html__( 'Search Categories', 'dhc' ),
        'menu_name'                  => esc_html__( 'Categories', 'dhc' ),
        'all_items'                  => esc_html__( 'All Categories', 'dhc' ),
        'parent_item'                => esc_html__( 'Parent Categories', 'dhc' ),
        'parent_item_colon'          => esc_html__( 'Parent Categories:', 'dhc' ),
        'new_item_name'              => esc_html__( 'New Categories Name', 'dhc' ),
        'add_new_item'               => esc_html__( 'Add New Categories', 'dhc' ),
        'edit_item'                  => esc_html__( 'Edit Categories', 'dhc' ),
        'update_item'                => esc_html__( 'Update Categories', 'dhc' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove Categories', 'dhc' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used Categories', 'dhc' ),
        'not_found'                  => esc_html__( 'No Categories found.' ),
        'menu_name'                  => esc_html__( 'Categories' ),
    );
    $args = array(
        'labels'       => $labels,
        'hierarchical' => true,
    );
    register_taxonomy( 'portfolios_category', 'portfolios', $args );
        $labels = array(
        'name'                       => esc_html__( 'Categories', 'dhc' ),
        'singular_name'              => esc_html__( 'Categories', 'dhc' ),
        'search_items'               => esc_html__( 'Search Categories', 'dhc' ),
        'menu_name'                  => esc_html__( 'Categories', 'dhc' ),
        'all_items'                  => esc_html__( 'All Categories', 'dhc' ),
        'parent_item'                => esc_html__( 'Parent Categories', 'dhc' ),
        'parent_item_colon'          => esc_html__( 'Parent Categories:', 'dhc' ),
        'new_item_name'              => esc_html__( 'New Categories Name', 'dhc' ),
        'add_new_item'               => esc_html__( 'Add New Categories', 'dhc' ),
        'edit_item'                  => esc_html__( 'Edit Categories', 'dhc' ),
        'update_item'                => esc_html__( 'Update Categories', 'dhc' ),
        'add_or_remove_items'        => esc_html__( 'Add or remove Categories', 'dhc' ),
        'choose_from_most_used'      => esc_html__( 'Choose from the most used Categories', 'dhc' ),
        'not_found'                  => esc_html__( 'No Categories found.' ),
        'menu_name'                  => esc_html__( 'Categories' ),
    );
    $args = array(
        'labels'       => $labels,
        'hierarchical' => true,
    );
    register_taxonomy( 'faq_category', 'faq', $args );
    flush_rewrite_rules();
}

add_action( 'init', 'register_portfolios_tag' );

/**
 * Register tag taxonomy
 */
function register_portfolios_tag() {
    $labels = array(
        'name'                       => esc_html__( 'Portfolio Tags', 'dhc' ),
        'singular_name'              => esc_html__( 'Portfolio Tags', 'dhc' ),
        'search_items'               => esc_html__( 'Search Tags', 'dhc' ),        
        'all_items'                  => esc_html__( 'All Tags', 'dhc' ),
        'new_item_name'              => esc_html__( 'Add New Tag', 'dhc' ),
        'add_new_item'               => esc_html__( 'New Tag Name', 'dhc' ),
        'edit_item'                  => esc_html__( 'Edit Tag', 'dhc' ),
        'update_item'                => esc_html__( 'Update Tag', 'dhc' ),
        'menu_name'                  => esc_html__( 'Tags' ),
    );
    $args = array(
        'labels'       => $labels,
        'hierarchical' => true,
    );
    register_taxonomy( 'portfolios_tag', 'portfolios', $args );
    flush_rewrite_rules();
}

