<?php
/**
 * Plugin Name: dhc By dhc.com
 * Plugin URI:  http://corpthemes.com/
 * Description: The theme's components
 * Author:      dhc
 * Version:     1.0.1
 * Author URI: http://corpthemes.com/
 */

defined( 'ABSPATH' ) or die();

define( 'dhc_VERSION', '1.0.1' );
define( 'dhc_PATH', plugin_dir_path( __FILE__ ) );
define( 'dhc_URL', plugin_dir_url( __FILE__ ) );

// Portfolio
require_once dhc_PATH . '/includes/portfolio/func-setup.php';

// Shortcodes
require_once dhc_PATH . '/includes/helpers.php';
require_once dhc_PATH . '/includes/shortcodes/iconbox.php';
require_once dhc_PATH . '/includes/shortcodes/iconlist.php';	
require_once dhc_PATH . '/includes/shortcodes/testimonial.php';	
require_once dhc_PATH . '/includes/shortcodes/title-section.php';
require_once dhc_PATH . '/includes/shortcodes/dhc-extend.php';
require_once dhc_PATH . '/includes/shortcodes/team-member.php';
require_once dhc_PATH . '/includes/shortcodes/maps.php';	
require_once dhc_PATH . '/includes/shortcodes/imagebox.php';
require_once dhc_PATH . '/includes/shortcodes/infomation.php';
require_once dhc_PATH . '/includes/shortcodes/spacer.php';
require_once dhc_PATH . '/includes/shortcodes/counter.php';
require_once dhc_PATH . '/includes/shortcodes/client.php';		
require_once dhc_PATH . '/includes/shortcodes/socials.php';		
require_once dhc_PATH . '/includes/shortcodes/simple-button.php';
require_once dhc_PATH . '/includes/admin/sample-data.php';		


if ( ! function_exists( 'dhc_shortcode_register_assets' ) ) {
	add_action( 'init', 'dhc_shortcode_register_assets' );

	/**
	 * Register all needed scripts & styles for the plugin
	 * 
	 * @return  void
	 */
	function dhc_shortcode_register_assets() {		
		wp_enqueue_style( 'vc_extend_shortcode', plugins_url('assets/css/shortcodes.css', __FILE__), array() );	
		wp_enqueue_style( 'vc_extend_style', plugins_url('assets/css/shortcodes-3rd.css', __FILE__),array() );
		wp_register_script( 'dhc-carousel', plugins_url('assets/3rd/owl.carousel.js', __FILE__), array(), '1.0', true );
		wp_register_script( 'dhc-flexslider', plugins_url('assets/3rd/jquery.flexslider-min.js', __FILE__), array(), '1.0', true );		
		wp_register_script( 'dhc-manific-popup', plugins_url('assets/3rd/jquery.magnific-popup.min.js', __FILE__), array(), '1.0', true );		
		wp_register_script( 'dhc-counter', plugins_url('assets/3rd/jquery-countTo.js', __FILE__), array(), '1.0', true );
		wp_enqueue_script( 'dhc-shortcode', plugins_url('assets/js/shortcodes.js', __FILE__), array(), '1.0', true );
		wp_register_script( 'dhc-google', 'https://maps.googleapis.com/maps/api/js?key='.get_theme_mod('key_api_gmap','null'), array(), '1.0', true );
		wp_register_script( 'dhc-gmap3', plugins_url('assets/3rd/gmap3.min.js', __FILE__), array(), '1.0', true );	
	}
}

// Show notice if your plugin is activated but Visual Composer is not
function showVcVersionNotice() {
    $plugin_data = get_plugin_data(__FILE__);
    echo '<div class="error">';
    echo '<p>' . wp_kses( esc_html__( $plugin_data['Name'] . ' - requires <a href="' . esc_url( admin_url( 'plugins.php') ) . '">Visual Composer</a>  plugin to be installed and activated on your site.', 'dhc' ), array( 'a' => array( 'href' => array() ) ) ) . '</p>';
    echo '</div>';
}

// disable frontend editor
if ( function_exists('vc_disable_frontend') ) vc_disable_frontend();

