/**
* testimonialCarousel
* portfolioIsotope
* portfolioMasory
* portfolioCarousel
* blogCarousel
* blogMasory
* logoClient
* googleMap
* dhcCounter
* videothumbnail
* progressBar
* rowStyling
* spacer
*/

;(function($) {

    'use strict'


    var testimonialCarousel = function() {   
        $('.content-wrapper').each(function() {               
            if ( $().owlCarousel ) {                  
                $(this).find('.testimonial-sliders').owlCarousel({                    
                    margin: 30,
                    nav: Boolean( $(this).find('.testimonial-sliders').data('show_direction') )? false: true, 
                    dots: Boolean( $(this).find('.testimonial-sliders').data('show_control') )? false: true,                   
                    autoplay: Boolean( $(this).find('.testimonial-sliders').data('autoplay') )? true: false,                
                    responsive:{
                        0:{
                            items: 1
                        },
                        767:{
                            items: 2
                        },
                        991:{
                            items: 2
                        },
                        1200: {
                            items: $(this).find('.testimonial-sliders').data('slides-per-view')
                        }
                    }
                });
            }
        });
    };   

    var portfolioIsotope = function() { 
        if ( $( '.portfolio-container' ).hasClass('show_filter_portfolio') ) {
            if ( $().isotope ) {           
                var $container = $('.portfolio-container');
                $container.imagesLoaded(function(){
                    $container.isotope({
                        itemSelector: '.item',
                        transitionDuration: '1s'
                    });
                });

                $('.portfolio-filter li').on('click',function() {                           
                    var selector = $(this).find("a").attr('data-filter');
                    $('.portfolio-filter li').removeClass('active');
                    $(this).addClass('active');
                    $container.isotope({ filter: selector });
                    return false;
                });            
            };
        };        
    };

    var portfolioMasory = function() {         
        if ( $().isotope ) {           
            var $container = $('.portfolio-container.masonry');
            $container.imagesLoaded(function(){
                $container.masonry({
                    itemSelector: '.item',
                    transitionDuration: '0.5s',                    
                    layoutMode: 'masonry',                 
                    masonry: { columnWidth: $container.width() / 12 }
                }); // isotope
            });

            $(window).resize(function() {
                $container.masonry({
                   masonry: { columnWidth: $container.width() / 12 }
               });
            }); // relayout        
            
        };
    };   

    var portfolioCarousel = function() {
        if ( $( ".dhc-portfolio" ).hasClass( "yes" ) ) {            
            if ( $().owlCarousel ) { 
                $('.dhc-portfolio.yes').find('.portfolio-container').owlCarousel({
                    loop: true,
                    margin: 0,
                    nav: true,
                    dots: true,                   
                    autoplay: false,                
                    responsive:{
                        0:{
                            items: 1
                        },
                        480: {
                            items: 2
                        },
                        767:{
                            items: 2
                        },
                        991:{
                            items: 2
                        },
                        1200: {
                            items: 3
                        }
                    }
                });
            }
        }
    };    

    var blogCarousel = function() {

        if ( $().owlCarousel ) { 
            $(".blog-shortcode.has-carousel:not(.blog-masonry)").each(function() {
                var $this = $(this),_items = $this.data('items');
                $this.owlCarousel({
                    loop: true,
                    margin: 0,
                    nav: true,
                    dots: false,                   
                    autoplay: false,                
                    responsive:{
                        0:{
                            items: next_item(_items-2,$this.width())
                        },
                        767:{
                            items: next_item(_items-1,$this.width())
                        },
                        991:{
                            items: next_item(_items,$this.width())
                        },
                        1200: {
                            items: _items
                        }
                    }
                });
            });
        }
    };  

    var blogMasory = function() {         
        if ( $().isotope ) {           
            var $container = $('.blog-shortcode.blog-masonry');
            $container.imagesLoaded(function(){
                $container.masonry({
                    itemSelector: '.entry',
                    transitionDuration: '0.5s',                    
                    layoutMode: 'masonry',                 
                    masonry: { columnWidth: $container.width() / 12 }
                }); // isotope
            });

            $(window).resize(function() {
                $container.masonry({
                   masonry: { columnWidth: $container.width() / 12 }
               });
            }); // relayout        
            
        };
    };

    var logoClient = function() {
        $('.dhc_client_slider').each(function() {             
            if ( $().owlCarousel ) {   
                var data = $(this).find('.dhc_client_slider_inner');
                $('.dhc_client_slider_inner').owlCarousel({
                    loop: true,
                    margin: parseInt( data.data('margin') ),
                    nav: Boolean( data.data('hide_buttons') )? false: true, 
                    dots: Boolean( data.data('hide_control') )? false: true,                   
                    autoplay: Boolean( data.data('autoplay') )? true: false,                        
                    responsive:{
                        0:{
                            items: 2
                        },                                              
                        480:{
                            items: 3
                        }, 
                        767:{
                            items: 4
                        },
                        991:{
                            items: 5
                        },
                        1200: {
                            items: parseInt( data.data('slides_per_view') )
                        }
                    }
                });
            }
        });
    };  

    var googleMap = function() {            
        if ( $().gmap3 ) {  
            $("#map").gmap3({
                map:{
                    options:{
                        zoom: 14,
                        mapTypeId: 'dhc_style',
                        mapTypeControlOptions: {
                            mapTypeIds: ['dhc_style', google.maps.MapTypeId.SATELLITE, google.maps.MapTypeId.HYBRID]
                        },
                        scrollwheel: false
                    }
                },
                getlatlng:{
                    address:  $('.dhc-maps').data('address'),
                    callback: function(results) {
                        if ( !results ) return;
                        $(this).gmap3('get').setCenter(new google.maps.LatLng(results[0].geometry.location.lat(), results[0].geometry.location.lng()));
                        $(this).gmap3({
                            marker:{
                                latLng:results[0].geometry.location,
                                options:{
                                    icon: $('.dhc-maps').data('images')
                                }
                            }
                        });
                    }
                },
                styledmaptype:{
                    id: "dhc_style",
                    options:{
                        name: "dhc Map"
                    },
                    styles:[
                    {
                        "featureType": "administrative",
                        "elementType": "labels.text.fill",
                        "stylers": [
                        {
                            "color": "#444444"
                        }
                        ]
                    },
                    {
                        "featureType": "landscape",
                        "elementType": "all",
                        "stylers": [
                        {
                            "color": "#f2f2f2"
                        }
                        ]
                    },
                    {
                        "featureType": "poi",
                        "elementType": "all",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "road",
                        "elementType": "all",
                        "stylers": [
                        {
                            "saturation": -100
                        },
                        {
                            "lightness": 45
                        }
                        ]
                    },
                    {
                        "featureType": "road.highway",
                        "elementType": "all",
                        "stylers": [
                        {
                            "visibility": "simplified"
                        }
                        ]
                    },
                    {
                        "featureType": "road.arterial",
                        "elementType": "labels.icon",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "transit",
                        "elementType": "all",
                        "stylers": [
                        {
                            "visibility": "off"
                        }
                        ]
                    },
                    {
                        "featureType": "water",
                        "elementType": "all",
                        "stylers": [
                        {
                            "color": "#46bcec"
                        },
                        {
                            "visibility": "on"
                        }
                        ]
                    }
                    ]
                },  
            });
}
$('#map').css( 'height', $('.dhc-maps').data('height') );
};

var dhcCounter = function() {
    $('.fl-counter').on('on-appear', function() { 
        $(this).find('.numb-count').each(function() { 
            var to = parseInt( ($(this).attr('data-to')),10 ), speed = parseInt( ($(this).attr('data-speed')),10 );
            if ( $().countTo ) {
                $(this).countTo({
                    to: to,
                    speed: speed
                });
            }
        });
    });
};

var detectViewport = function() {
    $('[data-waypoint-active="yes"]').waypoint(function() {
        $(this).trigger('on-appear');
    }, { offset: '90%', triggerOnce: true });
};   

var videothumbnail = function() { 
    $(document).on('click',".dhc_video_embed a",function(e){
        e.preventDefault();
        var iframe = $(this).parent().find('iframe');
        iframe[0].src += "&autoplay=1";
        iframe.show();
        $(this).hide();
    })
}

var progressBar = function() {        
    $('.progress-bar').on('on-appear', function() {
        $(this).each(function() {
            var percent = $(this).data('percent');                
            $(this).find('.progress-animate').animate({
                "width": percent + '%'
            }, $(this).find('.progress-animate').data('duration') );

            $(this).parent('.dhc-progress').find('.perc').addClass('show').animate({
                "width": percent + '%'
            }, $(this).find('.progress-animate').data('duration') );
        });
    });
};

var rowStyling = function() {
    $(".vc_row").each(function( idx, el ) {
        if ($(this).hasClass('dhc-overlay')) {
            var class_mask ='<div class="overlay"></div>';
            $(this).append(class_mask);
        }          

    });       
};

var spacer = function() {
    $(".dhc-spacer").each(function() {

        var spacer_size = $(this).data( 'desktop' );
        if ( matchMedia( 'only screen and (max-width: 991px)' ).matches ) {
            spacer_size = $(this).data( 'mobile' )
        }

        if ( matchMedia( 'only screen and (max-width: 479px)' ).matches ) {
            spacer_size = $(this).data( 'smobile' )
        }
        
        $(this).css( "height", spacer_size );
    });       
};    

function next_item($item,$width) {
    if (typeof $width =='undefined') {
        $width = 0;
    }
    var $int_item = parseInt($item);
    if ( $int_item -1 > 0) {
        if (($width/$int_item) > 250) {
            return $int_item 
        }
        return $int_item -1;
    }
    else {
        return 1;
    }
}   

    // Dom Ready
    $(function() {        
            
        //portfolioIsotope();
        //portfolioMasory();       
        //portfolioCarousel();
        blogCarousel();    
        testimonialCarousel();             
        dhcCounter();
        //detectViewport();
        blogMasory();
        //logoClient();
        googleMap();
        videothumbnail();
        progressBar();
        rowStyling();   
        spacer();            
    });

})(jQuery);