<?php

use WooBooking\CMS\Utilities\Utility;

$input = Factory::getInput();
$style = $input->getString('style', "list");
WpBookingPro_HtmlFrontend::_('jquery.icheck');
WpBookingPro_HtmlFrontend::_('jquery.moment');
WpBookingPro_HtmlFrontend::_('jquery.ui');
WpBookingPro_HtmlFrontend::_('jquery.select2');
WpBookingPro_HtmlFrontend::_('jquery.twbs_pagination');
WpBookingPro_HtmlFrontend::_('jquery.animated_modal');
WpBookingPro_HtmlFrontend::_('jquery.validate');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
WpBookingPro_HtmlFrontend::_('jquery.serialize_object');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_service_layout2.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$appConfig = Factory::getAppConfig();
$booking_style = $appConfig->get('booking_style', 'in_line');
$is_multi_product_in_cart = WpBookingPro_FrontEndHelper::is_multi_product_in_cart();
$list_sorting = [
    "name" => "sorting by name",
    "price" => "sorting by price"
];
$input = Factory::getInput();
$this->keyword=$input->getString('keyword',"");
$this->service_id = $input->getInt('service_id', 0);
$this->location_id = $input->getInt('location_id', 0);
$this->employee_id = $input->getInt('employee_id', 0);
$this->category_id = $input->getInt('category_id', 0);
$sort = $input->getString('key_sort', "a.ordering");
$direction = $input->getString('direction', "ASC");
$limit = $input->getInt('limit', 10);
$start = $input->getInt('start', 0);


?>
    <div class="view-list-layout-service2">
        <form class="list-service" action="#" method="post">
            <div class="row">
                <div class="col-md-12">
                    <h2 class="title"><?php esc_attr_e('List layout with sidebar', 'wpbookingpro') ?></h2>
                    <div class="pull-right">
                        <ul class="style-display">
                            <li class="<?php echo $style=="table"?' active ':'' ?>"><a data-display="table" href="javascript:void()"><i class="fas fa-th"></i></a></li>
                            <li class="<?php echo $style=="list"?' active ':'' ?>"><a data-display="list"  href="javascript:void()"><i class="fas fa-list"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <?php echo $this->loadTemplate('list_filter') ?>
                </div>
                <div class="col-md-8">
                    <?php if($style=="list"){ ?>
                        <?php echo $this->loadTemplate('list_display_list') ?>
                    <?php }else{ ?>
                        <?php echo $this->loadTemplate('list_display_table') ?>
                    <?php } ?>
                    <div id="pagination-services"></div>
                </div>
            </div>
            <input type="hidden" name="style" value="<?php echo $style ?>">
            <input type="hidden" name="key_sort" value="<?php echo $sort ?>">
            <input type="hidden" name="direction" value="<?php echo $direction ?>">
            <input type="hidden" name="start" value="<?php echo $start ?>">
        </form>
    </div>

<?php
$doc->addScriptApplySelector('.view-list-layout-service2', 'view_list_layout_service2', array(
        "total_record"=>$this->totalRecord,
        "limit"=>$limit,
        "start"=>$start,
        "title"=>'',
), 'nb_apps/nb_woobooking/assets/js/view_list_layout_service2.js');