<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_payment_cancel.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$total = 0;
?>
    <div class="view-payment-cancel">
        <div class="view-list-paynow">
            <?php if(!empty((array)($this->order->list_rate))) {?>
                <?php foreach ($this->order->list_rate as $item) { ?>
                    <?php $this->item = $item ?>
                    <?php
                    $total += $item->total;
                    ?>
                    <?php $this->loadTemplate('list_item') ?>
                <?php } ?>
            <?php } else { ?>
                <?php foreach ($this->order_package->list_order_detail as $order_package) { ?>
                    <?php $this->item = $order_package ?>
                    <?php $this->loadTemplate('list_item_package') ?>
                <?php } ?>
            <?php }?>
            <div class="row">
                <div class="col-md-4"></div>
                <div class="col-sm-6 col-md-4"></div>
                <div class="col-sm-6 col-md-4">
                    <div class="cart-totals" >
                        <div class="detail-cart">
                            <?php if(!empty((array)($this->order->list_rate))) { ?>
                                <h3><?php esc_attr_e('Payment totals','wpbookingpro')?></h3>
                                <div class="block-payment-total">
                                    <p ><?php esc_attr_e('Payment subtotal','wpbookingpro')?></p>
                                    <p class="subtotal_price"><?php echo(WpBookingPro_FrontEndHelper::format_currency($total)); ?></p>

                                </div>
                                <div class="block-shipping">
                                    <p><?php esc_attr_e('Shipping','wpbookingpro')?></p>
                                    <p class="shipping-price">0</p>
                                </div>
                                <div class="order_total_price">
                                    <p><?php esc_attr_e('Order total','wpbookingpro')?></p>
                                    <p class="total-price"><?php echo(WpBookingPro_FrontEndHelper::format_currency($total)); ?></p>
                                </div>
                            <?php } else {?>
                                <h3><?php esc_attr_e('Payment totals','wpbookingpro')?></h3>
                                <div class="block-payment-total">
                                    <p ><?php esc_attr_e('Payment subtotal','wpbookingpro')?></p>
                                    <p class="subtotal_price"><?php echo(WpBookingPro_FrontEndHelper::format_currency($this->order_package->total)); ?></p>

                                </div>
                                <div class="block-shipping">
                                    <p><?php esc_attr_e('Shipping','wpbookingpro')?></p>
                                    <p class="shipping-price">0</p>
                                </div>
                                <div class="order_total_price">
                                    <p><?php esc_attr_e('Order total','wpbookingpro')?></p>
                                    <p class="total-price"><?php echo(WpBookingPro_FrontEndHelper::format_currency($this->order_package->total)); ?></p>
                                </div>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4"></div>
                <div class="col-md-4"></div>
                <div class="col-md-4">
                    <div class="checkout-cart">
                        <h3><?php esc_attr_e('If you wish to proceed with the payment','wpbookingpro')?></h3>
                        <?php if(!empty((array)($this->order->list_rate))) {?>
                            <?php echo($this->paymentPlugin->onAfterOrderConfirm($this->order)) ?>
                        <?php } else {?>
                            <?php echo($this->paymentPlugin->onAfterOrderConfirm($this->order_package)) ?>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-payment-cancel','view_payment_cancel',array(
    "list_rate"=>  $this->order->list_rate,
    "title"=>''
),'nb_apps/nb_woobooking/assets/js/view_payment_cancel.js');
