<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_HtmlFrontend::_('jquery.icheck');
WpBookingPro_HtmlFrontend::_('jquery.moment');
WpBookingPro_HtmlFrontend::_('jquery.ui');
WpBookingPro_HtmlFrontend::_('jquery.select2');
WpBookingPro_HtmlFrontend::_('jquery.twbs_pagination');
WpBookingPro_HtmlFrontend::_('jquery.animated_modal');
WpBookingPro_HtmlFrontend::_('jquery.validate');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
WpBookingPro_HtmlFrontend::_('jquery.serialize_object');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_find_event_new.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$appConfig = Factory::getAppConfig();
$booking_style = $appConfig->get('booking_style', 'in_line');
$is_multi_product_in_cart = WpBookingPro_FrontEndHelper::is_multi_product_in_cart();
$list_sorting = [
	"name" => "sorting by name",
	"price" => "sorting by price"
];
$input = Factory::getInput();
$service_id = $input->getInt('service_id', 0);
$location_id = $input->getInt('location_id', 0);
$employee_id = $input->getInt('employee_id', 0);
$render_service_item = function () {
	ob_start();
	?>
    <div class="service-item panel panel-default">
        <div class="row wrapper-service-item-info">
            <div class="col-sm-2">
                <div class="img-box-service">
                    <div>
                        <img class="image-service-image service-image-cover" src="" alt="image-service-trainer" />
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                <div class="">
                    <div class="wrapper-center">
                        <h4><a href="" class="service_name"></a></h4>
                        <ul class="list-rating-star"></ul>
                        <div class="line-content">
                            <span class="property">
                                <span>
                                    <i class="fas fa-list"></i>
                                    <?php esc_attr_e('Category','wpbookingpro')?>:
                                </span>
                                <span class="category"></span>
                            </span>
                            <span class="property">
                                <span>
                                    <i class="icon-nb-clock"></i>
                                    <?php esc_attr_e('Duration','wpbookingpro')?>:
                                </span>
                                <span class="service_duration"></span>
                            </span>
                        </div>
                        <div class="location">
                            <span>
                                <i class="icon-nb-pin"></i>
                                <?php esc_attr_e('Location','wpbookingpro')?>:
                            </span>
                            <span class="service_address"></span>
                        </div>
                        <div class="description">
                            <p class="description-detail"></p>
                        </div>
                        <div class="wrapper-employee"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-2 wrapper-label-price">
                <span class="event_price_format label label-primary pull-right"></span>
            </div>
        </div>
        <div class="row row-button-action">
            <div class="col-md-12">
                <div class="wrapper-button-action">
                    <div class="btn-booknow">
                        <a class="book-service" href=""><?php esc_attr_e('Book now','wpbookingpro')?></a>
                        <i class="icon-nb-down-arrow"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<?php
	$content = ob_get_clean();
	return $content;
}
?>
    <div class="view-search-event-new">
        <div class="block-confirm"></div>
        <form class="form-filter" action="<?php $this->frontendGoToLink('booking.paynow') ?>" method="post">
            <div class="row">
                <div class="col-md-4">
                    <div class="input-filter">
                        <div style="display: none" class="calendar"></div>
                        <div class="time-range"></div>
                        <h4><?php esc_attr_e('Filter category','wpbookingpro') ?> :</h4>
                        <div class="list-category">
                            <ul class="ul-list-category">
								<?php foreach ($this->form->list_category as $category) { ?>
                                    <li>
                                        <div class="block-label">
                                            <label class="label-category">
                                                <input type="checkbox"  class="check-box-category" name="category_id[]" value="<?php esc_html_e($category->id); ?>" />
                                                <?php esc_html_e($category->name); ?>(<span><?php esc_html_e(count((array)$category->list_service)); ?></span>)
                                            </label>
                                            <i class="icon-nb-down-arrow"></i>
                                        </div>
                                        <ul class="ul-list-service">
                                            <?php foreach ($category->list_service as $service) { ?>
                                                <li>
                                                    <label class="label-service">
                                                        <input type="checkbox" class="check-box-service" name="service_id[]" value="<?php esc_html_e($service->id); ?>" <?php echo ($service_id == $service->id) ? 'checked' : '' ?> />
                                                        <?php esc_html_e($service->name); ?>
                                                    </label>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </li>
								<?php } ?>
                            </ul>
                        </div>
                        <div class="list-location">
                            <h4><?php esc_attr_e('Select address','wpbookingpro') ?></h4>
                            <select name="location_id" class="list-location">
                                <option value=""><?php esc_attr_e('Select address','wpbookingpro') ?></option>
								<?php foreach ($this->form->list_location as $location) { ?>
                                    <option <?php echo ($location_id == $location->id) ? 'selected' : '' ?>
                                            value="<?php esc_html_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
								<?php } ?>
                            </select>
                        </div>
                        <div class="list-employee">
                            <h4><?php esc_attr_e('Select trainer','wpbookingpro') ?></h4>
                            <select name="employee_id" class="list-employee">
                                <option value=""><?php esc_attr_e('Select trainer','wpbookingpro') ?></option>
								<?php foreach ($this->form->list_employee as $employee) { ?>
                                    <option <?php echo ($employee_id == $employee->id) ? 'selected' : '' ?>
                                            value="<?php esc_html_e($employee->id); ?>"><?php esc_html_e($employee->full_name); ?></option>
								<?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="wrapper-search-result">
                        <div class="search">
                            <i class="icon-nb-search icon-keyword-search"></i>
                            <input type="text" class="search form-control" name="keyword"  placeholder="<?php esc_attr_e('Search keyword','wpbookingpro')?>" />
                        </div>
                        <div class="wrapper-search-result-body">
                            <h3><span class="count-result"></span> <?php esc_attr_e('Services found','wpbookingpro') ?></h3>
                            <div class="sorting pull-right">
                            </div>
                        </div>
                        <div class="list-result">
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <ul class="pagination-list-service"></ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="task" value="services.ajax_search_service" />
        </form>
    </div>

<?php
$doc->addScriptApplySelector('.view-search-event-new','view_find_event_new',array(
        "service_item" => $render_service_item(),
        "title"=>''
),'nb_apps/nb_woobooking/assets/js/view_find_event_new.js');