<?php
$item = $this->item;
?>
<div class="row list-cart" data-id="<?php esc_html_e($item->id);?>">
    <div class="col-sm-2  ">
        <div class="check">
            <input type="checkbox" class="delete-cart-item" name="list-delete-cart_id[]" value="<?php esc_html_e($item->id); ?>" />
            <div class="image">
                <div class="img-block">
                    <div>
                        <img src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($item->employee_cover) ?>" alt="service-image" />
                    </div>
                </div>
                <p>ID: <?php esc_html_e($item->id); ?></p>
            </div>
        </div>
    </div>
    <div class="col-sm-5 ">
        <div class="information">
            <h4><?php esc_html_e($item->first_name) ?>&nbsp<?php esc_html_e($item->last_name) ?></h4>
            <p class="service-name"><?php esc_html_e($item->service_name) ?></p>
            <div class="employee-location">
                <p class="employee-name"><i class="icon-nb-user"></i><?php esc_html_e($item->employee_first_name) ?>&nbsp<?php esc_html_e($item->employee_last_name) ?></p>
                <p><i class="icon-nb-pin"></i><?php esc_html_e($item->location_address) ?></p>
            </div>
            <p class="date"><i class="icon-nb-clock"></i><?php esc_html_e($item->start_date) ?>-<?php esc_html_e($item->end_date) ?></p>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="price-quantity-total">
            <div class="price">
                <p class="price-title"><?php esc_attr_e('Price','wpbookingpro'); ?></p>
                <p class="price-price"><?php esc_html_e(WpBookingPro_FrontEndHelper::format_currency($item->price)) ?></p>
            </div>
            <div class="quantity">
                <p class="quantity-title"><?php esc_attr_e('Quantity','wpbookingpro'); ?></p>
                <p class="quantity-quantity"><?php esc_html_e($item->quantity) ?></p>
            </div>
            <div class="total">
                <p><?php esc_attr_e('Total','wpbookingpro'); ?></p>
                <p><?php esc_html_e(WpBookingPro_FrontEndHelper::format_currency($item->total)) ?></p>
            </div>
        </div>
    </div>
    <div class="col-sm-1 delete">
        <i class="far fa-trash-alt btn-delete"></i>
    </div>
</div>
